/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.md;

import java.security.DigestException;
import java.security.MessageDigestSpi;

abstract class PaddingMD
extends MessageDigestSpi {
    private static final int DEFAULT_BLOCKSIZE = 64;
    private final int blockSize;
    private final int hashSize;
    private final byte[] buf;
    private int bufOff;
    private long byteCount;
    private final int mode;
    static final int MODE_MD = 0;
    static final int MODE_SHA = 1;
    static final int MODE_TIGER = 2;

    protected PaddingMD(int n, int n2) {
        this(64, n, n2);
    }

    protected PaddingMD(int n, int n2, int n3) {
        if (n != 64 && n != 128) {
            throw new RuntimeException("blockSize must be 64 or 128!");
        }
        this.blockSize = n;
        this.hashSize = n2;
        this.buf = new byte[n];
        this.bufOff = 0;
        this.byteCount = 0L;
        this.mode = n3;
    }

    protected PaddingMD(PaddingMD paddingMD) {
        this.blockSize = paddingMD.blockSize;
        this.hashSize = paddingMD.hashSize;
        this.buf = (byte[])paddingMD.buf.clone();
        this.bufOff = paddingMD.bufOff;
        this.byteCount = paddingMD.byteCount;
        this.mode = paddingMD.mode;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("You have just found a bug!");
    }

    protected abstract void coreDigest(byte[] var1, int var2);

    protected abstract void coreReset();

    protected abstract void coreUpdate(byte[] var1, int var2);

    protected byte[] engineDigest() {
        byte[] byArray = new byte[this.hashSize];
        this.privateDigest(byArray, 0, this.hashSize);
        return byArray;
    }

    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (n2 < this.hashSize) {
            throw new DigestException();
        }
        return this.privateDigest(byArray, n, n2);
    }

    protected int engineGetDigestLength() {
        return this.hashSize;
    }

    protected void engineReset() {
        this.bufOff = 0;
        this.byteCount = 0L;
        this.coreReset();
    }

    protected void engineUpdate(byte by) {
        ++this.byteCount;
        this.buf[this.bufOff++] = by;
        if (this.bufOff == this.blockSize) {
            this.coreUpdate(this.buf, 0);
            this.bufOff = 0;
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        int n3;
        this.byteCount += (long)n2;
        while (n2 >= (n3 = this.blockSize - this.bufOff)) {
            System.arraycopy(byArray, n, this.buf, this.bufOff, n3);
            this.coreUpdate(this.buf, 0);
            n2 -= n3;
            n += n3;
            this.bufOff = 0;
        }
        System.arraycopy(byArray, n, this.buf, this.bufOff, n2);
        this.bufOff += n2;
    }

    private int privateDigest(byte[] byArray, int n, int n2) {
        int n3;
        this.buf[this.bufOff++] = this.mode == 2 ? 1 : -128;
        int n4 = this.blockSize == 128 ? 16 : 8;
        int n5 = this.blockSize - n4;
        if (this.bufOff > n5) {
            while (this.bufOff < this.blockSize) {
                this.buf[this.bufOff++] = 0;
            }
            this.coreUpdate(this.buf, 0);
            this.bufOff = 0;
        }
        while (this.bufOff < n5) {
            this.buf[this.bufOff++] = 0;
        }
        long l = this.byteCount * 8L;
        if (this.blockSize == 128) {
            n3 = 0;
            while (n3 < 8) {
                this.buf[this.bufOff++] = 0;
                ++n3;
            }
        }
        if (this.mode == 1) {
            n3 = 56;
            while (n3 >= 0) {
                this.buf[this.bufOff++] = (byte)(l >>> n3);
                n3 -= 8;
            }
        } else {
            n3 = 0;
            while (n3 < 64) {
                this.buf[this.bufOff++] = (byte)(l >>> n3);
                n3 += 8;
            }
        }
        this.coreUpdate(this.buf, 0);
        this.coreDigest(byArray, n);
        this.engineReset();
        return this.hashSize;
    }
}

