/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jdesktop.jdic.init.JdicInitException;
import org.jdesktop.jdic.init.JdicManager;

public class WebBrowserUtil {
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String JAVA_DOT_HOME = "java.home";
    public static final boolean IS_OS_WINDOWS = WebBrowserUtil.isCurrentOS("Windows");
    public static final boolean IS_OS_LINUX = WebBrowserUtil.isCurrentOS("Linux");
    public static final boolean IS_OS_SUNOS = WebBrowserUtil.isCurrentOS("SunOS");
    public static final boolean IS_OS_FREEBSD = WebBrowserUtil.isCurrentOS("FreeBSD");
    public static final boolean IS_OS_MAC = WebBrowserUtil.isCurrentOS("Mac");
    private static final String JDIC_LIB_NAME = "jdic";
    private static final String LD_LIBRARY_PATH = "LD_LIBRARY_PATH";
    private static final String PATH = "PATH";
    public static final String LIB_PATH_ENV = IS_OS_WINDOWS ? "PATH" : "LD_LIBRARY_PATH";
    private static String browserPath = null;
    private static boolean nativeLibLoaded = false;
    private static boolean isDebugOn = false;

    private static native String nativeGetBrowserPath();

    private static native String nativeGetMozillaGreHome();

    private static native void nativeSetEnv();

    public static void loadLibrary() {
        if (!nativeLibLoaded) {
            try {
                JdicManager.getManager().initShareNative();
            }
            catch (JdicInitException jdicInitException) {
                jdicInitException.printStackTrace();
                WebBrowserUtil.error(jdicInitException.getMessage());
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.loadLibrary(WebBrowserUtil.JDIC_LIB_NAME);
                    return null;
                }
            });
            nativeLibLoaded = true;
        }
    }

    public static String getDefaultBrowserPath() {
        if (browserPath == null) {
            WebBrowserUtil.loadLibrary();
            browserPath = WebBrowserUtil.nativeGetBrowserPath();
        }
        return browserPath;
    }

    public static String getMozillaGreHome() {
        WebBrowserUtil.loadLibrary();
        return WebBrowserUtil.nativeGetMozillaGreHome();
    }

    public static boolean isCurrentOS(String string) {
        if (string == null) {
            return false;
        }
        return OS_NAME.indexOf(string) >= 0;
    }

    public static void trace(String string) {
        if (isDebugOn) {
            System.out.println("*** Jtrace: " + string);
        }
    }

    public static void error(String string) {
        System.err.println("*** Error: " + string);
    }

    public static void enableDebugMessages(boolean bl) {
        isDebugOn = bl;
    }

    public static boolean getDebug() {
        return isDebugOn;
    }

    public static void nativeSetEnvironment() {
        WebBrowserUtil.loadLibrary();
        WebBrowserUtil.nativeSetEnv();
    }
}

