/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.Song;
import de.kapsi.net.daap.Transaction;
import de.kapsi.net.daap.Txn;
import de.kapsi.net.daap.chunks.BooleanChunk;
import de.kapsi.net.daap.chunks.Chunk;
import de.kapsi.net.daap.chunks.StringChunk;
import de.kapsi.net.daap.chunks.UByteChunk;
import de.kapsi.net.daap.chunks.impl.DeletedIdListing;
import de.kapsi.net.daap.chunks.impl.ItemCount;
import de.kapsi.net.daap.chunks.impl.ItemId;
import de.kapsi.net.daap.chunks.impl.ItemName;
import de.kapsi.net.daap.chunks.impl.Listing;
import de.kapsi.net.daap.chunks.impl.ListingItem;
import de.kapsi.net.daap.chunks.impl.PersistentId;
import de.kapsi.net.daap.chunks.impl.PlaylistRepeatMode;
import de.kapsi.net.daap.chunks.impl.PlaylistShuffleMode;
import de.kapsi.net.daap.chunks.impl.PlaylistSongs;
import de.kapsi.net.daap.chunks.impl.PodcastPlaylist;
import de.kapsi.net.daap.chunks.impl.ReturnedCount;
import de.kapsi.net.daap.chunks.impl.SmartPlaylist;
import de.kapsi.net.daap.chunks.impl.SpecifiedTotalCount;
import de.kapsi.net.daap.chunks.impl.Status;
import de.kapsi.net.daap.chunks.impl.UpdateType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Playlist {
    private static final Log LOG = LogFactory.getLog(Playlist.class);
    private static int playlistId = 1;
    private final ItemId itemId = new ItemId();
    private final PersistentId persistentId = new PersistentId();
    private final ItemName itemName = new ItemName();
    private final ItemCount itemCount = new ItemCount();
    private SmartPlaylist smartPlaylist;
    private PlaylistRepeatMode repeatMode;
    private PlaylistShuffleMode shuffleMode;
    private PodcastPlaylist podcastPlaylist;
    private final Map<String, Chunk> chunks = new HashMap<String, Chunk>();
    private final List<Song> songs = new ArrayList<Song>();
    private Set<Song> deletedSongs = null;

    protected Playlist(Playlist playlist, Transaction txn) {
        this.itemId.setValue(playlist.itemId.getValue());
        this.itemName.setValue(playlist.itemName.getValue());
        this.persistentId.setValue(playlist.persistentId.getValue());
        this.itemCount.setValue(playlist.itemCount.getValue());
        if (playlist.deletedSongs != null) {
            this.deletedSongs = playlist.deletedSongs;
            playlist.deletedSongs = null;
        }
        for (Song song : playlist.songs) {
            if (!txn.modified(song) || this.deletedSongs != null && this.deletedSongs.contains(song)) continue;
            this.songs.add(song);
        }
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Playlist(String name) {
        Class<Playlist> clazz = Playlist.class;
        synchronized (Playlist.class) {
            this.itemId.setValue(playlistId++);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.itemName.setValue(name);
            this.persistentId.setValue(Library.nextPersistentId());
            this.init();
            return;
        }
    }

    private void init() {
        this.addChunk(this.itemId);
        this.addChunk(this.itemName);
        this.addChunk(this.persistentId);
        this.addChunk(this.itemCount);
    }

    protected long getItemId() {
        return this.itemId.getUnsignedValue();
    }

    protected void addChunk(Chunk chunk) {
        this.chunks.put(chunk.getName(), chunk);
    }

    protected void removeChunk(Chunk chunk) {
        this.chunks.remove(chunk.getName());
    }

    protected Chunk getChunk(String name) {
        return this.chunks.get(name);
    }

    public void setName(Transaction txn, String name) {
        if (txn != null) {
            txn.addTxn(this, this.createNewTxn("itemName", name));
        } else {
            this.setValue("itemName", name);
        }
    }

    public String getName() {
        return this.getStringValue(this.itemName);
    }

    public void setSmartPlaylist(Transaction txn, boolean smartPlaylist) {
        if (txn != null) {
            txn.addTxn(this, this.createNewTxn("smartPlaylist", smartPlaylist));
        } else {
            this.setValue("smartPlaylist", smartPlaylist);
        }
    }

    public boolean isSmartPlaylist() {
        return this.getBooleanValue(this.smartPlaylist);
    }

    public void setPodcastPlaylist(Transaction txn, boolean podcastPlaylist) {
        if (txn != null) {
            txn.addTxn(this, this.createNewTxn("podcastPlaylist", podcastPlaylist));
        } else {
            this.setValue("podcastPlaylist", podcastPlaylist);
        }
    }

    public boolean isPodcastPlaylist() {
        return this.getBooleanValue(this.podcastPlaylist);
    }

    public void setRepeatMode(Transaction txn, int repeatMode) {
        UByteChunk.checkUByteRange(repeatMode);
        if (txn != null) {
            txn.addTxn(this, this.createNewTxn("repeatMode", repeatMode));
        } else {
            this.setValue("repeatMode", repeatMode);
        }
    }

    public int getRepeatMode() {
        return this.getUByteValue(this.repeatMode);
    }

    public void setShuffleMode(Transaction txn, int shuffleMode) {
        UByteChunk.checkUByteRange(shuffleMode);
        if (txn != null) {
            txn.addTxn(this, this.createNewTxn("shuffleMode", shuffleMode));
        } else {
            this.setValue("shuffleMode", shuffleMode);
        }
    }

    public int getShuffleMode() {
        return this.getUByteValue(this.shuffleMode);
    }

    public int getSongCount() {
        return this.songs.size();
    }

    public List<Song> getSongs() {
        return Collections.unmodifiableList(this.songs);
    }

    protected Set<Song> getDeletedSongs() {
        return this.deletedSongs;
    }

    public void addSong(Transaction txn, final Song song) {
        if (txn != null) {
            txn.addTxn(this, new Txn(){

                public void commit(Transaction txn) {
                    Playlist.this.addSongP(txn, song);
                }
            });
            txn.attach(song);
        } else {
            this.addSongP(txn, song);
        }
    }

    private void addSongP(Transaction txn, Song song) {
        if (!this.containsSong(song) && this.songs.add(song)) {
            this.itemCount.setValue(this.songs.size());
            if (this.deletedSongs != null && this.deletedSongs.remove(song) && this.deletedSongs.isEmpty()) {
                this.deletedSongs = null;
            }
        }
    }

    public void removeSong(Transaction txn, final Song song) {
        if (txn != null) {
            txn.addTxn(this, new Txn(){

                public void commit(Transaction txn) {
                    Playlist.this.removeSongP(txn, song);
                }
            });
        } else {
            this.removeSongP(txn, song);
        }
    }

    private void removeSongP(Transaction txn, Song song) {
        if (this.songs.remove(song)) {
            this.itemCount.setValue(this.songs.size());
            if (this.deletedSongs == null) {
                this.deletedSongs = new HashSet<Song>();
            }
            this.deletedSongs.add(song);
        }
    }

    protected Song getSong(DaapRequest request) {
        long songId = request.getItemId();
        for (Song song : this.songs) {
            if (song.getItemId() != songId) continue;
            return song;
        }
        return null;
    }

    protected Object select(DaapRequest request) {
        if (request.isPlaylistSongsRequest()) {
            return this.getPlaylistSongs(request);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Unknown request: " + request));
        }
        return null;
    }

    public boolean containsSong(Song song) {
        return this.songs.contains(song);
    }

    public int hashCode() {
        return this.itemId.getValue();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Playlist)) {
            return false;
        }
        return ((Playlist)o).getItemId() == this.getItemId();
    }

    public String toString() {
        return this.getName() + " (" + this.getItemId() + ")";
    }

    private PlaylistSongs getPlaylistSongs(DaapRequest request) {
        PlaylistSongs playlistSongs = new PlaylistSongs();
        playlistSongs.add(new Status(200L));
        playlistSongs.add(new UpdateType(request.isUpdateType() ? 1 : 0));
        playlistSongs.add(new SpecifiedTotalCount(this.itemCount.getValue()));
        playlistSongs.add(new ReturnedCount(this.getSongCount()));
        Listing listing = new Listing();
        for (Song song : this.songs) {
            ListingItem listingItem = new ListingItem();
            for (String key : request.getMeta()) {
                Chunk chunk = song.getChunk(key);
                if (chunk != null) {
                    listingItem.add(chunk);
                    continue;
                }
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)("Unknown chunk type: " + key));
            }
            listing.add(listingItem);
        }
        playlistSongs.add(listing);
        if (request.isUpdateType() && this.deletedSongs != null) {
            DeletedIdListing deletedListing = new DeletedIdListing();
            for (Song song : this.deletedSongs) {
                deletedListing.add(song.getChunk("dmap.itemid"));
            }
            playlistSongs.add(deletedListing);
        }
        return playlistSongs;
    }

    protected boolean getBooleanValue(BooleanChunk chunk) {
        return chunk != null ? chunk.getBooleanValue() : false;
    }

    protected int getUByteValue(UByteChunk chunk) {
        return chunk != null ? chunk.getValue() : 0;
    }

    protected String getStringValue(StringChunk chunk) {
        return chunk != null ? chunk.getValue() : null;
    }

    protected Txn createNewTxn(String name, boolean value) {
        return this.createNewTxn(name, Boolean.TYPE, new Boolean(value));
    }

    protected Txn createNewTxn(String name, int value) {
        return this.createNewTxn(name, Integer.TYPE, new Integer(value));
    }

    protected Txn createNewTxn(String name, long value) {
        return this.createNewTxn(name, Long.TYPE, new Long(value));
    }

    protected Txn createNewTxn(String name, String value) {
        return this.createNewTxn(name, String.class, value);
    }

    protected Txn createNewTxn(final String fieldName, final Class valueClass, final Object value) {
        Txn txn = new Txn(){

            public void commit(Transaction txn) {
                Playlist.this.setValue(fieldName, valueClass, value);
            }
        };
        return txn;
    }

    protected void setValue(String fieldName, boolean value) {
        this.setValue(fieldName, Boolean.TYPE, new Boolean(value));
    }

    protected void setValue(String fieldName, int value) {
        this.setValue(fieldName, Integer.TYPE, new Integer(value));
    }

    protected void setValue(String fieldName, long value) {
        this.setValue(fieldName, Long.TYPE, new Long(value));
    }

    protected void setValue(String fieldName, String value) {
        this.setValue(fieldName, String.class, value);
    }

    protected void setValue(String fieldName, Class valueClass, Object value) {
        try {
            Field field = Playlist.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            Chunk chunk = (Chunk)field.get(this);
            if (chunk == null) {
                Constructor<?> con = field.getType().getConstructor(valueClass);
                chunk = (Chunk)con.newInstance(value);
                field.set(this, chunk);
                this.addChunk(chunk);
            } else {
                Method method = field.getType().getMethod("setValue", valueClass);
                method.invoke((Object)chunk, value);
            }
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

