/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.DaapConnection;
import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.DaapUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.httpclient.Header;

public class DaapHeaderConstructor {
    private static final String HTTP_OK = "HTTP/1.1 200 OK";
    private static final String HTTP_NO_CONTENT = "HTTP/1.1 204 No Content";
    private static final String HTTP_PARTIAL_CONTENT = "HTTP/1.1 206 Partial Content";
    private static final String HTTP_AUTH = "HTTP/1.1 401 Authorization Required";

    public static byte[] createChunkHeader(DaapRequest request, long contentLength) {
        try {
            DaapConnection connection = request.getConnection();
            String serverName = connection.getServer().getConfig().getServerName();
            ArrayList<Header> headers = new ArrayList<Header>();
            headers.add(new Header("Date", DaapUtil.now()));
            headers.add(new Header("DAAP-Server", serverName));
            headers.add(new Header("Content-Type", "application/x-dmap-tagged"));
            headers.add(new Header("Content-Length", Long.toString(contentLength)));
            headers.add(new Header("Connection", "Keep-Alive"));
            if (request.isGZIPSupported()) {
                headers.add(new Header("Content-Encoding", "gzip"));
            }
            return DaapHeaderConstructor.toByteArray(HTTP_OK, headers.toArray(new Header[0]));
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
    }

    public static byte[] createAudioHeader(DaapRequest request, long pos, long end, long contentLength) {
        try {
            DaapConnection connection = request.getConnection();
            int version = connection.getProtocolVersion();
            if (version == 0) {
                throw new IOException("Client Protocol Version is unknown");
            }
            String serverName = connection.getServer().getConfig().getServerName();
            String statusLine = null;
            ArrayList<Header> headers = new ArrayList<Header>();
            headers.add(new Header("Date", DaapUtil.now()));
            headers.add(new Header("DAAP-Server", serverName));
            headers.add(new Header("Content-Type", "application/x-dmap-tagged"));
            headers.add(new Header("Connection", "close"));
            if (pos == 0L || version <= 131072) {
                statusLine = HTTP_OK;
                headers.add(new Header("Content-Length", Long.toString(contentLength)));
            } else {
                statusLine = HTTP_PARTIAL_CONTENT;
                String cotentLengthStr = Long.toString(contentLength - pos);
                String contentRange = "bytes " + pos + "-" + (contentLength - 1L) + "/" + contentLength;
                headers.add(new Header("Content-Length", cotentLengthStr));
                headers.add(new Header("Content-Range", contentRange));
            }
            headers.add(new Header("Accept-Ranges", "bytes"));
            return DaapHeaderConstructor.toByteArray(statusLine, headers.toArray(new Header[0]));
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
    }

    public static byte[] createBasicAuthHeader(DaapRequest request) {
        try {
            DaapConnection connection = request.getConnection();
            String serverName = connection.getServer().getConfig().getServerName();
            Header[] headers = new Header[]{new Header("Date", DaapUtil.now()), new Header("DAAP-Server", serverName), new Header("Content-Type", "text/html"), new Header("Content-Length", "0"), new Header("WWW-Authenticate", "Basic realm=\"daap\""), new Header("Connection", "Keep-Alive")};
            return DaapHeaderConstructor.toByteArray(HTTP_AUTH, headers);
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
    }

    public static byte[] createDigestAuthHeader(DaapRequest request) {
        try {
            DaapConnection connection = request.getConnection();
            String serverName = connection.getServer().getConfig().getServerName();
            String nonce = connection.createNonce();
            Header[] headers = new Header[]{new Header("Date", DaapUtil.now()), new Header("DAAP-Server", serverName), new Header("Content-Type", "text/html"), new Header("Content-Length", "0"), new Header("WWW-Authenticate", "Digest realm=\"daap\", nonce=\"" + nonce + "\""), new Header("Connection", "Keep-Alive")};
            return DaapHeaderConstructor.toByteArray(HTTP_AUTH, headers);
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
    }

    public static byte[] createNoContentHeader(DaapRequest request) {
        try {
            DaapConnection connection = request.getConnection();
            String serverName = connection.getServer().getConfig().getServerName();
            Header[] headers = new Header[]{new Header("Date", DaapUtil.now()), new Header("DAAP-Server", serverName), new Header("Content-Type", "application/x-dmap-tagged"), new Header("Content-Length", "0"), new Header("Connection", request.isLogoutRequest() ? "close" : "Keep-Alive")};
            return DaapHeaderConstructor.toByteArray(HTTP_NO_CONTENT, headers);
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
    }

    private static byte[] toByteArray(String statusLine, Header[] headers) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DaapHeaderConstructor.toByteArray(out, statusLine, headers).close();
        return out.toByteArray();
    }

    private static OutputStream toByteArray(OutputStream out, String statusLine, Header[] headers) throws IOException {
        out.write(DaapUtil.getBytes(statusLine, "ISO-8859-1"));
        out.write(DaapUtil.CRLF);
        for (int i = 0; i < headers.length; ++i) {
            out.write(DaapUtil.getBytes(headers[i].toExternalForm(), "ISO-8859-1"));
        }
        out.write(DaapUtil.CRLF);
        return out;
    }

    private DaapHeaderConstructor() {
    }
}

