// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/privacy/dlp/v2beta1/dlp.proto

/*
Package dlp is a generated protocol buffer package.

It is generated from these files:
	google/privacy/dlp/v2beta1/dlp.proto
	google/privacy/dlp/v2beta1/storage.proto

It has these top-level messages:
	InspectConfig
	OperationConfig
	ContentItem
	Table
	InspectResult
	Finding
	Location
	TableLocation
	Range
	ImageLocation
	RedactContentRequest
	Color
	RedactContentResponse
	InspectContentRequest
	InspectContentResponse
	CreateInspectOperationRequest
	OutputStorageConfig
	InfoTypeStatistics
	InspectOperationMetadata
	InspectOperationResult
	ListInspectFindingsRequest
	ListInspectFindingsResponse
	InfoTypeDescription
	ListInfoTypesRequest
	ListInfoTypesResponse
	CategoryDescription
	ListRootCategoriesRequest
	ListRootCategoriesResponse
	Value
	InfoType
	FieldId
	PartitionId
	KindExpression
	PropertyReference
	Projection
	DatastoreOptions
	CloudStorageOptions
	CloudStoragePath
	BigQueryOptions
	StorageConfig
	CloudStorageKey
	DatastoreKey
	Key
	RecordKey
	BigQueryTable
*/
package dlp

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import _ "github.com/golang/protobuf/ptypes/empty"
import google_protobuf3 "github.com/golang/protobuf/ptypes/timestamp"
import google_type "google.golang.org/genproto/googleapis/type/date"
import google_type1 "google.golang.org/genproto/googleapis/type/timeofday"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Categorization of results based on how likely they are to represent a match,
// based on the number of elements they contain which imply a match.
type Likelihood int32

const (
	// Default value; information with all likelihoods is included.
	Likelihood_LIKELIHOOD_UNSPECIFIED Likelihood = 0
	// Few matching elements.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	Likelihood_UNLIKELY      Likelihood = 2
	// Some matching elements.
	Likelihood_POSSIBLE Likelihood = 3
	Likelihood_LIKELY   Likelihood = 4
	// Many matching elements.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "LIKELIHOOD_UNSPECIFIED",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}
var Likelihood_value = map[string]int32{
	"LIKELIHOOD_UNSPECIFIED": 0,
	"VERY_UNLIKELY":          1,
	"UNLIKELY":               2,
	"POSSIBLE":               3,
	"LIKELY":                 4,
	"VERY_LIKELY":            5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}
func (Likelihood) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Configuration description of the scanning process.
// When used with redactContent only info_types and min_likelihood are currently
// used.
type InspectConfig struct {
	// Restricts what info_types to look for. The values must correspond to
	// InfoType values returned by ListInfoTypes or found in documentation.
	// Empty info_types runs all enabled detectors.
	InfoTypes []*InfoType `protobuf:"bytes,1,rep,name=info_types,json=infoTypes" json:"info_types,omitempty"`
	// Only returns findings equal or above this threshold.
	MinLikelihood Likelihood `protobuf:"varint,2,opt,name=min_likelihood,json=minLikelihood,enum=google.privacy.dlp.v2beta1.Likelihood" json:"min_likelihood,omitempty"`
	// Limits the number of findings per content item or long running operation.
	MaxFindings int32 `protobuf:"varint,3,opt,name=max_findings,json=maxFindings" json:"max_findings,omitempty"`
	// When true, a contextual quote from the data that triggered a finding is
	// included in the response; see Finding.quote.
	IncludeQuote bool `protobuf:"varint,4,opt,name=include_quote,json=includeQuote" json:"include_quote,omitempty"`
	// When true, excludes type information of the findings.
	ExcludeTypes bool `protobuf:"varint,6,opt,name=exclude_types,json=excludeTypes" json:"exclude_types,omitempty"`
	// Configuration of findings limit given for specified info types.
	InfoTypeLimits []*InspectConfig_InfoTypeLimit `protobuf:"bytes,7,rep,name=info_type_limits,json=infoTypeLimits" json:"info_type_limits,omitempty"`
}

func (m *InspectConfig) Reset()                    { *m = InspectConfig{} }
func (m *InspectConfig) String() string            { return proto.CompactTextString(m) }
func (*InspectConfig) ProtoMessage()               {}
func (*InspectConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *InspectConfig) GetInfoTypes() []*InfoType {
	if m != nil {
		return m.InfoTypes
	}
	return nil
}

func (m *InspectConfig) GetMinLikelihood() Likelihood {
	if m != nil {
		return m.MinLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

func (m *InspectConfig) GetMaxFindings() int32 {
	if m != nil {
		return m.MaxFindings
	}
	return 0
}

func (m *InspectConfig) GetIncludeQuote() bool {
	if m != nil {
		return m.IncludeQuote
	}
	return false
}

func (m *InspectConfig) GetExcludeTypes() bool {
	if m != nil {
		return m.ExcludeTypes
	}
	return false
}

func (m *InspectConfig) GetInfoTypeLimits() []*InspectConfig_InfoTypeLimit {
	if m != nil {
		return m.InfoTypeLimits
	}
	return nil
}

// Max findings configuration per info type, per content item or long running
// operation.
type InspectConfig_InfoTypeLimit struct {
	// Type of information the findings limit applies to. Only one limit per
	// info_type should be provided. If InfoTypeLimit does not have an
	// info_type, the DLP API applies the limit against all info_types that are
	// found but not specified in another InfoTypeLimit.
	InfoType *InfoType `protobuf:"bytes,1,opt,name=info_type,json=infoType" json:"info_type,omitempty"`
	// Max findings limit for the given infoType.
	MaxFindings int32 `protobuf:"varint,2,opt,name=max_findings,json=maxFindings" json:"max_findings,omitempty"`
}

func (m *InspectConfig_InfoTypeLimit) Reset()                    { *m = InspectConfig_InfoTypeLimit{} }
func (m *InspectConfig_InfoTypeLimit) String() string            { return proto.CompactTextString(m) }
func (*InspectConfig_InfoTypeLimit) ProtoMessage()               {}
func (*InspectConfig_InfoTypeLimit) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0, 0} }

func (m *InspectConfig_InfoTypeLimit) GetInfoType() *InfoType {
	if m != nil {
		return m.InfoType
	}
	return nil
}

func (m *InspectConfig_InfoTypeLimit) GetMaxFindings() int32 {
	if m != nil {
		return m.MaxFindings
	}
	return 0
}

// Additional configuration for inspect long running operations.
type OperationConfig struct {
	// Max number of findings per file, Datastore entity, or database row.
	MaxItemFindings int64 `protobuf:"varint,1,opt,name=max_item_findings,json=maxItemFindings" json:"max_item_findings,omitempty"`
}

func (m *OperationConfig) Reset()                    { *m = OperationConfig{} }
func (m *OperationConfig) String() string            { return proto.CompactTextString(m) }
func (*OperationConfig) ProtoMessage()               {}
func (*OperationConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *OperationConfig) GetMaxItemFindings() int64 {
	if m != nil {
		return m.MaxItemFindings
	}
	return 0
}

// Container structure for the content to inspect.
type ContentItem struct {
	// Type of the content, as defined in Content-Type HTTP header.
	// Supported types are: all "text" types, octet streams, PNG images,
	// JPEG images.
	Type string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	// Data of the item either in the byte array or UTF-8 string form.
	//
	// Types that are valid to be assigned to DataItem:
	//	*ContentItem_Data
	//	*ContentItem_Value
	//	*ContentItem_Table
	DataItem isContentItem_DataItem `protobuf_oneof:"data_item"`
}

func (m *ContentItem) Reset()                    { *m = ContentItem{} }
func (m *ContentItem) String() string            { return proto.CompactTextString(m) }
func (*ContentItem) ProtoMessage()               {}
func (*ContentItem) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type isContentItem_DataItem interface {
	isContentItem_DataItem()
}

type ContentItem_Data struct {
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3,oneof"`
}
type ContentItem_Value struct {
	Value string `protobuf:"bytes,3,opt,name=value,oneof"`
}
type ContentItem_Table struct {
	Table *Table `protobuf:"bytes,4,opt,name=table,oneof"`
}

func (*ContentItem_Data) isContentItem_DataItem()  {}
func (*ContentItem_Value) isContentItem_DataItem() {}
func (*ContentItem_Table) isContentItem_DataItem() {}

func (m *ContentItem) GetDataItem() isContentItem_DataItem {
	if m != nil {
		return m.DataItem
	}
	return nil
}

func (m *ContentItem) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *ContentItem) GetData() []byte {
	if x, ok := m.GetDataItem().(*ContentItem_Data); ok {
		return x.Data
	}
	return nil
}

func (m *ContentItem) GetValue() string {
	if x, ok := m.GetDataItem().(*ContentItem_Value); ok {
		return x.Value
	}
	return ""
}

func (m *ContentItem) GetTable() *Table {
	if x, ok := m.GetDataItem().(*ContentItem_Table); ok {
		return x.Table
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ContentItem) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ContentItem_OneofMarshaler, _ContentItem_OneofUnmarshaler, _ContentItem_OneofSizer, []interface{}{
		(*ContentItem_Data)(nil),
		(*ContentItem_Value)(nil),
		(*ContentItem_Table)(nil),
	}
}

func _ContentItem_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ContentItem)
	// data_item
	switch x := m.DataItem.(type) {
	case *ContentItem_Data:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.Data)
	case *ContentItem_Value:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Value)
	case *ContentItem_Table:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Table); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ContentItem.DataItem has unexpected type %T", x)
	}
	return nil
}

func _ContentItem_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ContentItem)
	switch tag {
	case 2: // data_item.data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.DataItem = &ContentItem_Data{x}
		return true, err
	case 3: // data_item.value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.DataItem = &ContentItem_Value{x}
		return true, err
	case 4: // data_item.table
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Table)
		err := b.DecodeMessage(msg)
		m.DataItem = &ContentItem_Table{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ContentItem_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ContentItem)
	// data_item
	switch x := m.DataItem.(type) {
	case *ContentItem_Data:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Data)))
		n += len(x.Data)
	case *ContentItem_Value:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Value)))
		n += len(x.Value)
	case *ContentItem_Table:
		s := proto.Size(x.Table)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Structured content to inspect. Up to 50,000 `Value`s per request allowed.
type Table struct {
	Headers []*FieldId   `protobuf:"bytes,1,rep,name=headers" json:"headers,omitempty"`
	Rows    []*Table_Row `protobuf:"bytes,2,rep,name=rows" json:"rows,omitempty"`
}

func (m *Table) Reset()                    { *m = Table{} }
func (m *Table) String() string            { return proto.CompactTextString(m) }
func (*Table) ProtoMessage()               {}
func (*Table) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *Table) GetHeaders() []*FieldId {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *Table) GetRows() []*Table_Row {
	if m != nil {
		return m.Rows
	}
	return nil
}

type Table_Row struct {
	Values []*Value `protobuf:"bytes,1,rep,name=values" json:"values,omitempty"`
}

func (m *Table_Row) Reset()                    { *m = Table_Row{} }
func (m *Table_Row) String() string            { return proto.CompactTextString(m) }
func (*Table_Row) ProtoMessage()               {}
func (*Table_Row) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3, 0} }

func (m *Table_Row) GetValues() []*Value {
	if m != nil {
		return m.Values
	}
	return nil
}

// All the findings for a single scanned item.
type InspectResult struct {
	// List of findings for an item.
	Findings []*Finding `protobuf:"bytes,1,rep,name=findings" json:"findings,omitempty"`
	// If true, then this item might have more findings than were returned,
	// and the findings returned are an arbitrary subset of all findings.
	// The findings list might be truncated because the input items were too
	// large, or because the server reached the maximum amount of resources
	// allowed for a single API call. For best results, divide the input into
	// smaller batches.
	FindingsTruncated bool `protobuf:"varint,2,opt,name=findings_truncated,json=findingsTruncated" json:"findings_truncated,omitempty"`
}

func (m *InspectResult) Reset()                    { *m = InspectResult{} }
func (m *InspectResult) String() string            { return proto.CompactTextString(m) }
func (*InspectResult) ProtoMessage()               {}
func (*InspectResult) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *InspectResult) GetFindings() []*Finding {
	if m != nil {
		return m.Findings
	}
	return nil
}

func (m *InspectResult) GetFindingsTruncated() bool {
	if m != nil {
		return m.FindingsTruncated
	}
	return false
}

// Container structure describing a single finding within a string or image.
type Finding struct {
	// The specific string that may be potentially sensitive info.
	Quote string `protobuf:"bytes,1,opt,name=quote" json:"quote,omitempty"`
	// The specific type of info the string might be.
	InfoType *InfoType `protobuf:"bytes,2,opt,name=info_type,json=infoType" json:"info_type,omitempty"`
	// Estimate of how likely it is that the info_type is correct.
	Likelihood Likelihood `protobuf:"varint,3,opt,name=likelihood,enum=google.privacy.dlp.v2beta1.Likelihood" json:"likelihood,omitempty"`
	// Location of the info found.
	Location *Location `protobuf:"bytes,4,opt,name=location" json:"location,omitempty"`
	// Timestamp when finding was detected.
	CreateTime *google_protobuf3.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
}

func (m *Finding) Reset()                    { *m = Finding{} }
func (m *Finding) String() string            { return proto.CompactTextString(m) }
func (*Finding) ProtoMessage()               {}
func (*Finding) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *Finding) GetQuote() string {
	if m != nil {
		return m.Quote
	}
	return ""
}

func (m *Finding) GetInfoType() *InfoType {
	if m != nil {
		return m.InfoType
	}
	return nil
}

func (m *Finding) GetLikelihood() Likelihood {
	if m != nil {
		return m.Likelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

func (m *Finding) GetLocation() *Location {
	if m != nil {
		return m.Location
	}
	return nil
}

func (m *Finding) GetCreateTime() *google_protobuf3.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

// Specifies the location of a finding within its source item.
type Location struct {
	// Zero-based byte offsets within a content item.
	ByteRange *Range `protobuf:"bytes,1,opt,name=byte_range,json=byteRange" json:"byte_range,omitempty"`
	// Character offsets within a content item, included when content type
	// is a text. Default charset assumed to be UTF-8.
	CodepointRange *Range `protobuf:"bytes,2,opt,name=codepoint_range,json=codepointRange" json:"codepoint_range,omitempty"`
	// Location within an image's pixels.
	ImageBoxes []*ImageLocation `protobuf:"bytes,3,rep,name=image_boxes,json=imageBoxes" json:"image_boxes,omitempty"`
	// Key of the finding.
	RecordKey *RecordKey `protobuf:"bytes,4,opt,name=record_key,json=recordKey" json:"record_key,omitempty"`
	// Field id of the field containing the finding.
	FieldId *FieldId `protobuf:"bytes,5,opt,name=field_id,json=fieldId" json:"field_id,omitempty"`
	// Location within a `ContentItem.Table`.
	TableLocation *TableLocation `protobuf:"bytes,6,opt,name=table_location,json=tableLocation" json:"table_location,omitempty"`
}

func (m *Location) Reset()                    { *m = Location{} }
func (m *Location) String() string            { return proto.CompactTextString(m) }
func (*Location) ProtoMessage()               {}
func (*Location) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *Location) GetByteRange() *Range {
	if m != nil {
		return m.ByteRange
	}
	return nil
}

func (m *Location) GetCodepointRange() *Range {
	if m != nil {
		return m.CodepointRange
	}
	return nil
}

func (m *Location) GetImageBoxes() []*ImageLocation {
	if m != nil {
		return m.ImageBoxes
	}
	return nil
}

func (m *Location) GetRecordKey() *RecordKey {
	if m != nil {
		return m.RecordKey
	}
	return nil
}

func (m *Location) GetFieldId() *FieldId {
	if m != nil {
		return m.FieldId
	}
	return nil
}

func (m *Location) GetTableLocation() *TableLocation {
	if m != nil {
		return m.TableLocation
	}
	return nil
}

// Location of a finding within a `ContentItem.Table`.
type TableLocation struct {
	// The zero-based index of the row where the finding is located.
	RowIndex int64 `protobuf:"varint,1,opt,name=row_index,json=rowIndex" json:"row_index,omitempty"`
}

func (m *TableLocation) Reset()                    { *m = TableLocation{} }
func (m *TableLocation) String() string            { return proto.CompactTextString(m) }
func (*TableLocation) ProtoMessage()               {}
func (*TableLocation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *TableLocation) GetRowIndex() int64 {
	if m != nil {
		return m.RowIndex
	}
	return 0
}

// Generic half-open interval [start, end)
type Range struct {
	// Index of the first character of the range (inclusive).
	Start int64 `protobuf:"varint,1,opt,name=start" json:"start,omitempty"`
	// Index of the last character of the range (exclusive).
	End int64 `protobuf:"varint,2,opt,name=end" json:"end,omitempty"`
}

func (m *Range) Reset()                    { *m = Range{} }
func (m *Range) String() string            { return proto.CompactTextString(m) }
func (*Range) ProtoMessage()               {}
func (*Range) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *Range) GetStart() int64 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *Range) GetEnd() int64 {
	if m != nil {
		return m.End
	}
	return 0
}

// Bounding box encompassing detected text within an image.
type ImageLocation struct {
	// Top coordinate of the bounding box. (0,0) is upper left.
	Top int32 `protobuf:"varint,1,opt,name=top" json:"top,omitempty"`
	// Left coordinate of the bounding box. (0,0) is upper left.
	Left int32 `protobuf:"varint,2,opt,name=left" json:"left,omitempty"`
	// Width of the bounding box in pixels.
	Width int32 `protobuf:"varint,3,opt,name=width" json:"width,omitempty"`
	// Height of the bounding box in pixels.
	Height int32 `protobuf:"varint,4,opt,name=height" json:"height,omitempty"`
}

func (m *ImageLocation) Reset()                    { *m = ImageLocation{} }
func (m *ImageLocation) String() string            { return proto.CompactTextString(m) }
func (*ImageLocation) ProtoMessage()               {}
func (*ImageLocation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *ImageLocation) GetTop() int32 {
	if m != nil {
		return m.Top
	}
	return 0
}

func (m *ImageLocation) GetLeft() int32 {
	if m != nil {
		return m.Left
	}
	return 0
}

func (m *ImageLocation) GetWidth() int32 {
	if m != nil {
		return m.Width
	}
	return 0
}

func (m *ImageLocation) GetHeight() int32 {
	if m != nil {
		return m.Height
	}
	return 0
}

// Request to search for potentially sensitive info in a list of items
// and replace it with a default or provided content.
type RedactContentRequest struct {
	// Configuration for the inspector.
	InspectConfig *InspectConfig `protobuf:"bytes,1,opt,name=inspect_config,json=inspectConfig" json:"inspect_config,omitempty"`
	// The list of items to inspect. Up to 100 are allowed per request.
	Items []*ContentItem `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	// The strings to replace findings text findings with. Must specify at least
	// one of these or one ImageRedactionConfig if redacting images.
	ReplaceConfigs []*RedactContentRequest_ReplaceConfig `protobuf:"bytes,3,rep,name=replace_configs,json=replaceConfigs" json:"replace_configs,omitempty"`
	// The configuration for specifying what content to redact from images.
	ImageRedactionConfigs []*RedactContentRequest_ImageRedactionConfig `protobuf:"bytes,4,rep,name=image_redaction_configs,json=imageRedactionConfigs" json:"image_redaction_configs,omitempty"`
}

func (m *RedactContentRequest) Reset()                    { *m = RedactContentRequest{} }
func (m *RedactContentRequest) String() string            { return proto.CompactTextString(m) }
func (*RedactContentRequest) ProtoMessage()               {}
func (*RedactContentRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *RedactContentRequest) GetInspectConfig() *InspectConfig {
	if m != nil {
		return m.InspectConfig
	}
	return nil
}

func (m *RedactContentRequest) GetItems() []*ContentItem {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *RedactContentRequest) GetReplaceConfigs() []*RedactContentRequest_ReplaceConfig {
	if m != nil {
		return m.ReplaceConfigs
	}
	return nil
}

func (m *RedactContentRequest) GetImageRedactionConfigs() []*RedactContentRequest_ImageRedactionConfig {
	if m != nil {
		return m.ImageRedactionConfigs
	}
	return nil
}

type RedactContentRequest_ReplaceConfig struct {
	// Type of information to replace. Only one ReplaceConfig per info_type
	// should be provided. If ReplaceConfig does not have an info_type, the DLP
	// API matches it against all info_types that are found but not specified in
	// another ReplaceConfig.
	InfoType *InfoType `protobuf:"bytes,1,opt,name=info_type,json=infoType" json:"info_type,omitempty"`
	// Content replacing sensitive information of given type. Max 256 chars.
	ReplaceWith string `protobuf:"bytes,2,opt,name=replace_with,json=replaceWith" json:"replace_with,omitempty"`
}

func (m *RedactContentRequest_ReplaceConfig) Reset()         { *m = RedactContentRequest_ReplaceConfig{} }
func (m *RedactContentRequest_ReplaceConfig) String() string { return proto.CompactTextString(m) }
func (*RedactContentRequest_ReplaceConfig) ProtoMessage()    {}
func (*RedactContentRequest_ReplaceConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{10, 0}
}

func (m *RedactContentRequest_ReplaceConfig) GetInfoType() *InfoType {
	if m != nil {
		return m.InfoType
	}
	return nil
}

func (m *RedactContentRequest_ReplaceConfig) GetReplaceWith() string {
	if m != nil {
		return m.ReplaceWith
	}
	return ""
}

// Configuration for determing how redaction of images should occur.
type RedactContentRequest_ImageRedactionConfig struct {
	// Type of information to redact from images.
	//
	// Types that are valid to be assigned to Target:
	//	*RedactContentRequest_ImageRedactionConfig_InfoType
	//	*RedactContentRequest_ImageRedactionConfig_RedactAllText
	Target isRedactContentRequest_ImageRedactionConfig_Target `protobuf_oneof:"target"`
	// The color to use when redacting content from an image. If not specified,
	// the default is black.
	RedactionColor *Color `protobuf:"bytes,3,opt,name=redaction_color,json=redactionColor" json:"redaction_color,omitempty"`
}

func (m *RedactContentRequest_ImageRedactionConfig) Reset() {
	*m = RedactContentRequest_ImageRedactionConfig{}
}
func (m *RedactContentRequest_ImageRedactionConfig) String() string { return proto.CompactTextString(m) }
func (*RedactContentRequest_ImageRedactionConfig) ProtoMessage()    {}
func (*RedactContentRequest_ImageRedactionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{10, 1}
}

type isRedactContentRequest_ImageRedactionConfig_Target interface {
	isRedactContentRequest_ImageRedactionConfig_Target()
}

type RedactContentRequest_ImageRedactionConfig_InfoType struct {
	InfoType *InfoType `protobuf:"bytes,1,opt,name=info_type,json=infoType,oneof"`
}
type RedactContentRequest_ImageRedactionConfig_RedactAllText struct {
	RedactAllText bool `protobuf:"varint,2,opt,name=redact_all_text,json=redactAllText,oneof"`
}

func (*RedactContentRequest_ImageRedactionConfig_InfoType) isRedactContentRequest_ImageRedactionConfig_Target() {
}
func (*RedactContentRequest_ImageRedactionConfig_RedactAllText) isRedactContentRequest_ImageRedactionConfig_Target() {
}

func (m *RedactContentRequest_ImageRedactionConfig) GetTarget() isRedactContentRequest_ImageRedactionConfig_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *RedactContentRequest_ImageRedactionConfig) GetInfoType() *InfoType {
	if x, ok := m.GetTarget().(*RedactContentRequest_ImageRedactionConfig_InfoType); ok {
		return x.InfoType
	}
	return nil
}

func (m *RedactContentRequest_ImageRedactionConfig) GetRedactAllText() bool {
	if x, ok := m.GetTarget().(*RedactContentRequest_ImageRedactionConfig_RedactAllText); ok {
		return x.RedactAllText
	}
	return false
}

func (m *RedactContentRequest_ImageRedactionConfig) GetRedactionColor() *Color {
	if m != nil {
		return m.RedactionColor
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RedactContentRequest_ImageRedactionConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RedactContentRequest_ImageRedactionConfig_OneofMarshaler, _RedactContentRequest_ImageRedactionConfig_OneofUnmarshaler, _RedactContentRequest_ImageRedactionConfig_OneofSizer, []interface{}{
		(*RedactContentRequest_ImageRedactionConfig_InfoType)(nil),
		(*RedactContentRequest_ImageRedactionConfig_RedactAllText)(nil),
	}
}

func _RedactContentRequest_ImageRedactionConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RedactContentRequest_ImageRedactionConfig)
	// target
	switch x := m.Target.(type) {
	case *RedactContentRequest_ImageRedactionConfig_InfoType:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.InfoType); err != nil {
			return err
		}
	case *RedactContentRequest_ImageRedactionConfig_RedactAllText:
		t := uint64(0)
		if x.RedactAllText {
			t = 1
		}
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case nil:
	default:
		return fmt.Errorf("RedactContentRequest_ImageRedactionConfig.Target has unexpected type %T", x)
	}
	return nil
}

func _RedactContentRequest_ImageRedactionConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RedactContentRequest_ImageRedactionConfig)
	switch tag {
	case 1: // target.info_type
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(InfoType)
		err := b.DecodeMessage(msg)
		m.Target = &RedactContentRequest_ImageRedactionConfig_InfoType{msg}
		return true, err
	case 2: // target.redact_all_text
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Target = &RedactContentRequest_ImageRedactionConfig_RedactAllText{x != 0}
		return true, err
	default:
		return false, nil
	}
}

func _RedactContentRequest_ImageRedactionConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RedactContentRequest_ImageRedactionConfig)
	// target
	switch x := m.Target.(type) {
	case *RedactContentRequest_ImageRedactionConfig_InfoType:
		s := proto.Size(x.InfoType)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RedactContentRequest_ImageRedactionConfig_RedactAllText:
		n += proto.SizeVarint(2<<3 | proto.WireVarint)
		n += 1
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Represents a color in the RGB color space.
type Color struct {
	// The amount of red in the color as a value in the interval [0, 1].
	Red float32 `protobuf:"fixed32,1,opt,name=red" json:"red,omitempty"`
	// The amount of green in the color as a value in the interval [0, 1].
	Green float32 `protobuf:"fixed32,2,opt,name=green" json:"green,omitempty"`
	// The amount of blue in the color as a value in the interval [0, 1].
	Blue float32 `protobuf:"fixed32,3,opt,name=blue" json:"blue,omitempty"`
}

func (m *Color) Reset()                    { *m = Color{} }
func (m *Color) String() string            { return proto.CompactTextString(m) }
func (*Color) ProtoMessage()               {}
func (*Color) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *Color) GetRed() float32 {
	if m != nil {
		return m.Red
	}
	return 0
}

func (m *Color) GetGreen() float32 {
	if m != nil {
		return m.Green
	}
	return 0
}

func (m *Color) GetBlue() float32 {
	if m != nil {
		return m.Blue
	}
	return 0
}

// Results of redacting a list of items.
type RedactContentResponse struct {
	// The redacted content.
	Items []*ContentItem `protobuf:"bytes,1,rep,name=items" json:"items,omitempty"`
}

func (m *RedactContentResponse) Reset()                    { *m = RedactContentResponse{} }
func (m *RedactContentResponse) String() string            { return proto.CompactTextString(m) }
func (*RedactContentResponse) ProtoMessage()               {}
func (*RedactContentResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *RedactContentResponse) GetItems() []*ContentItem {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request to search for potentially sensitive info in a list of items.
type InspectContentRequest struct {
	// Configuration for the inspector.
	InspectConfig *InspectConfig `protobuf:"bytes,1,opt,name=inspect_config,json=inspectConfig" json:"inspect_config,omitempty"`
	// The list of items to inspect. Items in a single request are
	// considered "related" unless inspect_config.independent_inputs is true.
	// Up to 100 are allowed per request.
	Items []*ContentItem `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
}

func (m *InspectContentRequest) Reset()                    { *m = InspectContentRequest{} }
func (m *InspectContentRequest) String() string            { return proto.CompactTextString(m) }
func (*InspectContentRequest) ProtoMessage()               {}
func (*InspectContentRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *InspectContentRequest) GetInspectConfig() *InspectConfig {
	if m != nil {
		return m.InspectConfig
	}
	return nil
}

func (m *InspectContentRequest) GetItems() []*ContentItem {
	if m != nil {
		return m.Items
	}
	return nil
}

// Results of inspecting a list of items.
type InspectContentResponse struct {
	// Each content_item from the request has a result in this list, in the
	// same order as the request.
	Results []*InspectResult `protobuf:"bytes,1,rep,name=results" json:"results,omitempty"`
}

func (m *InspectContentResponse) Reset()                    { *m = InspectContentResponse{} }
func (m *InspectContentResponse) String() string            { return proto.CompactTextString(m) }
func (*InspectContentResponse) ProtoMessage()               {}
func (*InspectContentResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *InspectContentResponse) GetResults() []*InspectResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// Request for scheduling a scan of a data subset from a Google Platform data
// repository.
type CreateInspectOperationRequest struct {
	// Configuration for the inspector.
	InspectConfig *InspectConfig `protobuf:"bytes,1,opt,name=inspect_config,json=inspectConfig" json:"inspect_config,omitempty"`
	// Specification of the data set to process.
	StorageConfig *StorageConfig `protobuf:"bytes,2,opt,name=storage_config,json=storageConfig" json:"storage_config,omitempty"`
	// Optional location to store findings. The bucket must already exist and
	// the Google APIs service account for DLP must have write permission to
	// write to the given bucket.
	// <p>Results are split over multiple csv files with each file name matching
	// the pattern "[operation_id]_[count].csv", for example
	// `3094877188788974909_1.csv`. The `operation_id` matches the
	// identifier for the Operation, and the `count` is a counter used for
	// tracking the number of files written. <p>The CSV file(s) contain the
	// following columns regardless of storage type scanned: <li>id <li>info_type
	// <li>likelihood <li>byte size of finding <li>quote <li>timestamp<br/>
	// <p>For Cloud Storage the next columns are: <li>file_path
	// <li>start_offset<br/>
	// <p>For Cloud Datastore the next columns are: <li>project_id
	// <li>namespace_id <li>path <li>column_name <li>offset<br/>
	// <p>For BigQuery the next columns are: <li>row_number <li>project_id
	// <li>dataset_id <li>table_id
	OutputConfig *OutputStorageConfig `protobuf:"bytes,3,opt,name=output_config,json=outputConfig" json:"output_config,omitempty"`
	// Additional configuration settings for long running operations.
	OperationConfig *OperationConfig `protobuf:"bytes,5,opt,name=operation_config,json=operationConfig" json:"operation_config,omitempty"`
}

func (m *CreateInspectOperationRequest) Reset()                    { *m = CreateInspectOperationRequest{} }
func (m *CreateInspectOperationRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateInspectOperationRequest) ProtoMessage()               {}
func (*CreateInspectOperationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *CreateInspectOperationRequest) GetInspectConfig() *InspectConfig {
	if m != nil {
		return m.InspectConfig
	}
	return nil
}

func (m *CreateInspectOperationRequest) GetStorageConfig() *StorageConfig {
	if m != nil {
		return m.StorageConfig
	}
	return nil
}

func (m *CreateInspectOperationRequest) GetOutputConfig() *OutputStorageConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

func (m *CreateInspectOperationRequest) GetOperationConfig() *OperationConfig {
	if m != nil {
		return m.OperationConfig
	}
	return nil
}

// Cloud repository for storing output.
type OutputStorageConfig struct {
	// Types that are valid to be assigned to Type:
	//	*OutputStorageConfig_Table
	//	*OutputStorageConfig_StoragePath
	Type isOutputStorageConfig_Type `protobuf_oneof:"type"`
}

func (m *OutputStorageConfig) Reset()                    { *m = OutputStorageConfig{} }
func (m *OutputStorageConfig) String() string            { return proto.CompactTextString(m) }
func (*OutputStorageConfig) ProtoMessage()               {}
func (*OutputStorageConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

type isOutputStorageConfig_Type interface {
	isOutputStorageConfig_Type()
}

type OutputStorageConfig_Table struct {
	Table *BigQueryTable `protobuf:"bytes,1,opt,name=table,oneof"`
}
type OutputStorageConfig_StoragePath struct {
	StoragePath *CloudStoragePath `protobuf:"bytes,2,opt,name=storage_path,json=storagePath,oneof"`
}

func (*OutputStorageConfig_Table) isOutputStorageConfig_Type()       {}
func (*OutputStorageConfig_StoragePath) isOutputStorageConfig_Type() {}

func (m *OutputStorageConfig) GetType() isOutputStorageConfig_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *OutputStorageConfig) GetTable() *BigQueryTable {
	if x, ok := m.GetType().(*OutputStorageConfig_Table); ok {
		return x.Table
	}
	return nil
}

func (m *OutputStorageConfig) GetStoragePath() *CloudStoragePath {
	if x, ok := m.GetType().(*OutputStorageConfig_StoragePath); ok {
		return x.StoragePath
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*OutputStorageConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _OutputStorageConfig_OneofMarshaler, _OutputStorageConfig_OneofUnmarshaler, _OutputStorageConfig_OneofSizer, []interface{}{
		(*OutputStorageConfig_Table)(nil),
		(*OutputStorageConfig_StoragePath)(nil),
	}
}

func _OutputStorageConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*OutputStorageConfig)
	// type
	switch x := m.Type.(type) {
	case *OutputStorageConfig_Table:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Table); err != nil {
			return err
		}
	case *OutputStorageConfig_StoragePath:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StoragePath); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("OutputStorageConfig.Type has unexpected type %T", x)
	}
	return nil
}

func _OutputStorageConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*OutputStorageConfig)
	switch tag {
	case 1: // type.table
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BigQueryTable)
		err := b.DecodeMessage(msg)
		m.Type = &OutputStorageConfig_Table{msg}
		return true, err
	case 2: // type.storage_path
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CloudStoragePath)
		err := b.DecodeMessage(msg)
		m.Type = &OutputStorageConfig_StoragePath{msg}
		return true, err
	default:
		return false, nil
	}
}

func _OutputStorageConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*OutputStorageConfig)
	// type
	switch x := m.Type.(type) {
	case *OutputStorageConfig_Table:
		s := proto.Size(x.Table)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OutputStorageConfig_StoragePath:
		s := proto.Size(x.StoragePath)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Statistics regarding a specific InfoType.
type InfoTypeStatistics struct {
	// The type of finding this stat is for.
	InfoType *InfoType `protobuf:"bytes,1,opt,name=info_type,json=infoType" json:"info_type,omitempty"`
	// Number of findings for this info type.
	Count int64 `protobuf:"varint,2,opt,name=count" json:"count,omitempty"`
}

func (m *InfoTypeStatistics) Reset()                    { *m = InfoTypeStatistics{} }
func (m *InfoTypeStatistics) String() string            { return proto.CompactTextString(m) }
func (*InfoTypeStatistics) ProtoMessage()               {}
func (*InfoTypeStatistics) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *InfoTypeStatistics) GetInfoType() *InfoType {
	if m != nil {
		return m.InfoType
	}
	return nil
}

func (m *InfoTypeStatistics) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

// Metadata returned within GetOperation for an inspect request.
type InspectOperationMetadata struct {
	// Total size in bytes that were processed.
	ProcessedBytes int64 `protobuf:"varint,1,opt,name=processed_bytes,json=processedBytes" json:"processed_bytes,omitempty"`
	// Estimate of the number of bytes to process.
	TotalEstimatedBytes int64                 `protobuf:"varint,4,opt,name=total_estimated_bytes,json=totalEstimatedBytes" json:"total_estimated_bytes,omitempty"`
	InfoTypeStats       []*InfoTypeStatistics `protobuf:"bytes,2,rep,name=info_type_stats,json=infoTypeStats" json:"info_type_stats,omitempty"`
	// The time which this request was started.
	CreateTime *google_protobuf3.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
	// The inspect config used to create the Operation.
	RequestInspectConfig *InspectConfig `protobuf:"bytes,5,opt,name=request_inspect_config,json=requestInspectConfig" json:"request_inspect_config,omitempty"`
	// The storage config used to create the Operation.
	RequestStorageConfig *StorageConfig `protobuf:"bytes,6,opt,name=request_storage_config,json=requestStorageConfig" json:"request_storage_config,omitempty"`
	// Optional location to store findings.
	RequestOutputConfig *OutputStorageConfig `protobuf:"bytes,7,opt,name=request_output_config,json=requestOutputConfig" json:"request_output_config,omitempty"`
}

func (m *InspectOperationMetadata) Reset()                    { *m = InspectOperationMetadata{} }
func (m *InspectOperationMetadata) String() string            { return proto.CompactTextString(m) }
func (*InspectOperationMetadata) ProtoMessage()               {}
func (*InspectOperationMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *InspectOperationMetadata) GetProcessedBytes() int64 {
	if m != nil {
		return m.ProcessedBytes
	}
	return 0
}

func (m *InspectOperationMetadata) GetTotalEstimatedBytes() int64 {
	if m != nil {
		return m.TotalEstimatedBytes
	}
	return 0
}

func (m *InspectOperationMetadata) GetInfoTypeStats() []*InfoTypeStatistics {
	if m != nil {
		return m.InfoTypeStats
	}
	return nil
}

func (m *InspectOperationMetadata) GetCreateTime() *google_protobuf3.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *InspectOperationMetadata) GetRequestInspectConfig() *InspectConfig {
	if m != nil {
		return m.RequestInspectConfig
	}
	return nil
}

func (m *InspectOperationMetadata) GetRequestStorageConfig() *StorageConfig {
	if m != nil {
		return m.RequestStorageConfig
	}
	return nil
}

func (m *InspectOperationMetadata) GetRequestOutputConfig() *OutputStorageConfig {
	if m != nil {
		return m.RequestOutputConfig
	}
	return nil
}

// The operational data.
type InspectOperationResult struct {
	// The server-assigned name, which is only unique within the same service that
	// originally returns it. If you use the default HTTP mapping, the
	// `name` should have the format of `inspect/results/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *InspectOperationResult) Reset()                    { *m = InspectOperationResult{} }
func (m *InspectOperationResult) String() string            { return proto.CompactTextString(m) }
func (*InspectOperationResult) ProtoMessage()               {}
func (*InspectOperationResult) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *InspectOperationResult) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for the list of results in a given inspect operation.
type ListInspectFindingsRequest struct {
	// Identifier of the results set returned as metadata of
	// the longrunning operation created by a call to CreateInspectOperation.
	// Should be in the format of `inspect/results/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Maximum number of results to return.
	// If 0, the implementation selects a reasonable value.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The value returned by the last `ListInspectFindingsResponse`; indicates
	// that this is a continuation of a prior `ListInspectFindings` call, and that
	// the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// Restricts findings to items that match. Supports info_type and likelihood.
	// <p>Examples:<br/>
	// <li>info_type=EMAIL_ADDRESS
	// <li>info_type=PHONE_NUMBER,EMAIL_ADDRESS
	// <li>likelihood=VERY_LIKELY
	// <li>likelihood=VERY_LIKELY,LIKELY
	// <li>info_type=EMAIL_ADDRESS,likelihood=VERY_LIKELY,LIKELY
	Filter string `protobuf:"bytes,4,opt,name=filter" json:"filter,omitempty"`
}

func (m *ListInspectFindingsRequest) Reset()                    { *m = ListInspectFindingsRequest{} }
func (m *ListInspectFindingsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListInspectFindingsRequest) ProtoMessage()               {}
func (*ListInspectFindingsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *ListInspectFindingsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListInspectFindingsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListInspectFindingsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListInspectFindingsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// Response to the ListInspectFindings request.
type ListInspectFindingsResponse struct {
	// The results.
	Result *InspectResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
	// If not empty, indicates that there may be more results that match the
	// request; this value should be passed in a new `ListInspectFindingsRequest`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListInspectFindingsResponse) Reset()                    { *m = ListInspectFindingsResponse{} }
func (m *ListInspectFindingsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListInspectFindingsResponse) ProtoMessage()               {}
func (*ListInspectFindingsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *ListInspectFindingsResponse) GetResult() *InspectResult {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *ListInspectFindingsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Info type description.
type InfoTypeDescription struct {
	// Internal name of the info type.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Human readable form of the info type name.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// List of categories this info type belongs to.
	Categories []*CategoryDescription `protobuf:"bytes,3,rep,name=categories" json:"categories,omitempty"`
}

func (m *InfoTypeDescription) Reset()                    { *m = InfoTypeDescription{} }
func (m *InfoTypeDescription) String() string            { return proto.CompactTextString(m) }
func (*InfoTypeDescription) ProtoMessage()               {}
func (*InfoTypeDescription) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *InfoTypeDescription) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *InfoTypeDescription) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *InfoTypeDescription) GetCategories() []*CategoryDescription {
	if m != nil {
		return m.Categories
	}
	return nil
}

// Request for the list of info types belonging to a given category,
// or all supported info types if no category is specified.
type ListInfoTypesRequest struct {
	// Category name as returned by ListRootCategories.
	Category string `protobuf:"bytes,1,opt,name=category" json:"category,omitempty"`
	// Optional BCP-47 language code for localized info type friendly
	// names. If omitted, or if localized strings are not available,
	// en-US strings will be returned.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode" json:"language_code,omitempty"`
}

func (m *ListInfoTypesRequest) Reset()                    { *m = ListInfoTypesRequest{} }
func (m *ListInfoTypesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListInfoTypesRequest) ProtoMessage()               {}
func (*ListInfoTypesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *ListInfoTypesRequest) GetCategory() string {
	if m != nil {
		return m.Category
	}
	return ""
}

func (m *ListInfoTypesRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Response to the ListInfoTypes request.
type ListInfoTypesResponse struct {
	// Set of sensitive info types belonging to a category.
	InfoTypes []*InfoTypeDescription `protobuf:"bytes,1,rep,name=info_types,json=infoTypes" json:"info_types,omitempty"`
}

func (m *ListInfoTypesResponse) Reset()                    { *m = ListInfoTypesResponse{} }
func (m *ListInfoTypesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListInfoTypesResponse) ProtoMessage()               {}
func (*ListInfoTypesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *ListInfoTypesResponse) GetInfoTypes() []*InfoTypeDescription {
	if m != nil {
		return m.InfoTypes
	}
	return nil
}

// Info Type Category description.
type CategoryDescription struct {
	// Internal name of the category.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Human readable form of the category name.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
}

func (m *CategoryDescription) Reset()                    { *m = CategoryDescription{} }
func (m *CategoryDescription) String() string            { return proto.CompactTextString(m) }
func (*CategoryDescription) ProtoMessage()               {}
func (*CategoryDescription) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *CategoryDescription) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CategoryDescription) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

// Request for root categories of Info Types supported by the API.
// Example values might include "FINANCE", "HEALTH", "FAST", "DEFAULT".
type ListRootCategoriesRequest struct {
	// Optional language code for localized friendly category names.
	// If omitted or if localized strings are not available,
	// en-US strings will be returned.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode" json:"language_code,omitempty"`
}

func (m *ListRootCategoriesRequest) Reset()                    { *m = ListRootCategoriesRequest{} }
func (m *ListRootCategoriesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListRootCategoriesRequest) ProtoMessage()               {}
func (*ListRootCategoriesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

func (m *ListRootCategoriesRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Response for ListRootCategories request.
type ListRootCategoriesResponse struct {
	// List of all into type categories supported by the API.
	Categories []*CategoryDescription `protobuf:"bytes,1,rep,name=categories" json:"categories,omitempty"`
}

func (m *ListRootCategoriesResponse) Reset()                    { *m = ListRootCategoriesResponse{} }
func (m *ListRootCategoriesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListRootCategoriesResponse) ProtoMessage()               {}
func (*ListRootCategoriesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *ListRootCategoriesResponse) GetCategories() []*CategoryDescription {
	if m != nil {
		return m.Categories
	}
	return nil
}

// Set of primitive values supported by the system.
type Value struct {
	// Types that are valid to be assigned to Type:
	//	*Value_IntegerValue
	//	*Value_FloatValue
	//	*Value_StringValue
	//	*Value_BooleanValue
	//	*Value_TimestampValue
	//	*Value_TimeValue
	//	*Value_DateValue
	Type isValue_Type `protobuf_oneof:"type"`
}

func (m *Value) Reset()                    { *m = Value{} }
func (m *Value) String() string            { return proto.CompactTextString(m) }
func (*Value) ProtoMessage()               {}
func (*Value) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

type isValue_Type interface {
	isValue_Type()
}

type Value_IntegerValue struct {
	IntegerValue int64 `protobuf:"varint,1,opt,name=integer_value,json=integerValue,oneof"`
}
type Value_FloatValue struct {
	FloatValue float64 `protobuf:"fixed64,2,opt,name=float_value,json=floatValue,oneof"`
}
type Value_StringValue struct {
	StringValue string `protobuf:"bytes,3,opt,name=string_value,json=stringValue,oneof"`
}
type Value_BooleanValue struct {
	BooleanValue bool `protobuf:"varint,4,opt,name=boolean_value,json=booleanValue,oneof"`
}
type Value_TimestampValue struct {
	TimestampValue *google_protobuf3.Timestamp `protobuf:"bytes,5,opt,name=timestamp_value,json=timestampValue,oneof"`
}
type Value_TimeValue struct {
	TimeValue *google_type1.TimeOfDay `protobuf:"bytes,6,opt,name=time_value,json=timeValue,oneof"`
}
type Value_DateValue struct {
	DateValue *google_type.Date `protobuf:"bytes,7,opt,name=date_value,json=dateValue,oneof"`
}

func (*Value_IntegerValue) isValue_Type()   {}
func (*Value_FloatValue) isValue_Type()     {}
func (*Value_StringValue) isValue_Type()    {}
func (*Value_BooleanValue) isValue_Type()   {}
func (*Value_TimestampValue) isValue_Type() {}
func (*Value_TimeValue) isValue_Type()      {}
func (*Value_DateValue) isValue_Type()      {}

func (m *Value) GetType() isValue_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *Value) GetIntegerValue() int64 {
	if x, ok := m.GetType().(*Value_IntegerValue); ok {
		return x.IntegerValue
	}
	return 0
}

func (m *Value) GetFloatValue() float64 {
	if x, ok := m.GetType().(*Value_FloatValue); ok {
		return x.FloatValue
	}
	return 0
}

func (m *Value) GetStringValue() string {
	if x, ok := m.GetType().(*Value_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (m *Value) GetBooleanValue() bool {
	if x, ok := m.GetType().(*Value_BooleanValue); ok {
		return x.BooleanValue
	}
	return false
}

func (m *Value) GetTimestampValue() *google_protobuf3.Timestamp {
	if x, ok := m.GetType().(*Value_TimestampValue); ok {
		return x.TimestampValue
	}
	return nil
}

func (m *Value) GetTimeValue() *google_type1.TimeOfDay {
	if x, ok := m.GetType().(*Value_TimeValue); ok {
		return x.TimeValue
	}
	return nil
}

func (m *Value) GetDateValue() *google_type.Date {
	if x, ok := m.GetType().(*Value_DateValue); ok {
		return x.DateValue
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Value) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Value_OneofMarshaler, _Value_OneofUnmarshaler, _Value_OneofSizer, []interface{}{
		(*Value_IntegerValue)(nil),
		(*Value_FloatValue)(nil),
		(*Value_StringValue)(nil),
		(*Value_BooleanValue)(nil),
		(*Value_TimestampValue)(nil),
		(*Value_TimeValue)(nil),
		(*Value_DateValue)(nil),
	}
}

func _Value_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Value)
	// type
	switch x := m.Type.(type) {
	case *Value_IntegerValue:
		b.EncodeVarint(1<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.IntegerValue))
	case *Value_FloatValue:
		b.EncodeVarint(2<<3 | proto.WireFixed64)
		b.EncodeFixed64(math.Float64bits(x.FloatValue))
	case *Value_StringValue:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.StringValue)
	case *Value_BooleanValue:
		t := uint64(0)
		if x.BooleanValue {
			t = 1
		}
		b.EncodeVarint(4<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *Value_TimestampValue:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TimestampValue); err != nil {
			return err
		}
	case *Value_TimeValue:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TimeValue); err != nil {
			return err
		}
	case *Value_DateValue:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DateValue); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Value.Type has unexpected type %T", x)
	}
	return nil
}

func _Value_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Value)
	switch tag {
	case 1: // type.integer_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Type = &Value_IntegerValue{int64(x)}
		return true, err
	case 2: // type.float_value
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.Type = &Value_FloatValue{math.Float64frombits(x)}
		return true, err
	case 3: // type.string_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Type = &Value_StringValue{x}
		return true, err
	case 4: // type.boolean_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Type = &Value_BooleanValue{x != 0}
		return true, err
	case 5: // type.timestamp_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf3.Timestamp)
		err := b.DecodeMessage(msg)
		m.Type = &Value_TimestampValue{msg}
		return true, err
	case 6: // type.time_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_type1.TimeOfDay)
		err := b.DecodeMessage(msg)
		m.Type = &Value_TimeValue{msg}
		return true, err
	case 7: // type.date_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_type.Date)
		err := b.DecodeMessage(msg)
		m.Type = &Value_DateValue{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Value_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Value)
	// type
	switch x := m.Type.(type) {
	case *Value_IntegerValue:
		n += proto.SizeVarint(1<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.IntegerValue))
	case *Value_FloatValue:
		n += proto.SizeVarint(2<<3 | proto.WireFixed64)
		n += 8
	case *Value_StringValue:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.StringValue)))
		n += len(x.StringValue)
	case *Value_BooleanValue:
		n += proto.SizeVarint(4<<3 | proto.WireVarint)
		n += 1
	case *Value_TimestampValue:
		s := proto.Size(x.TimestampValue)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Value_TimeValue:
		s := proto.Size(x.TimeValue)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Value_DateValue:
		s := proto.Size(x.DateValue)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*InspectConfig)(nil), "google.privacy.dlp.v2beta1.InspectConfig")
	proto.RegisterType((*InspectConfig_InfoTypeLimit)(nil), "google.privacy.dlp.v2beta1.InspectConfig.InfoTypeLimit")
	proto.RegisterType((*OperationConfig)(nil), "google.privacy.dlp.v2beta1.OperationConfig")
	proto.RegisterType((*ContentItem)(nil), "google.privacy.dlp.v2beta1.ContentItem")
	proto.RegisterType((*Table)(nil), "google.privacy.dlp.v2beta1.Table")
	proto.RegisterType((*Table_Row)(nil), "google.privacy.dlp.v2beta1.Table.Row")
	proto.RegisterType((*InspectResult)(nil), "google.privacy.dlp.v2beta1.InspectResult")
	proto.RegisterType((*Finding)(nil), "google.privacy.dlp.v2beta1.Finding")
	proto.RegisterType((*Location)(nil), "google.privacy.dlp.v2beta1.Location")
	proto.RegisterType((*TableLocation)(nil), "google.privacy.dlp.v2beta1.TableLocation")
	proto.RegisterType((*Range)(nil), "google.privacy.dlp.v2beta1.Range")
	proto.RegisterType((*ImageLocation)(nil), "google.privacy.dlp.v2beta1.ImageLocation")
	proto.RegisterType((*RedactContentRequest)(nil), "google.privacy.dlp.v2beta1.RedactContentRequest")
	proto.RegisterType((*RedactContentRequest_ReplaceConfig)(nil), "google.privacy.dlp.v2beta1.RedactContentRequest.ReplaceConfig")
	proto.RegisterType((*RedactContentRequest_ImageRedactionConfig)(nil), "google.privacy.dlp.v2beta1.RedactContentRequest.ImageRedactionConfig")
	proto.RegisterType((*Color)(nil), "google.privacy.dlp.v2beta1.Color")
	proto.RegisterType((*RedactContentResponse)(nil), "google.privacy.dlp.v2beta1.RedactContentResponse")
	proto.RegisterType((*InspectContentRequest)(nil), "google.privacy.dlp.v2beta1.InspectContentRequest")
	proto.RegisterType((*InspectContentResponse)(nil), "google.privacy.dlp.v2beta1.InspectContentResponse")
	proto.RegisterType((*CreateInspectOperationRequest)(nil), "google.privacy.dlp.v2beta1.CreateInspectOperationRequest")
	proto.RegisterType((*OutputStorageConfig)(nil), "google.privacy.dlp.v2beta1.OutputStorageConfig")
	proto.RegisterType((*InfoTypeStatistics)(nil), "google.privacy.dlp.v2beta1.InfoTypeStatistics")
	proto.RegisterType((*InspectOperationMetadata)(nil), "google.privacy.dlp.v2beta1.InspectOperationMetadata")
	proto.RegisterType((*InspectOperationResult)(nil), "google.privacy.dlp.v2beta1.InspectOperationResult")
	proto.RegisterType((*ListInspectFindingsRequest)(nil), "google.privacy.dlp.v2beta1.ListInspectFindingsRequest")
	proto.RegisterType((*ListInspectFindingsResponse)(nil), "google.privacy.dlp.v2beta1.ListInspectFindingsResponse")
	proto.RegisterType((*InfoTypeDescription)(nil), "google.privacy.dlp.v2beta1.InfoTypeDescription")
	proto.RegisterType((*ListInfoTypesRequest)(nil), "google.privacy.dlp.v2beta1.ListInfoTypesRequest")
	proto.RegisterType((*ListInfoTypesResponse)(nil), "google.privacy.dlp.v2beta1.ListInfoTypesResponse")
	proto.RegisterType((*CategoryDescription)(nil), "google.privacy.dlp.v2beta1.CategoryDescription")
	proto.RegisterType((*ListRootCategoriesRequest)(nil), "google.privacy.dlp.v2beta1.ListRootCategoriesRequest")
	proto.RegisterType((*ListRootCategoriesResponse)(nil), "google.privacy.dlp.v2beta1.ListRootCategoriesResponse")
	proto.RegisterType((*Value)(nil), "google.privacy.dlp.v2beta1.Value")
	proto.RegisterEnum("google.privacy.dlp.v2beta1.Likelihood", Likelihood_name, Likelihood_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for DlpService service

type DlpServiceClient interface {
	// Finds potentially sensitive info in a list of strings.
	// This method has limits on input size, processing time, and output size.
	InspectContent(ctx context.Context, in *InspectContentRequest, opts ...grpc.CallOption) (*InspectContentResponse, error)
	// Redacts potentially sensitive info from a list of strings.
	// This method has limits on input size, processing time, and output size.
	RedactContent(ctx context.Context, in *RedactContentRequest, opts ...grpc.CallOption) (*RedactContentResponse, error)
	// Schedules a job scanning content in a Google Cloud Platform data
	// repository.
	CreateInspectOperation(ctx context.Context, in *CreateInspectOperationRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Returns list of results for given inspect operation result set id.
	ListInspectFindings(ctx context.Context, in *ListInspectFindingsRequest, opts ...grpc.CallOption) (*ListInspectFindingsResponse, error)
	// Returns sensitive information types for given category.
	ListInfoTypes(ctx context.Context, in *ListInfoTypesRequest, opts ...grpc.CallOption) (*ListInfoTypesResponse, error)
	// Returns the list of root categories of sensitive information.
	ListRootCategories(ctx context.Context, in *ListRootCategoriesRequest, opts ...grpc.CallOption) (*ListRootCategoriesResponse, error)
}

type dlpServiceClient struct {
	cc *grpc.ClientConn
}

func NewDlpServiceClient(cc *grpc.ClientConn) DlpServiceClient {
	return &dlpServiceClient{cc}
}

func (c *dlpServiceClient) InspectContent(ctx context.Context, in *InspectContentRequest, opts ...grpc.CallOption) (*InspectContentResponse, error) {
	out := new(InspectContentResponse)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta1.DlpService/InspectContent", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) RedactContent(ctx context.Context, in *RedactContentRequest, opts ...grpc.CallOption) (*RedactContentResponse, error) {
	out := new(RedactContentResponse)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta1.DlpService/RedactContent", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) CreateInspectOperation(ctx context.Context, in *CreateInspectOperationRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta1.DlpService/CreateInspectOperation", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListInspectFindings(ctx context.Context, in *ListInspectFindingsRequest, opts ...grpc.CallOption) (*ListInspectFindingsResponse, error) {
	out := new(ListInspectFindingsResponse)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta1.DlpService/ListInspectFindings", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListInfoTypes(ctx context.Context, in *ListInfoTypesRequest, opts ...grpc.CallOption) (*ListInfoTypesResponse, error) {
	out := new(ListInfoTypesResponse)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta1.DlpService/ListInfoTypes", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListRootCategories(ctx context.Context, in *ListRootCategoriesRequest, opts ...grpc.CallOption) (*ListRootCategoriesResponse, error) {
	out := new(ListRootCategoriesResponse)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta1.DlpService/ListRootCategories", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for DlpService service

type DlpServiceServer interface {
	// Finds potentially sensitive info in a list of strings.
	// This method has limits on input size, processing time, and output size.
	InspectContent(context.Context, *InspectContentRequest) (*InspectContentResponse, error)
	// Redacts potentially sensitive info from a list of strings.
	// This method has limits on input size, processing time, and output size.
	RedactContent(context.Context, *RedactContentRequest) (*RedactContentResponse, error)
	// Schedules a job scanning content in a Google Cloud Platform data
	// repository.
	CreateInspectOperation(context.Context, *CreateInspectOperationRequest) (*google_longrunning.Operation, error)
	// Returns list of results for given inspect operation result set id.
	ListInspectFindings(context.Context, *ListInspectFindingsRequest) (*ListInspectFindingsResponse, error)
	// Returns sensitive information types for given category.
	ListInfoTypes(context.Context, *ListInfoTypesRequest) (*ListInfoTypesResponse, error)
	// Returns the list of root categories of sensitive information.
	ListRootCategories(context.Context, *ListRootCategoriesRequest) (*ListRootCategoriesResponse, error)
}

func RegisterDlpServiceServer(s *grpc.Server, srv DlpServiceServer) {
	s.RegisterService(&_DlpService_serviceDesc, srv)
}

func _DlpService_InspectContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InspectContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).InspectContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta1.DlpService/InspectContent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).InspectContent(ctx, req.(*InspectContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_RedactContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RedactContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).RedactContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta1.DlpService/RedactContent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).RedactContent(ctx, req.(*RedactContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_CreateInspectOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInspectOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).CreateInspectOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta1.DlpService/CreateInspectOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).CreateInspectOperation(ctx, req.(*CreateInspectOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListInspectFindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInspectFindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListInspectFindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta1.DlpService/ListInspectFindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListInspectFindings(ctx, req.(*ListInspectFindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListInfoTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInfoTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListInfoTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta1.DlpService/ListInfoTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListInfoTypes(ctx, req.(*ListInfoTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListRootCategories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRootCategoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListRootCategories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta1.DlpService/ListRootCategories",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListRootCategories(ctx, req.(*ListRootCategoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DlpService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.privacy.dlp.v2beta1.DlpService",
	HandlerType: (*DlpServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "InspectContent",
			Handler:    _DlpService_InspectContent_Handler,
		},
		{
			MethodName: "RedactContent",
			Handler:    _DlpService_RedactContent_Handler,
		},
		{
			MethodName: "CreateInspectOperation",
			Handler:    _DlpService_CreateInspectOperation_Handler,
		},
		{
			MethodName: "ListInspectFindings",
			Handler:    _DlpService_ListInspectFindings_Handler,
		},
		{
			MethodName: "ListInfoTypes",
			Handler:    _DlpService_ListInfoTypes_Handler,
		},
		{
			MethodName: "ListRootCategories",
			Handler:    _DlpService_ListRootCategories_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/privacy/dlp/v2beta1/dlp.proto",
}

func init() { proto.RegisterFile("google/privacy/dlp/v2beta1/dlp.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 2313 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x59, 0xcf, 0x6f, 0x1b, 0xc7,
	0xf5, 0xd7, 0x52, 0xa2, 0x44, 0x3e, 0x8a, 0x92, 0x3c, 0xfa, 0x61, 0x85, 0x8e, 0xbf, 0x91, 0x57,
	0x89, 0x23, 0xeb, 0xeb, 0x92, 0x31, 0x8b, 0xda, 0x70, 0x02, 0xa5, 0xb6, 0x28, 0xb9, 0x52, 0xa3,
	0x58, 0xf2, 0x48, 0x51, 0x90, 0x02, 0xc5, 0x62, 0xc5, 0x1d, 0x51, 0x03, 0x2f, 0x77, 0x36, 0xbb,
	0x43, 0x4b, 0x4c, 0x60, 0x14, 0x28, 0x8a, 0xa2, 0xf7, 0x1e, 0x5a, 0x14, 0xed, 0xad, 0x87, 0xb6,
	0xe8, 0x2d, 0xb7, 0xa2, 0xb7, 0xfe, 0x09, 0x3d, 0x15, 0xbd, 0xe6, 0xd4, 0x5b, 0x2f, 0x3d, 0x17,
	0xf3, 0x6b, 0xb9, 0x94, 0xe8, 0x95, 0xe8, 0xa6, 0x40, 0x6f, 0x33, 0x6f, 0xde, 0xe7, 0xcd, 0x9b,
	0x37, 0xef, 0xd7, 0xec, 0xc2, 0xdb, 0x2d, 0xc6, 0x5a, 0x3e, 0xa9, 0x85, 0x11, 0x7d, 0xe1, 0x36,
	0xbb, 0x35, 0xcf, 0x0f, 0x6b, 0x2f, 0xea, 0x47, 0x84, 0xbb, 0xf7, 0xc4, 0xb8, 0x1a, 0x46, 0x8c,
	0x33, 0x54, 0x51, 0x5c, 0x55, 0xcd, 0x55, 0x15, 0x2b, 0x9a, 0xab, 0xf2, 0xa6, 0x96, 0xe0, 0x86,
	0xb4, 0xe6, 0x06, 0x01, 0xe3, 0x2e, 0xa7, 0x2c, 0x88, 0x15, 0xb2, 0xb2, 0xac, 0x57, 0x7d, 0x16,
	0xb4, 0xa2, 0x4e, 0x10, 0xd0, 0xa0, 0x55, 0x63, 0x21, 0x89, 0xfa, 0x98, 0x56, 0x32, 0x94, 0x88,
	0x39, 0x8b, 0xdc, 0x16, 0xd1, 0x9c, 0x37, 0x12, 0x4e, 0xc6, 0xd9, 0x51, 0xe7, 0xb8, 0x46, 0xda,
	0x21, 0xef, 0xea, 0xc5, 0xb7, 0xce, 0x2f, 0x72, 0xda, 0x26, 0x31, 0x77, 0xdb, 0xfa, 0x18, 0x95,
	0x05, 0xcd, 0xc0, 0xbb, 0x21, 0xa9, 0x79, 0x2e, 0x3f, 0x2f, 0x55, 0xd2, 0x05, 0x88, 0x1d, 0x7b,
	0xae, 0x96, 0x6a, 0xff, 0x63, 0x14, 0xca, 0xdb, 0x41, 0x1c, 0x92, 0x26, 0x6f, 0xb0, 0xe0, 0x98,
	0xb6, 0x50, 0x03, 0x80, 0x06, 0xc7, 0xcc, 0x11, 0xec, 0xf1, 0xa2, 0xb5, 0x34, 0xba, 0x52, 0xaa,
	0xbf, 0x5d, 0x7d, 0xb5, 0x89, 0xaa, 0xdb, 0xc1, 0x31, 0x3b, 0xe8, 0x86, 0x04, 0x17, 0xa9, 0x1e,
	0xc5, 0xe8, 0x63, 0x98, 0x6a, 0xd3, 0xc0, 0xf1, 0xe9, 0x73, 0xe2, 0xd3, 0x13, 0xc6, 0xbc, 0xc5,
	0xdc, 0x92, 0xb5, 0x32, 0x55, 0xbf, 0x9d, 0x25, 0x68, 0x27, 0xe1, 0xc6, 0xe5, 0x36, 0x0d, 0x7a,
	0x53, 0x74, 0x0b, 0x26, 0xdb, 0xee, 0x99, 0x73, 0x4c, 0x03, 0x8f, 0x06, 0xad, 0x78, 0x71, 0x74,
	0xc9, 0x5a, 0xc9, 0xe3, 0x52, 0xdb, 0x3d, 0x7b, 0xa2, 0x49, 0x68, 0x19, 0xca, 0x34, 0x68, 0xfa,
	0x1d, 0x8f, 0x38, 0x9f, 0x77, 0x18, 0x27, 0x8b, 0x63, 0x4b, 0xd6, 0x4a, 0x01, 0x4f, 0x6a, 0xe2,
	0x33, 0x41, 0x13, 0x4c, 0xe4, 0x4c, 0x31, 0xa9, 0xe3, 0x8d, 0x2b, 0x26, 0x4d, 0x54, 0xba, 0xbb,
	0x30, 0x93, 0x18, 0xc0, 0xf1, 0x69, 0x9b, 0xf2, 0x78, 0x71, 0x42, 0x9a, 0xe1, 0x41, 0xb6, 0x19,
	0x52, 0x56, 0x4c, 0x8c, 0xb2, 0x23, 0xf0, 0x78, 0x8a, 0xa6, 0xa7, 0x71, 0xa5, 0x23, 0x8c, 0x9e,
	0xa2, 0xa0, 0xc7, 0x50, 0x4c, 0xf6, 0x5c, 0xb4, 0x96, 0xac, 0x2b, 0xdb, 0xbc, 0x60, 0x24, 0x5f,
	0xb0, 0x51, 0xee, 0x82, 0x8d, 0xec, 0x35, 0x98, 0xde, 0x35, 0xde, 0xa9, 0x6f, 0x7b, 0x15, 0xae,
	0x09, 0x14, 0xe5, 0xa4, 0xdd, 0x83, 0x0a, 0x05, 0x46, 0xf1, 0x74, 0xdb, 0x3d, 0xdb, 0xe6, 0xa4,
	0x9d, 0xc0, 0x7f, 0x61, 0x41, 0xa9, 0xc1, 0x02, 0x4e, 0x02, 0x2e, 0xe8, 0x08, 0xc1, 0x58, 0xa2,
	0x6f, 0x11, 0xcb, 0x31, 0x9a, 0x83, 0x31, 0xcf, 0xe5, 0xae, 0xdc, 0x7d, 0x72, 0x6b, 0x04, 0xcb,
	0x19, 0x5a, 0x80, 0xfc, 0x0b, 0xd7, 0xef, 0x10, 0x79, 0x71, 0xc5, 0xad, 0x11, 0xac, 0xa6, 0xe8,
	0x21, 0xe4, 0xb9, 0x7b, 0xe4, 0xab, 0xcb, 0x2a, 0xd5, 0x6f, 0x65, 0x1d, 0xf9, 0x40, 0x30, 0x0a,
	0xa8, 0x44, 0xac, 0x97, 0xa0, 0x28, 0x44, 0x4b, 0xcd, 0xed, 0xbf, 0x58, 0x90, 0x97, 0xeb, 0x68,
	0x0d, 0x26, 0x4e, 0x88, 0xeb, 0x91, 0xc8, 0xb8, 0xee, 0x72, 0x96, 0xcc, 0x27, 0x94, 0xf8, 0xde,
	0xb6, 0x87, 0x0d, 0x06, 0x3d, 0x84, 0xb1, 0x88, 0x9d, 0x0a, 0xe3, 0x09, 0xec, 0x3b, 0x97, 0xea,
	0x53, 0xc5, 0xec, 0x14, 0x4b, 0x48, 0xe5, 0x11, 0x8c, 0x62, 0x76, 0x8a, 0x1e, 0xc2, 0xb8, 0x3c,
	0x9b, 0xd9, 0x3f, 0xf3, 0x4c, 0x87, 0x82, 0x13, 0x6b, 0x80, 0xfd, 0xa3, 0x24, 0x14, 0x31, 0x89,
	0x3b, 0x3e, 0x47, 0xdf, 0x85, 0x42, 0xea, 0x4e, 0xae, 0x70, 0x1a, 0xc9, 0x8b, 0x13, 0x10, 0xfa,
	0x16, 0x20, 0x33, 0x76, 0x78, 0xd4, 0x09, 0x9a, 0x2e, 0x27, 0x2a, 0x14, 0x0b, 0xf8, 0x9a, 0x59,
	0x39, 0x30, 0x0b, 0xf6, 0xef, 0x73, 0x30, 0xa1, 0x85, 0xa0, 0x39, 0xc8, 0xab, 0x38, 0x52, 0xb7,
	0xab, 0x26, 0xfd, 0x7e, 0x9a, 0x7b, 0x2d, 0x3f, 0x7d, 0x02, 0x90, 0x4a, 0x0b, 0xa3, 0x43, 0xa5,
	0x85, 0x14, 0x12, 0x3d, 0x82, 0x82, 0xcf, 0x9a, 0xd2, 0x97, 0xb5, 0xfb, 0x64, 0x6a, 0xb2, 0xa3,
	0x79, 0x71, 0x82, 0x42, 0x1f, 0x40, 0xa9, 0x19, 0x11, 0x97, 0x13, 0x47, 0x64, 0x45, 0x99, 0x0b,
	0x4a, 0xf5, 0x4a, 0x4f, 0x88, 0xca, 0xb3, 0xd5, 0x03, 0x93, 0x67, 0x31, 0x28, 0x76, 0x41, 0xb0,
	0xff, 0x3c, 0x0a, 0x05, 0x23, 0x13, 0x3d, 0x02, 0x38, 0xea, 0x72, 0xe2, 0x44, 0x6e, 0xd0, 0x32,
	0xf1, 0x9b, 0x79, 0xf1, 0x58, 0x30, 0xe2, 0xa2, 0x00, 0xc9, 0x21, 0xfa, 0x3e, 0x4c, 0x37, 0x99,
	0x47, 0x42, 0x46, 0x03, 0xae, 0xc5, 0xe4, 0xae, 0x2a, 0x66, 0x2a, 0x41, 0x1a, 0x59, 0x25, 0xda,
	0x76, 0x5b, 0xc4, 0x39, 0x62, 0x67, 0x44, 0x24, 0x4b, 0xe1, 0x39, 0x77, 0x32, 0xaf, 0x49, 0xb0,
	0x27, 0x16, 0x02, 0x89, 0x5e, 0x17, 0x60, 0xb4, 0x01, 0x10, 0x91, 0x26, 0x8b, 0x3c, 0xe7, 0x39,
	0xe9, 0x6a, 0x3b, 0x67, 0x86, 0x05, 0x96, 0xdc, 0x1f, 0x91, 0x2e, 0x2e, 0x46, 0x66, 0x88, 0x3e,
	0x14, 0x8e, 0x4c, 0x7c, 0xcf, 0xa1, 0xde, 0x62, 0x5e, 0xca, 0xb8, 0x5a, 0x58, 0x1e, 0xab, 0x01,
	0xda, 0x83, 0x29, 0x19, 0xf5, 0x4e, 0x72, 0xe3, 0xea, 0xb2, 0xee, 0x5c, 0x1a, 0xa0, 0xc9, 0xa1,
	0xca, 0x3c, 0x3d, 0xb5, 0xef, 0x42, 0xb9, 0x6f, 0x1d, 0xdd, 0x80, 0x62, 0xc4, 0x4e, 0x1d, 0x1a,
	0x78, 0xe4, 0x4c, 0x27, 0xc0, 0x42, 0xc4, 0x4e, 0xb7, 0xc5, 0xdc, 0xae, 0x41, 0x5e, 0x99, 0x76,
	0x0e, 0xf2, 0x31, 0x77, 0x23, 0xae, 0x39, 0xd4, 0x04, 0xcd, 0xc0, 0x28, 0x09, 0x54, 0x5c, 0x8d,
	0x62, 0x31, 0xb4, 0x9b, 0x50, 0xee, 0xb3, 0xa9, 0x60, 0xe1, 0x2c, 0x94, 0xb0, 0x3c, 0x16, 0x43,
	0x91, 0x3d, 0x7d, 0x72, 0xcc, 0x75, 0x9e, 0x96, 0x63, 0x21, 0xfe, 0x94, 0x7a, 0xfc, 0x44, 0x17,
	0x38, 0x35, 0x41, 0x0b, 0x30, 0x7e, 0x42, 0x68, 0xeb, 0x84, 0x4b, 0xfb, 0xe7, 0xb1, 0x9e, 0xd9,
	0x5f, 0xe7, 0x61, 0x0e, 0x13, 0xcf, 0x95, 0x45, 0x47, 0x64, 0x65, 0x4c, 0x3e, 0xef, 0x90, 0x98,
	0x0b, 0x73, 0x51, 0x95, 0x48, 0x9c, 0xa6, 0x4c, 0xf3, 0xda, 0x25, 0xef, 0x5c, 0xb9, 0x7e, 0xe1,
	0x32, 0xed, 0x6b, 0x0a, 0xd6, 0x20, 0x2f, 0x12, 0xad, 0x49, 0x8c, 0xef, 0x66, 0x09, 0x4a, 0x95,
	0x08, 0xac, 0x50, 0xa8, 0x05, 0xd3, 0x11, 0x09, 0x7d, 0xb7, 0x49, 0xb4, 0x42, 0xc6, 0x2b, 0x3f,
	0xcc, 0x76, 0xa5, 0x8b, 0x67, 0xab, 0x62, 0x25, 0x47, 0xab, 0x39, 0x15, 0xa5, 0xa7, 0x31, 0x7a,
	0x09, 0xd7, 0x95, 0xeb, 0x47, 0x12, 0x4b, 0x59, 0x90, 0x6c, 0x38, 0x26, 0x37, 0xdc, 0x1c, 0x7a,
	0x43, 0x79, 0x8f, 0xd8, 0x88, 0xd3, 0xfb, 0xce, 0xd3, 0x01, 0x54, 0x59, 0xd7, 0xfb, 0xf4, 0xfb,
	0x86, 0xea, 0xba, 0xb1, 0xdd, 0x29, 0xe5, 0x27, 0xd2, 0x5f, 0x8a, 0xb8, 0xa4, 0x69, 0x9f, 0x52,
	0x7e, 0x52, 0xf9, 0xbb, 0x05, 0x73, 0x83, 0xd4, 0x44, 0x8d, 0xd7, 0xdc, 0x7e, 0x6b, 0x24, 0xa5,
	0xc0, 0x8a, 0xb8, 0x3c, 0x21, 0xd7, 0x71, 0x7d, 0xdf, 0xe1, 0xe4, 0x4c, 0xf9, 0x6c, 0x61, 0x6b,
	0x04, 0x97, 0xd5, 0xc2, 0x63, 0xdf, 0x3f, 0x20, 0x67, 0x5c, 0x24, 0xb1, 0xb4, 0xdd, 0x7d, 0x16,
	0x49, 0x47, 0xbe, 0x24, 0x89, 0x35, 0x04, 0xa3, 0xb8, 0xc9, 0x44, 0x77, 0x9f, 0x45, 0xeb, 0x05,
	0x18, 0xe7, 0x6e, 0xd4, 0x22, 0xdc, 0x6e, 0x40, 0x5e, 0x92, 0x44, 0x0c, 0x45, 0xc4, 0x93, 0xe7,
	0xc8, 0x61, 0x31, 0x14, 0xf1, 0xd2, 0x8a, 0x08, 0x09, 0xa4, 0x42, 0x39, 0xac, 0x26, 0x22, 0xb2,
	0x8e, 0x4c, 0xb3, 0x91, 0xc3, 0x72, 0x6c, 0x1f, 0xc2, 0xfc, 0xb9, 0xdb, 0x8d, 0x43, 0x16, 0xc4,
	0xa4, 0xe7, 0xd9, 0xd6, 0xeb, 0x78, 0xb6, 0xfd, 0x3b, 0x0b, 0xe6, 0x7b, 0x91, 0xf3, 0xbf, 0x1c,
	0x84, 0xf6, 0x0f, 0x61, 0xe1, 0xbc, 0xa6, 0xda, 0x06, 0x0d, 0x98, 0x88, 0x64, 0xc7, 0x61, 0xac,
	0x70, 0x15, 0x1d, 0x55, 0x8f, 0x82, 0x0d, 0xd2, 0xfe, 0x67, 0x0e, 0x6e, 0x36, 0x64, 0x7d, 0xd4,
	0x0c, 0x49, 0xab, 0xf9, 0xdf, 0xb3, 0xc8, 0x1e, 0x4c, 0xe9, 0x17, 0x94, 0x91, 0x98, 0xbb, 0x5c,
	0xe2, 0xbe, 0x42, 0x18, 0x89, 0x71, 0x7a, 0x8a, 0x0e, 0xa0, 0xcc, 0x3a, 0x3c, 0xec, 0x24, 0x2a,
	0x2a, 0x07, 0xae, 0x65, 0x09, 0xdc, 0x95, 0x80, 0x7e, 0xb1, 0x93, 0x4a, 0x8a, 0x96, 0x7a, 0x08,
	0x33, 0xc9, 0xb3, 0xd0, 0x08, 0x56, 0x75, 0xf0, 0xff, 0x33, 0x05, 0xf7, 0x37, 0xeb, 0x78, 0x9a,
	0xf5, 0x13, 0xec, 0xaf, 0x2c, 0x98, 0x1d, 0xb0, 0x3b, 0x7a, 0x6c, 0xfa, 0xea, 0x2b, 0x18, 0x78,
	0x9d, 0xb6, 0x9e, 0x75, 0x48, 0xd4, 0xed, 0xef, 0xaf, 0xd1, 0x33, 0x98, 0x34, 0xa6, 0x0d, 0x5d,
	0x9d, 0x76, 0x4a, 0xf5, 0xbb, 0x99, 0x3e, 0xe7, 0xb3, 0x8e, 0xa7, 0x15, 0xd9, 0x73, 0xf9, 0xc9,
	0xd6, 0x08, 0x2e, 0xc5, 0xbd, 0xe9, 0xfa, 0xb8, 0x7a, 0x2f, 0xd8, 0x6d, 0x40, 0x26, 0xd1, 0xec,
	0x8b, 0xf7, 0x74, 0xcc, 0x69, 0x33, 0xfe, 0x26, 0x52, 0xe5, 0x1c, 0xe4, 0x9b, 0xac, 0x13, 0x70,
	0x5d, 0x89, 0xd5, 0xc4, 0xfe, 0x6a, 0x0c, 0x16, 0xcf, 0xbb, 0xe4, 0xc7, 0x84, 0xbb, 0xf2, 0x65,
	0xf2, 0x2e, 0x4c, 0x87, 0x11, 0x6b, 0x92, 0x38, 0x26, 0x9e, 0x23, 0xda, 0x31, 0xf3, 0xfa, 0x99,
	0x4a, 0xc8, 0xeb, 0x82, 0x8a, 0xea, 0x30, 0xcf, 0x19, 0x77, 0x7d, 0x87, 0xc4, 0x9c, 0xb6, 0x45,
	0xbb, 0xac, 0xd9, 0xc7, 0x24, 0xfb, 0xac, 0x5c, 0xdc, 0x34, 0x6b, 0x0a, 0x73, 0x08, 0xd3, 0xbd,
	0x97, 0x64, 0xcc, 0x5d, 0x6e, 0x42, 0xb7, 0x7a, 0x95, 0x83, 0xf5, 0x6c, 0x23, 0xdc, 0xbe, 0x47,
	0x8b, 0xcf, 0x37, 0xae, 0xa3, 0xc3, 0x34, 0xae, 0xc8, 0x81, 0x85, 0x48, 0x05, 0xa4, 0x73, 0x2e,
	0x1a, 0xf3, 0xc3, 0x46, 0xe3, 0x9c, 0x16, 0xd4, 0xff, 0x01, 0x21, 0xb5, 0xc1, 0xb9, 0xe0, 0x1c,
	0x1f, 0x36, 0x38, 0xcd, 0x06, 0xfd, 0xde, 0xdd, 0x84, 0x79, 0xb3, 0x41, 0x7f, 0xac, 0x4e, 0xbc,
	0x5e, 0xac, 0xce, 0x6a, 0x69, 0xbb, 0xa9, 0x90, 0xb5, 0xef, 0x26, 0xd9, 0x32, 0x95, 0xc7, 0xe4,
	0xab, 0x0c, 0xc1, 0x58, 0xe0, 0xb6, 0x93, 0x67, 0xaf, 0x18, 0xdb, 0x3f, 0xb1, 0xa0, 0xb2, 0x43,
	0x13, 0x4b, 0x98, 0x27, 0xb3, 0xc9, 0x7c, 0x03, 0x20, 0xa2, 0xe1, 0x0c, 0x85, 0x6d, 0x62, 0xfa,
	0x05, 0xd1, 0x4d, 0x60, 0x41, 0x10, 0xf6, 0xe9, 0x17, 0x04, 0xdd, 0x04, 0x90, 0x8b, 0x9c, 0x3d,
	0x27, 0x81, 0x7a, 0x35, 0x63, 0xc9, 0x7e, 0x20, 0x08, 0xa2, 0x23, 0x3c, 0xa6, 0x3e, 0x27, 0x91,
	0xf4, 0xbe, 0x22, 0xd6, 0x33, 0xfb, 0x67, 0x16, 0xdc, 0x18, 0xa8, 0x86, 0x4e, 0xf4, 0x8f, 0x61,
	0x5c, 0xa5, 0xeb, 0x21, 0x32, 0xaf, 0xce, 0xf3, 0x1a, 0x88, 0x6e, 0xc3, 0x74, 0x40, 0xce, 0xb8,
	0x93, 0x52, 0x4f, 0x75, 0x24, 0x65, 0x41, 0xde, 0x33, 0x2a, 0xda, 0xbf, 0xb1, 0x60, 0xd6, 0x78,
	0xf2, 0x06, 0x89, 0x9b, 0x11, 0x0d, 0x65, 0x23, 0x3c, 0xc8, 0x14, 0xb7, 0x60, 0xd2, 0xa3, 0x71,
	0xe8, 0xbb, 0x5d, 0x47, 0xae, 0xe9, 0x16, 0x47, 0xd3, 0x9e, 0x0a, 0x96, 0x5d, 0x00, 0xf1, 0x46,
	0x6d, 0xb1, 0x88, 0x26, 0x4f, 0x9a, 0xcc, 0x8b, 0x6e, 0x28, 0xee, 0x6e, 0x6a, 0x6f, 0x9c, 0x12,
	0x61, 0x7f, 0x0a, 0x73, 0xca, 0x52, 0xfa, 0x93, 0x95, 0xb9, 0xaa, 0x0a, 0x14, 0x34, 0x57, 0x57,
	0xeb, 0x98, 0xcc, 0xd1, 0x32, 0x94, 0x7d, 0x37, 0x68, 0x75, 0x94, 0x4b, 0x7b, 0x46, 0xd1, 0x49,
	0x43, 0x6c, 0x30, 0x8f, 0xd8, 0x2d, 0x98, 0x3f, 0x27, 0x58, 0x1b, 0xff, 0xe9, 0x80, 0x0f, 0x6b,
	0xb5, 0xab, 0x24, 0x82, 0xf4, 0x11, 0x7a, 0xdf, 0xd8, 0xec, 0x1d, 0x98, 0x1d, 0x70, 0xc8, 0xd7,
	0x34, 0xb0, 0xfd, 0x08, 0xde, 0x10, 0x6a, 0x63, 0xc6, 0x78, 0x23, 0xb1, 0x92, 0x31, 0xca, 0x85,
	0x83, 0x5b, 0x03, 0x0e, 0xde, 0x56, 0x21, 0x70, 0x5e, 0x82, 0x3e, 0x7d, 0xff, 0x05, 0x5a, 0xff,
	0xf9, 0x05, 0xfe, 0x2d, 0x07, 0x79, 0xf9, 0xfd, 0x04, 0xbd, 0x03, 0x65, 0x1a, 0x70, 0xd2, 0x22,
	0x91, 0xa3, 0xbe, 0x32, 0xc9, 0x0c, 0xbe, 0x35, 0x82, 0x27, 0x35, 0x59, 0xb1, 0xdd, 0x82, 0xd2,
	0xb1, 0xcf, 0x5c, 0xae, 0x99, 0x84, 0x0d, 0xac, 0xad, 0x11, 0x0c, 0x92, 0xa8, 0x58, 0x96, 0x45,
	0xd1, 0x8b, 0x68, 0xd0, 0x72, 0xfa, 0x3f, 0x57, 0x95, 0x14, 0x35, 0xd9, 0xee, 0x88, 0x31, 0x9f,
	0xb8, 0x81, 0xe6, 0x1a, 0xd3, 0xdd, 0xf0, 0xa4, 0x26, 0x2b, 0xb6, 0x4d, 0x98, 0x4e, 0xbe, 0xd0,
	0x6a, 0xc6, 0xfc, 0x65, 0x89, 0x7a, 0x6b, 0x04, 0x4f, 0x25, 0x20, 0x25, 0xe6, 0x01, 0x80, 0xa0,
	0x68, 0x09, 0x2a, 0x83, 0x2e, 0x18, 0x09, 0xc2, 0x95, 0x24, 0x7a, 0xf7, 0x78, 0xc3, 0xed, 0x6e,
	0x8d, 0xe0, 0xa2, 0xe0, 0x55, 0xc0, 0x3a, 0x80, 0x27, 0x4a, 0x84, 0x02, 0xaa, 0xd4, 0x78, 0xad,
	0x0f, 0xb8, 0xe1, 0x72, 0x51, 0xf0, 0x8b, 0x82, 0x4d, 0x62, 0x4c, 0x85, 0x5e, 0xe5, 0x00, 0xa9,
	0xaf, 0xaf, 0x15, 0x58, 0xd8, 0xd9, 0xfe, 0x68, 0x73, 0x67, 0x7b, 0x6b, 0x77, 0x77, 0xc3, 0xf9,
	0xe4, 0xe9, 0xfe, 0xde, 0x66, 0x63, 0xfb, 0xc9, 0xf6, 0xe6, 0xc6, 0xcc, 0x08, 0xba, 0x06, 0xe5,
	0xc3, 0x4d, 0xfc, 0x99, 0xf3, 0xc9, 0x53, 0xc9, 0xf2, 0xd9, 0x8c, 0x85, 0x26, 0xa1, 0x90, 0xcc,
	0x72, 0x62, 0xb6, 0xb7, 0xbb, 0xbf, 0xbf, 0xbd, 0xbe, 0xb3, 0x39, 0x33, 0x8a, 0x00, 0xc6, 0xf5,
	0xca, 0x18, 0x9a, 0x86, 0x92, 0x84, 0x6a, 0x42, 0xbe, 0xfe, 0xaf, 0x09, 0x80, 0x0d, 0x3f, 0xdc,
	0x27, 0xd1, 0x0b, 0xda, 0x24, 0xe8, 0xd7, 0x16, 0x4c, 0xf5, 0x37, 0xac, 0xe8, 0xde, 0xd5, 0x6a,
	0x53, 0xaa, 0x0d, 0xaf, 0xd4, 0x87, 0x81, 0x28, 0x5f, 0xb5, 0x97, 0x7f, 0xfc, 0xd7, 0xaf, 0x7f,
	0x9e, 0xbb, 0x69, 0x2f, 0x26, 0xdf, 0xe9, 0x9b, 0x8a, 0xe3, 0x7d, 0x5d, 0x31, 0xdf, 0xb7, 0x56,
	0xd1, 0x2f, 0x2d, 0xf1, 0xd8, 0x4b, 0x3d, 0x29, 0xd0, 0x7b, 0xc3, 0xbe, 0x2d, 0x2b, 0xf7, 0x86,
	0x40, 0x68, 0xdd, 0x6c, 0xa9, 0xdb, 0x9b, 0xf6, 0xf5, 0x0b, 0xba, 0xa9, 0x07, 0x94, 0x50, 0xed,
	0x57, 0x16, 0x2c, 0x0c, 0x6e, 0xc5, 0xd1, 0xc3, 0xcc, 0x90, 0xcb, 0x6a, 0xdf, 0x2b, 0x37, 0x0d,
	0x34, 0xf5, 0xb7, 0xa3, 0xd7, 0xa2, 0xda, 0xb7, 0xa5, 0x62, 0x4b, 0xf6, 0x8d, 0x44, 0x31, 0x6d,
	0xac, 0xd4, 0x1f, 0x11, 0xa1, 0xdc, 0x9f, 0x2c, 0x98, 0x1d, 0x50, 0xa3, 0xd0, 0xfd, 0xec, 0x6f,
	0x80, 0xaf, 0xaa, 0xad, 0x95, 0x07, 0x43, 0xe3, 0xb4, 0x25, 0xeb, 0x52, 0xe1, 0xbb, 0x68, 0x35,
	0x51, 0xf8, 0x4b, 0x91, 0x1c, 0xd7, 0x8c, 0xda, 0xfa, 0x61, 0x53, 0x5b, 0x7d, 0x59, 0x4b, 0x3e,
	0xa8, 0xfe, 0xd1, 0x82, 0x72, 0x5f, 0x76, 0xcf, 0xbe, 0xf4, 0x41, 0x15, 0x26, 0xfb, 0xd2, 0x07,
	0x96, 0x0e, 0xfb, 0xbe, 0x54, 0xf5, 0x3d, 0x54, 0x4d, 0x54, 0x8d, 0xfa, 0xb2, 0x6c, 0xed, 0x4b,
	0x53, 0xa3, 0xd6, 0x56, 0x5f, 0xd6, 0x7a, 0xbf, 0x61, 0x7e, 0x6b, 0x01, 0xba, 0x98, 0x93, 0xd1,
	0x77, 0x2e, 0xd3, 0x60, 0x60, 0x15, 0xa8, 0xdc, 0x1f, 0x16, 0xa6, 0xb5, 0x7f, 0x4b, 0x6a, 0xff,
	0x06, 0xba, 0xfe, 0x0a, 0xed, 0xd7, 0x7f, 0x6a, 0xc1, 0xff, 0x35, 0x59, 0x3b, 0x43, 0xfc, 0x7a,
	0x61, 0xc3, 0x0f, 0xf7, 0x44, 0xbe, 0xdc, 0xb3, 0x7e, 0xb0, 0xa6, 0xf9, 0x5a, 0x4c, 0xd4, 0x9f,
	0x2a, 0x8b, 0x5a, 0xb5, 0x16, 0x09, 0x64, 0x36, 0xad, 0xa9, 0x25, 0x37, 0xa4, 0xf1, 0xa0, 0xff,
	0x6d, 0x1f, 0x78, 0x7e, 0xf8, 0x87, 0xdc, 0xe2, 0xf7, 0x14, 0x5e, 0xbe, 0x57, 0xaa, 0x1b, 0x7e,
	0x58, 0x3d, 0xac, 0xaf, 0x8b, 0xe5, 0xa3, 0x71, 0x29, 0xe4, 0xdb, 0xff, 0x0e, 0x00, 0x00, 0xff,
	0xff, 0x01, 0xfb, 0x51, 0xc8, 0x38, 0x1c, 0x00, 0x00,
}
