/*****************************************************************************/
/* The development of this program is partly supported by IPA                */
/* (Information-Technology Promotion Agency, Japan).                         */
/*****************************************************************************/

/*****************************************************************************/
/*  bfd_if.h - BFD library interface header                                  */
/*  Copyright: Copyright (c) Hitachi, Ltd. 2005-2008                         */
/*             Authors: Yumiko Sugita (yumiko.sugita.yf@hitachi.com),        */
/*                      Satoshi Fujiwara (sa-fuji@sdl.hitachi.co.jp)         */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA      */
/*****************************************************************************/

#ifndef __BFD_IF_H__
#define __BFD_IF_H__

#include <bfd.h>
#include <dis-asm.h>
#include <libiberty.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
//#include <libgen.h>
#include <errno.h>
#ifdef USE_ELFUTILS
#include <elfutils/libdwfl.h>
#endif
#include "avltree.h"

struct sect_cache {
	asection	*sect;
	bfd_vma		vma;
	bfd_size_type	size;
	bfd_byte	*data;
};

struct bfd_if {
	bfd			*abfd;
	asymbol			**p_syms;
	long			n_syms;
	asymbol			**p_dynsyms;
	long			n_dynsyms;
	asymbol			*p_synsyms;
	long			n_synsyms;
	asymbol			**p_fsyms;
	long			n_fsyms;
	arelent			**p_relocs;
	long			n_relocs;
	struct disassemble_info	info;
	struct sect_cache	cache;
	int			has_debuginfo;
	unsigned long		load_vaddr;
	int			*p_code_sects;
	int			n_code_sects;

#ifdef USE_ELFUTILS
	Dwfl			*dwfl;
#endif
};

enum branch_type {
	BTYPE_BRANCH,
	BTYPE_JMP,
	BTYPE_CALL,
	BTYPE_RET,
	BTYPE_IRET,
	BTYPE_INT,
	BTYPE_BREAK,
	BTYPE_OTHER,
};
/* When limiting the coverage output by function-list, limitted paths are
 * marked as "invalid".
 */
#define IS_INVALID_PATH		(1 << 31)

#define	RELOC_TYPE_PC32		2

#define UNKNOWN_BADDR		(-1)

#define CHK_BTYPE_E_OVERFLOW	(1 << 0)
#define CHK_BTYPE_E_BADDR	(1 << 1)
#define CHK_BTYPE_E_SEQNUM	(1 << 2)
#define CHK_BTYPE_E_NOT_FOUND	(1 << 3)
#define CHK_BTYPE_E_INTERNAL	(1 << 4)

struct unknown {
	unsigned long	addr;
	unsigned long	cnt;
	struct unknown	*next;
};

struct path {
	unsigned long	addr;		/* state start address */
	long		cnt;		/* -1 means next and jmp not linked */
	int		type;
	unsigned long	base;		/* branch/jmp/call instruction address*/
	unsigned long	next;		/* fallthrough address */
	long		next_cnt;	/* -1 means switch case jump */
	unsigned long	jmp;		/* branch/jmp/call destination address
					 * if jmp == UNKNOWN_BADDR then jmp_cnt
					 * is pointer to 'struct unknown'
					 */
	long		jmp_cnt;
};

typedef int (*t_func_for_fsym)(unsigned long, const char*, void*);


/*------ proto-type ------*/
/* initialize */
int init_bfd_if(struct bfd_if*, const char*, const char*);
unsigned long get_offset_addr(struct bfd_if*, unsigned long);
void get_kernel_min_max_addr(struct bfd_if*, unsigned long*, unsigned long*);
void remove_useless_fsyms(struct bfd_if*, unsigned long, unsigned long,
			  unsigned long);
/* path-tree */
int chk_path_tree(struct bfd_if*, struct path***, long*, unsigned long, int);
int chk_kernel_has_ud2_src_info(struct bfd_if*);
struct path* find_path_from_addr(struct path**, long*, unsigned long);
void free_path(struct path*);
void printf_path(struct path*);
void dump_path_tree(struct path**, long);
/* utility */
#ifdef USE_ELFUTILS
int init_dwarf(struct bfd_if *bi, const char *obj_name);
#endif
int get_source_info(struct bfd_if*, unsigned long, const char**, const char**,
		    int*);
int addr_to_func_name_and_offset(struct bfd_if*, unsigned long, const char**,
				 size_t*);
void printf_func_name(const char*, size_t);
int printf_mnemonic(struct bfd_if*, unsigned long, unsigned long*);
int get_branch_info(struct bfd_if*, unsigned long, int*, unsigned long*,
		    unsigned long*, unsigned long);
int get_addr_of_symbol(struct bfd_if*, unsigned long, const char*,
		       unsigned long*);
int get_addr_of_symbol_all(struct bfd_if*, unsigned long, const char*,
			   unsigned long**);
int get_begin_of_func(struct bfd_if*, unsigned long, unsigned long*);
int get_end_of_func(struct bfd_if*, unsigned long, unsigned long*);
int for_each_fsymbols(struct bfd_if *bi, unsigned long offset,
		      t_func_for_fsym f, void *data);
void dump_bfd_symbols(struct bfd_if*, unsigned long, unsigned long,
		      unsigned long);
#ifdef RELOC_TEST
void enable_reloc_test(void);
#endif

#endif /* __BFD_IF_H__ */
