/*****************************************************************************/
/* The development of this program is partly supported by IPA                */
/* (Information-Technology Promotion Agency, Japan).                         */
/*****************************************************************************/

/*****************************************************************************/
/*  bt_execcmd.c - execute child command                                     */
/*  Copyright: Copyright (c) Hitachi, Ltd. 2006-2008                         */
/*             Authors: Yumiko Sugita (yumiko.sugita.yf@hitachi.com),        */
/*                      Satoshi Fujiwara (sa-fuji@sdl.hitachi.co.jp)         */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA      */
/*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include "bt_utils.h"
#include "btrax/bt_for_ap.h"

#define BT_EXECCMD_VER	VERSION
#define	COPYRIGHT	"Copyright (c) Hitachi, Ltd. 2005-" RELEASE_YEAR

pid_t c_pid = 0;
int c_enable = 0;

void handler(int sig)
{
	if (sig == SIGUSR1)
		c_enable = 1;
}

void finalize(int sig)
{
	switch (sig) {
	case SIGHUP:
	case SIGINT:
	case SIGKILL:
	case SIGTERM:
		bt_term_from_ap();
		break;
	}
}

int chk_syscall_ids(char *ids)
{
	char *p, *p_end;
	int id;

	if (!ids)
		return 0;
	p = strtok(strdup(ids), ",");
	while (p) {
		id = strtol(p, &p_end, 0);
		if (id < 0 || *p_end != '\0') {
			fprintf(stderr, "invalid syscall_ids: %s\n", ids);
			return -1;
		}
		p = strtok(NULL, ",");
	}
	return 0;
}

void err_exit(void)
{
	exit(1);
}

void usage(void)
{
	fprintf(stderr, "__bt_execcmd %s\n", BT_EXECCMD_VER);
	fprintf(stderr, "    %s\n\n", COPYRIGHT);
	fprintf(stderr, "__bt_execcmd [-s syscall_id,...] -c cmd [arg...]\n");
	fprintf(stderr, "  -s syscall_id,...: system call id(s)\n");
	fprintf(stderr, "  -c cmd [arg...]: target application\n");
}

int main(int argc, char *argv[])
{
	char c, *syscall_ids;
	sighandler_t h_old;
	int c_opt_index, st;

	syscall_ids = NULL;
	c_opt_index = 0;
	opterr = 0;
	while ((c = getopt(argc, argv, "s:c:")) != -1) {
		switch (c) {
		case 's':
			syscall_ids = optarg;
			break;
		case 'c':
			c_opt_index = optind;
			break;
		case '?':
		default:
			goto END;
		}
	}
END:
	if (c_opt_index == 0) {
		usage();
		err_exit();
	}
	if (chk_syscall_ids(syscall_ids) < 0)
		err_exit();
	h_old = signal(SIGUSR1, handler);
	switch (c_pid = fork()) {
	case -1:
		fprintf(stderr, "fork failed.(%s)\n", strerror(errno));
		err_exit();
		break;
	case 0:
		while (!c_enable)
			pause();
		signal(SIGUSR1, h_old);
		if (execvp(argv[c_opt_index - 1], &argv[c_opt_index - 1]) < 0) {
			fprintf(stderr, "execvp failed.(%s)\n",
				strerror(errno));
			_exit(1);
		}
		break;
	default:
		signal(SIGUSR1, h_old);
		signal(SIGHUP, finalize);
		signal(SIGINT, finalize);
		signal(SIGKILL, finalize);
		signal(SIGTERM, finalize);
		//printf("C_PID:%d\n", c_pid);
		__bt_start_from_ap(c_pid, syscall_ids);
		kill(c_pid, SIGUSR1);
		waitpid(c_pid, &st, 0);
		bt_term_from_ap();
		break;
	}
	exit(st);
}

