/* 
 djprobe -- Direct jmp-insertion probe
 Copyright (c) 2005 Hitachi,Ltd.,
 Created by Masami Hiramatsu<hiramatu@sdl.hitachi.co.jp>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <linux/version.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/rcupdate.h>
#include "djprobe.h"

#define _DEBUG_(a) 
#if 0
#define _DEBUG_(a) a
#endif

static long exec=0; //do_execve
module_param(exec, long, 0444);
static long exsz=0;
module_param(exsz, long, 0444);
static long fork=0; //sched_fork
module_param(fork, long, 0444);
static long fksz=0;
module_param(fksz, long, 0444);

#define CALLER(regs) (((unsigned long *)&regs->esp)[0])
#define ARG(n,regs) (((unsigned long *)&regs->esp)[n]) /*arg1: ARG(1,stadr)*/

static void fork_probe(struct djprobe *djp, struct pt_regs *regs)
{
	struct task_struct *task;
	unsigned long long tsc;
#ifdef CONFIG_REGPARM
	task = (void*)regs->eax;
#else
	task = ARG(1, regs);
#endif
	rdtscll(tsc);
	printk("[%llu] fork(%d) to %d \n", tsc,
	       current->pid, task->pid);
	
}

static void exec_probe(struct djprobe *djp, struct pt_regs *regs)
{
	char *name;
	unsigned long long tsc;
#ifdef CONFIG_REGPARM
	name = (void*)regs->eax;
#else
	name = ARG(1, regs);
#endif
	rdtscll(tsc);
	printk("[%llu] execve(%d) file:%s \n", tsc,
	       current->pid, name);
}

static struct djprobe ex_djp, fk_djp;

static int install_probe(void) 
{
	
	if (exec == 0 || fork == 0 || 
	    exsz < 5 || exsz > 16+5 || 
	    fksz < 5 || fksz > 16+5) {
		return -1;
	}

	ex_djp.addr = (void*)exec;
	ex_djp.size = exsz;
	ex_djp.handler = exec_probe;
	fk_djp.addr = (void*)fork;
	fk_djp.size = fksz;
	fk_djp.handler = fork_probe;
	printk("execve probe install at %p, size %ld\n", (void*)exec, exsz);
	if (register_djprobe(&ex_djp) != 0) return -1;
	printk("fork probe install at %p, size %ld\n", (void*)fork, fksz);
	if (register_djprobe(&fk_djp) != 0) {
		unregister_djprobe(&ex_djp);
		return -1;
	}
	return 0;
}

static void uninstall_probe(void)
{
	unregister_djprobe(&fk_djp);
	unregister_djprobe(&ex_djp);
	printk("execve probe uninstall from %p\n", (void*)exec);
	printk("fork probe uninstall from %p\n", (void*)fork);
}

module_init(install_probe);
module_exit(uninstall_probe);
MODULE_AUTHOR("M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>");
MODULE_LICENSE("GPL");

