/*****************************************************************************/
/* The development of this program is partly supported by IPA                */
/* (Information-Technology Promotion Agency, Japan).                         */
/*****************************************************************************/

/*****************************************************************************/
/*  bt_utils.h - utilities header                                            */
/*  Copyright: Copyright (c) Hitachi, Ltd. 2005-2008                         */
/*             Authors: Yumiko Sugita (yumiko.sugita.yf@hitachi.com),        */
/*                      Satoshi Fujiwara (sa-fuji@sdl.hitachi.co.jp)         */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA      */
/*****************************************************************************/

#ifndef __BT_UTILS_H__
#define __BT_UTILS_H__

#include "bt.h"
#include "avltree.h"
#include <libgen.h>

int u_open(const char*, off_t*);
int u_close(int);
off_t u_lseek(int, off_t, int);
ssize_t u_read(int, void*, size_t);
ssize_t u_write(int, const void*, size_t);

typedef int (*t_func_each_bt_record)(struct bt_record*, off_t, void*);
int for_each_bt_record(int, off_t, t_func_each_bt_record, void*);
int for_each_block_record(int, off_t, off_t, t_func_each_bt_record, void*);

typedef int (*proc_cpu_files_t)(int cpu, char *cpu_path, size_t size, void *dt);
int proc_cpu_files(char *dir_path, proc_cpu_files_t handler, void *dt);
int count_cpu_files(char *dir_path);

/* check the log file's split point */
#define MAX_CPU_FILES	64
struct log_file_info {
	char			*fpath;
	int			fd;
	off_t			size;
};
struct tv {
	unsigned long		tv_sec;
	unsigned long		tv_usec;
};
struct __pid_info {
	struct log_file_info	*finfo;
	unsigned long long	clocks;
	off_t			i_rec;
	off_t			n_rec;
};
struct pid_log_info {
	pid_t			pid;
	char			comm[BT_COMM_LEN + 1];
	unsigned long long	comm_clocks;
	node			*info;	// avl-tree of struct __pid_info
};
typedef int (*proc_pid_log_info_t)(struct pid_log_info *p, void *data);

int initialize_log_info(char *files[]);
void finalize_log_info(void);

int chk_pid_pos(char *files[], int is_search, unsigned long search_addr);
void print_pid_info(void);
void dump_pid_pos(void);
int for_each_pid_log_info(proc_pid_log_info_t func, void *data);
inline struct log_file_info *get_log_file_info(struct __pid_info *p);

#endif /* __BT_UTILS_H__ */
