#!/bin/sh
[ $# -gt 3 ] && echo "usage: disym.sh [-a] <kernel_symbol> [kernel-version]" && exit 0
DISALL=0
if [ $1 = "-a" ] ;then
DISALL=1
shift 1
fi

SYM=$1
#KVER=$2
[ -z "$KVER" ] && KVER=`uname -r`

function cntarg () {
return $#
}

#SYSMAP=/lib/modules/$KVER/build/System.map
[ -n "$SYSMAP" ] || SYSMAP=/lib/modules/$KVER/build/System.map
[ -f $SYSMAP ] || SYSMAP=/boot/System.map-`uname -r`
[ -f $SYSMAP ] || SYSMAP=/proc/kallsyms

#VMLINUX=/lib/modules/$KVER/build/vmlinux
[ -n "$VMLINUX" ] || VMLINUX=/lib/modules/$KVER/build/vmlinux
[ -f $VMLINUX ] || VMLINUX=/boot/vmlinux-`uname -r`
[ -f $VMLINUX ] || VMLINUX=/usr/lib/debug/lib/modules/$KVER/vmlinux

setaddrs () {
XADDR=$1
XEADDR=$2
}

echo $SYM
case $SYM in
	0x*)
	XADDR=$SYM
	SADDR=`printf "%d" $SYM`
	EADDR=`expr $SADDR + 5`
	;;
	*)
	if [ $DISALL -eq 1 ] ;then
	setaddrs `sort $SYSMAP | grep -A1 " $SYM"$  | cut -f 1 -d\ `
	if [ -z "$XADDR" ] ; then 
		echo "Error : $SYM was not found in "$SYSMAP
		exit 0;
	fi
	XADDR=0x$XADDR
	XEADDR=0x$XEADDR
	SADDR=`printf "%d" $XADDR` 
	EADDR=`printf "%d" $XEADDR` 
	else
	XADDR=0x`grep " $SYM"$ $SYSMAP | cut -f 1 -d\ `
	if [ "$XADDR" = "0x" ] ; then 
		echo "Error : $SYM was not found in "$SYSMAP
		exit 0;
	fi
	SADDR=`printf "%d" $XADDR` 
	EADDR=`expr $SADDR + 5`
	fi
	;;
esac
echo $XADDR

objdump -w --start-address=$SADDR --stop-address=$EADDR -j ".text" -d $VMLINUX
echo 
LLINE=`objdump -w --start-address=$SADDR --stop-address=$EADDR -j ".text" -d $VMLINUX | tail -n 1 | sed s/"	"/\:/g`
EXADDR=`echo $LLINE | cut -f 1 -d:`
cntarg `echo $LLINE | cut -f 3 -d:`
DIFF=$?
EADDR=`printf "%d" 0x$EXADDR`
SIZE=`expr $EADDR - $SADDR + $DIFF`
echo "Please be sure that the above-disassembled instructions are relocatable."
echo "Parameter: addr=$XADDR size=$SIZE"
