using System;
using System.ComponentModel;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
//using System.Drawing.Drawing2D;
//using System.IO;
using System.Text.RegularExpressions;
using System.Runtime.InteropServices;

namespace Browser.Boon.Control
{
	/// <summary>
	/// ȒPȃ^uuEU[p̃Rg[񋟂܂B: Panelp
	/// </summary>
	public class TabBrowserControl : Panel
	{
		Regex Regex_DownMovieLink = new Regex(@"^boon://(?<movieid>sm[\\d]{1,10})[/\|\?]?(?<title>.*)");
		int maxTabCount = 32;
		readonly string blankUrl = "about:blank";
		string HomeUrl { get { return "about:home"; } }
		private int menuFocusTab = -1;
		int frg_occs = 0;
		Point tmpGuesturePt = Point.Empty;
		int maxClosedTabHistory = 10;


		#region Field / Components

		const int TAB_IMG_INDEX_NORMAL = -1;
		const int TAB_IMG_INDEX_LOCKED = 1;

		Panel pnlBrowser;
		SplitContainer splitter;
		TabControl core;

		List<WebBrowserEx> _browser;
		TabBrowserSetting _setting;

		#endregion


		#region Property

		TabBrowserDragDropData _dd_data = null;
		bool _frg_dd_active = false;
		int _frg_tmp_tabcount = 0;

		public int ContextMenuTargetTab
		{
			get { return (this.menuFocusTab >= 0) ? this.menuFocusTab : this.TbSelectedIndex; }
		}

		#endregion

		/// <summary>
		/// RXgN^łB
		/// </summary>
		/// <param name="setting"></param>
		public TabBrowserControl(TabBrowserSetting setting)
		{
			this._setting = setting;
			this.constructor();
			Boon.Net.Urlmon.InternetOptionProxy(
				this._setting.ProxyUse ? Browser.Boon.Net.InternetOpenType.INTERNET_OPEN_TYPE_PROXY : Browser.Boon.Net.InternetOpenType.INTERNET_OPEN_TYPE_PRECONFIG,
				this._setting.ProxyUrl + ":" + this._setting.ProxyPort.ToString(),
				this._setting.ProxyBypass);
		}
		/// <summary>
		/// RXgN^łBftHg̐ݒgp܂
		/// </summary>
		public TabBrowserControl()
		{
			this._setting = new TabBrowserSetting();
			this.constructor();
		}
		private void constructor()
		{
			if(this._browser != null)
			{
				throw new InvalidOperationException("̃\bh̓RXgN^݂̂ŌĂяo܂");
			}
			this.BorderStyle = BorderStyle.None;
			this.Margin = new Padding(0);
			this.Padding = new Padding(0);

			this._browser = new List<WebBrowserEx>(32);

			this.core = new TabControl();
			this.core.TabPages.Clear();
			this.core.Dock = DockStyle.Fill;
			this.core.ShowToolTips = true;
			this.core.AllowDrop = true;
			this.core.ImageList = new ImageList();
			this.core.ImageList.ImageSize = new Size(4, 4);
			this.core.ImageList.Images.Add("default", Browser.Properties.Resources.none);
			this.core.ImageList.Images.Add(Browser.Properties.Resources.tabLocked, Color.White);

			this.pnlBrowser = new Panel();
			this.pnlBrowser.Dock = DockStyle.Fill;
			this.pnlBrowser.Margin = new Padding(0);

			this.splitter = new SplitContainer();
			this.splitter.Orientation = Orientation.Horizontal;
			this.splitter.Panel1MinSize = 0;
			this.splitter.SplitterDistance = 20;
			this.splitter.SplitterWidth = 1;
			this.splitter.Dock = DockStyle.Fill;
			this.splitter.FixedPanel = FixedPanel.Panel1;
			this.splitter.IsSplitterFixed = true;

			this.splitter.Panel1.Controls.Add(this.core);
			this.splitter.Panel2.Controls.Add(this.pnlBrowser);
			this.Controls.Add(this.splitter);

			this.splitter.Panel1.MouseDown += new MouseEventHandler(SplitterPanel1_MouseDown);
			this.splitter.Panel1.MouseClick += new MouseEventHandler(SplitterPanel1_MouseClick);
			this.splitter.Panel1.MouseDoubleClick += new MouseEventHandler(SplitterPanel1_MouseDoubleClick);

			this.core.MouseDown += new MouseEventHandler(core_MouseDown);
			
			this.core.MouseClick += new MouseEventHandler(core_MouseClick);
			this.core.MouseDoubleClick += new MouseEventHandler(core_MouseDoubleClick);
			this.core.MouseUp += new MouseEventHandler(core_MouseUp);
			this.core.MouseWheel += new MouseEventHandler(core_MouseWheel);
			this.core.MouseMove += new MouseEventHandler(core_MouseMove);
			
			this.core.SelectedIndexChanged += new EventHandler(core_SelectedIndexChanged);
			
			this.core.DragEnter += new DragEventHandler(core_DragEnter);
			this.core.DragDrop += new DragEventHandler(core_DragDrop);
			this.core.DragOver += new DragEventHandler(core_DragOver);
			this.initializeContext();
			this.initializePageList();

			this.initiaizeClosedHistory();
		}


		#region ^uRg[Cxg
		void core_MouseUp(object sender, MouseEventArgs e)
		{
			this._dd_data = null;
			this._frg_dd_active = false;
		}
		void core_MouseDown(object sender, MouseEventArgs e)
		{
			this.menuFocusTab = -1;
			for(int i = 0; i < this.TbTabCount; i++)
			{
				if(this.core.GetTabRect(i).Contains(e.Location))
				{
					this.menuFocusTab = i;
					break;
				}
			}

			if(e.Button == MouseButtons.Middle) // CloseTab
			{
				if(this.menuFocusTab >= 0)
				{
					this.TbRemove(this.menuFocusTab);
				}
			}
			else if(e.Button == MouseButtons.Left) // D&D
			{
				this._frg_dd_active = false;
				TabBrowserDragDropData td = new TabBrowserDragDropData(this.TbSelectedIndex);
				td.Title = this.TbSelectedBrowser.DocumentTitle;
				td.Url = this.TbSelectedBrowser.Url.AbsoluteUri;
				this._dd_data = td;
			}
		}
		void core_MouseMove(object sender, MouseEventArgs e)
		{
			if(this._dd_data != null && !this._frg_dd_active)
			{
				this._frg_dd_active = true;
				DataObject data = new DataObject();
				data.SetText(this._dd_data.Url);
				data.SetData(typeof(TabBrowserDragDropData), this._dd_data);
				DragDropEffects dde = DragDropEffects.All;
				this.DoDragDrop(data, dde);
			}
		}
		void core_MouseWheel(object sender, MouseEventArgs e)
		{
			if(this._setting.EnableTabWheel && this.TbTabCount > 1)
			{
				for(int i = 0; i < this.core.TabCount; i++)
				{
					if(this.core.GetTabRect(i).Contains(e.Location))
					{
						int tmp = (this.TbTabCount + this.TbSelectedIndex - e.Delta / 120);
						if(this._setting.TabWheelRotate || (this.TbTabCount <= tmp && tmp < this.TbTabCount * 2))
						{
							this.TbSelectedIndex = tmp % this.TbTabCount;
						}
						break;
					}
				}
			}
		}
		void core_MouseClick(object sender, MouseEventArgs e)
		{
			if(e.Button == MouseButtons.Right)
			{
				this.contextMenuStrip100_ForTab.Show(this, e.Location);
			}
		}
		void core_MouseDoubleClick(object sender, MouseEventArgs e)
		{
			if(e.Button == MouseButtons.Left)
			{
				for(int i = 0; i < this.TbTabCount; ++i)
				{
					if(this.TbGetTabRect(i).Contains(e.Location))
					{
						this.TbSetIsLocked(i, !this.TbGetIsLocked(i));
						break;
					}
				}
			}
		}

		void core_SelectedIndexChanged(object sender, EventArgs e)
		{
			this.browser_set_visible(this.core.SelectedIndex);
			this.OnSelectedIndexChanged(sender, e);
		}


		void core_DragEnter(object sender, DragEventArgs e)
		{
			if(e.Data.GetDataPresent(typeof(TabBrowserDragDropData)))
			{
				e.Effect = DragDropEffects.Move;
			}
			else if(e.Data.GetDataPresent("UniformResourceLocator"))
			{
				e.Effect = DragDropEffects.Link;
			}
			else { e.Effect = DragDropEffects.None; }
		}
		void core_DragOver(object sender, DragEventArgs e)
		{
			if(e.Data.GetDataPresent(typeof(TabBrowserDragDropData)))
			{
				e.Effect = DragDropEffects.Move;
			}
			else if(e.Data.GetDataPresent("UniformResourceLocator"))
			{
				e.Effect = DragDropEffects.Link;
			}
		}
		void core_DragDrop(object sender, DragEventArgs e)
		{
			if(e.Data.GetDataPresent(typeof(TabBrowserDragDropData)))
			{
				int tgt = -1;
				for(int i = 0; i < this.core.TabCount; ++i)
				{
					if(this.core.GetTabRect(i).Contains(this.core.PointToClient(Cursor.Position)))
					{
						tgt = i; break;
					}
				}
				TabBrowserDragDropData data = (TabBrowserDragDropData)e.Data.GetData(typeof(TabBrowserDragDropData));
				int source = data.Index;
				if(tgt != -1 && 0 <= source && source < this.core.TabCount)
				{
					this.TbChangeIndex(source, tgt);
					this.TbSelectedIndex = tgt;
				}
			}
		}


		#endregion

		// wiplCxg
		void SplitterPanel1_MouseClick(object sender, MouseEventArgs e)
		{
			if(e.Button == MouseButtons.Right)
			{
				this.ctxMenuPageList.Show(this, e.Location);
			}
			else if(e.Button == MouseButtons.Middle)
			{
				this.ctxCloseHistory.Show(this, e.Location);

			}
		}
		void SplitterPanel1_MouseDoubleClick(object sender, MouseEventArgs e)
		{
			if(e.Button == MouseButtons.Left)
			{
				this.ctxMenuPageList.Hide();
				this.TbOpenNewWindow(blankUrl, this.TbTabCount, false);
			}
		}
		void SplitterPanel1_MouseDown(object sender, MouseEventArgs e)
		{
		}


		// -------------  ---------------- //
		private void actBeforeCloseTab(int index)
		{
			if(this.TbSelectedIndex == index
				&& 0 <= index
				&& index < this.TbTabCount)
			{
				if(this.TbSelectedIndex == 0)// ԍ̃^u
				{
				}
				else if(this.TbSelectedIndex == this.TbTabCount - 1)//ԉẼ^u
				{
					this.TbSelectedIndex = this.TbSelectedIndex - 1;
				}
				else
				{
					this.TbSelectedIndex = this.TbSelectedIndex + (this._setting.FocusRightWhenFocusedClosed ? 1 : -1);
				}
			}
		}
		private void browser_set_visible(int index)
		{
			if(this.core.TabCount == 0)
			{
				this.splitter.Panel2Collapsed = true;
			}
			else
			{
				this.splitter.Panel2Collapsed = false;
				for(int i = 0; i < this._browser.Count; ++i)
				{
					this._browser[i].Visible = (index == i);
				}
			}
		}
		private WebBrowserEx create_browser()
		{
			WebBrowserEx browser = new WebBrowserEx();

			browser.Dock = DockStyle.Fill;
			browser.Visible = false;
			
			browser.BeforeNavigate += new EventHandler(Browser_BeforeNavigate);
			browser.BeforeNewWindow += new EventHandler(Browser_beforeNewWindow);
			browser.DocumentTitleChanged += new EventHandler(Browser_DocumentTitleChanged);
			browser.Navigated += new WebBrowserNavigatedEventHandler(Browser_Navigated);
			browser.DocumentCompleted += new WebBrowserDocumentCompletedEventHandler(Browser_documentCompleted);
			browser.StatusTextChanged += new EventHandler(Browser_StatusTextChanged);
			browser.CanGoBackChanged += new EventHandler(Browser_CanGoBackChanged);
			browser.CanGoForwardChanged += new EventHandler(Browser_CanGoForwardChanged);
			
			return browser;
		}

		// -------------  Methods --------------- //

		#region  -------- Basic Function --------
		/// <summary>
		/// ݑIĂ^ũCfbNX擾Eݒ肵܂
		/// </summary>
		public int TbSelectedIndex
		{
			get { return this.core.SelectedIndex; }
			set { this.core.SelectedIndex = value; }
		}
		/// <summary>
		/// ݂̃^u擾܂
		/// </summary>
		public int TbTabCount
		{
			get { return this.core.TabCount; }
		}
		/// <summary>
		/// ^ũRNV擾܂
		/// </summary>
		public TabControl.TabPageCollection TbTabPages
		{
			get { return this.core.TabPages; }
		}
		/// <summary>
		/// w肵CfbNX̃^úAOڂlp`擾܂
		/// </summary>
		/// <param name="index">擾^ũCfbNX</param>
		/// <returns>w肵^ůOڎlp`킷RectangleiLocalWj</returns>
		public Rectangle TbGetTabRect(int index)
		{
			return this.core.GetTabRect(index);
		}
		/// <summary>
		/// w肵^ũbNԂ擾܂
		/// </summary>
		/// <param name="index">Ԃ擾^ũCfbNX</param>
		/// <returns>bNĂtrue</returns>
		public bool TbGetIsLocked(int index)
		{
			return this.core.TabPages[index].ImageIndex == 1;
		}
		/// <summary>
		/// w肵^ũbNԂݒ肵܂
		/// </summary>
		/// <param name="index">Ԃݒ肷^ũCfbNX</param>
		/// <param name="locked">bNꍇtrueAꍇfalse</param>
		public void TbSetIsLocked(int index, bool locked)
		{
			this.core.TabPages[index].ImageIndex = locked ? 1 : -1;
			this.tb_LockedChanged(this, new EventArgs());
		}

		#endregion

		#region  -------- Page Control ----------
		/// <summary>
		/// V^uǉ܂B
		/// </summary>
		/// <param name="page">ǉTabBrowserPage</param>
		private void tbAdd(WebBrowserEx browser)
		{
			if(this.core.TabCount != this._browser.Count)
				throw new Exception("TabƃuEUCX^X̊Ԃɕs܂");
			browser.Visible = false;
			this._browser.Add(browser);
			TabPage tp = new TabPage(browser.DocumentTitle);
			this.core.TabPages.Add(tp);
			this.pnlBrowser.Controls.Add(browser);
			this.browser_set_visible(this.TbSelectedIndex);
			this.OnTabCountChanged(this, null);
		}
		/// <summary>
		/// w肵ʒuɐV^uǉ܂B
		/// </summary>
		/// <param name="insertIndex">^uǉʒu</param>
		/// <param name="page">ǉTabBrowserPage</param>
		private void tbAdd(int insertIndex, WebBrowserEx browser)
		{
			if(this.core.TabCount != this._browser.Count)
				throw new Exception("TabƃuEUCX^X̊Ԃɕs܂");
			browser.Visible = false;
			this._browser.Insert(insertIndex, browser);
			TabPage tp = new TabPage(browser.DocumentTitle);
			this.core.TabPages.Insert(insertIndex, tp);
			this.pnlBrowser.Controls.Add(browser);
			this.browser_set_visible(this.TbSelectedIndex);
			this.OnTabCountChanged(this, null);
		}
		/// <summary>
		/// y[WCollectionO܂BOꂽy[WDispose܂B
		/// QƂcĂKvꍇ̓I[o[Chꂽ̂gpĂB
		/// </summary>
		/// <param name="deleteIndex">폜y[Ẅʒu</param>
		public void TbRemove(int deleteIndex)
		{
			this.TbRemove(deleteIndex, false);
		}
		/// <summary>
		/// y[WCollectionO܂BOꂽy[WDispose܂B
		/// QƂcĂKvꍇ̓I[o[Chꂽ̂gpĂB
		/// </summary>
		/// <param name="deleteIndex">폜y[Ẅʒu</param>
		/// <param name="_ignoreLock">bNꂽ^u폜ꍇtrue</param>
		public void TbRemove(int deleteIndex, bool _ignoreLock)
		{
			if(!_ignoreLock && this.TbGetIsLocked(deleteIndex)) { return; }
			this.actBeforeCloseTab(deleteIndex);
			WebBrowserEx browser = this._browser[deleteIndex];
			if(browser.Url != null)
			{
				this.set_ClosedTabHistory(browser.DocumentTitle, browser.Url.ToString());
			}
			this._browser.RemoveAt(deleteIndex);
			Debug.Write(this.pnlBrowser.Controls.Count);
			this.pnlBrowser.Controls.Remove(browser);
			this.core.TabPages.RemoveAt(deleteIndex);
			this.browser_set_visible(this.TbSelectedIndex);
			this.OnTabCountChanged(this, null);
			browser.Stop();
			browser.Dispose();
		}
		/// <summary>
		/// y[WCollectionO܂BłWebBrowserւ̎QƂc邽߁ADispose܂B
		/// Tab̍ւsꍇ͂gp܂B
		/// ʏ̍폜ɂ̓I[o[Chꂽ̂𗘗pĂB
		/// </summary>
		/// <param name="page">CollectionOy[W̎Q</param>
		public void TbRemove(WebBrowserEx browser)
		{
			int index = this._browser.IndexOf(browser);
			if(index < 0) { return; }
			this.actBeforeCloseTab(index);
			this.pnlBrowser.Controls.Remove(browser);
			this.core.TabPages.RemoveAt(index);
			this.OnTabCountChanged(this, null);
		}
		/// <summary>
		/// Rg[̃^uׂč폜AWebBrowserj܂
		/// </summary>
		/// <param name="_ignoreLock">bN^u폜ꍇtrue</param>
		public void TbClear(bool _ignoreLock)
		{
			for(int i = 0; i < this.TbTabCount; )
			{
				if((!_ignoreLock) && this.TbGetIsLocked(i))
				{
					++i;
				}
				else
				{
					this.TbRemove(i);
				}
			}
		}

		/// <summary>
		/// ^ȕԂւ܂
		/// </summary>
		/// <param name="from">ړ^ũCfbNX</param>
		/// <param name="newindex">ړ̃CfbNX</param>
		public void TbChangeIndex(int from, int newindex)
		{
			if(from != newindex && 0 <= from && from < this.TbTabCount
				&& 0 <= newindex && newindex < this.TbTabCount)
			{
				WebBrowserEx browser = this._browser[from];
				TabPage tabp = this.core.TabPages[from];

				this._browser.Remove(browser);
				this.core.TabPages.Remove(tabp);

				this.core.TabPages.Insert(newindex, tabp);
				this._browser.Insert(newindex, browser);
			}

		}


		#endregion

		#region  -------- Browsing Function --------
		/// <summary>
		/// Iꂽ^uWebuEU擾܂
		/// </summary>
		public WebBrowserEx TbSelectedBrowser
		{
			get
			{
				return (this.TbSelectedIndex >= 0) ?
					this._browser[this.TbSelectedIndex] : null;
			}
		}
		/// <summary>
		/// w肵^uWebuEU擾܂
		/// </summary>
		/// <param name="index">Ώۂ̃^ũCfbNX</param>
		/// <returns></returns>
		public WebBrowserEx TbGetBrowser(int index)
		{
			if(this.TbTabCount > 0)
			{
				return this._browser[index];
			}
			else { return null; }
		}

		/// <summary>
		/// V^uURLJ܂
		/// </summary>
		/// <param name="URL">ǂݍURL</param>
		public void TbOpenNewWindow(string URL)
		{
			this.TbOpenNewWindow(URL, this.TbTabCount, true);
		}
		/// <summary>
		/// V^uURLJ܂
		/// </summary>
		/// <param name="URL">ǂݍURL</param>
		/// <param name="tabIndex">}̃CfbNX</param>
		public void TbOpenNewWindow(string URL, int tabIndex)
		{
			this.TbOpenNewWindow(URL, tabIndex, true);
		}
		/// <summary>
		/// V^uURLJ܂
		/// </summary>
		/// <param name="URL">ǂݍURL</param>
		/// <param name="tabIndex">}̃CfbNX</param>
		/// <param name="focus">tH[JXڂꍇtrue</param>
		public void TbOpenNewWindow(string URL, int tabIndex, bool focus)
		{
			if(URL == null || URL == "")
			{
				URL = blankUrl;
			}
			try
			{
				Uri uri = new Uri(URL, UriKind.Absolute);
				this.TbOpenNewWindow(uri, tabIndex, focus);
			}
			catch(Exception e)
			{
				this.TbOpenNewWindow("res://ieframe.dll/syntax.htm#" + URL, tabIndex, focus);
			}
		}
		/// <summary>
		/// V^uURLJ܂
		/// </summary>
		/// <param name="URL">ǂݍURL</param>
		/// <param name="tabIndex">}̃CfbNX</param>
		/// <param name="focus">tH[JXڂꍇtrue</param>
		public void TbOpenNewWindow(Uri URL, int tabIndex, bool focus)
		{
			Match mt = Regex_DownMovieLink.Match(URL.ToString());
			if(mt.Success) // Download Link
			{
				string movid = mt.Groups["movieid"].Value;
				if(movid == null) throw new Exception("URLERROR/ boon://-ɖȃAhX");
				this.OnMovieDownloadRequired(this, URL.ToString());
			}
			else if(this.TbTabCount >= maxTabCount)
			{
				MessageBox.Show("^u̐𒴂܂B͖̑łB");
				return;
			}
			else
			{
				//Trace.WriteLine(String.Format("OpenNewWindow-OK: url={0}", URL.AbsoluteUri));
				WebBrowserEx browser = this.create_browser();

				this.tbAdd(tabIndex, browser);
				
				if(Regex.IsMatch(URL.AbsoluteUri, this._setting.TrustZoneUrl, RegexOptions.Singleline | RegexOptions.IgnoreCase))
				{
					browser.SecurityDefault = this._setting.DefaultSecurityTrust;
				}
				else
				{
					browser.SecurityDefault = this._setting.DefaultSecurity;
				}
				
				browser.Url = URL;
				if(focus) { this.TbSelectedIndex = tabIndex; }
				this.browser_set_visible(this.TbSelectedIndex);
			}
		}

		/// <summary>
		/// IĂuEUŕ\Ăy[ŴURL擾܂
		/// </summary>
		public string TbUrlText
		{
			get
			{
				if(this.TbSelectedIndex >= 0 && this.TbSelectedBrowser.Url != null)
				{
					return this.TbSelectedBrowser.Url.ToString();
				}
				else
				{
					return String.Empty;
				}
			}
		}
		/// <summary>
		/// IĂuEUŕ\Ăy[W̃^Cg擾܂
		/// </summary>
		public string TbTitleText
		{
			get
			{
				return this.TbSelectedIndex >= 0 ?
					this.TbSelectedBrowser.DocumentTitle : String.Empty;
			}
		}
		/// <summary>
		/// IĂuEUStatusText擾܂
		/// </summary>
		public string TbStatusText
		{
			get
			{
				return this.TbSelectedIndex >= 0 ?
				this.TbSelectedBrowser.StatusText : String.Empty;
			}
		}



		#endregion


		#region Handler

		void tb_LockedChanged(object sender, EventArgs e)
		{
			this.core.Invalidate(false);
		}

		void Browser_CanGoForwardChanged(object sender, EventArgs e)
		{
			this.OnCanGoForwardChanged(sender, e);
		}
		void Browser_CanGoBackChanged(object sender, EventArgs e)
		{
			this.OnCanGoBackChanged(sender, e);
		}
		void Browser_StatusTextChanged(object sender, EventArgs e)
		{
			this.OnStatusTextChanged(sender, e);
		}
		void Browser_DocumentTitleChanged(object sender, EventArgs e)
		{
			
			WebBrowserEx browser = sender as WebBrowserEx;
			int index = this._browser.IndexOf(browser);
			if(index < 0) return;
			string title = this._browser[index].DocumentTitle;
			string url = this._browser[index].Url.ToString();
			this.core.TabPages[index].ToolTipText = String.Format("{0}\r\n{1}", title, url);
			try
			{
				if(this._setting.EnableEditTitle && Regex.IsMatch(url, this._setting.EditTitle_MatchHost, RegexOptions.IgnoreCase | RegexOptions.Singleline))
				{
					title = Regex.Replace(title, this._setting.EditTitle_MatchPattern, this._setting.EditTitle_ReplacePattern, RegexOptions.Singleline);
				}
			}
			catch(Exception ex)
			{
				Trace.WriteLine("TabBrowser::DocTitleCh Error : " + ex.Message);
			}
			this.core.TabPages[index].Text = title;
			this.OnDocumentTitleChanged(sender, e);
			
		}

		void Browser_BeforeNavigate(object sender, EventArgs e)
		{
			WebBrowserExtendedNavigatingEventArgs ex = (WebBrowserExtendedNavigatingEventArgs)e;
			//Trace.WriteLine(String.Format("BeforeNavigate:url={0} ::frame={1}", ex.Url ,ex.Frame));
			this.OnBeforeNavitage(sender, ex);
			int index = this._browser.IndexOf(sender as WebBrowserEx);
			if(this.TbGetIsLocked(index))
			{
				ex.Cancel = true;
				this.TbOpenNewWindow(ex.Url, this.TbSelectedIndex + 1, false);
			}
		}
		void Browser_Navigated(object sender, WebBrowserNavigatedEventArgs e)
		{
			//Trace.WriteLine(String.Format("Navigated:url={0}", e.Url));
			this.OnNavigated(sender, e);
		}

		void Browser_beforeNewWindow(object sender, EventArgs e)
		{
			WebBrowserExtendedNavigatingEventArgs ex = (WebBrowserExtendedNavigatingEventArgs)e;
			//Trace.WriteLine(String.Format("BeforeNewWindow:url={0} ::frame={1}", ex.Url, ex.Frame));
			ex.Cancel = true;
			this.TbOpenNewWindow(ex.Url, this.TbSelectedIndex + 1);
		}
		void Browser_documentCompleted(object sender, WebBrowserDocumentCompletedEventArgs e)
		{
			//Trace.WriteLine(String.Format("DocumentCompleted:url={0}", e.Url));
			HtmlDocument doc__ = ((WebBrowser)sender).Document;
			doc__.Body.MouseDown += new HtmlElementEventHandler(Body_MouseDown);
			doc__.Body.MouseUp += new HtmlElementEventHandler(Body_MouseUp);
			foreach(HtmlElement link in doc__.Links)
			{
				link.MouseUp += new HtmlElementEventHandler(link_MouseUp);
				link.MouseDown += new HtmlElementEventHandler(link_MouseDown);
				link.MouseLeave += new HtmlElementEventHandler(link_MouseLeave);
			}
			this.OnDocumentCompleted(sender, e);
		}

		void Body_MouseDown(object sender, HtmlElementEventArgs e)
		{
			if(e.MouseButtonsPressed == MouseButtons.Right)
			{
				if(tmpGuesturePt == Point.Empty)
				{
					tmpGuesturePt = e.MousePosition;
				}
				else { this.tmpGuesturePt = Point.Empty; }
			}
		}
		void Body_MouseUp(object sender, HtmlElementEventArgs e)
		{
			bool guestureCalled = false;
			if(tmpGuesturePt != Point.Empty)
			{
				int mx = e.MousePosition.X - tmpGuesturePt.X;
				int my = e.MousePosition.Y - tmpGuesturePt.Y;
				if(mx >= this._setting.GuestureThreshold)
				{
					if(-this._setting.GuestureThreshold < my && my < this._setting.GuestureThreshold)
					{
						// Guesture Right
						this.TbSelectedBrowser.GoForward();
						guestureCalled = true;
					}
				}
				else if(mx <= -this._setting.GuestureThreshold)
				{
					if(-this._setting.GuestureThreshold < my && my < this._setting.GuestureThreshold)
					{
						// Guesture Left
						this.TbSelectedBrowser.GoBack();
						guestureCalled = true;
					}
				}
				else if(my <= -this._setting.GuestureThreshold)
				{
					// Guesture Up
					this.TbSelectedBrowser.Refresh();
					guestureCalled = true;
				}
				else if(my >= this._setting.GuestureThreshold)
				{
					// Guresture Down
					this.TbRemove(this.TbSelectedIndex);
					guestureCalled = true;
				}
				tmpGuesturePt = Point.Empty;
			}
			if(guestureCalled)
			{
				e.BubbleEvent = false;
			}
		}

		void link_MouseDown(object sender, HtmlElementEventArgs e)
		{
			if(e.MouseButtonsPressed == MouseButtons.Middle && frg_occs == 0)
			{
				string href_;
				string linkelem = ((HtmlElement)sender).OuterHtml;
				href_ = Regex.Match(linkelem, "href\\s*=\\s*(?:\"(?<1>[^\"]*)\"|(?<1>\\S+))", RegexOptions.IgnoreCase).Result("$1");

				if(href_ != null)
				{
					if(href_.StartsWith("javascript:", StringComparison.CurrentCultureIgnoreCase))
					{
						// javascriptNNbN̓
					}
					else if(Uri.IsWellFormedUriString(href_, UriKind.Absolute))
					{
						Uri u_ = new Uri(href_);
						if(u_.IsAbsoluteUri)
						{
							this.TbOpenNewWindow(u_, this.TbSelectedIndex + 1, this._setting.FocusOnCenterClickOpen);
						}
					}
					else if(Uri.IsWellFormedUriString(href_, UriKind.Relative))
					{
						string urlbase = String.Empty;
						HtmlElementCollection basetag = this.TbSelectedBrowser.Document.GetElementsByTagName("base");
						if(basetag.Count > 0)
						{
							foreach(HtmlElement el in basetag)
							{
								string s = el.GetAttribute("href");
								if(s != null)
								{
									urlbase = s;
									break;
								}
							}
						}
						Uri u_;
						if(urlbase == string.Empty)
						{
							u_ = new Uri(this.TbSelectedBrowser.Url, href_);
						}
						else
						{
							u_ = new Uri(new Uri(urlbase), href_);
						}
						this.TbOpenNewWindow(u_, this.TbSelectedIndex + 1, this._setting.FocusOnCenterClickOpen);
					}
					else
					{
						MessageBox.Show("TabBrowserControl::link_MouseDown/InvalidLink");
					}
					SendKeys.Send("e");//AutoScroll΍
				}
				else
				{
					MessageBox.Show("Error");
				}
			}
			frg_occs = 1;
		}
		void link_MouseLeave(object sender, HtmlElementEventArgs e)
		{
			frg_occs = 0;
		}
		void link_MouseUp(object sender, HtmlElementEventArgs e)
		{
			frg_occs = 0;
		}


		#endregion

		#region Event

		public event EventHandler<MovieDownloadRequiredEventArgs> MovieDownloadRequired;
		/// <summary>
		/// TbSelectedIndexvpeBύXꂽɔ܂B
		/// </summary>
		public event EventHandler TbSelectedIndexChanged;
		/// <summary>
		/// Rg[Ɋ܂܂uEÛꂩŔCanGoBackChangedCxg`B܂B
		/// </summary>
		public event EventHandler TbCanGoBackChanged;
		/// <summary>
		/// Rg[Ɋ܂܂uEÛꂩŔCanGoForwardChangedCxg`B܂B
		/// </summary>
		public event EventHandler TbCanGoForwardChanged;
		/// <summary>
		/// Rg[Ɋ܂܂uEÛꂩŔStatusTextChangedCxg`B܂B
		/// </summary>
		public event EventHandler TbStatusTextChanged;
		/// <summary>
		/// Rg[Ɋ܂܂uEÛꂩŔDocumentTitleChangedCxg`B܂B
		/// </summary>
		public event EventHandler TbDocumentTitleChanged;
		/// <summary>
		/// Rg[Ɋ܂܂uEÛꂩŔNavigatedCxg`B܂B
		/// </summary>
		public event WebBrowserNavigatedEventHandler TbNavigated;
		/// <summary>
		/// Rg[Ɋ܂܂uEÛꂩŔCxgBeforeNavigate`B܂B
		/// </summary>
		public event CancelEventHandler TbBeforeNavigate;
		/// <summary>
		/// Rg[Ɋ܂܂uEÛꂩŔDocumentCompletedCxg`B܂B
		/// </summary>
		public event WebBrowserDocumentCompletedEventHandler TbDocumentCompleted;
		/// <summary>
		/// Rg[Ɋ܂܂uEÛꂩŔProgressChangedCxg`B܂B
		/// </summary>
		public event WebBrowserProgressChangedEventHandler TbProgressChanged;

		public event EventHandler TbTabCountChanged;

		protected void OnMovieDownloadRequired(object sender, string url)
		{
			if(MovieDownloadRequired != null)
			{
				MovieDownloadRequiredEventArgs e = new MovieDownloadRequiredEventArgs(url);
				MovieDownloadRequired(sender, e);
			}
		}
		protected void OnDocumentCompleted(object sender, WebBrowserDocumentCompletedEventArgs e)
		{
			if(TbDocumentCompleted != null)
			{
				TbDocumentCompleted(sender, e);
			}
		}
		protected void OnDocumentTitleChanged(object sender, EventArgs e)
		{
			if(this.TbDocumentTitleChanged != null)
			{
				this.TbDocumentTitleChanged(sender, e);
			}
		}
		protected void OnNavigated(object sender, WebBrowserNavigatedEventArgs e)
		{
			if(TbNavigated != null)
			{
				TbNavigated(sender, e);
			}
		}
		protected void OnBeforeNavitage(object sender, WebBrowserExtendedNavigatingEventArgs e)
		{
			Match mt = Regex_DownMovieLink.Match(e.Url);
			if(mt.Success)
			{
				e.Cancel = true;
				this.OnMovieDownloadRequired(this, e.Url);
				return;
			}
			if(this.TbBeforeNavigate != null)
			{
				TbBeforeNavigate(sender, e);
			}
			if(e.Cancel)
			{
				int index = this._browser.IndexOf(sender as WebBrowserEx);
				if(this._browser[index].Url == null)
				{
					this.TbRemove(index);
				}
			}
		}
		protected void OnProgressChanged(object sender, WebBrowserProgressChangedEventArgs e)
		{
			if(this.TbProgressChanged != null)
			{
				TbProgressChanged(sender, e);
			}
		}
		protected void OnStatusTextChanged(object sender, EventArgs e)
		{
			if(TbStatusTextChanged != null)
			{
				TbStatusTextChanged(sender, e);
			}
		}
		protected void OnCanGoBackChanged(object sender, EventArgs e)
		{
			if(this.TbCanGoBackChanged != null)
			{
				this.TbCanGoBackChanged(sender, e);
			}
		}
		protected void OnCanGoForwardChanged(object sender, EventArgs e)
		{
			if(this.TbCanGoForwardChanged != null)
			{
				this.TbCanGoForwardChanged(sender, e);
			}
		}
		protected void OnSelectedIndexChanged(object sender, EventArgs e)
		{
			if(this.TbSelectedIndexChanged != null)
			{
				this.TbSelectedIndexChanged(sender, e);
			}
		}
		protected void OnTabCountChanged(object sender, EventArgs e)
		{
			if(this._frg_tmp_tabcount != this.TbTabCount && this.TbTabCountChanged != null)
			{
				this.TbTabCountChanged(sender, e);
				this._frg_tmp_tabcount = this.TbTabCount;
			}
		}
		#endregion

		#region contextMenuStrip100֘A


		private void toolStripMenuItem101_CloseTab_Click(object sender, EventArgs e)
		{
			this.TbRemove(this.ContextMenuTargetTab);
		}
		private void toolStripMenuItem102_CloseAllTabs_Click(object sender, EventArgs e)
		{
			this.TbClear(false);
		}
		private void toolStripMenuItem103_OpenNewTab_Click(object sender, EventArgs e)
		{
			this.TbOpenNewWindow("about:blank");
		}
		private void toolStripMenuItem104_Refresh_Click(object sender, EventArgs e)
		{
			this.TbSelectedBrowser.Refresh();
		}
		private void toolStripMenuItem105_RefreshAllLockedTabs_Click(object sender, EventArgs e)
		{
			for(int i = 0; i < TbTabCount; i++)
			{
				if(this.TbGetIsLocked(i))
				{
					this.TbSetIsLocked(i,false);
					this.TbGetBrowser(i).Refresh();
					this.TbSetIsLocked(i,true);
				}
			}
		}
		private void toolStripMenuItem106_RefreshAllTabs_Click(object sender, EventArgs e)
		{
			int tooMuchTabs = 3;
			if(this.TbTabCount >= tooMuchTabs)
			{
				if(MessageBox.Show("\̃^uxɍXV悤ƂĂ܂B\n̑͑傫ȕׂSz܂B\n\n{Ɏs܂H"
				, "\ׂ̂Ẵ^u̍XV", MessageBoxButtons.OKCancel, MessageBoxIcon.Warning)
					== DialogResult.Cancel)
				{
					return;
				}
			}
			for(int i = 0; i < this.TbTabCount; i++)
			{
				this.TbSelectedBrowser.Refresh();
			}
		}
		private void toolStripMenuItem107_LockThisTab_Click(object sender, EventArgs e)
		{
			this.TbSetIsLocked(this.ContextMenuTargetTab, !this.TbGetIsLocked(this.ContextMenuTargetTab));
		}
		private void toolStripMenuItem108_CopyTitleAndUrl_Click(object sender, EventArgs e)
		{
			Clipboard.SetText(
				this.TbGetBrowser(this.ContextMenuTargetTab).DocumentTitle
				+ "\n" +
				this.TbGetBrowser(this.ContextMenuTargetTab).Url.ToString());
		}
		private void toolStripMenuItem109_CopyTitle_Click(object sender, EventArgs e)
		{
			Clipboard.SetText(this.TbGetBrowser(this.ContextMenuTargetTab).DocumentTitle);
		}
		private void toolStripMenuItem110_CopyUrl_Click(object sender, EventArgs e)
		{
			Clipboard.SetText(this.TbGetBrowser(this.ContextMenuTargetTab).Url.ToString());
		}

		// ----------------- MenuField ------------------------ //

		private System.Windows.Forms.ContextMenuStrip contextMenuStrip100_ForTab;
		private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem101_CloseTab;
		private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem102_CloseAllTabs;
		private System.Windows.Forms.ToolStripSeparator toolStripSeparator101;
		private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem103_OpenNewTab;
		private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem103_TabPageList;
		private System.Windows.Forms.ToolStripSeparator toolStripSeparator102;
		private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem104_Refresh;
		private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem105_RefreshAllLockedTabs;
		private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem106_RefreshAllTabs;
		private System.Windows.Forms.ToolStripSeparator toolStripSeparator103;
		private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem107_LockThisTab;
		private System.Windows.Forms.ToolStripSeparator toolStripSeparator104;
		private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem108_CopyTitleAndUrl;
		private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem109_CopyTitle;
		private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem110_CopyUrl;

		private void initializeContext()
		{
			this.contextMenuStrip100_ForTab = new System.Windows.Forms.ContextMenuStrip();
			this.toolStripMenuItem101_CloseTab = new System.Windows.Forms.ToolStripMenuItem();
			this.toolStripMenuItem102_CloseAllTabs = new System.Windows.Forms.ToolStripMenuItem();
			this.toolStripSeparator101 = new System.Windows.Forms.ToolStripSeparator();
			this.toolStripMenuItem103_OpenNewTab = new System.Windows.Forms.ToolStripMenuItem();
			this.toolStripMenuItem103_TabPageList = new ToolStripMenuItem();
			this.toolStripSeparator102 = new System.Windows.Forms.ToolStripSeparator();
			this.toolStripMenuItem104_Refresh = new System.Windows.Forms.ToolStripMenuItem();
			this.toolStripMenuItem105_RefreshAllLockedTabs = new System.Windows.Forms.ToolStripMenuItem();
			this.toolStripMenuItem106_RefreshAllTabs = new System.Windows.Forms.ToolStripMenuItem();
			this.toolStripSeparator103 = new System.Windows.Forms.ToolStripSeparator();
			this.toolStripMenuItem107_LockThisTab = new System.Windows.Forms.ToolStripMenuItem();
			this.toolStripSeparator104 = new System.Windows.Forms.ToolStripSeparator();
			this.toolStripMenuItem108_CopyTitleAndUrl = new System.Windows.Forms.ToolStripMenuItem();
			this.toolStripMenuItem109_CopyTitle = new System.Windows.Forms.ToolStripMenuItem();
			this.toolStripMenuItem110_CopyUrl = new System.Windows.Forms.ToolStripMenuItem();
			// 
			// contextMenuStrip100_ForTab
			// 
			this.contextMenuStrip100_ForTab.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.toolStripMenuItem101_CloseTab,
            this.toolStripMenuItem102_CloseAllTabs,
            this.toolStripSeparator101,
            this.toolStripMenuItem103_OpenNewTab,
				this.toolStripMenuItem103_TabPageList,
            this.toolStripSeparator102,
            this.toolStripMenuItem104_Refresh,
            this.toolStripMenuItem105_RefreshAllLockedTabs,
            this.toolStripMenuItem106_RefreshAllTabs,
            this.toolStripSeparator103,
            this.toolStripMenuItem107_LockThisTab,
            this.toolStripSeparator104,
            this.toolStripMenuItem108_CopyTitleAndUrl,
            this.toolStripMenuItem109_CopyTitle,
            this.toolStripMenuItem110_CopyUrl});
			this.contextMenuStrip100_ForTab.Name = "contextMenuStrip100_ForTab";
			this.contextMenuStrip100_ForTab.Size = new System.Drawing.Size(261, 248);
			this.contextMenuStrip100_ForTab.Opening += new CancelEventHandler(contextMenuStrip100_ForTab_Opening);
			// 
			// toolStripMenuItem101_CloseTab
			// 
			this.toolStripMenuItem101_CloseTab.Name = "toolStripMenuItem101_CloseTab";
			this.toolStripMenuItem101_CloseTab.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.W)));
			this.toolStripMenuItem101_CloseTab.Size = new System.Drawing.Size(260, 22);
			this.toolStripMenuItem101_CloseTab.Text = "(&C)";
			this.toolStripMenuItem101_CloseTab.Click += new System.EventHandler(this.toolStripMenuItem101_CloseTab_Click);
			// 
			// toolStripMenuItem102_CloseAllTabs
			// 
			this.toolStripMenuItem102_CloseAllTabs.Name = "toolStripMenuItem102_CloseAllTabs";
			this.toolStripMenuItem102_CloseAllTabs.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.T)));
			this.toolStripMenuItem102_CloseAllTabs.Size = new System.Drawing.Size(260, 22);
			this.toolStripMenuItem102_CloseAllTabs.Text = "ׂẴ^u(&A)";
			this.toolStripMenuItem102_CloseAllTabs.Click += new System.EventHandler(this.toolStripMenuItem102_CloseAllTabs_Click);
			// 
			// toolStripSeparator101
			// 
			this.toolStripSeparator101.Name = "toolStripSeparator101";
			this.toolStripSeparator101.Size = new System.Drawing.Size(257, 6);
			// 
			// toolStripMenuItem103_OpenNewTab
			// 
			this.toolStripMenuItem103_OpenNewTab.Name = "toolStripMenuItem103_OpenNewTab";
			this.toolStripMenuItem103_OpenNewTab.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.T)));
			this.toolStripMenuItem103_OpenNewTab.Size = new System.Drawing.Size(260, 22);
			this.toolStripMenuItem103_OpenNewTab.Text = "V^uJ(&N)";
			this.toolStripMenuItem103_OpenNewTab.Click += new System.EventHandler(this.toolStripMenuItem103_OpenNewTab_Click);
			//
			// toolStripMenuItem103_TabPageList
			//
			this.toolStripMenuItem103_TabPageList.Name = "toolStripMenuItem103_TabPageList";
			this.toolStripMenuItem103_TabPageList.Size = new Size(260, 22);
			this.toolStripMenuItem103_TabPageList.Text = "JĂ^üꗗ";
			// 
			// toolStripSeparator102
			// 
			this.toolStripSeparator102.Name = "toolStripSeparator102";
			this.toolStripSeparator102.Size = new System.Drawing.Size(257, 6);
			// 
			// toolStripMenuItem104_Refresh
			// 
			this.toolStripMenuItem104_Refresh.Name = "toolStripMenuItem104_Refresh";
			this.toolStripMenuItem104_Refresh.ShortcutKeys = System.Windows.Forms.Keys.F5;
			this.toolStripMenuItem104_Refresh.Size = new System.Drawing.Size(260, 22);
			this.toolStripMenuItem104_Refresh.Text = "ŐV̏ɍXV(&R)";
			this.toolStripMenuItem104_Refresh.Click += new System.EventHandler(this.toolStripMenuItem104_Refresh_Click);
			// 
			// toolStripMenuItem105_RefreshAllLockedTabs
			// 
			this.toolStripMenuItem105_RefreshAllLockedTabs.Name = "toolStripMenuItem105_RefreshAllLockedTabs";
			this.toolStripMenuItem105_RefreshAllLockedTabs.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.F5)));
			this.toolStripMenuItem105_RefreshAllLockedTabs.Size = new System.Drawing.Size(260, 22);
			this.toolStripMenuItem105_RefreshAllLockedTabs.Text = "ׂẴbN^uXV(&O)";
			this.toolStripMenuItem105_RefreshAllLockedTabs.Click += new System.EventHandler(this.toolStripMenuItem105_RefreshAllLockedTabs_Click);
			// 
			// toolStripMenuItem106_RefreshAllTabs
			// 
			this.toolStripMenuItem106_RefreshAllTabs.Name = "toolStripMenuItem106_RefreshAllTabs";
			this.toolStripMenuItem106_RefreshAllTabs.ShortcutKeys = ((System.Windows.Forms.Keys)(((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.Shift)
						| System.Windows.Forms.Keys.F5)));
			this.toolStripMenuItem106_RefreshAllTabs.Size = new System.Drawing.Size(260, 22);
			this.toolStripMenuItem106_RefreshAllTabs.Text = "ׂẴ^uXV(&E)";
			this.toolStripMenuItem106_RefreshAllTabs.Click += new System.EventHandler(this.toolStripMenuItem106_RefreshAllTabs_Click);
			// 
			// toolStripSeparator103
			// 
			this.toolStripSeparator103.Name = "toolStripSeparator103";
			this.toolStripSeparator103.Size = new System.Drawing.Size(257, 6);
			// 
			// toolStripMenuItem107_LockThisTab
			// 
			this.toolStripMenuItem107_LockThisTab.Name = "toolStripMenuItem107_LockThisTab";
			this.toolStripMenuItem107_LockThisTab.Size = new System.Drawing.Size(260, 22);
			this.toolStripMenuItem107_LockThisTab.Text = "̃^ubN(&L)";
			this.toolStripMenuItem107_LockThisTab.Click += new System.EventHandler(this.toolStripMenuItem107_LockThisTab_Click);
			// 
			// toolStripSeparator104
			// 
			this.toolStripSeparator104.Name = "toolStripSeparator104";
			this.toolStripSeparator104.Size = new System.Drawing.Size(257, 6);
			// 
			// toolStripMenuItem108_CopyTitleAndUrl
			// 
			this.toolStripMenuItem108_CopyTitleAndUrl.Name = "toolStripMenuItem108_CopyTitleAndUrl";
			this.toolStripMenuItem108_CopyTitleAndUrl.Size = new System.Drawing.Size(260, 22);
			this.toolStripMenuItem108_CopyTitleAndUrl.Text = "^CgURLRs[(&B)";
			this.toolStripMenuItem108_CopyTitleAndUrl.Click += new System.EventHandler(this.toolStripMenuItem108_CopyTitleAndUrl_Click);
			// 
			// toolStripMenuItem109_CopyTitle
			// 
			this.toolStripMenuItem109_CopyTitle.Name = "toolStripMenuItem109_CopyTitle";
			this.toolStripMenuItem109_CopyTitle.Size = new System.Drawing.Size(260, 22);
			this.toolStripMenuItem109_CopyTitle.Text = "^CgRs[(&T)";
			this.toolStripMenuItem109_CopyTitle.Click += new System.EventHandler(this.toolStripMenuItem109_CopyTitle_Click);
			// 
			// toolStripMenuItem110_CopyUrl
			// 
			this.toolStripMenuItem110_CopyUrl.Name = "toolStripMenuItem110_CopyUrl";
			this.toolStripMenuItem110_CopyUrl.Size = new System.Drawing.Size(260, 22);
			this.toolStripMenuItem110_CopyUrl.Text = "URLRs[(&U)";
			this.toolStripMenuItem110_CopyUrl.Click += new System.EventHandler(this.toolStripMenuItem110_CopyUrl_Click);

		}

		void contextMenuStrip100_ForTab_Opening(object sender, CancelEventArgs e)
		{
			if(0 <= this.ContextMenuTargetTab && this.ContextMenuTargetTab < this.TbTabCount)
			{
				this.toolStripMenuItem107_LockThisTab.Checked = this.TbGetIsLocked(this.ContextMenuTargetTab);
			}
			this.get_PageListMenu(this.toolStripMenuItem103_TabPageList.DropDownItems, true);
		}

		#endregion

		#region contextPageList

		private ContextMenuStrip ctxMenuPageList;
		private ToolStripMenuItem tsmiPageListOpenNewTab;
		private List<ToolStripMenuItem> tsmiPageLists;
		private ToolStripSeparator tsctxmenuSeparate1 = new ToolStripSeparator();
		private ToolStripSeparator tsctxmenuSeparate2 = new ToolStripSeparator();

		private void initializePageList()
		{
			this.ctxMenuPageList = new ContextMenuStrip();
			this.tsctxmenuSeparate1 = new ToolStripSeparator();
			this.tsctxmenuSeparate2 = new ToolStripSeparator();
			this.tsctxmenuSeparate1.Name = "-1";
			this.tsctxmenuSeparate2.Name = "-1";

			this.ctxMenuPageList.ItemClicked += new ToolStripItemClickedEventHandler(ctxMenuPageList_ItemClicked);
			this.ctxMenuPageList.Opening += new CancelEventHandler(ctxMenuPageList_Opening);
			this.tsmiPageLists = new List<ToolStripMenuItem>(32);
			for(int i = 0; i < this.maxTabCount; i++)
			{
				tsmiPageLists.Add(new ToolStripMenuItem());
				tsmiPageLists[i].Name = i.ToString();
			}
			this.tsmiPageListOpenNewTab = new ToolStripMenuItem();
			tsmiPageListOpenNewTab.Text = "V^uJ";
			tsmiPageListOpenNewTab.Name = "-10";
			tsmiPageListOpenNewTab.Image = Browser.Properties.Resources.document.ToBitmap();
			tsmiPageListOpenNewTab.ShowShortcutKeys = true;
		}
		/// <summary>
		/// \̃y[Wꗗ擾
		/// </summary>
		/// <param name="target_"></param>
		/// <param name="useTitle_"></param>
		private void get_PageListMenu(ToolStripItemCollection target_, bool useTitle_)
		{
			for(int i = 0; i < this.TbTabCount; i++)
			{
				tsmiPageLists[i].Text =
					useTitle_ ?
					this.TbGetBrowser(i).DocumentTitle
					: this.TbGetBrowser(i).Url.ToString();
				tsmiPageLists[i].Checked = this.TbSelectedIndex == i;
				target_.Add(tsmiPageLists[i]);
			}
		}

		void ctxMenuPageList_Opening(object sender, CancelEventArgs e)
		{
			bool useTitle_ = true;
			this.ctxMenuPageList.Items.Clear();
			this.ctxMenuPageList.Items.Add(tsmiPageListOpenNewTab);
			this.ctxMenuPageList.Items.Add(tsctxmenuSeparate1);
			this.get_PageListMenu(this.ctxMenuPageList.Items, useTitle_);
		}

		void ctxMenuPageList_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
		{
			int tgt = Int32.Parse(e.ClickedItem.Name);
			if(0 <= tgt && tgt < this.TbTabCount)
			{
				this.TbSelectedIndex = tgt;
			}
			else if(tgt == -10)
			{
				this.TbOpenNewWindow(blankUrl);
			}
		}

		#endregion



		#region LatestClosedTabHistory֘A

		ContextMenuStrip ctxCloseHistory;
		ToolStripMenuItem tsmiCloseHistoryHeader;
		List<ToolStripMenuItem> tsmiCloseHistory;
		List<KeyValuePair<string, string>> closedTabHistory;

		/// <summary>
		/// ŋߕ^ũ^CgURL擾܂B
		/// </summary>
		/// <param name="offset">Ōɕ^u0Ƃ̒l</param>
		/// <returns>KeyɃ^CgAValueUrlPair</returns>
		public KeyValuePair<string, string> GetRecentClosed(int offset)
		{
			if(0 <= offset && this.closedTabHistory.Count < offset)
			{
				return this.closedTabHistory[offset];
			}
			else
			{
				throw new ArgumentException("TabBrowser::GetRecentClosed̈sł");
			}
		}
		/// <summary>
		/// 
		/// </summary>
		public int RecentclosedTabCount
		{
			get { return this.closedTabHistory.Count; }
		}

		private void initiaizeClosedHistory()
		{
			this.closedTabHistory = new List<KeyValuePair<string, string>>(maxClosedTabHistory);
			this.ctxCloseHistory = new ContextMenuStrip();
			this.ctxCloseHistory.ShowItemToolTips = true;

			this.tsmiCloseHistoryHeader = new ToolStripMenuItem();
			this.tsmiCloseHistoryHeader.Text = "ŋߕ^üꗗ";
			this.tsmiCloseHistoryHeader.Enabled = false;

			this.tsmiCloseHistory = new List<ToolStripMenuItem>(maxClosedTabHistory);
			for(int i = 0; i < this.tsmiCloseHistory.Capacity; i++)
			{
				ToolStripMenuItem mn = new ToolStripMenuItem();
				mn.Name = i.ToString();
				this.tsmiCloseHistory.Add(mn);
			}
			this.ctxCloseHistory.Opening += new CancelEventHandler(ctxCloseHistory_Opening);
			this.ctxCloseHistory.ItemClicked += new ToolStripItemClickedEventHandler(ctxCloseHistory_ItemClicked);
		}

		void ctxCloseHistory_Opening(object sender, CancelEventArgs e)
		{
			this.ctxCloseHistory.Items.Clear();
			this.ctxCloseHistory.Items.Add(tsmiCloseHistoryHeader);
			this.ctxCloseHistory.Items.Add(tsctxmenuSeparate2);
			for(int i = 0; i < this.closedTabHistory.Count; i++)
			{
				this.tsmiCloseHistory[i].Text = closedTabHistory[i].Key;
				this.tsmiCloseHistory[i].ToolTipText = closedTabHistory[i].Value;
				this.ctxCloseHistory.Items.Add(this.tsmiCloseHistory[i]);
			}
		}

		void ctxCloseHistory_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
		{
			int tgt = Int32.Parse(e.ClickedItem.Name);
			if(tgt >= 0)
			{
				this.TbOpenNewWindow(this.closedTabHistory[tgt].Value);
				this.closedTabHistory.RemoveAt(tgt);
			}
		}

		private void set_ClosedTabHistory(string _title, string _url)
		{
			if(this.closedTabHistory.Count == this.closedTabHistory.Capacity)
			{
				this.closedTabHistory.RemoveAt(this.closedTabHistory.Count - 1);
			}
			this.closedTabHistory.Insert(0, new KeyValuePair<string, string>(_title, _url));
		}
		private void remove_LatestClosedTabHistory()
		{
			this.closedTabHistory.RemoveAt(0);
		}
		private string get_LatestClosedTabHistory()
		{
			if(this.closedTabHistory.Count > 0)
			{
				return this.closedTabHistory[0].Value;
			}
			else { return String.Empty; }
		}

		#endregion

	}

	// ********************  TabBrowserControl ܂  *************************** //




	public class MovieDownloadRequiredEventArgs : EventArgs
	{
		string _url;
		public string Url
		{
			get { return this._url; }
		}
		public MovieDownloadRequiredEventArgs(string url)
			: base()
		{
			this._url = url;
		}
	}

	public class TabBrowserDragDropData
	{
		public string Url;
		public string Title;
		public int Index;

		public TabBrowserDragDropData(int index)
		{
			this.Index = index;
			this.Url = "";
			this.Title = "";
		}
		public TabBrowserDragDropData(int index, string url, string title)
		{
			this.Index = index;
			this.Url = "";
			this.Title = "";
		}
	}

	/// <summary>
	/// 
	/// </summary>
	[Serializable]
	public class TabBrowserSetting
	{
		#region Fields 

		/// <summary>
		/// y[W^Cg\ύXsǂł
		/// </summary>
		public bool EnableEditTitle;
		/// <summary>
		/// y[W^Cg\ύXszXg̐K\}b`p^[ł
		/// </summary>
		public string EditTitle_MatchHost;
		/// <summary>
		/// y[W^Cg\̐K\}b`p^[ł
		/// </summary>
		public string EditTitle_MatchPattern;
		/// <summary>
		/// y[W^Cg\̒up^[ł
		/// </summary>
		public string EditTitle_ReplacePattern;

		/// <summary>
		/// OuEU̎st@C̃tpXł
		/// </summary>
		public string BrowserPath;
		/// <summary>
		/// bNꂽ^u̐U镑ł
		/// </summary>
		public LockedTabBehaviors LockedTabBehavior;

		/// <summary>
		/// V^uJƂ̃ftHg̃ZLeBԂł
		/// </summary>
		public SecurityFlags DefaultSecurity;
		/// <summary>
		/// TrustZoneUrlɃ}b`URL̃TCgŃftHgɎgpZLeBԂł
		/// </summary>
		public SecurityFlags DefaultSecurityTrust;
		/// <summary>
		/// MURL\K\ł
		/// </summary>
		public string TrustZoneUrl;

		/// <summary>
		/// }EXWFX`[Fۂ̃}EXړʂ臒lł
		/// </summary>
		public int GuestureThreshold;
		/// <summary>
		/// zC[NbNŊJ^uɃtH[JX܂
		/// </summary>
		public bool FocusOnCenterClickOpen;
		/// <summary>
		/// tH[JX̂^uƂɉEփtH[JXڂ܂
		/// </summary>
		public bool FocusRightWhenFocusedClosed;
		/// <summary>
		/// ^ũzC[őI^uɕύX܂
		/// </summary>
		public bool EnableTabWheel;
		/// <summary>
		/// ^ũzC[őI^uύXƂA[[փ[e[V܂
		/// </summary>
		public bool TabWheelRotate;
		/// <summary>
		/// ^u_uNbNƂ̓ł
		/// </summary>
		public string Cmd_TabDoubleClick;

		#endregion

		#region Field (Require Restart)
		/// <summary>
		/// vLVT[o[gp邩ǂ擾Eݒ肵܂
		/// iċN܂Ŕf܂j
		/// </summary>
		public bool ProxyUse;
		/// <summary>
		/// vLVT[o[URL擾Eݒ肵܂
		/// iċN܂Ŕf܂j
		/// </summary>
		public string ProxyUrl;
		/// <summary>
		/// vLVT[o[̃|[g擾Eݒ肵܂
		/// iċN܂Ŕf܂j
		/// </summary>
		public int ProxyPort;
		/// <summary>
		/// vLVT[o[̗Oݒ擾Eݒ肵܂
		/// iċN܂Ŕf܂j
		/// </summary>
		public string ProxyBypass;
		/// <summary>
		/// 
		/// </summary>
		public Dictionary<string, string> RecentClosedTab;


		#endregion


		public TabBrowserSetting()
		{
			this.load_default();
		}

		private void load_default()
		{
			this.EnableEditTitle = true;
			this.EditTitle_MatchPattern =
				@"(?<title>.+)(]jRjR\(\)|]jRjR`\(\)|]NICO NICO DOUGA\(\)).*";
			this.EditTitle_ReplacePattern = @"${title}";
			this.EditTitle_MatchHost = "^http://(www|tw|de|es).nicovideo.jp/";
			this.BrowserPath = @"C:\Program Files\Internet Explorer\iexplorer.exe";
			this.LockedTabBehavior = LockedTabBehaviors.BoonCompatible;
			this.DefaultSecurity = SecurityFlags.Script;//SecurityFlags.None;
			this.DefaultSecurityTrust = SecurityFlags.Script | SecurityFlags.AxExecute;
			this.TrustZoneUrl = @"^https?://((www|tw|de|es|secure)\.nicovideo\.jp/|www\.nicochart\.jp/)";
			this.GuestureThreshold = 10;
			this.FocusOnCenterClickOpen = false;
			this.FocusRightWhenFocusedClosed = true;
			this.EnableTabWheel = true;
			this.TabWheelRotate = false;

			this.ProxyUse = false;
			this.ProxyUrl = "localhost";
			this.ProxyPort = 8080;

			this.Cmd_TabDoubleClick = TabBrowserAction.TabLockChange;
		}

	}

	/// <summary>
	/// 
	/// </summary>
	public class TabNavigateHistory
	{
		public const int maxentry = 10;
		public TravelLogEntry[] BackHistory;
		public TravelLogEntry[] ForeHistory;
		public TravelLogEntry Current;

		public TabNavigateHistory(WebBrowserEx browser)
		{
			this.BackHistory = browser.History.EnumEntries(TLENUMF.TLEF_RELATIVE_BACK,10);
			this.ForeHistory = browser.History.EnumEntries(TLENUMF.TLEF_RELATIVE_FORE,10);
			this.Current = browser.History.EnumEntries(TLENUMF.TLEF_RELATIVE_INCLUDE_CURRENT,1)[0];
		}
	}

	/// <summary>
	/// 
	/// </summary>
	public enum LockedTabBehaviors : byte
	{
		AsNotLocked = 0x0,
		IgnoreClose = 0x1,
		NavigateOnNew = 0x2,
		ForeBackOnNew = 0x4,
		ReloadOnNew = 0x8,

		BoonCompatible = 0x7,
	}

	public static class TabBrowserAction
	{
		private static readonly List<string> _keynames;

		static TabBrowserAction()
		{
			_keynames = new List<string>();

			_keynames.Add(None);

			_keynames.Add(OpenTabBlank);
			_keynames.Add(OpenTabCopy);

			_keynames.Add(CloseTab);
			_keynames.Add(CloseAll);

			_keynames.Add(GoBack);
			_keynames.Add(GoFore);
			_keynames.Add(Reload);
			_keynames.Add(Stop);
			_keynames.Add(TabLockChange);
		}

		public static string IndexToName(int index)
		{
			return _keynames[index];
		}
		public static int NameToIndex(string name)
		{
			return _keynames.IndexOf(name);
		}
		public static IEnumerator<string> GetEnumerator()
		{
			return _keynames.GetEnumerator();
		}

		#region Action Name

		public static string None { get { return "None"; } }

		public static string OpenTabBlank { get { return "OpenTabBlank"; } }
		public static string OpenTabCopy { get { return "OpenTabCopy"; } }

		public static string CloseTab { get { return "CloseTab"; } }
		public static string CloseAll { get { return "CloseAll"; } }

		public static string GoBack { get { return "GoBack"; } }
		public static string GoFore { get { return "GoFore"; } }
		public static string Reload { get { return "Reload"; } }
		public static string Stop { get { return "Stop"; } }

		public static string TabLockChange { get { return "TabLockChange"; } }


		#endregion

	}

	public enum Direction
	{
		Up = 0x01,
		Down = 0x02,
		Left = 0x04,
		Right = 0x08,
	}

}