/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type.builtin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.bitmeister.asn1.annotation.ASN1BuiltIn;
import jp.bitmeister.asn1.annotation.ASN1Identifier;
import jp.bitmeister.asn1.annotation.ASN1Tag;
import jp.bitmeister.asn1.annotation.ASN1XmlTypeName;
import jp.bitmeister.asn1.exception.ASN1IllegalArgument;
import jp.bitmeister.asn1.processor.ASN1Visitor;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagMode;
import jp.bitmeister.asn1.type.PrimitiveType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ASN1BuiltIn
@ASN1Identifier(value="OBJECT IDENTIFIER")
@ASN1XmlTypeName(value="OBJECT_IDENTIFIER")
@ASN1Tag(tagClass=ASN1TagClass.UNIVERSAL, value=6, tagMode=ASN1TagMode.IMPLICIT)
public class OBJECT_IDENTIFIER
extends PrimitiveType<List<Integer>> {
    private static Map<String, Integer> NAMES_ROOT = new HashMap<String, Integer>();
    private static Map<String, Integer> NAMES_ITU_T = new HashMap<String, Integer>();
    private static Map<String, Integer> NAMES_ISO = new HashMap<String, Integer>();
    private static Map<String, Integer> NAMES_ITU_T_REC = new HashMap<String, Integer>();

    static {
        NAMES_ROOT.put("itu-t", 0);
        NAMES_ROOT.put("ccitt", 0);
        NAMES_ROOT.put("iso", 1);
        NAMES_ROOT.put("joint-iso-itu-t", 2);
        NAMES_ROOT.put("joint-iso-ccitt", 2);
        NAMES_ITU_T.put("recommendation", 0);
        NAMES_ITU_T.put("question", 1);
        NAMES_ITU_T.put("administration", 2);
        NAMES_ITU_T.put("network-operator", 3);
        NAMES_ITU_T.put("identified-organization", 4);
        NAMES_ITU_T.put("r-recommendation", 5);
        NAMES_ISO.put("standard", 0);
        NAMES_ISO.put("registration-authority", 1);
        NAMES_ISO.put("member-body", 2);
        NAMES_ISO.put("identified-organization", 3);
        char c = 'a';
        while (c <= 'z') {
            NAMES_ITU_T_REC.put(String.valueOf(c), c - 97);
            c = (char)(c + '\u0001');
        }
    }

    public static int nameFormToInt(List<Integer> list, String nameForm) {
        Integer number = null;
        if (list.size() == 0) {
            number = NAMES_ROOT.get(nameForm);
        } else if (list.size() == 1) {
            if (list.get(0) == 0) {
                number = NAMES_ITU_T.get(nameForm);
            } else if (list.get(0) == 1) {
                number = NAMES_ISO.get(nameForm);
            }
        } else if (list.size() == 2 && list.get(0) == 0 && list.get(1) == 0) {
            number = NAMES_ITU_T_REC.get(nameForm);
        }
        if (number == null) {
            ASN1IllegalArgument e = new ASN1IllegalArgument();
            e.setMessage("Invalid OID name form '" + nameForm + "'.", null, OBJECT_IDENTIFIER.class, null, null);
            throw e;
        }
        return number;
    }

    public OBJECT_IDENTIFIER() {
    }

    public OBJECT_IDENTIFIER(List<Integer> value) {
        this.set(value);
    }

    public OBJECT_IDENTIFIER(int ... value) {
        this.set(value);
    }

    @Override
    public void set(int ... value) {
        ArrayList<Integer> oids = new ArrayList<Integer>();
        int[] nArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            oids.add(i);
            ++n2;
        }
        this.set(oids);
    }

    @Override
    protected List<Integer> cloneValue() {
        ArrayList<Integer> clone = new ArrayList<Integer>();
        clone.addAll((Collection)this.value());
        return clone;
    }

    @Override
    public <R, E extends Throwable> R accept(ASN1Visitor<R, E> visitor) throws E {
        return visitor.visit(this);
    }
}

