/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type.builtin;

import java.lang.reflect.Field;
import java.util.Map;
import jp.bitmeister.asn1.annotation.ASN1BuiltIn;
import jp.bitmeister.asn1.annotation.ASN1Tag;
import jp.bitmeister.asn1.exception.ASN1IllegalDefinition;
import jp.bitmeister.asn1.exception.ASN1RuntimeException;
import jp.bitmeister.asn1.processor.ASN1Visitor;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagMode;
import jp.bitmeister.asn1.type.AbstractInteger;
import jp.bitmeister.asn1.type.NamedNumberMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ASN1BuiltIn
@ASN1Tag(tagClass=ASN1TagClass.UNIVERSAL, value=2, tagMode=ASN1TagMode.IMPLICIT)
public class INTEGER
extends AbstractInteger<Long> {
    private static final NamedNumberMap<Long> NAMED_NUMBER_MAPS = new NamedNumberMap<Long>(){

        @Override
        public Long getKeyValue(Field f) {
            Long value;
            if (f.getType() == Integer.TYPE || f.getType() == Long.TYPE) {
                try {
                    value = f.getLong(null);
                }
                catch (Exception e) {
                    ASN1RuntimeException ex = new ASN1RuntimeException("Failed to retreave the Long value.");
                    throw ex;
                }
            } else {
                ASN1IllegalDefinition ex = new ASN1IllegalDefinition("An enumeration of INTEGER type must be an 'int' or a 'long' field.");
                throw ex;
            }
            return value;
        }
    };

    static {
        NAMED_NUMBER_MAPS.putEmptyMap(INTEGER.class);
    }

    public INTEGER() {
    }

    public INTEGER(long value) {
        this.set(value);
    }

    @Override
    public Map<Long, String> getNamedNumberMap() {
        return NAMED_NUMBER_MAPS.getNamedNumberMap(this.getClass());
    }

    @Override
    public <R, E extends Throwable> R accept(ASN1Visitor<R, E> visitor) throws E {
        return visitor.visit(this);
    }

    @Override
    public boolean isLongValue() {
        return true;
    }

    @Override
    public boolean isIntValue() {
        return Integer.MIN_VALUE <= (Long)this.value() && (Long)this.value() <= Integer.MAX_VALUE;
    }

    @Override
    protected boolean isEnum() {
        return false;
    }
}

