/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type.builtin;

import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.Map;
import jp.bitmeister.asn1.annotation.ASN1BuiltIn;
import jp.bitmeister.asn1.annotation.ASN1Identifier;
import jp.bitmeister.asn1.annotation.ASN1Tag;
import jp.bitmeister.asn1.exception.ASN1IllegalDefinition;
import jp.bitmeister.asn1.exception.ASN1RuntimeException;
import jp.bitmeister.asn1.processor.ASN1Visitor;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagMode;
import jp.bitmeister.asn1.type.AbstractInteger;
import jp.bitmeister.asn1.type.NamedNumberMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ASN1BuiltIn
@ASN1Identifier(value="INTEGER")
@ASN1Tag(tagClass=ASN1TagClass.UNIVERSAL, value=2, tagMode=ASN1TagMode.IMPLICIT)
public class BigINTEGER
extends AbstractInteger<BigInteger> {
    private static final NamedNumberMap<BigInteger> NAMED_NUMBER_MAPS = new NamedNumberMap<BigInteger>(){

        @Override
        public BigInteger getKeyValue(Field f) {
            BigInteger value;
            if (f.getType() == BigInteger.class) {
                try {
                    value = (BigInteger)f.get(null);
                }
                catch (Exception e) {
                    ASN1RuntimeException ex = new ASN1RuntimeException("Failed to retreave the BigInteger value.");
                    throw ex;
                }
            } else if (f.getType() == Integer.TYPE || f.getType() == Long.TYPE) {
                try {
                    value = BigInteger.valueOf(f.getLong(null));
                }
                catch (Exception e) {
                    ASN1RuntimeException ex = new ASN1RuntimeException("Failed to convert the value to BigInteger.");
                    throw ex;
                }
            } else {
                ASN1IllegalDefinition ex = new ASN1IllegalDefinition("An enumeration of BigINTEGER type must be an 'int', a 'long' or a 'BigInteger' field.");
                throw ex;
            }
            return value;
        }
    };

    static {
        NAMED_NUMBER_MAPS.putEmptyMap(BigINTEGER.class);
    }

    public BigINTEGER() {
    }

    public BigINTEGER(BigInteger value) {
        this.set(value);
    }

    public BigINTEGER(long value) {
        this.set(value);
    }

    @Override
    public void set(long value) {
        this.set(BigInteger.valueOf(value));
    }

    @Override
    public boolean isLongValue() {
        return ((BigInteger)this.value()).compareTo(BigInteger.valueOf(Long.MIN_VALUE)) >= 0 && ((BigInteger)this.value()).compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0;
    }

    @Override
    public boolean isIntValue() {
        return ((BigInteger)this.value()).compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) >= 0 && ((BigInteger)this.value()).compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) <= 0;
    }

    @Override
    public Map<BigInteger, String> getNamedNumberMap() {
        return NAMED_NUMBER_MAPS.getNamedNumberMap(this.getClass());
    }

    @Override
    public <R, E extends Throwable> R accept(ASN1Visitor<R, E> visitor) throws E {
        return visitor.visit(this);
    }

    @Override
    protected boolean isEnum() {
        return false;
    }
}

