/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type;

import java.util.Arrays;
import jp.bitmeister.asn1.annotation.ASN1BuiltIn;
import jp.bitmeister.asn1.annotation.ASN1Identifier;
import jp.bitmeister.asn1.processor.ASN1Visitor;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ASN1BuiltIn
@ASN1Identifier(value="(unknown)")
public final class UnknownType
extends ASN1Type {
    private ASN1TagClass tagClass;
    private int tagNumber;
    private byte[] value;

    public UnknownType(ASN1TagClass tagClass, int tagNumber) {
        this.tagClass = tagClass;
        this.tagNumber = tagNumber;
    }

    public void set(byte[] value) {
        this.value = value;
    }

    public byte[] value() {
        return this.value;
    }

    public ASN1TagClass tagClass() {
        return this.tagClass;
    }

    public int tagNumber() {
        return this.tagNumber;
    }

    @Override
    public void clear() {
        this.tagClass = null;
        this.tagNumber = 0;
        this.value = null;
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public <R, E extends Throwable> R accept(ASN1Visitor<R, E> visitor) throws E {
        return visitor.visit(this);
    }

    @Override
    public boolean valueEquals(Object other) {
        if (other instanceof UnknownType) {
            UnknownType comparison = (UnknownType)other;
            if (comparison.tagClass == this.tagClass && comparison.tagNumber == this.tagNumber && Arrays.equals(comparison.value, this.value)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public Object clone() {
        UnknownType clone = new UnknownType(this.tagClass, this.tagNumber);
        clone.value = (byte[])this.value.clone();
        return clone;
    }
}

