/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import jp.bitmeister.asn1.annotation.ASN1BuiltIn;
import jp.bitmeister.asn1.annotation.ASN1Enumeration;
import jp.bitmeister.asn1.annotation.ASN1Identifier;
import jp.bitmeister.asn1.exception.ASN1IllegalDefinition;
import jp.bitmeister.asn1.exception.ASN1RuntimeException;
import jp.bitmeister.asn1.type.AbstractInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NamedNumberMap<T extends Number> {
    private Map<Class<? extends AbstractInteger<T>>, Map<T, String>> namedNumberMaps = new HashMap<Class<? extends AbstractInteger<T>>, Map<T, String>>();

    public void putEmptyMap(Class<? extends AbstractInteger<T>> type) {
        this.namedNumberMaps.put(type, new HashMap());
    }

    public Map<T, String> getNamedNumberMap(Class<? extends AbstractInteger<T>> type) {
        Map<T, String> map = this.namedNumberMaps.get(type);
        if (map != null) {
            return map;
        }
        map = new HashMap<T, String>();
        Field[] fieldArray = type.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (f.isAnnotationPresent(ASN1Enumeration.class)) {
                String fieldId;
                int modifier = 25;
                ASN1Identifier id = f.getAnnotation(ASN1Identifier.class);
                String string = fieldId = id != null ? id.value() : f.getName();
                if ((f.getModifiers() & 0x19) != 25) {
                    ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
                    ex.setMessage("An enumeration must be a public static final field.", null, type, fieldId, null);
                    throw ex;
                }
                Object value = null;
                try {
                    value = this.getKeyValue(f);
                }
                catch (ASN1RuntimeException ex) {
                    ex.setMessage(ex.getMessage(), ex.getCause(), type, fieldId, null);
                    throw ex;
                }
                if (map.containsKey(value)) {
                    ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
                    ex.setMessage("Each number of enumerations shall be distinct from all other enumerations in the type.", null, type, fieldId, null);
                    throw ex;
                }
                map.put(value, fieldId);
            }
            ++n2;
        }
        Class<AbstractInteger<T>> parent = type.getSuperclass();
        if (parent.isAnnotationPresent(ASN1BuiltIn.class)) {
            if (!type.getSuperclass().equals(AbstractInteger.class) && map.isEmpty()) {
                ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
                ex.setMessage("ENUMERATED type shall have at least one enumeration item.", null, type, null, null);
                throw ex;
            }
        } else {
            if (!map.isEmpty()) {
                ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
                ex.setMessage("A class that does not extend 'INTEGER' or 'ENUMERATED' directly, can not have own enumerations.", null, type, null, null);
                throw ex;
            }
            map = this.getNamedNumberMap(parent);
        }
        this.namedNumberMaps.put(type, map);
        return map;
    }

    public abstract T getKeyValue(Field var1);
}

