/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type;

import java.util.HashMap;
import java.util.Map;
import jp.bitmeister.asn1.exception.ASN1IllegalDefinition;
import jp.bitmeister.asn1.type.ASN1Module;
import jp.bitmeister.asn1.type.ASN1ModuleManager;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagDefault;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.TypeSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModuleSpecification {
    private String identifier;
    private ASN1TagDefault tagDefault;
    private Map<String, Class<? extends ASN1Type>> identifierMap = new HashMap<String, Class<? extends ASN1Type>>();
    private Map<ASN1TagClass, Map<Integer, Class<? extends ASN1Type>>> tagMap = new HashMap<ASN1TagClass, Map<Integer, Class<? extends ASN1Type>>>();
    private Map<String, Class<? extends ASN1Module>> importedModules = new HashMap<String, Class<? extends ASN1Module>>();

    ModuleSpecification(Class<? extends ASN1Module> module) {
        this.identifier = ASN1Module.identifier(module);
        this.tagDefault = ASN1Module.tagDefault(module);
        if (ASN1Module.isUniversal(module)) {
            this.tagMap.put(ASN1TagClass.UNIVERSAL, new HashMap());
        } else {
            this.tagMap.put(ASN1TagClass.APPLICATION, new HashMap());
            this.tagMap.put(ASN1TagClass.PRIVATE, new HashMap());
        }
        ASN1Module.registerTypes(module, this);
        ASN1Module.importModules(module, this);
    }

    void imports(Class<? extends ASN1Module> module) {
        this.importedModules.put(ASN1Module.identifier(module), module);
    }

    void register(Class<? extends ASN1Type> type) {
        if ((type.getModifiers() & 0x600) != 0) {
            ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
            ex.setMessage("An ASN.1 type class must be instantiatable.", null, type, null, null);
            throw ex;
        }
        if ((type.getModifiers() & 1) == 0) {
            ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
            ex.setMessage("An ASN.1 type class must be a public class", null, type, null, null);
            throw ex;
        }
        if (type.isMemberClass() && (type.getModifiers() & 8) == 0) {
            ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
            ex.setMessage("If an ASN.1 type class is a member class, it must be static.", null, type, null, null);
            throw ex;
        }
        TypeSpecification typeSpec = TypeSpecification.getSpecification(type);
        if (typeSpec.tag() != null) {
            Map<Integer, Class<? extends ASN1Type>> map = this.tagMap.get((Object)typeSpec.tag().tagClass());
            if (map == null) {
                ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
                ex.setMessage("Tag class '" + (Object)((Object)typeSpec.tag().tagClass()) + "'is not allowed to this module.", null, type, null, null);
                throw ex;
            }
            if (map.containsKey(typeSpec.tag().tagNumber())) {
                ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
                ex.setMessage("Tag number '" + typeSpec.tag().tagNumber() + "' is dupulicated.", null, type, null, null);
                throw ex;
            }
            map.put(typeSpec.tag().tagNumber(), type);
        }
        this.identifierMap.put(typeSpec.xmlTypeName(), type);
    }

    String identifier() {
        return this.identifier;
    }

    ASN1TagDefault tagDefault() {
        return this.tagDefault;
    }

    ASN1Type instantiate(ASN1TagClass tagClass, int tagNumber) {
        Class<? extends ASN1Type> type = this.tagMap.get((Object)tagClass).get(tagNumber);
        if (type != null) {
            return ASN1Type.instantiate(type);
        }
        for (Class<? extends ASN1Module> clazz : this.importedModules.values()) {
            ModuleSpecification spec = ASN1ModuleManager.specification(clazz);
            ASN1Type data = spec.instantiate(tagClass, tagNumber);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    ASN1Type instantiate(String typeIdentifier) {
        if (typeIdentifier.indexOf(46) >= 0) {
            String[] identifier = typeIdentifier.split(".");
            return this.instantiate(identifier[0], identifier[1]);
        }
        Class<? extends ASN1Type> type = this.identifierMap.get(typeIdentifier);
        if (type != null) {
            return ASN1Type.instantiate(type);
        }
        return null;
    }

    private ASN1Type instantiate(String moduleIdentifier, String typeIdentifier) {
        ModuleSpecification spec = ASN1ModuleManager.specification(this.importedModules.get(moduleIdentifier));
        if (spec != null) {
            return spec.instantiate(typeIdentifier);
        }
        return null;
    }
}

