/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type;

import java.util.Map;
import jp.bitmeister.asn1.exception.ASN1IllegalArgument;
import jp.bitmeister.asn1.exception.ASN1RuntimeException;
import jp.bitmeister.asn1.type.PrimitiveType;
import jp.bitmeister.asn1.type.ValueComparable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInteger<T extends Number>
extends PrimitiveType<T>
implements ValueComparable<AbstractInteger<T>> {
    @Override
    public void set(String nameOfNumber) {
        Map.Entry<T, String> e2;
        for (Map.Entry<T, String> e2 : this.getNamedNumberMap().entrySet()) {
            if (!((String)e2.getValue()).equals(nameOfNumber)) continue;
            this.set((T)((Number)e2.getKey()));
            return;
        }
        e2 = new ASN1IllegalArgument();
        ((ASN1RuntimeException)((Object)e2)).setMessage("The name '" + nameOfNumber + "' is not defined in this type.", null, this.getClass(), null, null);
        throw e2;
    }

    @Override
    public void set(T value) {
        Map<T, String> map;
        if (this.isEnum() && !(map = this.getNamedNumberMap()).isEmpty() && !map.containsKey(value)) {
            ASN1IllegalArgument ex = new ASN1IllegalArgument();
            ex.setMessage("Invalid value '" + value + "'. Value of a class that represents ASN.1 'ENUMERATED' must be same as one of enumerations.", null, this.getClass(), null, null);
            throw ex;
        }
        super.set(value);
    }

    public String identifier() {
        return this.getNamedNumberMap().get(this.value());
    }

    public abstract boolean isLongValue();

    public abstract boolean isIntValue();

    public long longValue() {
        return ((Number)this.value()).longValue();
    }

    public int intValue() {
        return ((Number)this.value()).intValue();
    }

    @Override
    public int compareTo(AbstractInteger<T> other) {
        return ((Comparable)this.value()).compareTo((Number)other.value());
    }

    protected abstract Map<T, String> getNamedNumberMap();

    protected abstract boolean isEnum();
}

