/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type;

import jp.bitmeister.asn1.annotation.ASN1Tag;
import jp.bitmeister.asn1.exception.ASN1IllegalDefinition;
import jp.bitmeister.asn1.type.ASN1Module;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagDefault;
import jp.bitmeister.asn1.type.ASN1TagMode;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.NamedTypeSpecification;
import jp.bitmeister.asn1.type.TypeSpecification;
import jp.bitmeister.asn1.type.builtin.ANY;
import jp.bitmeister.asn1.type.builtin.CHOICE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASN1TagValue {
    private ASN1TagClass tagClass;
    private int tagNumber;
    private ASN1TagMode tagMode;

    ASN1TagValue(Class<? extends ASN1Type> type, Class<? extends ASN1Module> module) {
        ASN1Tag tag = type.getAnnotation(ASN1Tag.class);
        this.tagClass = tag.tagClass();
        this.tagNumber = tag.value();
        this.setTagMode(tag.tagMode(), ASN1Module.tagDefault(module), type, null);
    }

    ASN1TagValue(NamedTypeSpecification namedType) {
        ASN1Tag tag = namedType.field().getAnnotation(ASN1Tag.class);
        if (tag.tagClass() != ASN1TagClass.CONTEXT_SPECIFIC && tag.tagClass() != ASN1TagClass.PRIVATE) {
            ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
            ex.setMessage("Only context-specific or private tagging is allowed to elements of structured type.", null, namedType.enclosingType(), namedType.identifier(), null);
            throw ex;
        }
        this.tagClass = tag.tagClass();
        this.tagNumber = tag.value();
        this.setTagMode(tag.tagMode(), TypeSpecification.getSpecification(namedType.enclosingType()).tagDefault(), namedType.enclosingType(), namedType.identifier());
    }

    ASN1TagValue(int order, Class<? extends ASN1Type> type) {
        this.tagClass = ASN1TagClass.CONTEXT_SPECIFIC;
        this.tagNumber = order;
        this.tagMode = this.canImplicitTagging(type) ? ASN1TagMode.IMPLICIT : ASN1TagMode.EXPLICIT;
    }

    public ASN1TagClass tagClass() {
        return this.tagClass;
    }

    public int tagNumber() {
        return this.tagNumber;
    }

    public ASN1TagMode tagMode() {
        return this.tagMode;
    }

    private void setTagMode(ASN1TagMode tagMode, ASN1TagDefault tagDefault, Class<? extends ASN1Type> type, String fieldName) {
        this.tagMode = tagMode == ASN1TagMode.DEFAULT ? (tagDefault == ASN1TagDefault.IMPLICIT_TAGS || tagDefault == ASN1TagDefault.AUTOMATIC_TAGS && this.canImplicitTagging(type) ? ASN1TagMode.IMPLICIT : ASN1TagMode.EXPLICIT) : tagMode;
        if (tagMode == ASN1TagMode.IMPLICIT && !this.canImplicitTagging(type)) {
            ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
            ex.setMessage("Implicit tagging is not allowed to 'CHOICE' types and 'ANY' types.", null, type, fieldName, null);
            throw ex;
        }
    }

    private boolean canImplicitTagging(Class<?> type) {
        return !CHOICE.class.isAssignableFrom(type) && !ANY.class.isAssignableFrom(type);
    }
}

