/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.sample;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import jp.bitmeister.asn1.codec.ber.BerDecoder;
import jp.bitmeister.asn1.codec.ber.DerEncoder;
import jp.bitmeister.asn1.codec.xer.XerDecoder;
import jp.bitmeister.asn1.codec.xer.XerEncoder;
import jp.bitmeister.asn1.exception.ASN1DecodingException;
import jp.bitmeister.asn1.exception.ASN1EncodingException;
import jp.bitmeister.asn1.sample.FrightStatus;
import jp.bitmeister.asn1.sample.FrightStatusTypes;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.builtin.INTEGER;
import jp.bitmeister.asn1.type.useful.UTCTime;
import jp.bitmeister.asn1.value.HexString;

public class FrightStatusMain {
    public static void main(String[] args) {
        FrightStatusTypes.AllFrights frights = new FrightStatusTypes.AllFrights(new FrightStatus(new FrightStatusTypes.FrightNumber("JP041"), new FrightStatusTypes.Information(new FrightStatusTypes.Airport(0L), new UTCTime("110627073000"), new UTCTime("110627073000")), new FrightStatusTypes.Information(new FrightStatusTypes.Airport(1L), new UTCTime("110627090000"), null)), new FrightStatus(new FrightStatusTypes.FrightNumber("NI022"), new FrightStatusTypes.Information(new FrightStatusTypes.Airport(3L), new UTCTime("110627080000"), new UTCTime("110627081000")), new FrightStatusTypes.Information(new FrightStatusTypes.Airport(2L), new UTCTime("110627093000"), null), new FrightStatusTypes.Status(new INTEGER(10L))));
        System.out.println("Source data:");
        System.out.println(frights);
        FrightStatusMain.derEncAndDec(frights);
        FrightStatusMain.xerEncAndDec(frights);
    }

    static void derEncAndDec(ASN1Type data) {
        System.out.println("BER encoding:");
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        DerEncoder enc = new DerEncoder(bo);
        try {
            enc.encode(data);
        }
        catch (ASN1EncodingException e) {
            e.printStackTrace();
        }
        System.out.println(new HexString(bo.toByteArray()));
        ByteArrayInputStream bi = new ByteArrayInputStream(bo.toByteArray());
        BerDecoder dec = new BerDecoder(FrightStatusTypes.class, bi);
        try {
            ASN1Type result = dec.decode();
            System.out.println("BER decoding:");
            System.out.println(result);
        }
        catch (ASN1DecodingException e) {
            e.printStackTrace();
        }
    }

    static void xerEncAndDec(ASN1Type data) {
        System.out.println("XER encoding:");
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        XerEncoder enc = new XerEncoder(bo);
        try {
            enc.encode(data);
        }
        catch (ASN1EncodingException e) {
            e.printStackTrace();
        }
        System.out.println(new String(bo.toByteArray()));
        ByteArrayInputStream bi = new ByteArrayInputStream(bo.toByteArray());
        XerDecoder dec = new XerDecoder(FrightStatusTypes.class, bi);
        try {
            ASN1Type result = dec.decode();
            System.out.println("XER decoding:");
            System.out.println(result);
        }
        catch (ASN1DecodingException e) {
            e.printStackTrace();
        }
    }
}

