/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.codec.xer;

import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import jp.bitmeister.asn1.codec.ASN1Decoder;
import jp.bitmeister.asn1.codec.xer.XerStringEscapeUtil;
import jp.bitmeister.asn1.exception.ASN1DecodingException;
import jp.bitmeister.asn1.processor.ASN1Visitor;
import jp.bitmeister.asn1.type.ASN1Module;
import jp.bitmeister.asn1.type.ASN1ModuleManager;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.CollectionType;
import jp.bitmeister.asn1.type.NamedTypeSpecification;
import jp.bitmeister.asn1.type.StringType;
import jp.bitmeister.asn1.type.StructuredType;
import jp.bitmeister.asn1.type.TimeType;
import jp.bitmeister.asn1.type.UnknownType;
import jp.bitmeister.asn1.type.builtin.ANY;
import jp.bitmeister.asn1.type.builtin.BIT_STRING;
import jp.bitmeister.asn1.type.builtin.BOOLEAN;
import jp.bitmeister.asn1.type.builtin.BigENUMERATED;
import jp.bitmeister.asn1.type.builtin.BigINTEGER;
import jp.bitmeister.asn1.type.builtin.CHOICE;
import jp.bitmeister.asn1.type.builtin.ENUMERATED;
import jp.bitmeister.asn1.type.builtin.INTEGER;
import jp.bitmeister.asn1.type.builtin.NULL;
import jp.bitmeister.asn1.type.builtin.OBJECT_IDENTIFIER;
import jp.bitmeister.asn1.type.builtin.OCTET_STRING;
import jp.bitmeister.asn1.type.builtin.REAL;
import jp.bitmeister.asn1.type.builtin.RELATIVE_OID;
import jp.bitmeister.asn1.type.builtin.SEQUENCE;
import jp.bitmeister.asn1.type.builtin.SEQUENCE_OF;
import jp.bitmeister.asn1.type.builtin.SET;
import jp.bitmeister.asn1.type.builtin.SET_OF;
import jp.bitmeister.asn1.value.BinString;
import jp.bitmeister.asn1.value.HexString;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XerDecoder
implements ASN1Decoder,
ASN1Visitor<DataDecoder, SAXException> {
    private Class<? extends ASN1Module> module;
    private InputStream in;
    private XMLReader reader;

    public XerDecoder(InputStream in) {
        this.in = in;
    }

    public XerDecoder(Class<? extends ASN1Module> module, InputStream in) {
        this(in);
        this.module = module;
    }

    @Override
    public <T extends ASN1Type> T decode(final Class<T> type) throws ASN1DecodingException {
        XerHandler handler = new XerHandler<T>(){

            @Override
            void initializeData(String qName) throws SAXException {
                this.data = ASN1Type.instantiate(type);
                if (XerDecoder.this.module == null) {
                    XerDecoder.this.module = this.data.specification().module();
                }
                if (!(this.data instanceof ANY) && !qName.equals(this.data.specification().xmlTypeName(XerDecoder.this.module))) {
                    throw new SAXException("Unexpected xml tag name '" + qName + "'. '" + this.data.specification().xmlTypeName(XerDecoder.this.module) + "' is expected.");
                }
            }
        };
        this.parse(handler);
        return handler.data;
    }

    @Override
    public ASN1Type decode() throws ASN1DecodingException {
        XerHandler<ASN1Type> handler = new XerHandler<ASN1Type>(){

            @Override
            void initializeData(String qName) throws SAXException {
                this.data = ASN1ModuleManager.instantiate(XerDecoder.this.module, qName);
                if (this.data == null) {
                    throw new SAXException("Unknown data type '" + qName + "'.");
                }
            }
        };
        this.parse(handler);
        return handler.data;
    }

    private void parse(XerHandler<?> handler) throws ASN1DecodingException {
        try {
            this.reader = XMLReaderFactory.createXMLReader();
            this.reader.setContentHandler(handler);
            this.reader.parse(new InputSource(this.in));
        }
        catch (Exception e) {
            ASN1DecodingException ex = new ASN1DecodingException();
            ex.setMessage("An exception thrown while decoding process.", e, null, null, null);
            throw ex;
        }
    }

    @Override
    public DataDecoder visit(final BOOLEAN data) {
        return new DataDecoder(){

            void startChildElement(String qName) {
                if (qName.equals("true")) {
                    data.set(true);
                } else if (qName.equals("false")) {
                    data.set(false);
                }
            }
        };
    }

    @Override
    public DataDecoder visit(final INTEGER data) {
        return new DataDecoder(){

            void startChildElement(String qName) {
                data.set(qName);
            }

            public void characters(String characters) {
                data.set(Long.valueOf(characters));
            }
        };
    }

    @Override
    public DataDecoder visit(final BigINTEGER data) {
        return new DataDecoder(){

            void startChildElement(String qName) {
                data.set(qName);
            }

            public void characters(String characters) {
                data.set(new BigInteger(characters));
            }
        };
    }

    @Override
    public DataDecoder visit(final BIT_STRING data) {
        return new DataDecoder(){

            public void startChildElement(String qName) {
                data.set(qName);
            }

            public void characters(String characters) {
                data.set(new BinString(characters));
            }
        };
    }

    @Override
    public DataDecoder visit(final OCTET_STRING data) {
        return new DataDecoder(){

            public void characters(String characters) {
                data.set(new HexString(characters));
            }
        };
    }

    @Override
    public DataDecoder visit(NULL data) {
        return new DataDecoder(){};
    }

    @Override
    public DataDecoder visit(final OBJECT_IDENTIFIER data) {
        return new DataDecoder(){

            /*
             * Unable to fully structure code
             */
            public void characters(String characters) {
                oids = new ArrayList<Integer>();
                var6_3 = characters.split("\\.");
                var5_4 = var6_3.length;
                var4_5 = 0;
                while (var4_5 < var5_4) {
                    e = var6_3[var4_5];
                    e.trim();
                    if (!Character.isLetter(e.charAt(0))) ** GOTO lbl15
                    if (!e.endsWith(")")) {
                        oids.add(OBJECT_IDENTIFIER.nameFormToInt(oids, e));
                    } else {
                        e = e.substring(e.indexOf(40) + 1, e.indexOf(41));
lbl15:
                        // 2 sources

                        oids.add(Integer.parseInt(e));
                    }
                    ++var4_5;
                }
                data.set(oids);
            }
        };
    }

    @Override
    public DataDecoder visit(final REAL data) {
        return new DataDecoder(){

            public void startChildElement(String qName) {
                if (qName.equals("PLUS-INFINITY")) {
                    data.set(Double.POSITIVE_INFINITY);
                } else if (qName.equals("MINUS-INFINITY")) {
                    data.set(Double.NEGATIVE_INFINITY);
                } else if (qName.equals("NOT-A-NUMBER")) {
                    data.set(Double.NaN);
                }
            }

            public void characters(String characters) {
                data.set(Double.parseDouble(characters));
            }
        };
    }

    @Override
    public DataDecoder visit(ENUMERATED data) {
        return this.visit((INTEGER)data);
    }

    @Override
    public DataDecoder visit(BigENUMERATED data) {
        return this.visit((BigINTEGER)data);
    }

    @Override
    public DataDecoder visit(RELATIVE_OID data) {
        return this.visit((OBJECT_IDENTIFIER)data);
    }

    @Override
    public DataDecoder visit(final ANY data) {
        return new DataDecoder(){
            private DataDecoder decoder;

            void startElement(String qName) throws SAXException {
                data.set(ASN1ModuleManager.instantiate(XerDecoder.this.module, qName));
                this.decoder = ((ASN1Type)data.value()).accept(XerDecoder.this);
                this.decoder.startElement(qName);
            }

            void startChildElement(String qName) throws SAXException {
                this.decoder.startChildElement(qName);
            }

            void characters(String characters) {
                this.decoder.characters(characters);
            }

            void endChildElement(String qName) {
                this.decoder.endChildElement(qName);
            }

            void endElement() {
                this.decoder.endElement();
            }
        };
    }

    @Override
    public DataDecoder visit(CHOICE data) {
        return this.decoderForStructuredType(data);
    }

    @Override
    public DataDecoder visit(SEQUENCE_OF<? extends ASN1Type> data) {
        return this.decoderForCollectionType(data);
    }

    @Override
    public DataDecoder visit(SEQUENCE data) {
        return this.decoderForStructuredType(data);
    }

    @Override
    public DataDecoder visit(SET_OF<? extends ASN1Type> data) {
        return this.decoderForCollectionType(data);
    }

    @Override
    public DataDecoder visit(SET data) {
        return this.decoderForStructuredType(data);
    }

    @Override
    public DataDecoder visit(final StringType data) {
        return new DataDecoder(){
            private StringBuilder builder;
            {
                this.builder = new StringBuilder();
            }

            public void startChildElement(String qName) {
                this.builder.append(XerStringEscapeUtil.unescapeCtrl(qName));
            }

            public void characters(String characters) {
                this.builder.append(characters);
            }

            void endElement() {
                if (this.builder.length() > 0) {
                    data.set(this.builder.toString());
                }
            }
        };
    }

    @Override
    public DataDecoder visit(TimeType data) {
        return this.visit((StringType)data);
    }

    @Override
    public DataDecoder visit(UnknownType data) throws SAXException {
        throw new SAXException("UnkownType is not supported by XerDecoder.");
    }

    private DataDecoder decoderForStructuredType(final StructuredType data) {
        return new ConstructedDataDecoder(){
            private NamedTypeSpecification namedType;
            private ASN1Type element;

            void startChildElement(String qName) throws SAXException {
                if (this.decoder == null) {
                    this.namedType = data.getElement(qName);
                    this.element = this.namedType.instantiate();
                    this.decoder = new NamedElementDecoder(qName, this.element.accept(XerDecoder.this));
                }
                this.decoder.startElement(qName);
            }

            void endChildElement(String qName) {
                if (this.decoder.endElement(qName)) {
                    data.set(this.namedType, this.element);
                    this.decoder = null;
                }
            }
        };
    }

    private <T extends ASN1Type> DataDecoder decoderForCollectionType(final CollectionType<T, ?> data) {
        return new ConstructedDataDecoder(){
            private T component;
            private boolean useXmlValueList;
            {
                this.useXmlValueList = false;
            }

            void startElement(String qName) {
                if (BOOLEAN.class.isAssignableFrom(data.componentType()) || ENUMERATED.class.isAssignableFrom(data.componentType()) || BigENUMERATED.class.isAssignableFrom(data.componentType()) || CHOICE.class.isAssignableFrom(data.componentType())) {
                    this.useXmlValueList = true;
                }
            }

            void startChildElement(String qName) throws SAXException {
                if (this.decoder == null) {
                    this.component = ASN1Type.instantiate(data.componentType());
                    this.decoder = this.useXmlValueList ? new ValueListElementDecoder(((ASN1Type)this.component).accept(XerDecoder.this)) : new NamedElementDecoder(qName, ((ASN1Type)this.component).accept(XerDecoder.this));
                }
                this.decoder.startElement(qName);
            }

            void endChildElement(String qName) {
                if (this.decoder.endElement(qName)) {
                    ((Collection)data.collection()).add(this.component);
                    this.decoder = null;
                }
            }
        };
    }

    private abstract class ConstructedDataDecoder
    extends DataDecoder {
        ElementDecoder decoder;

        private ConstructedDataDecoder() {
        }

        void characters(String characters) {
            if (this.decoder != null) {
                this.decoder.characters(characters);
            }
        }
    }

    abstract class DataDecoder {
        DataDecoder() {
        }

        void startElement(String qName) throws SAXException {
        }

        void startChildElement(String qName) throws SAXException {
        }

        void characters(String characters) {
        }

        void endChildElement(String qName) {
        }

        void endElement() {
        }
    }

    private abstract class ElementDecoder {
        DataDecoder decoder;

        ElementDecoder(DataDecoder decoder) {
            this.decoder = decoder;
        }

        abstract void startElement(String var1) throws SAXException;

        void characters(String characters) {
            this.decoder.characters(characters);
        }

        abstract boolean endElement(String var1);
    }

    private class NamedElementDecoder
    extends ElementDecoder {
        private String tagName;

        NamedElementDecoder(String tagName, DataDecoder decoder) {
            super(decoder);
            this.tagName = tagName;
        }

        public void startElement(String qName) throws SAXException {
            if (qName.equals(this.tagName)) {
                this.decoder.startElement(qName);
            } else {
                this.decoder.startChildElement(qName);
            }
        }

        public boolean endElement(String qName) {
            if (qName.equals(this.tagName)) {
                this.decoder.endElement();
                return true;
            }
            this.decoder.endChildElement(qName);
            return false;
        }
    }

    private class ValueListElementDecoder
    extends ElementDecoder {
        ValueListElementDecoder(DataDecoder decoder) {
            super(decoder);
        }

        public void startElement(String qName) throws SAXException {
            this.decoder.startElement(qName);
            this.decoder.startChildElement(qName);
        }

        public boolean endElement(String qName) {
            this.decoder.endChildElement(qName);
            this.decoder.endElement();
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class XerHandler<T extends ASN1Type>
    extends DefaultHandler {
        T data;
        private ElementDecoder decoder;

        private XerHandler() {
        }

        abstract void initializeData(String var1) throws SAXException;

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.data == null) {
                this.initializeData(qName);
                this.decoder = new NamedElementDecoder(qName, ((ASN1Type)this.data).accept(XerDecoder.this));
            }
            this.decoder.startElement(qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            char[] tmp = new char[length];
            System.arraycopy(ch, start, tmp, 0, length);
            this.decoder.characters(String.valueOf(tmp));
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.decoder.endElement(qName);
        }
    }
}

