/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.codec.ber;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jp.bitmeister.asn1.codec.ASN1Decoder;
import jp.bitmeister.asn1.exception.ASN1DecodingException;
import jp.bitmeister.asn1.processor.ASN1Visitor;
import jp.bitmeister.asn1.type.ASN1Module;
import jp.bitmeister.asn1.type.ASN1ModuleManager;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagMode;
import jp.bitmeister.asn1.type.ASN1TagValue;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.CollectionType;
import jp.bitmeister.asn1.type.Concatenatable;
import jp.bitmeister.asn1.type.ElementSpecification;
import jp.bitmeister.asn1.type.NamedTypeSpecification;
import jp.bitmeister.asn1.type.StringType;
import jp.bitmeister.asn1.type.StructuredType;
import jp.bitmeister.asn1.type.TimeType;
import jp.bitmeister.asn1.type.TypeSpecification;
import jp.bitmeister.asn1.type.UnknownType;
import jp.bitmeister.asn1.type.builtin.ANY;
import jp.bitmeister.asn1.type.builtin.BIT_STRING;
import jp.bitmeister.asn1.type.builtin.BOOLEAN;
import jp.bitmeister.asn1.type.builtin.BigENUMERATED;
import jp.bitmeister.asn1.type.builtin.BigINTEGER;
import jp.bitmeister.asn1.type.builtin.CHOICE;
import jp.bitmeister.asn1.type.builtin.ENUMERATED;
import jp.bitmeister.asn1.type.builtin.INTEGER;
import jp.bitmeister.asn1.type.builtin.NULL;
import jp.bitmeister.asn1.type.builtin.OBJECT_IDENTIFIER;
import jp.bitmeister.asn1.type.builtin.OCTET_STRING;
import jp.bitmeister.asn1.type.builtin.REAL;
import jp.bitmeister.asn1.type.builtin.RELATIVE_OID;
import jp.bitmeister.asn1.type.builtin.SEQUENCE;
import jp.bitmeister.asn1.type.builtin.SEQUENCE_OF;
import jp.bitmeister.asn1.type.builtin.SET;
import jp.bitmeister.asn1.type.builtin.SET_OF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BerDecoder
implements ASN1Decoder,
ASN1Visitor<Void, ASN1DecodingException> {
    private Class<? extends ASN1Module> module;
    private InputStream in;
    private int tagNumber;
    private ASN1TagClass tagClass;
    private boolean isConstructed;
    private int count;

    public BerDecoder(InputStream in) {
        this.in = in;
    }

    public BerDecoder(Class<? extends ASN1Module> module, InputStream in) {
        this(in);
        this.module = module;
    }

    @Override
    public ASN1Type decode() throws ASN1DecodingException {
        return this.decodeImpl(null);
    }

    @Override
    public <T extends ASN1Type> T decode(Class<T> type) throws ASN1DecodingException {
        T data = ASN1Type.instantiate(type);
        if (this.module == null) {
            this.module = ((ASN1Type)data).specification().module();
        }
        return this.decodeImpl(data);
    }

    public int count() {
        return this.count;
    }

    private <T extends ASN1Type> T decodeImpl(T data) throws ASN1DecodingException {
        this.readTag();
        if (data == null) {
            data = ASN1ModuleManager.instantiate(this.module, this.tagClass, this.tagNumber);
        }
        TypeSpecification specification = ((ASN1Type)data).specification();
        do {
            if (specification.tag() == null) continue;
            ASN1TagValue tag = specification.tag();
            if (tag.tagClass() != this.tagClass || tag.tagNumber() != this.tagNumber) {
                ASN1DecodingException ex = new ASN1DecodingException();
                ex.setMessage("Decoded tag '" + (Object)((Object)this.tagClass) + " " + this.tagNumber + "' does not match given type.", null, data.getClass(), null, null);
                throw ex;
            }
            if (tag.tagMode() == ASN1TagMode.IMPLICIT) break;
            this.readLength();
            this.readTag();
        } while ((specification = specification.reference()) != null);
        try {
            ((ASN1Type)data).accept(this);
        }
        catch (ASN1DecodingException ex) {
            throw ex;
        }
        catch (Exception e) {
            ASN1DecodingException ex = new ASN1DecodingException();
            ex.setMessage("Exception thrown while decoding process.", e, data.getClass(), null, (ASN1Type)data);
            throw ex;
        }
        ((ASN1Type)data).validate();
        return (T)data;
    }

    @Override
    public Void visit(BOOLEAN data) throws ASN1DecodingException {
        data.set(this.readStream(this.readLength())[0] != 0);
        return null;
    }

    @Override
    public Void visit(INTEGER data) throws ASN1DecodingException {
        data.set(new BigInteger(this.readStream(this.readLength())).longValue());
        return null;
    }

    @Override
    public Void visit(BigINTEGER data) throws ASN1DecodingException {
        data.set(new BigInteger(this.readStream(this.readLength())));
        return null;
    }

    @Override
    public Void visit(ENUMERATED data) throws ASN1DecodingException {
        this.visit((INTEGER)data);
        return null;
    }

    @Override
    public Void visit(BigENUMERATED data) throws ASN1DecodingException {
        this.visit((BigINTEGER)data);
        return null;
    }

    @Override
    public Void visit(REAL data) throws ASN1DecodingException {
        byte[] octets = this.readStream(this.readLength());
        if (octets.length == 0) {
            data.set(0.0);
        } else if ((octets[0] & 0x80) != 0) {
            int base;
            int sign = (octets[0] & 0x40) == 0 ? 1 : -1;
            switch (octets[0] & 0x30) {
                case 0: {
                    base = 2;
                    break;
                }
                case 16: {
                    base = 8;
                    break;
                }
                case 32: {
                    base = 16;
                    break;
                }
                default: {
                    ASN1DecodingException ex = new ASN1DecodingException();
                    ex.setMessage("'0x" + Integer.toHexString(octets[0] & 0xFF) + "' Invalid base B' value.", null, data.getClass(), null, null);
                    throw ex;
                }
            }
            int scaling = (octets[0] & 0xC) >> 2;
            short exponent = octets[1];
            int index = 2;
            if ((octets[0] & 3) == 1) {
                exponent = (short)(exponent << 8);
                exponent = (short)(exponent | octets[2] & 0xFF);
                ++index;
            }
            byte[] tmp = new byte[octets.length - index];
            System.arraycopy(octets, index, tmp, 0, octets.length - index);
            long mantissa = new BigInteger(tmp).longValue();
            data.set((double)mantissa * Math.pow(2.0, scaling) * Math.pow(base, exponent) * (double)sign);
        } else if ((octets[0] & 0x40) == 0) {
            data.set(Double.valueOf(new String(octets, 1, octets.length - 1)));
        } else {
            switch (octets[0]) {
                case 64: {
                    data.set(Double.POSITIVE_INFINITY);
                    break;
                }
                case 65: {
                    data.set(Double.NEGATIVE_INFINITY);
                    break;
                }
                case 66: {
                    data.set(Double.NaN);
                    break;
                }
                case 67: {
                    data.set(-0.0);
                    break;
                }
                default: {
                    ASN1DecodingException ex = new ASN1DecodingException();
                    ex.setMessage("'0x" + Integer.toHexString(octets[0] & 0xFF) + "' Invalid special value.", null, data.getClass(), null, null);
                    throw ex;
                }
            }
        }
        return null;
    }

    @Override
    public Void visit(BIT_STRING data) throws ASN1DecodingException {
        if (this.isConstructed) {
            this.processConcatenatable(data);
            return null;
        }
        byte[] octets = this.readStream(this.readLength());
        if (octets.length == 1) {
            if (octets[0] == 0) {
                data.set(new boolean[0]);
                return null;
            }
            ASN1DecodingException ex = new ASN1DecodingException();
            ex.setMessage("'0x" + Integer.toHexString(octets[0] & 0xFF) + "'The initial octet of empty BitString shall be zero.", null, data.getClass(), null, null);
            throw ex;
        }
        boolean[] value = new boolean[(octets.length - 1) * 8 - octets[0]];
        int mask = 128;
        int index = 1;
        int i = 0;
        while (i < value.length) {
            boolean bl = value[i] = (octets[index] & mask) > 0;
            if ((mask >>>= 1) == 0) {
                mask = 128;
                ++index;
            }
            ++i;
        }
        data.set(value);
        return null;
    }

    @Override
    public Void visit(OCTET_STRING data) throws ASN1DecodingException {
        if (this.isConstructed) {
            this.processConcatenatable(data);
        } else {
            data.set(this.readStream(this.readLength()));
        }
        return null;
    }

    @Override
    public Void visit(NULL data) throws ASN1DecodingException {
        if (this.readLength() != 0) {
            ASN1DecodingException ex = new ASN1DecodingException();
            ex.setMessage("The contents octets shall not contain any octets.", null, data.getClass(), null, null);
            throw ex;
        }
        return null;
    }

    @Override
    public Void visit(final SEQUENCE data) throws ASN1DecodingException {
        final ElementSpecification[] elements = data.getElementTypeList();
        this.processMultipleOctets(this.readLength(), new ElementProcessor(){
            private int index = 0;

            public void process() throws ASN1DecodingException {
                BerDecoder.this.readTag();
                while (this.index < elements.length) {
                    if (elements[this.index].matches(BerDecoder.this.tagClass, BerDecoder.this.tagNumber)) {
                        BerDecoder.this.processComponent(data, elements[this.index]);
                        break;
                    }
                    ++this.index;
                }
                ++this.index;
            }
        });
        return null;
    }

    @Override
    public Void visit(SEQUENCE_OF<? extends ASN1Type> data) throws ASN1DecodingException {
        this.processCollection(data);
        return null;
    }

    @Override
    public Void visit(final SET data) throws ASN1DecodingException {
        this.processMultipleOctets(this.readLength(), new ElementProcessor(){

            public void process() throws ASN1DecodingException {
                BerDecoder.this.readTag();
                ElementSpecification[] elementSpecificationArray = data.getElementTypeList();
                int n = elementSpecificationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ElementSpecification e = elementSpecificationArray[n2];
                    if (e.matches(BerDecoder.this.tagClass, BerDecoder.this.tagNumber)) {
                        BerDecoder.this.processComponent(data, e);
                        break;
                    }
                    ++n2;
                }
            }
        });
        return null;
    }

    @Override
    public Void visit(SET_OF<? extends ASN1Type> data) throws ASN1DecodingException {
        this.processCollection(data);
        return null;
    }

    @Override
    public Void visit(CHOICE data) throws ASN1DecodingException {
        this.processComponent(data, data.alternative(this.tagClass, this.tagNumber));
        return null;
    }

    @Override
    public Void visit(OBJECT_IDENTIFIER data) throws ASN1DecodingException {
        int length = this.readLength();
        ArrayList<Integer> oids = new ArrayList<Integer>();
        byte[] octets = this.readStream(1);
        oids.add(octets[0] / 40);
        oids.add(octets[0] % 40);
        this.decodeOids(oids, length - 1);
        data.set(oids);
        return null;
    }

    @Override
    public Void visit(RELATIVE_OID data) throws ASN1DecodingException {
        ArrayList<Integer> oids = new ArrayList<Integer>();
        this.decodeOids(oids, this.readLength());
        data.set(oids);
        return null;
    }

    private void decodeOids(final List<Integer> oids, int length) throws ASN1DecodingException {
        this.processMultipleOctets(length, new ElementProcessor(){

            public void process() throws ASN1DecodingException {
                oids.add(BerDecoder.this.readMultipleOctets());
            }
        });
    }

    @Override
    public Void visit(StringType data) throws ASN1DecodingException {
        this.visit((OCTET_STRING)data);
        return null;
    }

    @Override
    public Void visit(TimeType data) throws ASN1DecodingException {
        data.set(new String(this.readStream(this.readLength())));
        return null;
    }

    @Override
    public Void visit(ANY data) throws ASN1DecodingException {
        if (data.value() == null) {
            data.set(ASN1ModuleManager.instantiate(this.module, this.tagClass, this.tagNumber));
        }
        ((ASN1Type)data.value()).accept(this);
        return null;
    }

    @Override
    public Void visit(UnknownType data) throws ASN1DecodingException {
        data.set(this.readStream(this.readLength()));
        return null;
    }

    private <T extends ASN1Type> void processCollection(final CollectionType<T, ?> data) throws ASN1DecodingException {
        if (data.size() > 0) {
            data.clear();
        }
        this.processMultipleOctets(this.readLength(), new ElementProcessor(){

            public void process() throws ASN1DecodingException {
                ((Collection)data.collection()).add(BerDecoder.this.decodeImpl(ASN1Type.instantiate(data.componentType())));
            }
        });
    }

    private <T extends ASN1Type> void processConcatenatable(final T data) throws ASN1DecodingException {
        this.processMultipleOctets(this.readLength(), new ElementProcessor(){

            public void process() throws ASN1DecodingException {
                Object component = ASN1Type.instantiate(data.getClass());
                ((Concatenatable)((Object)data)).concatenate(BerDecoder.this.decodeImpl(component));
            }
        });
    }

    private void processComponent(StructuredType enclosure, NamedTypeSpecification namedType) throws ASN1DecodingException {
        ASN1Type component = namedType.instantiate();
        if (namedType.tag() != null && namedType.tag().tagMode() != ASN1TagMode.IMPLICIT) {
            this.readLength();
            this.decodeImpl(component);
        } else {
            component.accept(this);
        }
        enclosure.set(namedType, component);
    }

    private void processMultipleOctets(int length, ElementProcessor processor) throws ASN1DecodingException {
        int counter = this.count;
        while (this.count - counter < length) {
            processor.process();
        }
    }

    private void readTag() throws ASN1DecodingException {
        byte[] octets = this.readStream(1);
        switch (octets[0] & 0xC0) {
            case 0: {
                this.tagClass = ASN1TagClass.UNIVERSAL;
                break;
            }
            case 64: {
                this.tagClass = ASN1TagClass.APPLICATION;
                break;
            }
            case 128: {
                this.tagClass = ASN1TagClass.CONTEXT_SPECIFIC;
                break;
            }
            case 192: {
                this.tagClass = ASN1TagClass.PRIVATE;
            }
        }
        this.isConstructed = (octets[0] & 0x20) > 0;
        this.tagNumber = (octets[0] & 0x1F) == 31 ? this.readMultipleOctets() : octets[0] & 0x1F;
    }

    private int readLength() throws ASN1DecodingException {
        byte[] octets = this.readStream(1);
        if ((octets[0] & 0xFFFFFF80) == 0) {
            return octets[0];
        }
        octets = this.readStream(octets[0] & 0x7F);
        int length = 0;
        byte[] byArray = octets;
        int n = octets.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            length <<= 8;
            length |= b & 0xFF;
            ++n2;
        }
        return length;
    }

    private int readMultipleOctets() throws ASN1DecodingException {
        int result = 0;
        while (true) {
            byte[] octets = this.readStream(1);
            result |= octets[0] & 0x7F;
            if ((octets[0] & 0x80) == 0) {
                return result;
            }
            result <<= 7;
        }
    }

    private byte[] readStream(int length) throws ASN1DecodingException {
        if (length == 0) {
            return new byte[0];
        }
        byte[] octets = new byte[length];
        try {
            if (this.in.read(octets) != octets.length) {
                ASN1DecodingException ex = new ASN1DecodingException();
                ex.setMessage("length = '" + length + "' Incorrect length octets.", null, null, null, null);
                throw ex;
            }
        }
        catch (IOException e) {
            ASN1DecodingException ex = new ASN1DecodingException();
            ex.setMessage("IOException thrown while decoding process.", e, null, null, null);
            throw ex;
        }
        this.count += octets.length;
        return octets;
    }

    private static interface ElementProcessor {
        public void process() throws ASN1DecodingException;
    }
}

