/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.bitmeister.asn1.annotation.ASN1Alternative;
import jp.bitmeister.asn1.annotation.ASN1Extendable;
import jp.bitmeister.asn1.exception.ASN1IllegalArgument;
import jp.bitmeister.asn1.exception.ASN1IllegalDefinition;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagDefault;
import jp.bitmeister.asn1.type.ASN1TagValue;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.NamedTypeSpecification;
import jp.bitmeister.asn1.type.StructuredType;
import jp.bitmeister.asn1.type.TypeSpecification;
import jp.bitmeister.asn1.type.UnorderedElementsChecker;
import jp.bitmeister.asn1.type.builtin.CHOICE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SelectiveType
extends StructuredType {
    private static final Map<Class<? extends StructuredType>, NamedTypeSpecification[]> ALTERNATIVES_MAP = new HashMap<Class<? extends StructuredType>, NamedTypeSpecification[]>();
    private NamedTypeSpecification selection;

    private static NamedTypeSpecification[] getAlternativeTypeList(Class<? extends SelectiveType> type) {
        NamedTypeSpecification[] array;
        if (ALTERNATIVES_MAP.containsKey(type)) {
            return ALTERNATIVES_MAP.get(type);
        }
        ArrayList<NamedTypeSpecification> alternatives = new ArrayList<NamedTypeSpecification>();
        Field[] fieldArray = type.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (f.isAnnotationPresent(ASN1Alternative.class)) {
                alternatives.add(new NamedTypeSpecification(f.getAnnotation(ASN1Alternative.class).value(), f));
            }
            ++n2;
        }
        Class<? extends SelectiveType> parent = type.getSuperclass();
        if (parent == CHOICE.class || parent.isAnnotationPresent(ASN1Extendable.class)) {
            if (alternatives.isEmpty()) {
                ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
                ex.setMessage("CHOICE type shall have at least one alternative.", null, type, null, null);
                throw ex;
            }
            array = alternatives.toArray(new NamedTypeSpecification[0]);
            if (TypeSpecification.getSpecification(type).tagDefault() == ASN1TagDefault.AUTOMATIC_TAGS) {
                SelectiveType.generateAutomaticTags(array);
            }
            new UnorderedElementsChecker(type).check(array);
        } else {
            if (!alternatives.isEmpty()) {
                ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
                ex.setMessage("If a class does not extend CHOICE or a type annotated as ASN1Extendable directly,it can not define own alternatives.", null, type, null, null);
                throw ex;
            }
            array = SelectiveType.getAlternativeTypeList(parent);
        }
        ALTERNATIVES_MAP.put(type, array);
        return array;
    }

    public SelectiveType() {
    }

    public SelectiveType(ASN1Type data) {
        NamedTypeSpecification[] namedTypeSpecificationArray = SelectiveType.getAlternativeTypeList(this.getClass());
        int n = namedTypeSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            NamedTypeSpecification e = namedTypeSpecificationArray[n2];
            if (e.type() == data.getClass()) {
                this.set(e, data);
                return;
            }
            ++n2;
        }
        ASN1IllegalArgument ex = new ASN1IllegalArgument();
        ex.setMessage("Can't select alternative by the type of the data.", null, this.getClass(), null, data);
        throw ex;
    }

    public SelectiveType(ASN1TagClass tagClass, int tagNumber, ASN1Type data) {
        this.set(this.alternative(tagClass, tagNumber), data);
    }

    public SelectiveType(String elementName, ASN1Type data) {
        this.set(elementName, data);
    }

    public NamedTypeSpecification alternative(ASN1TagClass tagClass, int tagNumber) {
        NamedTypeSpecification[] namedTypeSpecificationArray = SelectiveType.getAlternativeTypeList(this.getClass());
        int n = namedTypeSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            NamedTypeSpecification e = namedTypeSpecificationArray[n2];
            if (e.matches(tagClass, tagNumber)) {
                return e;
            }
            ++n2;
        }
        ASN1IllegalArgument ex = new ASN1IllegalArgument();
        ex.setMessage("The tag '" + (Object)((Object)tagClass) + " " + tagNumber + "' does not match to any alternatives of this type.", null, this.getClass(), null, null);
        throw ex;
    }

    @Override
    public boolean matches(ASN1TagClass tagClass, int tagNumber) {
        NamedTypeSpecification[] namedTypeSpecificationArray = SelectiveType.getAlternativeTypeList(this.getClass());
        int n = namedTypeSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            NamedTypeSpecification e = namedTypeSpecificationArray[n2];
            if (e.matches(tagClass, tagNumber)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void set(NamedTypeSpecification alternative, ASN1Type data) {
        alternative.assign(this, data);
        this.selection = alternative;
    }

    @Override
    public void set(String elementName, ASN1Type component) {
        this.set(this.getElement(elementName), component);
    }

    @Override
    public ASN1Type get(String elementName) {
        return this.getElement(elementName).retrieve(this);
    }

    @Override
    public NamedTypeSpecification getElement(String elementName) {
        NamedTypeSpecification[] namedTypeSpecificationArray = SelectiveType.getAlternativeTypeList(this.getClass());
        int n = namedTypeSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            NamedTypeSpecification e = namedTypeSpecificationArray[n2];
            if (e.identifier().equals(elementName)) {
                return e;
            }
            ++n2;
        }
        ASN1IllegalArgument ex = new ASN1IllegalArgument();
        ex.setMessage("No such alternative '" + elementName + "' in this type.", null, this.getClass(), null, null);
        throw ex;
    }

    private NamedTypeSpecification selection() {
        if (this.selection == null) {
            NamedTypeSpecification[] namedTypeSpecificationArray = SelectiveType.getAlternativeTypeList(this.getClass());
            int n = namedTypeSpecificationArray.length;
            int n2 = 0;
            while (n2 < n) {
                NamedTypeSpecification e = namedTypeSpecificationArray[n2];
                if (e.retrieve(this) != null) {
                    this.selection = e;
                    break;
                }
                ++n2;
            }
        }
        return this.selection;
    }

    public ASN1Type selectedValue() {
        if (this.selection() != null) {
            return this.selection.retrieve(this);
        }
        return null;
    }

    public String selectedIdentifier() {
        if (this.selection() != null) {
            return this.selection.identifier();
        }
        return null;
    }

    public ASN1TagValue selectedTag() {
        if (this.selection() != null) {
            return this.selection.tag();
        }
        return null;
    }

    public void clearSelection() {
        if (this.selection() != null) {
            this.selection.assign(this, null);
            this.selection = null;
        }
    }

    @Override
    public void clear() {
        this.selection = null;
        NamedTypeSpecification[] namedTypeSpecificationArray = SelectiveType.getAlternativeTypeList(this.getClass());
        int n = namedTypeSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            NamedTypeSpecification e = namedTypeSpecificationArray[n2];
            e.assign(this, null);
            ++n2;
        }
    }

    @Override
    public boolean hasValue() {
        return this.selection() != null;
    }

    @Override
    public boolean valueEquals(Object other) {
        if (other instanceof SelectiveType) {
            ASN1Type thisSelection = this.selectedValue();
            ASN1Type otherSelection = ((SelectiveType)other).selectedValue();
            if (thisSelection != null) {
                return thisSelection.equals(otherSelection);
            }
            return otherSelection == null;
        }
        return false;
    }

    @Override
    public int hashCode() {
        ASN1Type data = this.selectedValue();
        if (data == null) {
            return 0;
        }
        return data.hashCode();
    }

    @Override
    public Object clone() {
        SelectiveType clone = (SelectiveType)ASN1Type.instantiate(this.getClass());
        ASN1Type value = this.selectedValue();
        if (value != null) {
            this.selection.assign(clone, (ASN1Type)value.clone());
            clone.selection = this.selection;
        }
        return clone;
    }
}

