/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.codec.xer;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import jp.bitmeister.asn1.codec.ASN1Encoder;
import jp.bitmeister.asn1.codec.xer.XerStringEscapeUtil;
import jp.bitmeister.asn1.exception.ASN1EncodingException;
import jp.bitmeister.asn1.processor.ASN1Visitor;
import jp.bitmeister.asn1.type.ASN1Module;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.CollectionType;
import jp.bitmeister.asn1.type.ConstructiveType;
import jp.bitmeister.asn1.type.ElementSpecification;
import jp.bitmeister.asn1.type.StringType;
import jp.bitmeister.asn1.type.TimeType;
import jp.bitmeister.asn1.type.UnknownType;
import jp.bitmeister.asn1.type.builtin.ANY;
import jp.bitmeister.asn1.type.builtin.BIT_STRING;
import jp.bitmeister.asn1.type.builtin.BOOLEAN;
import jp.bitmeister.asn1.type.builtin.CHOICE;
import jp.bitmeister.asn1.type.builtin.ENUMERATED;
import jp.bitmeister.asn1.type.builtin.INTEGER;
import jp.bitmeister.asn1.type.builtin.NULL;
import jp.bitmeister.asn1.type.builtin.OBJECT_IDENTIFIER;
import jp.bitmeister.asn1.type.builtin.OCTET_STRING;
import jp.bitmeister.asn1.type.builtin.REAL;
import jp.bitmeister.asn1.type.builtin.RELATIVE_OID;
import jp.bitmeister.asn1.type.builtin.SEQUENCE;
import jp.bitmeister.asn1.type.builtin.SEQUENCE_OF;
import jp.bitmeister.asn1.type.builtin.SET;
import jp.bitmeister.asn1.type.builtin.SET_OF;
import jp.bitmeister.asn1.value.BinString;
import jp.bitmeister.asn1.value.HexString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XerEncoder
implements ASN1Encoder,
ASN1Visitor<String, ASN1EncodingException> {
    private Class<? extends ASN1Module> module;
    private OutputStream out;
    private StringBuilder builder;
    private boolean prologIsEmpty = false;

    public XerEncoder(OutputStream out) {
        this.out = out;
    }

    public XerEncoder(Class<? extends ASN1Module> module, OutputStream out) {
        this(out);
        this.module = module;
    }

    public XerEncoder(OutputStream out, boolean prologIsEmpty) {
        this(out);
        this.prologIsEmpty = prologIsEmpty;
    }

    public XerEncoder(Class<? extends ASN1Module> module, OutputStream out, boolean prologIsEmpty) {
        this(module, out);
        this.prologIsEmpty = prologIsEmpty;
    }

    @Override
    public int encode(ASN1Type data) throws ASN1EncodingException {
        if (this.module == null) {
            this.module = data.specification().module();
        }
        this.builder = new StringBuilder();
        if (!this.prologIsEmpty) {
            this.builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        }
        this.encodeImpl(data, data.specification().xmlTypeName(this.module));
        try {
            byte[] result = this.builder.toString().getBytes("UTF-8");
            this.out.write(result);
            return result.length;
        }
        catch (Exception e) {
            ASN1EncodingException ex = new ASN1EncodingException();
            ex.setMessage("Failed to write result to stream.", e, null, null, data);
            throw ex;
        }
    }

    private void encodeImpl(ASN1Type data, String xmlTagName) throws ASN1EncodingException {
        String contents = data.accept(this);
        if (contents == null) {
            return;
        }
        if (contents.length() == 0) {
            this.builder.append("<").append(xmlTagName).append("/>");
        } else {
            this.builder.append("<").append(xmlTagName).append(">");
            this.builder.append(contents);
            this.builder.append("</").append(xmlTagName).append(">");
        }
    }

    @Override
    public String visit(BOOLEAN data) {
        return "<" + ((Boolean)data.value() != false ? "true" : "false") + "/>";
    }

    @Override
    public String visit(INTEGER data) {
        String numberId = data.identifier();
        if (numberId != null) {
            return "<" + numberId + "/>";
        }
        return ((BigInteger)data.value()).toString();
    }

    @Override
    public String visit(BIT_STRING data) {
        if (data.hasNamedBits()) {
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < data.size()) {
                String name;
                if (data.bit(i) && (name = data.nameOfBit(i)) != null) {
                    builder.append("<").append(name).append("/>");
                }
                ++i;
            }
            return builder.toString();
        }
        return new BinString((boolean[])data.value()).string();
    }

    @Override
    public String visit(OCTET_STRING data) {
        return new HexString((byte[])data.value()).string();
    }

    @Override
    public String visit(NULL data) {
        return "";
    }

    @Override
    public String visit(OBJECT_IDENTIFIER data) {
        StringBuilder builder = new StringBuilder();
        if (((List)data.value()).size() > 0) {
            builder.append(((List)data.value()).get(0));
            int i = 1;
            while (i < ((List)data.value()).size()) {
                builder.append('.').append(((List)data.value()).get(i));
                ++i;
            }
        }
        return builder.toString();
    }

    @Override
    public String visit(RELATIVE_OID data) {
        return this.visit((OBJECT_IDENTIFIER)data);
    }

    @Override
    public String visit(REAL data) {
        if (((Double)data.value()).isInfinite()) {
            return "<" + ((Double)data.value() == Double.POSITIVE_INFINITY ? "PLUS-INFINITY" : "MINUS-INFINITY") + "/>";
        }
        if ((Double)data.value() == 0.0) {
            return "0";
        }
        return BigDecimal.valueOf((Double)data.value()).stripTrailingZeros().toPlainString();
    }

    @Override
    public String visit(ENUMERATED data) {
        return this.visit((INTEGER)data);
    }

    @Override
    public String visit(ANY data) throws ASN1EncodingException {
        this.encodeImpl((ASN1Type)data.value(), ((ASN1Type)data.value()).specification().xmlTypeName(this.module));
        return null;
    }

    @Override
    public String visit(CHOICE data) throws ASN1EncodingException {
        StringBuilder enclosure = this.builder;
        this.builder = new StringBuilder();
        this.encodeImpl(data.selectedValue(), data.selectedIdentifier());
        String result = this.builder.toString();
        this.builder = enclosure;
        return result;
    }

    @Override
    public String visit(SEQUENCE_OF<? extends ASN1Type> data) throws ASN1EncodingException {
        return this.processCollection(data);
    }

    @Override
    public String visit(SEQUENCE data) throws ASN1EncodingException {
        return this.processConstructive(data);
    }

    @Override
    public String visit(SET_OF<? extends ASN1Type> data) throws ASN1EncodingException {
        return this.processCollection(data);
    }

    @Override
    public String visit(SET data) throws ASN1EncodingException {
        return this.processConstructive(data);
    }

    @Override
    public String visit(StringType data) throws ASN1EncodingException {
        try {
            return new String(XerStringEscapeUtil.escape(data.stringValue()).getBytes("Shift_JIS"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ASN1EncodingException();
        }
    }

    @Override
    public String visit(TimeType data) throws ASN1EncodingException {
        return data.stringValue();
    }

    @Override
    public String visit(UnknownType data) throws ASN1EncodingException {
        ASN1EncodingException ex = new ASN1EncodingException();
        ex.setMessage("Can't encode unknown type.", null, data.getClass(), null, data);
        throw ex;
    }

    private String processConstructive(ConstructiveType data) throws ASN1EncodingException {
        StringBuilder enclosure = this.builder;
        this.builder = new StringBuilder();
        ElementSpecification[] elementSpecificationArray = data.getElementTypeList();
        int n = elementSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ElementSpecification e = elementSpecificationArray[n2];
            ASN1Type component = data.getComponent(e);
            if (component != null) {
                this.encodeImpl(component, e.identifier());
            }
            ++n2;
        }
        String result = this.builder.toString();
        this.builder = enclosure;
        return result;
    }

    private String processCollection(CollectionType<? extends ASN1Type, ?> data) throws ASN1EncodingException {
        StringBuilder enclosure = this.builder;
        this.builder = new StringBuilder();
        if (BOOLEAN.class.isAssignableFrom(data.componentType()) || ENUMERATED.class.isAssignableFrom(data.componentType()) || CHOICE.class.isAssignableFrom(data.componentType())) {
            for (ASN1Type e : data.collection()) {
                this.builder.append(e.accept(this));
            }
        } else {
            for (ASN1Type e : data.collection()) {
                this.encodeImpl(e, e.specification().xmlTypeName(this.module));
            }
        }
        String result = this.builder.toString();
        this.builder = enclosure;
        return result;
    }
}

