/*
	DCC送信器
*/
package compiledplugin;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.border.*;
import javax.swing.event.*;
import java.util.*;
import java.io.*;
import java.net.*;
import java.nio.channels.*;
import java.nio.ByteBuffer;
import java.io.IOException;
import bluntirc.*;
import dialog.*;
import irc.*;
import base.*;
import gui.*;
import java.text.ParseException;

// 送信する項目
class DCCSendItem implements base.SelectorItem{
	// 補助的なもの
	public static void unloadStatic(){ nf=null; }
	static final String[] scale=new String[]{ "B","KB","MB","GB","TB"};
	static java.text.NumberFormat nf ;
	static String cropSize(double size){
		if(size<0) return "不明";
		if(nf==null){
			nf=java.text.NumberFormat.getInstance();
			nf.setMaximumFractionDigits(2);
		}
		for(int i=0;i<scale.length;++i){
			if(size<1000 || i==scale.length-1) return nf.format(size)+scale[i];
			size/=1000;
		}
		return "?";
	}
	static int parseInt(String text,String desc)
	throws ParseException
	{
		if(text==null) throw new ParseException(desc+"の指定がありません",0);
		try{ return Integer.parseInt(text); }
		catch(Exception e){ throw new ParseException(desc+"の値"+text+"+を整数に変換できません",0);}
	}
	static String createSendName(String src){
		StringBuffer sb = new StringBuffer();
		for(int i=0;i<src.length();++i){
			char c= src.charAt(i);
			if(c<=' ') c='_';
			sb.append(c);
		}
		return sb.toString();
	}
	// アドレスを数値に変換する
	static String toNumber(String src){
		if( -1==src.indexOf('.') ) return src;
		int[] i4=new int[4];
		int i=0;
		int start;
		for(int j=0;j<4;++j){
			i=src.indexOf('.',start=i);
			if(i==-1)i=src.length();
			i4[j]=Integer.parseInt(src.substring(start,i));
			++i;
		}
		return Long.toString( (((long)i4[0])<<24)+(((long)i4[1])<<16)+(((long)i4[2])<<8)+(((long)i4[3])) );
	}
	// 空いているポートを選んでListenしてサーバソケットを返す
	static ServerSocketChannel getServerSocket() throws Exception {
		InetAddress addr=null;
		String host = App.root_property.getString("DCCSender/IPAddressListen");
		if( host !=null && host.length()>0 ){
			try{
				addr = InetAddress.getByName(host);
			}catch(UnknownHostException e){
				throw new Exception("設定のListenアドレスに書かれた["+host+"]をInetAddressに変換できません");
			}
		}else{
			addr = InetAddress.getLocalHost();
		}
		int port_first = App.root_property.getInt("DCCSender/PortFirst",1096);
		int port_last  = App.root_property.getInt("DCCSender/PortLast",1154);
		ServerSocketChannel server =ServerSocketChannel.open();
		for(int port=port_first;port<=port_last;++port){
			InetSocketAddress isa=null;
			try{
				if(addr!=null)isa=new InetSocketAddress(addr,port);
				else          isa=new InetSocketAddress(port);
			}catch(IllegalArgumentException e){
				throw new Exception("ポート番号の設定が変です。");
			}
			try{
				server.socket().bind(isa);
				return server;
			}catch(Throwable e){
				App.logger.log(java.util.logging.Level.FINER,"DCCSend:getServerSocket",e);
			}
		}
		server.close();
		throw new Exception("ポートの空きがありません");
	}

	////////////////////////
	// 情報

	// 送り先
	IRCConnection conn;
	String to_nick;
		String text_to;

	// 送るファイル
	File sendfile;
		String text_srcfile; 
		String text_srcfile_dir; 
		String text_srcsize;

	// DCC SENDを送った時刻
	TimeZone tz;
	java.text.DateFormat date_format;
	java.text.DateFormat time_format;
	Date _sendtime; // DCC SENDを受けた時刻
	String text_sendtime ="";

	// アドレス
		String text_remote ="";
		String text_listen ="";
		String text_notify ="";

	// 状態と速度
	boolean now_progress =false;
		String text_state;
		String text_speed;

	DCCSendManager owner;

	void setState(boolean progress,String text,String detail){
		now_progress=progress;
		text_state=text;
		if(detail!=null) text_speed=detail;
		if(owner!=null) owner.updateDisplay(this);
	}

	// テーブルセルの表示
	public Object getCellValue(int col){
		switch(col){
		case 0: return text_sendtime;
		case 1: return text_listen;
		case 2: return text_to;
		case 3: return text_remote;
		case 4: return text_srcfile_dir;
		case 5: return text_srcfile;
		case 6: return text_srcsize;
		case 7: return text_state;
		case 8: return text_speed;
		case 9: return text_notify;
		}
		return "?";
	}

	///////////////////////////////////
	// 進行状況の更新

	int  sec_read=0;
	long pre_time;
	long total_offset=0;
	void clearStats(long start_pos){
		pre_time = System.currentTimeMillis();
		sec_read=0;
		total_offset=start_pos;
	}

	void updateSpeed(int plus){
		total_offset+=plus;
		sec_read+=plus;
		long now = System.currentTimeMillis();
		if(now-pre_time <1000) return;
		text_speed = cropSize( sec_read*(double)1000/(now-pre_time) )+"/s";
		text_state = cropSize( total_offset )+" 送信";
		pre_time=now;
		sec_read=0;
		if(owner!=null) owner.updateDisplay(this);
	}

	///////////////////////////////////////////
	// 送信

	ServerSocketChannel server;
	SocketChannel channel;
	SelectionKey key;
	FileChannel fi;
	ByteBuffer read_buffer;
	ByteBuffer write_buffer;

	boolean file_end;
	long last_ack =-1;
	long resume_start_pos=0;

	// 送信の開始
	boolean canStart(){ return !now_progress; }
	void start(){
		last_ack =-1;
		file_end =false;
		try{
			// サーバソケットの作成
			try{
				server = getServerSocket();
				server.socket().setReuseAddress(true);
			}catch(Throwable e){
			//	App.logger.log(java.util.logging.Level.WARNING,"",e);
				setState(false,"エラー",e.toString());
				return;
			}
			InetSocketAddress s_addr = (InetSocketAddress)server.socket().getLocalSocketAddress();
			text_listen = s_addr.toString();

			// 送信するファイル
			fi = new FileInputStream(sendfile).getChannel();
			text_srcsize = cropSize( fi.size() );

			// バッファの確保
			read_buffer  =ByteBuffer.allocate(4096);
			write_buffer =ByteBuffer.allocate(16384);
			// 出力用バッファの初期状態を !hasRemaining() にする
			write_buffer.flip();

			// 非同期にしてセレクタに登録
			server.configureBlocking(false);
			App.selector.register(this,server);

			// DCC SEND を送信する
			{
				InetAddress show_addr = s_addr.getAddress();
				String host=null;
				switch(App.root_property.getInt("DCCSender/IPAddressShowType",0)){
				case 0: break;
				case 1: host = conn.host001; break;
				case 2: host = Util.fromJIS(conn.myself.getHostBytes()); break;
				case 3: host = App.root_property.getString("DCCSender/IPAddressShow"); break;
				}
				if( host !=null && host.length()>0 ){
					try{
						show_addr =InetAddress.getByName(host);
					}catch(Throwable e){
					}
				}
				Vector v=new Vector(6);
				v.add("DCC");
				v.add("SEND");
				v.add( Util.toJIS(text_srcfile) );
				v.add(toNumber( show_addr.getHostAddress() ));
				v.add(""+s_addr.getPort() );
				v.add(""+fi.size() );
				conn.SendToServer(conn.encodeCTCP(Util.toJIS(to_nick),v,"PRIVMSG"));
				text_notify = show_addr.toString();
			}

			// DCC SENDを送った時刻
			date_format = java.text.DateFormat.getDateInstance(java.text.DateFormat.LONG );
			time_format = java.text.DateFormat.getTimeInstance(java.text.DateFormat.LONG );
			date_format.setCalendar(new GregorianCalendar(tz));
			time_format.setCalendar(new GregorianCalendar(tz));
			_sendtime = new Date();
			text_sendtime = date_format.format(_sendtime)
				+"_"+time_format.format(_sendtime)
				;
			setState(true,"交渉中","相手の受信開始を待ちます");
		}catch(IOException e){
			closeByError(e,"送信の準備");
		}
	}

	// resumeを受けた
	public boolean resumeRequest(IRCMessage m,int port,long pos,byte[] name){
		InetSocketAddress s_addr = (InetSocketAddress)server.socket().getLocalSocketAddress();
		// この項目へのリクエストではない
		if( m.conn !=conn ||  port != s_addr.getPort() ) return false;

		/*
			リジューム時の名前はmIRCが腐ってるので確認しない
			see http://www.mirc.co.uk/help/dccresum.txt
		*/

		try{
			App.Log(text_srcfile+"の送信に位置"+cropSize(pos)+"/"+cropSize(fi.size())+"からの再開要求がきました");
			if(server==null){
				App.Log("しかし交渉中ではないので無視します。");
				return true;
			}
			// ファイル位置を設定する
			if( pos > fi.size() ) pos = fi.size();
			fi.position(pos);
			last_ack = resume_start_pos =pos;

			// ニックネーム変更に備える
			this.to_nick=m.from.getName();
			text_to = to_nick+"@"+conn.getListener().getConnectionName(conn);

			// DCC ACCEPTを送信する
			{
				Vector v=new Vector(5);
				v.add("DCC");
				v.add("ACCEPT");
				v.add(Util.toJIS(text_srcfile));
				v.add(""+port );
				v.add(""+pos );
				conn.SendToServer(conn.encodeCTCP(Util.toJIS(to_nick),v,"PRIVMSG"));
			}
			setState(true,"交渉中",cropSize(pos)+"からの再開要求を受けました");
		}catch(IOException e){
			App.Log(text_srcfile+" "+e.getMessage());
			App.logger.log(java.util.logging.Level.WARNING,text_srcfile,e);
		}
		return true;
	}

	///////////////////////////////////////////////////////////////////////
	// implements SelectorItem
	public boolean onConnectable (SelectableChannel which){return true;}

	public boolean onAcceptable (SelectableChannel which){
		try{
			channel = server.accept();
			if(channel==null) return false;

			server.close(); server=null;
			channel.socket().setSoTimeout(1000*60*3);
			channel.socket().setTcpNoDelay(true);
			channel.socket().setReuseAddress(true);

			SocketAddress r_addr = channel.socket().getRemoteSocketAddress();
			text_remote = r_addr.toString();
			//  = src_host.getHostAddress()+" p#"+src_port;

			// 非同期にしてセレクタに登録
			channel.configureBlocking(false);
			key = App.selector.register(this,channel);
			key.interestOps(SelectionKey.OP_WRITE);
			setState(true,"送信中","接続されました");

			clearStats( fi.position() );
			if( fi.position() >= fi.size() ){
				file_end=true;
				return close(false,"完了","送信が終わりました");
			}
			return true;
		}catch(Throwable e){ return closeByError(e,"接続"); }
	}


	public boolean onReadable(SelectableChannel which){
		int r=0;
		do{
			try{
				r=channel.read(read_buffer);
				parse_read_buffer();
			}catch(IOException e){ return closeByError(e,"受信"); }
		}while(r>0);
		// 最後まで読んだ？
		if(r==-1 || last_ack >= sendfile.length() ){
			App.Log( "DCC送信完了: " + text_srcfile );
			return close(false,"完了","送信が終わりました");
		}
		return true;
	}

	public boolean onWritable(SelectableChannel which){
		// 書けるだけ書く
		do{
			if(write_buffer.hasRemaining() ){
				try{ updateSpeed(channel.write(write_buffer)); }catch(IOException e){ return closeByError(e,"送信"); }
				if( write_buffer.hasRemaining() ) break;
			}
			charge_write_buffer();
		}while(write_buffer.hasRemaining());

		// アクノリッジがあれば読んでおく
		onReadable(which);

		// まだ残りがあるならもっと書きたい
		if( !file_end || write_buffer.hasRemaining() ){
			return false;
		}
		// 書き込み停止
		key.interestOps(SelectionKey.OP_READ);
		return true;
	}

	// 送信の再開
	public void onTimer(SelectableChannel which){
	}

	void charge_write_buffer(){
		write_buffer.clear();
		if( file_end ) return;
		int r;
		try{ r=fi.read(write_buffer);}catch(IOException e){ closeByError(e,"read error"); return;}
		write_buffer.flip();
		if(r==-1){
			file_end=true;
			try{ fi.close(); }catch(IOException e){ fi=null; closeByError(e,"read error"); return;}
			fi=null; 
			setState(true,"受信報告待ち",null);
		}
	}

	public void parse_read_buffer(){
		read_buffer.flip();
		try{
			for(;;){
				int i = read_buffer.getInt();
				if(i<last_ack){
					// DCC受信側から送られてくるlast_ackが今までに受け取った値よりも小さい
					// resumeの実装だろうか？
					i+= resume_start_pos;
				}
				last_ack =i;
			}
		}catch(Throwable e){}

		if(!read_buffer.hasRemaining()){
			read_buffer.clear();
			return;
		}
		byte[] ba = new byte[read_buffer.remaining()];
		read_buffer.get(ba);
		read_buffer.clear();
		read_buffer.put(ba);
	}

	public void onSelectorExit(SelectableChannel which){}

	public boolean close(boolean state,String text,String detail){
		if(channel!=null) try{ channel.close(); }catch(IOException e){ }finally{channel=null;}
		if(server !=null) try{ server .close(); }catch(IOException e){ }finally{ server=null;}
		if(fi     !=null) try{ fi     .close(); }catch(IOException e){ fi=null; return closeByError(e,"read error"); }finally{ fi=null; }
		setState(state,text,detail);
		return true;
	}

	protected boolean closeByError(Throwable e,String desc){
		App.logger.log(java.util.logging.Level.WARNING,"DCCSend:closeByError:"+desc,e);
		String message = e.getLocalizedMessage();
		if(message==null || message.length()==0) message = e.getMessage();
		if(message==null || message.length()==0) message = e.toString();
		App.Log("DCC送信の"+desc+"でエラーがありました。 "+message);
		return close(false,"エラー",message);
	}
	//////////////////////////////////////////////////
	// マネージャからの他の操作

	// 中止
	public boolean canStop(){ return now_progress;}
	public void stop(){ close(false,"中止","ユーザによる中止"); }

	// 削除
	public boolean canRemove(){ return !now_progress; }

	// アンロード
	public void unload(){ close(false,"アンロード","終了前の後始末"); owner=null; }

	// フォルダを開く
	public void openFolder()
	{ App.os_dependence.openFolder(sendfile.getParentFile()); }

	// コンストラクタ
	public DCCSendItem
	(DCCSendManager owner,TimeZone tz,File sendfile,IRCConnection conn,String to_nick)
	{
		this.owner=owner;
		this.tz=tz;
		this.conn=conn;
		this.to_nick=to_nick;

		text_to = to_nick+"@"+conn.getListener().getConnectionName(conn);

		this.sendfile=sendfile;

		text_srcfile = createSendName(sendfile.getName());
		text_srcfile_dir  =sendfile.getParentFile().getAbsolutePath();
		text_srcsize = cropSize(sendfile.length());

		setState(false,"待機中","送信ボタンを押してください");
		// 自動開始するのもいいのかもな
	}
};

/////////////////////////////////////////////////////////////////
// 一覧を表示するフレーム
public class DCCSendManager 
extends JFrame
implements hook.IRCMessageRewrite2,TableModel,bluntirc.djava.ScriptUnloadable
{
	//	abstract public void updateDisplay(Object src);

	public void unload(){
		// 表示状態を覚える
		WindowPos.saveTableColPos(table,"DCCSender/TableColPos");
		WindowPos.saveWindowPos(this,"DCCSender/WindowPos");

		// アイテムを捨てる
		for(Iterator it=list.iterator();it.hasNext();)
		{ ((DCCSendItem)it.next()).unload(); }
		list.clear();
		this.fireTableChanged(new TableModelEvent(this));

		// 終了
		DCCSendItem.unloadStatic();
		setVisible(false);
		hide(); 
		dispose();
	}

	// インナークラスから呼ばれる
	public DCCSendManager getThis(){return this;}

	public DCCSendManager(ScriptManager manager){
		super("DCC送信器");
		setIconImage(App.icon_app.getImage());
		App.root_property.setDefaultObject("DCCSender",new HashMap());
		App.root_property.setDefaultString("DCCSender/Recent","");
		App.root_property.setDefaultString("DCCSender/IPAddressShow","");
		App.root_property.setDefaultString("DCCSender/IPAddressListen","");
		App.root_property.setDefaultString("DCCSender/PortFirst","1096");
		App.root_property.setDefaultString("DCCSender/PortLast","1154");
		addComponents();
		checkButtonEnabled();

		manager.addScriptAction("show",new AbstractAction(){
		public void actionPerformed(ActionEvent e){
			show();
		}});
		manager.addScriptAction("hide",new AbstractAction(){
		public void actionPerformed(ActionEvent e){
			hide();
		}});

		manager.addScriptAction("send",new AbstractAction(){
		public void actionPerformed(ActionEvent e){
			action.ConnectionAndTarget ct = new action.ConnectionAndTarget(e);
			if( ct.node!=null &&  ct.target!=null ){
				sendto(ct.getConnectionNode(),ct.target);
			}else{
				App.Log("送信先の情報を内部から読み取れなかった");
			}
		}});
	}

	// フック
	public IRCMessage rewriteIRCMessage2(IRCMessage m)
	{ if( m.cmd.equals("CTCP_DCC")) checkCTCP(m); return m; }

	// 送信アイテムを作成する
	JFileChooser fc;
	public void sendto(CTN_Conn node,Object[] targets){
		if(fc==null){
			fc=new JFileChooser();
/*
			fc.setFileView(new javax.swing.filechooser.FileView(){
				Icon icon_file = javax.swing.filechooser.FileSystemView.getFileSystemView().getSystemIcon(new File("Style.conf"));
				Icon icon_dir = javax.swing.filechooser.FileSystemView.getFileSystemView().getSystemIcon(new File(System.getProperty("user.dir")));
				public Icon getIcon(File f){
					return f.isDirectory()?icon_dir:icon_file;
				}
			});
*/
		}
		fc.updateUI();
		String recent = App.root_property.getString("DCCSender/Recent");
		if(recent==null || recent.length()==0)
			recent = (new java.io.File("nonexistent")).getAbsoluteFile().getParent();
		File rr = new File(recent);
		if(rr.isDirectory() ) fc.setCurrentDirectory(rr);
		if(rr.isFile()      ) fc.setSelectedFile(rr);

		int r= fc.showOpenDialog(this);
		if(fc.APPROVE_OPTION != r ){
			App.root_property.setString("DCCSender/Recent",fc.getCurrentDirectory().getAbsolutePath());
			return;
		}
		App.root_property.setString("DCCSender/Recent",fc.getSelectedFile().getAbsolutePath());
		show();

		for(int i=0;i<targets.length;++i){
			Object o = targets[i];
			if( o instanceof IRCChannelMember){ o=((IRCChannelMember)o).getUser();}
			if( o instanceof CTN_Chan ){ o=((CTN_Chan)o).GetChannel();}
			if( o instanceof CTN_Priv ){ o=((CTN_Priv)o).GetChannel();}
			if( o instanceof IRCChannelNameOrPrefix){
				if(IRCChannelName.isChannelName(((IRCChannelNameOrPrefix)o).getRawBytes())) continue;
				table_add(new DCCSendItem(this, TimeZone.getDefault(), fc.getSelectedFile(), node.conn, ((IRCChannelNameOrPrefix)o).getShortName() ));
			}else{
				App.Log("unknown target type:"+o.getClass().getName() );
			}
		}

	}

	// リジューム対応
	void checkCTCP(IRCMessage ctcp){
		byte[] ba=ctcp.getParam(0);
		int start;
		int i=0;
		// 最初の引数
		while(i<ba.length && ba[i]==' ') ++i;
		start=i;while(i<ba.length && ba[i]!=' ') ++i;
		if(i>start){
			String cmd =Util.fromJIS(ba,start,i);
			if(cmd.equals("RESUME")){
				String[] desc=new String[]{"ファイル名","送信ポート","再開位置",};
				byte[][] value = new byte[desc.length][];
				ByteArrayOutputStream bao =new ByteArrayOutputStream();
				try{
					for(int j=0;j<desc.length;++j){
						while(i<ba.length&&ba[i]==' ')++i;
						start=i;while(i<ba.length&&ba[i]!=' ')++i;
						if(i>start){
							bao.reset();
							irc.CTCPQuote.decodeParam(bao,ba,start,i);
							value[j]= bao.toByteArray();
							continue;
						}
						throw new ParseException(desc[j]+"の指定がない",0);
					}
					int port = Integer.parseInt(Util.fromJIS(value[1]));
					long pos  = Long.parseLong(Util.fromJIS(value[2]));
					for(Iterator it=list.iterator();it.hasNext();){
						if( ((DCCSendItem)it.next()).resumeRequest(ctcp,port,pos,value[0]) ) break;
					}
				}catch(Throwable e){
					App.Log("DCC RESUMEを読めません："+e.getMessage());
					App.logger.log(java.util.logging.Level.WARNING,"DCC RESUMEを読めません",e);
				}
			}
		}
	}


	////////////////////////////////////////////////
	// GUI部品

	JTable table;
	DccSender_MyCellRendererH  header_renderer;
	DccSender_MyCellRendererD  cell_renderer;
	public void show(){
		boolean old_showing=isShowing();
		super.show();
		if(!old_showing){
			App.os_dependence.updateUI(UIManager.getColor("control"),this);
			header_renderer.updateUI();
			cell_renderer.updateUI();
		}
	}

	void addComponents(){
		getContentPane().setLayout(new BorderLayout());
		// テーブルを追加する
		{
			table = new JTable(this);
			JScrollPane scrollpane = new JScrollPane(table);
			getContentPane().add(scrollpane,BorderLayout.CENTER);

			table.setFont(new Font("Dialog",0,12));
			
			header_renderer = new DccSender_MyCellRendererH(table.getTableHeader().getDefaultRenderer());
			table.getTableHeader().setDefaultRenderer(header_renderer);

			cell_renderer = new DccSender_MyCellRendererD();
			 table.setDefaultRenderer(String.class,cell_renderer);

			table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
			table.setShowVerticalLines(false);

			table.getSelectionModel().setSelectionMode(ListSelectionModel.SINGLE_SELECTION );
			table.getSelectionModel().addListSelectionListener(new ListSelectionListener (){
				public void valueChanged(ListSelectionEvent e){
					checkButtonEnabled();
				}
			});
			updateColWidth();
		}
		// ボタンを追加する
		{
			buttons=Box.createHorizontalBox();
			Insets inset = new Insets(0,0,0,0);
			for(int i=0;i<button_actions.length;++i){
				if(button_actions[i]==null){
					buttons.add(Box.createHorizontalGlue());
					continue;
				}
				JButton b= new JButton(button_actions[i]);
				b.setFont(table.getFont());
				b.setMargin(inset);
				buttons.add(b);
			}
			
			getContentPane().add(buttons,BorderLayout.SOUTH);
		}
		setSize(300,300);
		WindowPos.setWindowsPosToCenter(this);
		WindowPos.loadWindowPos(this,"DCCSender/WindowPos");
		WindowPos.loadTableColPos(table,"DCCSender/TableColPos");
	}


	////////
	// manage TableModelListener 
	LinkedList listener = new LinkedList();
	public void addTableModelListener(TableModelListener l)
	{ if(-1==listener.indexOf(l)) listener.add(l); }
	public void removeTableModelListener(TableModelListener l)
	{ listener.remove(l); }
	public void fireTableChanged(TableModelEvent e){
		for(Iterator i=listener.iterator();i.hasNext();)
		{ ((TableModelListener)i.next()).tableChanged(e); }
	}
	////////
	// implements TableModel
	public int getColumnCount() { return header.length; }
	public String getColumnName(int column){ return header[column];}
	public Class getColumnClass(int column){ return String.class;}
	public int getRowCount() { return list.size();}
	public Object getValueAt(int row, int col)
	{ return ((DCCSendItem)list.get(row)).getCellValue(col);}
	public boolean isCellEditable(int rowIndex,int columnIndex){return false;}
	public void setValueAt(Object aValue,int rowIndex,int columnIndex){}
	////////

	static String[] header=new String[]{
		// ヘッダ 
		"提示時刻",
		"Listenアドレス",

		"相手",
		"相手アドレス",

		"フォルダ",
		"ファイル名",
		"サイズ",

		"状態",
		"速度",
		"通知アドレス",
	};
	public void updateColWidth(){
		int size= table.getColumnModel().getColumnCount();
		for(int c=0;c<size;++c){
			int mc =table.convertColumnIndexToModel(c);
			int w=8+table.getFontMetrics(table.getFont()).stringWidth(header[c]);
/*
			for(int y=0;y<list.size();++y){
				String s = (String) getValueAt(y,mc);
				if(s==null) continue;
				int wid = 8+table.getFontMetrics(table.getFont()).stringWidth(s);
				if(w<wid) w=wid;
			}
*/
			table.getColumnModel().getColumn(c).setMinWidth    (w);
			table.getColumnModel().getColumn(c).setPreferredWidth(w);
		}
	}

	//////////////////////////////////////////////////////////
	// 受信項目のリスト

	LinkedList list = new LinkedList();

	public int getSelectedIndex(){
		if(list!=null && table!=null){
			int i = table.getSelectionModel().getAnchorSelectionIndex();
			if(i>=0 && i<list.size()) return i;
		}
		return -1;
	}
	public DCCSendItem getSelectedItem(){
		int i= getSelectedIndex();
		return i==-1?null:(DCCSendItem)list.get(i);
	}

	public void table_add(DCCSendItem item){
		list.add(item);
		int i= list.size()-1;
		if(i>=0) this.fireTableChanged(new TableModelEvent(this, i, i, TableModelEvent.ALL_COLUMNS, TableModelEvent.INSERT));
		if(-1==getSelectedIndex()){
			table.getSelectionModel().setSelectionInterval(i,i);
		}
	}

	public void updateDisplay(Object src){
		int i = list.indexOf(src);
		if(i>=0) this.fireTableChanged(new TableModelEvent(this, i, i, TableModelEvent.ALL_COLUMNS, TableModelEvent.UPDATE));
		checkButtonEnabled();
		repaint();
	}
	Box buttons;
	void checkButtonEnabled(){
		 Component[] list = buttons.getComponents();
		 for(int i=0;i<list.length;++i){
			if(!(list[i] instanceof JButton)) continue;
			JButton b = (JButton)list[i];
			b.setEnabled(b.getAction().isEnabled());
		}
	}
	public void removeSelected(){
		int index = getSelectedIndex();
		getSelectedItem().unload();
		list.remove(index);
		getThis().fireTableChanged(new TableModelEvent(getThis(), index, index, TableModelEvent.ALL_COLUMNS, TableModelEvent.DELETE));
		//
		if(index >= list.size())index=list.size()-1;
		if(index>=0) table.getSelectionModel().setSelectionInterval(index,index);
	}

	//////////////////////////////////////////////////////////
	// ボタン類
	Action[] button_actions = new Action[]{
		new AbstractAction("送信"){
			public boolean isEnabled(){
				DCCSendItem item = getSelectedItem();
				return item==null?false:item.canStart();
			}
			public void actionPerformed(ActionEvent e){
				if(!isEnabled())return;
				getSelectedItem().start();
			}
		},
		new AbstractAction("中止"){
			public boolean isEnabled(){
				DCCSendItem item = getSelectedItem();
				return item==null?false:item.canStop();
			}
			public void actionPerformed(ActionEvent e){
				if(!isEnabled())return;
				getSelectedItem().stop();
			}
		},
		new AbstractAction("フォルダを開く"){
			public boolean isEnabled()
			{ return getSelectedIndex()!=-1; }
			public void actionPerformed(ActionEvent e)
			{ if(isEnabled()) getSelectedItem().openFolder(); }
		},
		new AbstractAction("削除"){
			public boolean isEnabled(){
				DCCSendItem item = getSelectedItem();
				return item==null?false:item.canRemove();
			}
			public void actionPerformed(ActionEvent e){
				if(!isEnabled())return;
				removeSelected();
			}
		},
		null,
		new AbstractAction("設定"){
			public void actionPerformed(ActionEvent e)
			{ new DCCSenderDialog(); }
		},
		new AbstractAction("送信器を閉じる"){
			public void actionPerformed(ActionEvent e)
			{ hide(); }
		},
	};
}

/////////////////////////////////////////////////////////////////
// 設定ダイアログ

class DCCSenderDialog extends DialogBase{
	public DCCSenderDialog(){
		super();
		App.root_property.setDefaultObject("DCCSender",new HashMap());
		setup(App.getApp(),item_list);
	}
	protected void CheckInputs_ok(){ setTitle( "DCC送信器の設定" ); }
	protected ConnTreeNode createNode(){ return null;}

	DialogEditItem[] item_list = new DialogEditItem[]{
		new DialogEditItem_TabSeparator("オプション"),
		new DialogEditItem_String(){
			public String getPropertyKey(){ return "DCCSender/PortFirst";}
			public String getCaption(){ return "ポート番号始端";}
			public String getDesc(){ return "使用するポート番号";}
		},
		new DialogEditItem_String(){
			public String getPropertyKey(){ return "DCCSender/PortLast";}
			public String getCaption(){ return "ポート番号終端";}
			public String getDesc(){ return "使用するポート番号";}
		},

		new DialogEditItem_String(){
			public String getPropertyKey(){ return "DCCSender/IPAddressListen";}
			public String getCaption(){ return "Listenするアドレス";}
			public String getDesc(){ return "省略するとInetAddress.getLocalHost()";}
		},
		new DialogEditItem_ComboBox(){
			String[] list = new String[]{
				"Listenするアドレス",
				"001リプライを読む",
				"whoisリプライを読む",
				"その他",
			};
			public String getPropertyKey(){ return "DCCSender/IPAddressShowType";}
			public String getCaption(){ return "通知するIPアドレス";}
			public String getDesc(){ return "相手に通知するIPアドレス";}
			public boolean isEditable(){return false;}

			public String[] getCaptionList(){ return list;}
			public int getFirstSelected(Object prop_value){
				if(prop_value instanceof String){
					try{
						return Integer.parseInt((String)prop_value);
					}catch(Throwable e){}
				}
				return 0;
			}
			public Object getListValue(int index){
				return ""+index;
			}
			public void checkValue(Component c) throws Exception {}
		},
		new DialogEditItem_String(){
			public String getPropertyKey(){ return "DCCSender/IPAddressShow";}
			public String getCaption(){ return "(その他の場合)";}
			public String getDesc(){ return "↑でその他を選んだ場合は指定してください";}
		},
	};
};

class DccSender_MyCellRendererD implements TableCellRenderer{
	Font f= new Font("Dialog",0,12);
	public DccSender_MyCellRendererD(){}
	TableCellRenderer orig= new DefaultTableCellRenderer();
	public void updateUI(){
		((JComponent)orig).updateUI();
	}

	public Component getTableCellRendererComponent
	(JTable table,Object value,boolean isSelected,boolean hasFocus,int row,int column)
	{
		JLabel c = (JLabel)orig.getTableCellRendererComponent
			( table, value, isSelected, hasFocus, row, column);

		switch(table.convertColumnIndexToModel(column)){
		case 5: case 6: case 8:
			c.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
			c.setHorizontalAlignment(JLabel.RIGHT);
			break;
		default:
			c.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT );
			c.setHorizontalAlignment(JLabel.LEFT);
			break;
		}
		c.setFont(f);
		return c;
	}
};

class DccSender_MyCellRendererH implements TableCellRenderer{
	TableCellRenderer orig;
	DccSender_MyCellRendererH(TableCellRenderer orig){
		this.orig=orig;
	}
	public void updateUI(){
		((JComponent)orig).updateUI();
	}
	public Component getTableCellRendererComponent
	(JTable table,Object value,boolean isSelected,boolean hasFocus,int row,int column)
	{
		JLabel c = (JLabel)orig.getTableCellRendererComponent
			( table, value, isSelected, hasFocus, row, column);

		switch(table.convertColumnIndexToModel(column)){
		case 5: case 6: case 8:
			c.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
			c.setHorizontalAlignment(JLabel.RIGHT);
			break;
		default:
			c.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT );
			c.setHorizontalAlignment(JLabel.LEFT);
			break;
		}
		c.setFont(table.getFont());
		return c;
	}
};
