package buffer;

public class PackedLineReader
extends PackedStyle
{
	public PackedLineReader(
		PackedLineBlock block,int line
		,StyleID sid,String basestyle
	){
		super(sid,basestyle);
		this.block=block;
		this.line=line;

		style_bulk  =block.getStyleArray();
		style_offset=block.getStyleStart(line);
		style_end   =block.getStyleEnd  (line);

		text_bulk   =block.getTextArray();
		text_offset =block.getTextStart(line);
		text_span_length=0; 
	}
	//////////////////////////
	// \[XubN̏
	PackedLineBlock block;
	public int line;
	public char[] text_bulk;
	public byte[] style_bulk;
	public int style_end;
	//////////////////////////
	// ݒڂĂԂ̈ʒu
	public int style_offset;
	public int text_offset;
	public int text_span_length; //Ԃchar̒

	public boolean hasNextSpan(){ return style_offset<style_end;}

	// ̋Ԃ𓾂
	// Ԃ̒return valuetext_span_lengthɁÃ݂X^Csuperɐݒ肳B
	// 0̋ԂhasNext()Ȏ͎̕\s̃Cfgʒuݒ肷钷0̋ԂƂĈ
	public int readSpan(){
		// ܂œǂ񂾁AƂɂ
		text_offset+=text_span_length;
		// ̋Ԃ܂ŃX^Cwǂ
		text_span_length=0;
		int long_text_flag=0;
		while(style_offset<style_end){
			int flag = (255&(style_bulk[style_offset++]));
			     if(flag< TEXT_END           ){ text_span_length = flag + (long_text_flag*0x80); break; }
			else if(flag==TEXT_LONG          ){ ++long_text_flag; }
			else if(flag< BASESTYLE_END      ){ super.baseid = (flag&BASESTYLE_MASK); }
			else if(flag==SAVEINDENT         ){ break; }
			else if(flag< OPTIONSTYLE_END    ){ super.optionid[(flag&OPTIONSTYLE_MASK)]=(255&(style_bulk[style_offset++])); }
			else /* flag< OPTIONREMOVE_END */ { super.optionid[(flag&OPTIONSTYLE_MASK)]=-1; }
		}
		return text_span_length;
	}

	public String getSpanText()
	{ return new String( text_bulk ,text_offset ,text_span_length ); }

	public void writeSubstringToStringBuffer(StringBuffer sb,int start,int length)
	{ sb.append(text_bulk,text_offset+start,length); }

	////////////////////////////////////////////
	// s̋Ԃ̏𓾂
	public int span_count=0;
	public int lastspan_length=0;
	public void calcSpanNodes(){
		span_count=0;
		lastspan_length=0;
		int long_text_flag=0;
		for(int bs=block.getStyleStart(line);bs<style_end;){
			int flag = (255&(style_bulk[bs++]));
			     if(flag< TEXT_END           ){ ++span_count; lastspan_length=flag + (long_text_flag*0x80); long_text_flag=0; }
			else if(flag==TEXT_LONG          ){ ++long_text_flag; }
			else if(flag< BASESTYLE_END      ){}
			else if(flag==SAVEINDENT         ){++span_count;  lastspan_length=0; }
			else if(flag< OPTIONSTYLE_END    ){ ++bs; }
			else /* flag< OPTIONREMOVE_END */ {}
		}
	}
}
