// UTF-8 ☀☁☂☃
package bluntirc;
import irc.*;
// 埋め込まれたマクロ１つについての情報
abstract public class PrintFormatMacro{
	private String m_name;
	private Object m_extra;
	private boolean allow_ctcp;
	public PrintFormatMacro(String a_name,Object a_extra,boolean a_ctcp){
		m_name=a_name;
		m_extra=a_extra;
		allow_ctcp = a_ctcp;
	}
	public String name(){return m_name;}
	public Object extra(){return m_extra;}
	public boolean allowCTCP(){return allow_ctcp;}
	// サブクラス用
	abstract public String getText(IRCMessage m,Object to);
	public boolean isSaveWrap(){return false;}
	// 色指定やボールド等の指定
	public int getStyle(){return 0;}
		public static final int COLOR=-1;
		public static final int SAVE_WRAP=-2;
		// ほかは FontInfo2 のスタイル指定を参照

	// デバッグ用
	public String toString(){
		if(m_extra!=null) return "{"+m_name+":"+m_extra+"}";
		return "{"+m_name+"}";
	}

	///////////////////////////////
	// サブクラスの getTextから使われる
	public static String getShortName(Object o){
		if(o==null) return "(null)";
		if(o instanceof IRCConnection) o=((IRCConnection)o).getListener().getConnectionName((IRCConnection)o);
		if(o instanceof byte[]) o=new IRCChannelName((byte[])o);
		if(o instanceof IRCChannelNameOrPrefix) return ((IRCChannelNameOrPrefix)o).getShortName();
		if(o instanceof String) return (String)o;
		return "getShortName:unknown type:"+o.toString();
	}
	public static String getNormalName(Object o){
		if(o==null) return "(null)";
		if(o instanceof IRCConnection) o=((IRCConnection)o).getListener().getConnectionName((IRCConnection)o);
		if(o instanceof byte[]) o=new IRCChannelName((byte[])o);
		if(o instanceof IRCChannelNameOrPrefix) return ((IRCChannelNameOrPrefix)o).getPrintableName();
		if(o instanceof String) return (String)o;
		return "getNormalName:unknown type:"+o.toString();
	}
	public static String getEscapedName (Object o){
		if(o==null) return "(null)";
		if(o instanceof IRCConnection) o=((IRCConnection)o).getListener().getConnectionName((IRCConnection)o);
		if(o instanceof byte[]) o=new IRCChannelName((byte[])o);
		if(o instanceof IRCChannelNameOrPrefix) return ((IRCChannelNameOrPrefix)o).getEscapedName();
		if(o instanceof String) return (String)o;
		return "getEscapedName:unknown type:"+o.toString();
	}
}
