// UTF-8 ☀☁☂☃

package action;

import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import bluntirc.*;
import irc.*;
import base.*;
import gui.*;
import java.nio.charset.*;

// Actionのあまり使わないメンバにカラの処理を用意したもの。
abstract class Action_ extends AbstractAction{
	public static java.util.logging.Logger logger = java.util.logging.Logger.getLogger("action.action_");
	static{ logger.setLevel(null); }

	abstract public String GetName();
	abstract public String GetDesc();
	public Object getValue(String key){
		if(key.equals(Action.NAME)){return GetName();}
		if(key.equals(Action.SHORT_DESCRIPTION)){return GetDesc();}
		if(key.equals(Action.LONG_DESCRIPTION)){return GetDesc();}
		return super.getValue(key);
	}
	public void putValue(String key, Object newValue){
		super.putValue(key,newValue);
		if(newValue==null) newValue="(null)";
		logger.finer("putValue "+key+"="+newValue.toString() );
	}
}

public class BaseActions{
	public static java.util.logging.Logger logger = java.util.logging.Logger.getLogger("action.baseactions");
	static{ logger.setLevel(null); }

	public static void entry(){
		Object owner = App.getApp();

App.action_manager.add( owner,"app-dialog",new Action_(){
	public String GetName(){ return "環境設定"; }
	public String GetDesc(){ return App.config_AppName+"の環境設定を行います。";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		new dialog.AppConfDialog(App.getApp());
	}
});
App.action_manager.add( owner,"conn-dialog",new Action_(){
	int callcount=0;
	public String GetName(){ return "接続先の設定"; }
	public String GetDesc(){ return "選択した接続先の設定を編集します。";}
	public boolean isEnabled(){ return null != App.getSelectedConn(); }
	public void actionPerformed(java.awt.event.ActionEvent e){
		CTN_Conn node= App.getSelectedConn();
		if(node!=null) new dialog.ConnDialog(node);
	}
});
App.action_manager.add( owner,"channel-dialog",new Action_(){
	public String GetName(){ return "設定"; }
	public String GetDesc(){ return "選択したチャンネルの設定を見ます。";}
	public boolean isEnabled(){ return App.getSelectedChannel()!=null; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		CTN_Chan node=App.getSelectedChannel();
		if(node!=null) new dialog.ChannelDialog(node);
	}
});

// 0 app level menu
App.action_manager.add( owner,"connection-new",new Action_(){
	public String GetName(){ return "接続先の追加"; }
	public String GetDesc(){ return "接続先の設定をツリーに追加します。";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		new dialog.ConnDialog(null);
	}
});
App.action_manager.add( owner,"app-save",new Action_(){
	public String GetName(){ return "接続設定保存"; }
	public String GetDesc(){ return "接続設定を"+App.config_AppName+".iniに保存します。";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		PropertyManager.resetSaveFlag();
		PropertyManager.save(App.getApp(),App.IniFileName);
	}
});
/*
App.action_manager.add( owner,"set-browser-save",new Action_(){
	public String GetName(){ return "ブラウザの指定"; }
	public String GetDesc(){ return "URLをクリックしたときに使用するブラウザを選びます。";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		JFileChooser chooser = new JFileChooser();
		int returnVal = chooser.showOpenDialog(App.getApp());
	    if(returnVal == JFileChooser.APPROVE_OPTION){
			App.root_property.setString("BrowserName",chooser.getSelectedFile().getPath());
	    }
	}
});
*/
App.action_manager.add( owner,"allmessage-show",new Action_(){
	public String GetName(){ return "「全てのメッセージ」を表示"; }
	public String GetDesc(){ return "「全てのメッセージ」を表示します。";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		App.getApp().log_all.show();
	}
});
App.action_manager.add( owner,"allmessage-clear",new Action_(){
	public String GetName(){ return "「全てのメッセージ」をクリア"; }
	public String GetDesc(){ return "「全てのメッセージ」の表示内容を消去します";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		App.getApp().log_all.doc.clear(App.main_window);
	}
});
/*
App.action_manager.add( owner,"joblist-show",new Action_(){
	public String GetName(){ return "ジョブ一覧"; }
	public String GetDesc(){ return "ジョブ一覧を表示します。";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		App.getApp().job_view.show();
	}
});
*/
App.action_manager.add( owner,"scriptslist-show",new Action_(){
	public String GetName(){ return "スクリプト一覧"; }
	public String GetDesc(){ return "スクリプト一覧を表示します。";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		App.script_manager.show();
	}
});
App.action_manager.add( owner,"app-exit",new Action_(){
	public String GetName(){ return "<HTML><font color=\"red\">"+App.config_AppName+"の終了</font>"; }
	public String GetDesc(){ return App.config_AppName+"を終了します。";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		App.getApp().AppExit("menu action");
	}
});

// 1 conn level menu
App.action_manager.add( owner,"conn-start",new Action_(){
	public String GetName(){ return "接続開始"; }
	public String GetDesc(){ return "接続を開始します。";}
	public boolean isEnabled(){ return null != App.getSelectedConn() && ! App.getSelectedConn().conn.isConnected(); }
	public void actionPerformed(java.awt.event.ActionEvent e){
		CTN_Conn c=App.getSelectedConn();
		if( c!=null && ! c.conn.isConnected() ){
			c.conn.Connect();
		}
	}
});
App.action_manager.add( owner,"conn-stop",new Action_(){
	public String GetName(){ return "接続終了"; }
	public String GetDesc(){ return "接続を終了します。";}
	public boolean isEnabled(){ return null != App.getSelectedConn() && App.getSelectedConn().conn.isConnected(); }
	public void actionPerformed(java.awt.event.ActionEvent e){
		CTN_Conn c=App.getSelectedConn();
		if( c==null || !c.conn.isConnected() ) return;
		String message = (String)c.property.get("QuitMessage");
		if(message==null) message="";
		new OneLineDialog(App.main_window
			,App.config_AppName
			,"終了メッセージを指定すれ"
			,message
			,new OneLineDialogListener(new Object[]{ c.conn }){
				public void apply(String value){
					IRCConnection conn = (IRCConnection)args[0];
					conn.Disconnect(value);
				}
			}
		);
	}
});
App.action_manager.add( owner,"conn-nick-dialog",new Action_(){
	public String GetName(){ return "ニックネーム変更"; }
	public String GetDesc(){ return "自分のニックネームを変更します。";}
	public boolean isEnabled(){ return null != App.getSelectedConn() && App.getSelectedConn().conn.isConnected(); }
	public void actionPerformed(java.awt.event.ActionEvent e){
		CTN_Conn c=App.getSelectedConn();
		if(c!=null && c.conn.isConnected()){
			new OneLineDialog(App.main_window
				,App.config_AppName
				,c.getName()+"での新しいニックネームを指定すれ"
				,c.conn.myself.getShortName()
				,new OneLineDialogListener(new Object[]{ c.conn }){
					public void apply(String value){
						IRCConnection conn = (IRCConnection)args[0];
						if(conn.isConnected()){
							Vector v=new Vector();
							v.add("NICK");
							v.add(value);
							conn.SendToServer(v);
						}
					}
				}
			);
		}
	}
});
App.action_manager.add( owner,"channel-new",new Action_(){
	public String GetName(){ return "チャンネル追加"; }
	public String GetDesc(){ return "チャンネルまたはぷりぶ用のバッファをツリーに追加します。";}
	public boolean isEnabled(){ return null != App.getSelectedConn() && App.getSelectedConn().conn.isConnected(); }
	public void actionPerformed(java.awt.event.ActionEvent e){
		CTN_Conn c=App.getSelectedConn();
		if(c!=null  && c.conn.isConnected()){
			new OneLineDialog(App.main_window
				,App.config_AppName
				,c.getName()+"に追加するチャンネル名かプリブ先のニックを指定すれ"
				,""
				,new OneLineDialogListener(new Object[]{ c.conn }){
					public void apply(String value){
						IRCConnection conn = (IRCConnection)args[0];

						if(value.length()==0) return;
						if(IRCChannelName.isChannelName(value.charAt(0))){
							Vector v=new Vector();
							v.add("JOIN");
							v.add(IRCChannelName.unescape(value));
							conn.SendToServer(v);
						}else{
							IRCChannel chan=conn.FindChannel(value,true);
							App.buf_list.select((ConnTreeNode) chan.Extra);
						}
					}
				}
			);
		}
	}
});
App.action_manager.add( owner,"conn-list-channel",new Action_(){
	public String GetName(){ return "チャンネル一覧"; }
	public String GetDesc(){ return "サーバからチャンネルの一覧を取得します。";}
	public boolean isEnabled(){ return  App.getSelectedConn() !=null && App.getSelectedConn().conn.isConnected(); }
	public void actionPerformed(java.awt.event.ActionEvent e){
		CTN_Conn c=App.getSelectedConn();
		if(c!=null && c.conn.isConnected()){
			App.Log(GetName()+":未対応");
		}
	}
});
App.action_manager.add( owner,"conn-ignore-edit",new Action_(){
	public String GetName(){ return "無視リスト編集"; }
	public String GetDesc(){ return "無視リストを編集します。";}
	public boolean isEnabled(){ return App.getSelectedConn() !=null; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		CTN_Conn c=App.getSelectedConn();
		if(c!=null ){
			App.Log(GetName()+":未対応");
		}
	}
});
App.action_manager.add( owner,"conn-remove",new Action_(){
	public String GetName(){ return "削除"; }
	public String GetDesc(){ return "選択した接続先の設定をツリーから削除します。";}
	public boolean isEnabled(){ return  App.getSelectedConn() !=null && ! App.getSelectedConn().conn.isConnected(); }
	public void actionPerformed(java.awt.event.ActionEvent e){
		CTN_Conn c=App.getSelectedConn();
		if( c!=null && ! c.conn.isConnected() ){
			c.getParent().removeNode(c);
		}
	}
});
// 2 channel level menu
App.action_manager.add( owner,"channel-join",new Action_(){
	public String GetName(){ return "参加"; }
	public String GetDesc(){ return "チャンネルにjoinします。";}
	public boolean isEnabled(){
		CTN_Chan node=App.getSelectedChannel();
		return node!=null && ! node.chan.isInMyself();
	}
	public void actionPerformed(java.awt.event.ActionEvent e){
		CTN_Chan node=App.buf_list.getChannel();
		if(node!=null && ! node.chan.isInMyself() ) node.OnMenuJoin();
	}
});
App.action_manager.add( owner,"channel-name-copy",new Action_(){
	public String GetName(){ return "チャンネル名をコピー"; }
	public String GetDesc(){ return "チャンネル名をクリップボードにコピーします。";}
	public boolean isEnabled(){
		CTN_Chan node=App.getSelectedChannel();
		return node!=null ;
	}
	public void actionPerformed(java.awt.event.ActionEvent e){
		CTN_Chan node=App.buf_list.getChannel();
		if(node==null) return;
		IRCChannel channel = node.getChannel();
		String s = e.getActionCommand();
		if(s==null) s="";
		String name=null;
		     if(s.equals("ShortName")     ) name=channel.getShortName();
		else if(s.equals("PrintableName") ) name=channel.getPrintableName();
		else if(s.equals("EscapedName")   ) name=channel.getEscapedName();
		else name = channel.getName();
		App.os_dependence.Copy(name);
	}
});

App.action_manager.add( owner,"channel-part",new Action_(){
	public String GetName(){ return "退室"; }
	public String GetDesc(){ return "チャンネルから退室します。";}
	public boolean isEnabled(){
		CTN_Chan node=App.getSelectedChannel();
		return node!=null && node.chan.isInMyself();
	}
	public void actionPerformed(java.awt.event.ActionEvent e){
		CTN_Chan node=App.getSelectedChannel();
		if(node==null) return;

		String PartMessage =(String)node.property.get("PartMessage");
		if(PartMessage==null || PartMessage.length()==0)
			PartMessage =(String)node.getParent().property.get("PartMessage");
		if(PartMessage==null) PartMessage="";

		new OneLineDialog(App.main_window
			,App.config_AppName
			,"退出メッセージ"
			,PartMessage
			,new OneLineDialogListener(new Object[]{ node }){
				public void apply(String value){
					CTN_Chan node = (CTN_Chan)args[0];
					if(node!=null && node.chan.isInMyself() ) node.OnMenuPart(value);
				}
			}
		);
	}
});
App.action_manager.add( owner,"channel-topic-dialog",new Action_(){
	public String GetName(){ return "トピック設定"; }
	public String GetDesc(){ return "チャンネルのトピックを設定します。";}
	public boolean isEnabled(){
		CTN_Chan node=App.getSelectedChannel();
		return node!=null && node.chan.isInMyself();
	}
	public void actionPerformed(java.awt.event.ActionEvent e){
		CTN_Chan node=App.getSelectedChannel();
		new OneLineDialog(App.main_window
			,App.config_AppName
			,"新しいトピックを指定すれ"
			,node.chan.getTopic()
			,new OneLineDialogListener(new Object[]{ node }){
				public void apply(String value){
					CTN_Chan node = (CTN_Chan)args[0];
					if(node!=null && node.chan.isInMyself() ) node.OnMenuTopic(value);
				}
			}
		);
	}
});
App.action_manager.add( owner,"channel-ban-dialog",new Action_(){
	public String GetName(){ return "banリスト編集"; }
	public String GetDesc(){ return "チャンネルのbanリストを編集します。";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		App.Log(GetName()+":未対応");
	}
});
App.action_manager.add( owner,"channel-remove",new Action_(){
	public String GetName(){ return "削除"; }
	public String GetDesc(){ return "選択したチャンネルをツリーから削除します。";}
	public boolean isEnabled(){
		CTN_Chan node=App.getSelectedChannel();
		return node!=null && ! node.chan.isInMyself();
	}
	public void actionPerformed(java.awt.event.ActionEvent e){
		CTN_Chan node=App.getSelectedChannel();
		if(node!=null && ! node.chan.isInMyself() ){
			node.getParent().removeNode(node);
		}
	}
});
// 3 priv-buffer menu

App.action_manager.add( owner,"irc-call1",new Action_(){
	public String GetName(){ return "irc-call1"; }
	public String GetDesc(){ return "IRCコマンドを実行します。引数はチャンネル名かニックネーム";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		String command = e.getActionCommand().toUpperCase();
		if(command==null || command.length()==0){
			App.Log("irc-call1 にアクションコマンドが指定されていない");
		}
		ConnectionAndTarget ct = new ConnectionAndTarget(e);
	//	App.Log("irc-call1 conn="+ct.node+" target="+ct.target);
		if( ct.node!=null &&  ct.target!=null ){
			for(int i=0;i<ct.target.length;++i){
				Object o = ct.target[i];
				if( o instanceof IRCChannelMember){ o=((IRCChannelMember)o).getUser();}
				if( o instanceof CTN_Chan ){ o=((CTN_Chan)o).GetChannel();}
				if( o instanceof CTN_Priv ){ o=((CTN_Priv)o).GetChannel();}
				if( o instanceof IRCChannelNameOrPrefix){
					LinkedList v=new LinkedList();
					v.add(command);
					v.add(((IRCChannelNameOrPrefix)o).getRawBytes() );
					ct.getConnectionNode().conn.SendToServer(v);
				}else{
					App.Log("irc-call1:unknown target type:"+o.getClass().getName() );
				}
			}
		}
	}
});

App.action_manager.add( owner,"irc-channel-command",new Action_(){
	public String GetName(){ return "IRCコマンドを実行します。"; }
	public String GetDesc(){ return "IRCコマンドを実行します。 /<コマンド> 現在のチャンネル 選択した引数";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		String command = e.getActionCommand().toUpperCase();
		if(command==null || command.length()==0){
			App.Log("irc-channel-command にアクションコマンドが指定されていない");
		}
		ConnectionAndTarget ct = new ConnectionAndTarget(e);
	//	App.Log("irc-call1 conn="+ct.node+" target="+ct.target);
		if( ct.node!=null &&  ct.target!=null ){
			for(int i=0;i<ct.target.length;++i){
				Object o = ct.target[i];
				if( o instanceof IRCChannelMember){ o=((IRCChannelMember)o).getUser();}
				if( o instanceof CTN_Chan ){ o=((CTN_Chan)o).GetChannel();}
				if( o instanceof CTN_Priv ){ o=((CTN_Priv)o).GetChannel();}
				if( o instanceof IRCChannelNameOrPrefix){
					LinkedList v=new LinkedList();
					v.add(command);
					v.add(ct.getChannelNode().chan.getRawBytes());
					v.add(((IRCChannelNameOrPrefix)o).getRawBytes() );
					ct.getConnectionNode().conn.SendToServer(v);
				}else{
					App.Log("irc-channel-command:unknown target type:"+o.getClass().getName() );
				}
			}
		}
	}
});

App.action_manager.add( owner,"irc-channel-command-plus",new Action_(){
	public String GetName(){ return "コマンド文字列を組み立てて入力エリアに書きます。"; }
	public String GetDesc(){ return "コマンド文字列を組み立てて入力エリアに書きます。";}
	public boolean isEnabled(){ return true; }

	

	public void actionPerformed(java.awt.event.ActionEvent e){
		String command = e.getActionCommand();
		if(command==null || command.length()==0){
			App.Log("irc-channel-command-plus にアクションコマンドが指定されていない");
		}

		ConnectionAndTarget ct = new ConnectionAndTarget(e);
		if( ct.node!=null){
			App.buf_list.select(ct.node);
			StringBuffer sb = new StringBuffer();
			sb.append(App.root_property.getString("CommandSlash").charAt(0));
			for(int i=0;i<command.length();){
				// %まで
				int start=i;i=command.indexOf('%',start);
				if(i==-1)i=command.length();
				if(i>start) sb.append(command.substring(start,i));
				if(i>=command.length()) break;

				String[] macro_type = { "%te","%ts","%t"};
				int target_type=-1;
				String target_key =null;
				for(int j=0;j<macro_type.length;++j){
					if(command.startsWith(macro_type[j],i)){
						target_type=j;
						i+=macro_type[j].length();
						break;
					}
				}
				if(target_type!=-1){
					if( ct.target!=null ){
						for(int j=0;j<ct.target.length;++j){
							Object o = ct.target[j];
							if( o instanceof IRCChannelMember){ o=((IRCChannelMember)o).getUser();}
							if( o instanceof CTN_Chan ){ o=((CTN_Chan)o).GetChannel();}
							if( o instanceof CTN_Priv ){ o=((CTN_Priv)o).GetChannel();}
							if( o instanceof IRCChannelNameOrPrefix){
								if(j!=0)sb.append(" ");
								if( target_type==0) sb.append(((IRCChannelNameOrPrefix)o).getEscapedName());
								if( target_type==1) sb.append(((IRCChannelNameOrPrefix)o).getShortName());
								if( target_type==2) sb.append(((IRCChannelNameOrPrefix)o).getPrintableName());
							}
						}
					}
					continue;
				}

				if(command.startsWith("%c",i)){
					i+=2;
					if(ct.getChannelNode()!=null){
						sb.append(ct.getChannelNode().chan.getEscapedName());
					}
					continue;
				}
				if(command.startsWith("%s",i)){
					i+=2;
					if(ct.getChannelNode()!=null){
						sb.append(ct.getConnectionNode().getName() );
					}
					continue;
				}
				if(command.startsWith("%{",i)){
					i+=2;
					start = i;
					i= command.indexOf('{',i);
					if(i==-1) i=command.length();
					String name = command.substring(start,i++);
					Object o = ct.node.property.get(name);
					if(o==null) o = App.root_property.get(name);
					if(o==null) o = "(null)";
					sb.append(o.toString());
					continue;
				}
				sb.append('%');
				++i;
			}
			App.main_window.input_area.pasteText(sb.toString());
		}
	}
});


App.action_manager.add( owner,"priv-open",new Action_(){
	public String GetName(){ return "ぷりぶ窓作成"; }
	public String GetDesc(){ return "個別に話すためのバッファを作成します";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		ConnectionAndTarget ct = new ConnectionAndTarget(e);
		if( ct.node!=null &&  ct.target!=null ){
			for(int i=0;i<ct.target.length;++i){
				Object o = ct.target[i];
				if( o instanceof IRCChannelMember){ o=((IRCChannelMember)o).getUser();}
				if( o instanceof CTN_Chan ){ o=((CTN_Chan)o).GetChannel();}
				if( o instanceof CTN_Priv ){ o=((CTN_Priv)o).GetChannel();}
				if( o instanceof IRCChannelNameOrPrefix){
					IRCUser user = ct.getConnectionNode().conn.findUser( ((IRCChannelNameOrPrefix)o).getRawBytes() );
					if(user!=null){
						IRCChannel chan=ct.getConnectionNode().conn.FindChannel(user,true);
						App.buf_list.select( (ConnTreeNode) chan.Extra);
					}
				}else{
					App.Log("irc-call1:unknown target type:"+o.getClass().getName() );
				}
			}
		}
	}
});


App.action_manager.add( owner,"priv-ignore-add",new Action_(){
	public String GetName(){ return "無視リスト追加"; }
	public String GetDesc(){ return "ぷりぶバッファの相手を無視リストに追加します。";}
	public boolean isEnabled(){ return false; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		App.Log(GetName()+":未対応");
	}
});
App.action_manager.add( owner,"priv-remove",new Action_(){
	public String GetName(){ return "削除"; }
	public String GetDesc(){ return "選択したぷりぶバッファをツリーから削除します。";}
	public boolean isEnabled(){
		CTN_Priv node=App.getSelectedPriv();
		return node!=null ;
	}
	public void actionPerformed(java.awt.event.ActionEvent e){
		CTN_Priv node=App.getSelectedPriv();
		if(node!=null ) node.getParent().removeNode(node);
	}
});
// 4 channeluser level menu
App.action_manager.add( owner,"cuser-op-add",new Action_(){
	public String GetName(){ return "+o op権限を渡す"; }
	public String GetDesc(){ return "選択した参加者になるとを配ります";}
	public boolean isEnabled(){ return App.main_window !=null && App.main_window.user_view!=null&& App.main_window.user_view.isSelectedMulti(); }
	public void actionPerformed(java.awt.event.ActionEvent e){
		ActionUtility.setUsersMode("+ooo");
	}
});

App.action_manager.add( owner,"cuser-copy-nickname",new Action_(){
	public String GetName(){ return "copy nickname"; }
	public String GetDesc(){ return "選択したユーザのニックネームをクリップボードにコピーします。";}
	public boolean isEnabled(){ return App.main_window !=null && App.main_window.user_view!=null&& App.main_window.user_view.isSelectedMulti(); }
	public void actionPerformed(java.awt.event.ActionEvent e){
		LinkedList users = App.main_window.user_view.getSelectedMulti();
		if(users!=null && users.size()!=0){
			StringBuffer sb=new StringBuffer();
			while(0!=users.size()){
				IRCChannelMember user =(IRCChannelMember)users.removeFirst();
				sb.append(user.getUser().getShortName());
				sb.append('\n');
			}
			App.os_dependence.Copy(new String(sb));
		}
	}
});
App.action_manager.add( owner,"cuser-copy-prefix",new Action_(){
	public String GetName(){ return "copy prefix"; }
	public String GetDesc(){ return "選択したユーザのprefixをクリップボードにコピーします。";}
	public boolean isEnabled(){ return App.main_window !=null && App.main_window.user_view!=null&& App.main_window.user_view.isSelectedMulti(); }
	public void actionPerformed(java.awt.event.ActionEvent e){
		LinkedList users = App.main_window.user_view.getSelectedMulti();
		if(users!=null && users.size()!=0){
			StringBuffer sb=new StringBuffer();
			boolean flag=false;
			while(0!=users.size()){
				IRCChannelMember user =(IRCChannelMember)users.removeFirst();
				sb.append(user.getUser().getEscapedName());
				if(!flag) flag=true; else sb.append('\n');
			}
			App.os_dependence.Copy(new String(sb));
		}
	}
});
App.action_manager.add( owner,"cuser-ignore-add",new Action_(){
	public String GetName(){ return "無視"; }
	public String GetDesc(){ return "選択した参加者を無視します。永続的な設定は他のメニューで。";}
	public boolean isEnabled(){ 
		return App.main_window !=null && App.main_window.user_view!=null&& App.main_window.user_view.isSelectedMulti();
	}
	public void actionPerformed(java.awt.event.ActionEvent e){
		App.Log(GetName()+":未対応");
	}
});
App.action_manager.add( owner,"cuser-ban",new Action_(){
	public String GetName(){ return "banリスト追加"; }
	public String GetDesc(){ return "選択した参加者をbanします";}
	public boolean isEnabled(){
		return App.main_window !=null && App.main_window.user_view!=null&& App.main_window.user_view.isSelectedMulti(); 
	}
	public void actionPerformed(java.awt.event.ActionEvent e){
		App.Log(GetName()+":未対応");
	}
});
App.action_manager.add( owner,"cuser-op-remove",new Action_(){
	public String GetName(){ return "-o"; }
	public String GetDesc(){ return "選択した参加者を -o します。";}
	public boolean isEnabled(){ return App.main_window !=null && App.main_window.user_view!=null&& App.main_window.user_view.isSelectedMulti(); }
	public void actionPerformed(java.awt.event.ActionEvent e){
		ActionUtility.setUsersMode("-ooo");
	}
});
App.action_manager.add( owner,"cuser-voice-add",new Action_(){
	public String GetName(){ return "+v 発言者にする"; }
	public String GetDesc(){ return "選択した参加者を発言者にします。(+v)";}
	public boolean isEnabled(){ return App.main_window !=null && App.main_window.user_view!=null&& App.main_window.user_view.isSelectedMulti(); }
	public void actionPerformed(java.awt.event.ActionEvent e){
		ActionUtility.setUsersMode("+vvv");
	}
});
App.action_manager.add( owner,"cuser-voice-remove",new Action_(){
	public String GetName(){ return "-v"; }
	public String GetDesc(){ return "選択した参加者を -v します。";}
	public boolean isEnabled(){ return App.main_window !=null && App.main_window.user_view!=null&& App.main_window.user_view.isSelectedMulti(); }
	public void actionPerformed(java.awt.event.ActionEvent e){
		ActionUtility.setUsersMode("-vvv");
	}
});

App.action_manager.add( owner,"ctcp-request",new Action_(){
	public String GetName(){ return "CTCP request"; }
	public String GetDesc(){ return "CTCPリクエストを発行します";}
	public boolean isEnabled(){ return true;}
	public void actionPerformed(java.awt.event.ActionEvent e){
		String command = e.getActionCommand().toUpperCase();
		if(command==null || command.length()==0){
			App.Log("ctcp-request にアクションコマンドが指定されていない");
		}
		ConnectionAndTarget ct = new ConnectionAndTarget(e);
		if( ct.node!=null &&  ct.target!=null ){
			for(int i=0;i<ct.target.length;++i){
				Object o = ct.target[i];
				if( o instanceof IRCChannelMember){ o=((IRCChannelMember)o).getUser();}
				if( o instanceof CTN_Chan ){ o=((CTN_Chan)o).GetChannel();}
				if( o instanceof CTN_Priv ){ o=((CTN_Priv)o).GetChannel();}
				if( o instanceof IRCChannelNameOrPrefix){
					long now = (new GregorianCalendar()).getTime().getTime();
					LinkedList v=new LinkedList();
					v.add(command);
					if(command.equals("PING")) v.add(Long.toString((new GregorianCalendar()).getTime().getTime()));
					ct.getConnectionNode().conn.SendToServer(ct.getConnectionNode().conn.encodeCTCP(((IRCChannelNameOrPrefix)o).getRawBytes(),v,"PRIVMSG"));
				}else{
					App.Log("unknown target type:"+o.getClass().getName() );
				}
			}
		}
	}
});


// 5 log level menu
App.action_manager.add( owner,"buffer-select-all",new Action_(){
	public String GetName(){ return "全て選択"; }
	public String GetDesc(){ return "表示されているバッファのテキストを全て選択します。";}
	public boolean isEnabled(){ 
		ConnTreeNode ctn;
		buffer.LogDocument d;
		return App.buf_list!=null
		&& null!=(ctn=App.buf_list.getSelected())
		&& null!=(d=ctn.getLogDocument())
		;
	}
	public void actionPerformed(java.awt.event.ActionEvent e){
		ConnTreeNode ctn;
		buffer.LogDocument d;
		if( App.buf_list!=null
		&& null!=(ctn=App.buf_list.getSelected())
		&& null!=(d=ctn.getLogDocument())
		){
			d.selectAll();
		}
	}
});

App.action_manager.add( owner,"buffer-paste-to-input",new Action_(){
	public String GetName(){ return "選択範囲を入力窓に貼る"; }
	public String GetDesc(){ return "バッファの選択範囲を入力窓に貼り付けます。クリップボードにはアクセスしません。";}
	public boolean isEnabled(){ 
		ConnTreeNode ctn;
		buffer.LogDocument d;
		return App.buf_list!=null
		&& null!=(ctn=App.buf_list.getSelected())
		&& null!=(d=ctn.getLogDocument())
		&& 0 != d.getSelectedText().length()
		;
	}
	public void actionPerformed(java.awt.event.ActionEvent e){
		ConnTreeNode ctn;
		buffer.LogDocument d;
		if( App.buf_list!=null
		&& null!=(ctn=App.buf_list.getSelected())
		&& null!=(d=ctn.getLogDocument())
		){
			String s=d.getSelectedText();
			if(s.length()!=0) App.main_window.input_area.pasteText(s);
		}
	}
});
App.action_manager.add( owner,"buffer-clear",new Action_(){
	public String GetName(){ return "クリア"; }
	public String GetDesc(){ return "今見ているバッファの内容をクリアします。";}
	public boolean isEnabled(){ 
		ConnTreeNode ctn;
		buffer.LogDocument d;
		return App.buf_list!=null
		&& null!=(ctn=App.buf_list.getSelected())
		&& null!=(d=ctn.getLogDocument())
		;
	}
	public void actionPerformed(java.awt.event.ActionEvent e){
		ConnTreeNode ctn;
		buffer.LogDocument d;
		if( App.buf_list!=null
		&& null!=(ctn=App.buf_list.getSelected())
		&& null!=(d=ctn.getLogDocument())
		){
			d.clear(App.main_window);
		}
	}
});
App.action_manager.add( owner,"buffer-url-list",new Action_(){
	public String GetName(){ return "URL履歴"; }
	public String GetDesc(){ return "ログに出現したURLの履歴を表示します。";}
	public boolean isEnabled(){ return false; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		App.Log(GetName()+":未対応");
	}
});
// p input-area menu
App.action_manager.add( owner,"inputarea-send-privmsg",new Action_(){
	public String GetName(){ return "発言"; }
	public String GetDesc(){ return "入力エリアに書かれた内容を発言します。";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		App.main_window.input_area.OnMenuTalk();
	}
});
App.action_manager.add( owner,"inputarea-send-topic",new Action_(){
	public String GetName(){ return "トピック"; }
	public String GetDesc(){ return "入力エリアに書かれた内容をトピックにします。";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		App.main_window.input_area.OnMenuTopic();
	}
});
App.action_manager.add( owner,"inputarea-send-notice",new Action_(){
	public String GetName(){ return "NOTICE"; }
	public String GetDesc(){ return "入力エリアに書かれた内容をNOTICEで送信します。";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		App.main_window.input_area.OnMenuNotice();
	}
});
App.action_manager.add( owner,"inputarea-send-action",new Action_(){
	public String GetName(){ return "ACTION"; }
	public String GetDesc(){ return "入力エリアに書かれた内容をCTCP ACTIONで送信します。";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		App.main_window.input_area.OnMenuAction();
	}
});
App.action_manager.add( owner,"inputarea-send-all-channnel",new Action_(){
	public String GetName(){ return "全CH"; }
	public String GetDesc(){ return "入力エリアに書かれた内容を全チャンネルで発言します。";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		App.main_window.input_area.OnMenuSendAll();
	}
});
App.action_manager.add( owner,"inputarea-cut",new Action_(){
	public String GetName(){ return "カット"; }
	public String GetDesc(){ return "選択範囲をカットしてクリップボードに記録します。";}
	public boolean isEnabled(){ 
		return  App.main_window.input_area!=null 
		&& App.main_window.input_area.InputArea.hasFocus()
		&& App.main_window.input_area.hasSelectedText()
		;
	}
	public void actionPerformed(java.awt.event.ActionEvent e){
		if(App.main_window.input_area!=null) App.main_window.input_area.cutText();
	}
});
App.action_manager.add( owner,"inputarea-paste",new Action_(){
	public String GetName(){ return "貼り付け"; }
	public String GetDesc(){ return "クリップボードの内容を現在キャレットがある位置に貼り付けます。";}
	public boolean isEnabled(){ 
		return App.main_window.input_area!=null && App.os_dependence.canGetClipboardText();
	}
	public void actionPerformed(java.awt.event.ActionEvent e){
		String s= App.os_dependence.getClipboardText();
		if(s!=null) App.main_window.input_area.pasteText(s);
	}
});
// おまけ
App.action_manager.add( owner,"reload-conf",new Action_(){
	public String GetName(){ return "reload *.conf"; }
	public String GetDesc(){ return "表示設定ファイルを読み直します。";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		App.style_manager.load("Style.conf");
		App.pfm_manager.load("PrintFormat.conf");
		App.main_window.reloadBGInfoAll();
	}
});
App.action_manager.add( owner,"font-list",new Action_(){
	public String GetName(){ return "フォント一覧をダンプ"; }
	public String GetDesc(){ return "フォント一覧をダンプバッファに出力します。";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
		String[] fl = genv.getAvailableFontFamilyNames();
		for(int i=0;i<fl.length;i++){
			App.Log(fl[i]);
		}
	}
});
App.action_manager.add( owner,"lookandfeel-list",new Action_(){
	public String GetName(){ return "Look&Feelの一覧"; }
	public String GetDesc(){ return "Look&Feelの一覧をダンプバッファに出力します。";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		UIManager.LookAndFeelInfo[] list = UIManager.getInstalledLookAndFeels();
		for(int i=0;i<list.length;i++){
			App.Log(list[i].getClassName());
		}
	}
});
App.action_manager.add( owner,"system-property",new Action_(){
	public String GetName(){ return "Javaのシステムプロパティをダンプ"; }
	public String GetDesc(){ return "Javaのシステムプロパティをダンプバッファに出力します。";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		Map tm =new TreeMap(); //ソートしたいのでHashでなくTree
		for(Iterator it=System.getProperties().entrySet().iterator();it.hasNext();){
			Map.Entry m = (Map.Entry) it.next();
			tm.put(m.getKey(),m.getValue());
		}
		for(Iterator it=tm.entrySet().iterator();it.hasNext();){
			Map.Entry m= (Map.Entry) it.next();
			App.Log(m.getKey().toString()+"="+m.getValue());
		}
	}
});
App.action_manager.add( owner,"garbage-collection",new Action_(){
	public String GetName(){ return "garbage collection"; }
	public String GetDesc(){ return "参照されていないメモリを解放します";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		System.gc();
	}
});
App.action_manager.add( owner,"repair-inputarea",new Action_(){
	public String GetName(){ return "入力エリアの修復"; }
	public String GetDesc(){ return "入力エリアを交換します";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		App.main_window.input_area.repair();
	}
});

App.action_manager.add( owner,"property-inspector",new Action_(){
	public String GetName(){ return "property-inspector"; }
	public String GetDesc(){ return "バッファ項目のプロパティを表示/編集します。";}
	public boolean isEnabled(){ return App.getSelected() !=null; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		ConnTreeNode node= App.getSelected();
		if(node!=null){
			new PropertyInspector(node.property,node.GetCaption()+" property");
		}
	}
});

App.action_manager.add( owner,"bufferlist-num",new Action_(){
	public String GetName(){ return "バッファ一覧から指定した項目を選択"; }
	public String GetDesc(){ return "バッファ一覧から指定した項目を選択";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		Object o=App.action_manager.getStackParameter();
		if(o==null) o= e.getActionCommand();
		try{
			int i=Integer.parseInt((String)o);
			App.buf_list.select(i);
		}catch(Throwable ee){
			if(o==null) o="(null)";
			if(!(o instanceof String)) o= o.getClass().getName();
			App.Log("bufferlist-num "+(String)o+" failed:"+ee.getClass().getName()+" "+ee.getMessage() );
		}
	}
});
App.action_manager.add( owner,"bufferlist-prevnext",new Action_(){
	public String GetName(){ return "バッファ一覧を移動"; }
	public String GetDesc(){ return "指定した値だけ上下に移動";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		Object o=App.action_manager.getStackParameter();
		if(o==null) o= e.getActionCommand();
		try{
			int i=Integer.parseInt((String)o);
			App.buf_list.StepScroll(i,true);
		}catch(Throwable ee){
			if(o==null) o="(null)";
			if(!(o instanceof String)) o= o.getClass().getName();
			App.Log("bufferlist-prevnext "+(String)o+" failed:"+ee.getClass().getName()+" "+ee.getMessage() );
		}
	}
});

App.action_manager.add( owner,"inputhistory-prev",new Action_(){
	public String GetName(){ return "前の入力履歴"; }
	public String GetDesc(){ return "前の入力履歴";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		try{
			App.main_window.input_area.history_prev();
		}catch(Throwable ee){
			App.Log("inputhistory-prev "+ee.getClass().getName()+" "+ee.getMessage() );
		}
	}
});
App.action_manager.add( owner,"inputhistory-next",new Action_(){
	public String GetName(){ return "次の入力履歴"; }
	public String GetDesc(){ return "次の入力履歴";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		try{
			App.main_window.input_area.history_next();
		}catch(Throwable ee){
			App.Log("inputhistory-next "+ee.getClass().getName()+" "+ee.getMessage() );
		}
	}
});

App.action_manager.add( owner,"edit-cut",new Action_(){
	public String GetName(){ return "カット"; }
	public String GetDesc(){ return "選択範囲をカットしてクリップボードに格納します。";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		Object o=App.getFocusComponent();
		if(o==null) return;
		if(o instanceof buffer.LogView){
			String s = ((buffer.LogView)o).getSelectedText();
			if(s.length()>0) App.os_dependence.Copy(s);
			return;
		}
		if(o instanceof javax.swing.text.JTextComponent ){
			logger.finer("edit-cut for JTextComponent");
			((javax.swing.text.JTextComponent)o).cut();
			return;
		}
		if( o instanceof JTable ){
			o = ((JTable)o).getModel();
			if(o instanceof ChannelMemberView){
				Action a= App.action_manager.find("cuser-copy-prefix");
				if(a!=null) App.action_manager.call(a,null);
				return;
			}
		}
		App.Log("edit-cut "+o.getClass().getName());
	}
});
App.action_manager.add( owner,"edit-copy",new Action_(){
	public String GetName(){ return "コピー"; }
	public String GetDesc(){ return "選択範囲をコピーしてクリップボードに格納します。";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		Object o=App.getFocusComponent();
		if(o==null) return;
		if(o instanceof buffer.LogView){
			String s = ((buffer.LogView)o).getSelectedText();
			if(s.length()>0) App.os_dependence.Copy(s);
			return;
		}
		if(o instanceof javax.swing.text.JTextComponent ){
			logger.finer("edit-copy for JTextComponent");
			((javax.swing.text.JTextComponent)o).copy();
			return;
		}
		if( o instanceof JTable ){
			o = ((JTable)o).getModel();
			if(o instanceof ChannelMemberView){
				Action a= App.action_manager.find("cuser-copy-prefix");
				if(a!=null) App.action_manager.call(a,null);
				return;
			}
		}
		App.Log("edit-copy "+o.getClass().getName());
	}
});
App.action_manager.add( owner,"edit-paste",new Action_(){
	public String GetName(){ return "貼り付け"; }
	public String GetDesc(){ return "クリップボードの内容を選択位置に貼り付けます。";}
	public boolean isEnabled(){
		return true;
	}
	public void actionPerformed(java.awt.event.ActionEvent e){
		String s = App.os_dependence.getClipboardText();
		if(s!=null && s.length()>0) App.main_window. input_area.pasteText(s);
	}
});
App.action_manager.add( owner,"edit-selectall",new Action_(){
	public String GetName(){ return "全て選択"; }
	public String GetDesc(){ return "フォーカスのあるコンポーネントの内容を全て選択します。";}
	public boolean isEnabled(){ return true; }
	public void actionPerformed(java.awt.event.ActionEvent e){
		Object o=App.getFocusComponent();
		if(o==null) return;
		if(o instanceof javax.swing.text.JTextComponent ){
			((javax.swing.text.JTextComponent)o).selectAll();
			return;
		}
		if(o instanceof buffer.LogView){
			((buffer.LogView)o).selectAll();
			return;
		}
		if( o instanceof JTable ){
			((JTable)o).selectAll();
			return;
		}
		App.Log("edit-selectall "+o.getClass().getName());
	}
});


App.action_manager.add( owner,"popupurl-browse",new Action_(){
	public String GetName(){ return "browse"; }
	public String GetDesc(){ return "バッファで選択中のURLをブラウザで開きます。";}
	public boolean isEnabled(){ return true;}
	public void actionPerformed(java.awt.event.ActionEvent e){
		String url =ActionUtility.readHoverOrSelected(e);
		if(url==null || url.length()==0 ) return;
		String keyname = e.getActionCommand();
		if(keyname==null || keyname.length()==0 ){
			App.Log("menu.conf の popupurl-browse にアクションコマンドでブラウザパス設定のプロパティ名を指定してください");
			return;
		}
		String cmd =App.root_property.getString(keyname);
		App.os_dependence.openURL("プロパティ"+keyname,cmd,url);
	}
});

App.action_manager.add( owner,"popupurl-other",new Action_(){
	public String GetName(){ return "popupurl-other"; }
	public String GetDesc(){ return "バッファで選択中のURLをmenu.confに指定したコマンドで開きます。";}
	public boolean isEnabled(){ return true;}
	public void actionPerformed(java.awt.event.ActionEvent e){
		String url = ActionUtility.readHoverOrSelected(e);
		if(url==null || url.length()==0 ) return;
		App.os_dependence.openURL("popupurl-otherのcommand指定",e.getActionCommand(),url);
	}
});

App.action_manager.add( owner,"popupurl-click",new Action_(){
	public String GetName(){ return "popupurl-click"; }
	public String GetDesc(){ return "バッファで選択中のURLをブラウザで開きます。";}
	public boolean isEnabled(){ return true;}
	public void actionPerformed(java.awt.event.ActionEvent e){
		// ブラウザの指定を読む
		String cmd = App.root_property.getString("BrowserName");
		if(cmd==null || cmd.length()==0){
			App.Log("環境設定のブラウザのパスが設定されていない");
			return ;
		}
		// パラメータを読む
		Object o=App.action_manager.getStackParameter();
		String url;

		boolean result=false;
		// バッファをクリックした
		if(o instanceof Object[]){
			Object[] arg = (Object[]) o;
			MouseEvent ee        =(MouseEvent)arg[0];
			buffer.LogDocument document =(buffer.LogDocument)arg[1];
			buffer.TextSpanInfo pos     =(buffer.TextSpanInfo)arg[2];
			if(ee.getClickCount()!=2) return;
			result = App.os_dependence.openURL("プロパティBrowserName",cmd,pos.text);
		}
		else if(o instanceof String) result = App.os_dependence.openURL("プロパティBrowserName",cmd,(String)o);
		else result = App.os_dependence.openURL("プロパティBrowserName",cmd,e.getActionCommand());
		// 成功したら 非nullを返す
		App.action_manager.setStackParameter(result?this:null);
	}
});


App.action_manager.add( owner,"texteditor-open",new Action_(){
	public String GetName(){ return "texteditor-open"; }
	public String GetDesc(){ return "指定したファイルをテキストエディタで開きます";}
	public boolean isEnabled(){ return true;}
	public void actionPerformed(java.awt.event.ActionEvent e){
		String s = ActionUtility.getStringParamater();
		if(s==null || s.length()==0 ) s = e.getActionCommand();
		if(s==null || s.length()==0 ){ App.Log("texteditor-open: 引数が不明"); return;}
		App.os_dependence.editTextFile(new File(s) );
	}
});

App.action_manager.add( owner,"buffer-list-sort",new Action_(){
	public String GetName(){ return "バッファ一覧のソート"; }
	public String GetDesc(){ return "バッファ一覧を整列します。";}
	public boolean isEnabled(){ return true;}
	public void actionPerformed(java.awt.event.ActionEvent e){
		App.buf_list.sortItem();
	}
});

App.action_manager.add( owner,"bluntirc-version",new Action_(){
	public String GetName(){ return "ビルド表記"; }
	public String GetDesc(){ return "ビルド表記を全てのメッセージに書きます";}
	public boolean isEnabled(){ return true;}
	public void actionPerformed(java.awt.event.ActionEvent e){
		App.Log(App.config_AppName+" build "+bdate.BuildDate.getVersion());
	}
});
App.action_manager.add( owner,"java-charset-list",new Action_(){
	public String GetName(){ return "Charset一覧"; }
	public String GetDesc(){ return "Charset一覧を全てのメッセージに書きます";}
	public boolean isEnabled(){ return true;}
	public void actionPerformed(java.awt.event.ActionEvent e){
		// 利用できる文字セット名の一覧
		for(Iterator it= Charset.availableCharsets().values().iterator(); it.hasNext();){
			Charset cs = (Charset) it.next();
			StringBuffer sb = new StringBuffer();
			sb.append( cs.displayName() );
			for(Iterator it2 = cs.aliases().iterator();it2.hasNext();){
				sb.append(" "+(String) it2.next());
			}
			App.Log(sb.toString());
		}
	}
});
App.action_manager.add( owner,"delaylog-flush",new Action_(){
	public String GetName(){ return "ログ出力のフラッシュ"; }
	public String GetDesc(){ return "出力を遅延させているログをファイルに出力します";}
	public boolean isEnabled(){ return true;}
	public void actionPerformed(java.awt.event.ActionEvent e){
		App.delay_log.flushAll();
	}
});

}}
