/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayType;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.Type;
import koala.dynamicjava.tree.visitor.Visitor;

public class VariableDeclaration
extends Node {
    public static final String FINAL = "final";
    public static final String TYPE = "type";
    public static final String NAME = "name";
    public static final String INITIALIZER = "initializer";
    private boolean finalVariable;
    private Type type;
    private String name;
    private Expression initializer;

    public VariableDeclaration(boolean fin, Type type, String name, Expression init) {
        this(fin, type, name, init, null, 0, 0, 0, 0);
    }

    public VariableDeclaration(boolean fin, Type type, String name, Expression init, String fn, int bl, int bc, int el, int ec) {
        super(fn, bl, bc, el, ec);
        if (type == null) {
            throw new IllegalArgumentException("type == null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        this.finalVariable = fin;
        this.type = type;
        this.name = name;
        this.initializer = init;
        if (type instanceof ArrayType && this.initializer instanceof ArrayInitializer) {
            ((ArrayInitializer)this.initializer).setElementType(((ArrayType)type).getElementType());
        }
    }

    public boolean isFinal() {
        return this.finalVariable;
    }

    public void setFinal(boolean b) {
        this.finalVariable = b;
        this.firePropertyChange(FINAL, this.finalVariable, this.finalVariable);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type t) {
        if (t == null) {
            throw new IllegalArgumentException("t == null");
        }
        this.type = t;
        this.firePropertyChange(TYPE, this.type, this.type);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s == null");
        }
        this.name = s;
        this.firePropertyChange(NAME, this.name, this.name);
    }

    public Expression getInitializer() {
        return this.initializer;
    }

    public void setInitializer(Expression e) {
        this.initializer = e;
        this.firePropertyChange(INITIALIZER, this.initializer, this.initializer);
    }

    public Object acceptVisitor(Visitor visitor) {
        return visitor.visit(this);
    }
}

