/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.List;
import java.util.ListIterator;
import koala.dynamicjava.tree.ConstructorInvocation;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.TreeUtilities;
import koala.dynamicjava.tree.visitor.Visitor;

public class ConstructorDeclaration
extends Node {
    public static final String ACCESS_FLAGS = "accessFlags";
    public static final String NAME = "name";
    public static final String PARAMETERS = "parameters";
    public static final String EXCEPTIONS = "exceptions";
    public static final String STATEMENTS = "statements";
    private int accessFlags;
    private String name;
    private List parameters;
    private List exceptions;
    private ConstructorInvocation constructorInvocation;
    private List statements;

    public ConstructorDeclaration(int flags, String name, List params, List excepts, ConstructorInvocation eci, List stmts) {
        this(flags, name, params, excepts, eci, stmts, null, 0, 0, 0, 0);
    }

    public ConstructorDeclaration(int flags, String name, List params, List excepts, ConstructorInvocation eci, List stmts, String fn, int bl, int bc, int el, int ec) {
        super(fn, bl, bc, el, ec);
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        if (params == null) {
            throw new IllegalArgumentException("params == null");
        }
        if (excepts == null) {
            throw new IllegalArgumentException("excepts == null");
        }
        if (stmts == null) {
            throw new IllegalArgumentException("stmts == null");
        }
        this.accessFlags = flags;
        this.name = name;
        this.parameters = params;
        this.constructorInvocation = eci;
        this.statements = stmts;
        this.exceptions = excepts;
        ListIterator<String> it = excepts.listIterator();
        while (it.hasNext()) {
            it.set(TreeUtilities.listToName((List)it.next()));
        }
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(int f) {
        this.accessFlags = f;
        this.firePropertyChange(ACCESS_FLAGS, this.accessFlags, this.accessFlags);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s == null");
        }
        this.name = s;
        this.firePropertyChange(NAME, this.name, this.name);
    }

    public List getParameters() {
        return this.parameters;
    }

    public void setParameters(List l) {
        this.parameters = l;
        this.firePropertyChange(PARAMETERS, this.parameters, this.parameters);
    }

    public List getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List l) {
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        this.exceptions = l;
        this.firePropertyChange(EXCEPTIONS, this.exceptions, this.exceptions);
    }

    public ConstructorInvocation getConstructorInvocation() {
        return this.constructorInvocation;
    }

    public void setConstructorInvocation(ConstructorInvocation ci) {
        this.constructorInvocation = ci;
    }

    public List getStatements() {
        return this.statements;
    }

    public void setStatements(List l) {
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        this.statements = l;
        this.firePropertyChange(STATEMENTS, this.statements, this.statements);
    }

    public Object acceptVisitor(Visitor visitor) {
        return visitor.visit(this);
    }
}

