/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classinfo;

import java.util.Iterator;
import java.util.List;
import koala.dynamicjava.classinfo.ClassFinder;
import koala.dynamicjava.classinfo.ClassInfo;
import koala.dynamicjava.classinfo.MethodInfo;
import koala.dynamicjava.classinfo.TypeVisitor;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.MethodDeclaration;

public class TreeMethodInfo
implements MethodInfo {
    private MethodDeclaration methodTree;
    private ClassFinder classFinder;
    private ClassInfo[] parameters;
    private ClassInfo[] exceptions;
    private ClassInfo declaringClass;
    private TypeVisitor typeVisitor;

    public TreeMethodInfo(MethodDeclaration f, ClassFinder cf, ClassInfo dc) {
        this.methodTree = f;
        this.classFinder = cf;
        this.declaringClass = dc;
        this.typeVisitor = new TypeVisitor(this.classFinder, this.declaringClass);
    }

    public MethodDeclaration getMethodDeclaration() {
        return this.methodTree;
    }

    public int getModifiers() {
        return this.methodTree.getAccessFlags();
    }

    public ClassInfo getReturnType() {
        return (ClassInfo)this.methodTree.getReturnType().acceptVisitor(this.typeVisitor);
    }

    public String getName() {
        return this.methodTree.getName();
    }

    public ClassInfo[] getParameterTypes() {
        if (this.parameters == null) {
            List ls = this.methodTree.getParameters();
            Iterator it = ls.iterator();
            this.parameters = new ClassInfo[ls.size()];
            int i = 0;
            while (it.hasNext()) {
                FormalParameter fp = (FormalParameter)it.next();
                this.parameters[i++] = (ClassInfo)fp.getType().acceptVisitor(this.typeVisitor);
            }
        }
        return (ClassInfo[])this.parameters.clone();
    }

    public ClassInfo[] getExceptionTypes() {
        if (this.exceptions == null) {
            List ls = this.methodTree.getExceptions();
            Iterator it = ls.iterator();
            this.exceptions = new ClassInfo[ls.size()];
            int i = 0;
            while (it.hasNext()) {
                this.exceptions[i++] = this.lookupClass((String)it.next(), this.declaringClass);
            }
        }
        return (ClassInfo[])this.exceptions.clone();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TreeMethodInfo)) {
            return false;
        }
        return this.methodTree.equals(((TreeMethodInfo)obj).methodTree);
    }

    protected ClassInfo lookupClass(String s, ClassInfo c) {
        try {
            if (c == null) {
                return this.classFinder.lookupClass(s, c);
            }
            return this.classFinder.lookupClass(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }
}

