/*
 * Decompiled with CFR 0.152.
 */
package irc;

import base.Util;
import irc.IRCChannel;
import irc.IRCChannelName;
import irc.IRCConnection;
import irc.IRCMessage;
import irc.IRCUser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class IRCMessageReader {
    public static Logger logger = Logger.getLogger("irc.ircmessagereader");
    protected static Map map;
    static StringBuffer log_sb;

    public abstract void dispach(IRCMessage var1) throws IndexOutOfBoundsException;

    public static int checkMessage(IRCMessage m) {
        m.log_from = m.from;
        int count = 0;
        LinkedList v = (LinkedList)map.get(m.cmd);
        if (v == null) {
            return 0;
        }
        int i = 0;
        while (i < v.size()) {
            IRCMessageReader r = (IRCMessageReader)v.get(i);
            try {
                r.dispach(m);
            }
            catch (IndexOutOfBoundsException e) {
                m.conn.Log("OnError", e.getMessage());
                break;
            }
            ++count;
            ++i;
        }
        return count;
    }

    public static void add(String key, IRCMessageReader r, int index) {
        LinkedList<IRCMessageReader> v = (LinkedList<IRCMessageReader>)map.get(key);
        if (v == null) {
            v = new LinkedList<IRCMessageReader>();
            map.put(key, v);
        }
        int i = 0;
        while (i < v.size()) {
            if (r == v.get(i)) {
                v.remove(i);
                break;
            }
            ++i;
        }
        if (index < 0) {
            index += v.size() + 1;
        }
        if (index < 0) {
            index = 0;
        }
        if (index >= v.size()) {
            v.add(r);
        } else {
            v.add(index, r);
        }
    }

    public static void remove(String key, IRCMessageReader r) {
        LinkedList v = (LinkedList)map.get(key);
        if (v == null) {
            v = new LinkedList();
            map.put(key, v);
        }
        int i = 0;
        while (i < v.size()) {
            if (r == v.get(i)) {
                v.remove(i);
                break;
            }
            ++i;
        }
    }

    public static Vector DivString(String key) {
        Vector<String> r = new Vector<String>();
        StreamTokenizer in = new StreamTokenizer(new StringReader(key));
        in.resetSyntax();
        in.wordChars(48, 57);
        in.wordChars(97, 122);
        in.wordChars(65, 90);
        in.wordChars(95, 95);
        in.whitespaceChars(32, 32);
        in.whitespaceChars(9, 9);
        in.whitespaceChars(10, 10);
        in.whitespaceChars(13, 13);
        in.parseNumbers();
        in.eolIsSignificant(true);
        in.slashStarComments(true);
        in.slashSlashComments(true);
        while (true) {
            try {
                int type = in.nextToken();
                if (type == -1) break;
                switch (type) {
                    case -2: {
                        r.add("" + (int)in.nval);
                        break;
                    }
                    case -3: {
                        r.add(in.sval);
                    }
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "parse error in DivString key=" + key, e);
            }
        }
        return r;
    }

    public static void add(String key, IRCMessageReader r) {
        Vector keys = IRCMessageReader.DivString(key);
        int i = 0;
        while (i < keys.size()) {
            key = (String)keys.get(i);
            log_sb.append(" " + key);
            IRCMessageReader.add(key, r, -1);
            ++i;
        }
    }

    public static void init() {
        log_sb.append("entry IRCMessageReader: ");
        IRCMessageReader.add("1", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                m.conn.fromServer = m.from;
                m.checkSize(1);
                byte[] text = m.getParam(m.size() - 1);
                int s = text.length;
                while (s > 0 && text[s - 1] != 32) {
                    --s;
                }
                m.conn.myself = m.conn.findUser(Util.ByteSubString(text, s, text.length));
                m.conn.getListener().ChangeNickMyself(m);
                m.conn.host001 = Util.fromJIS(m.conn.myself.getHostBytes());
                m.addContext(m.conn);
                m.conn.ConnAuthorized(m);
            }
        });
        IRCMessageReader.add("2", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                m.log_msg = m.getTrail(1);
                String key = "Your host is ";
                int start = m.log_msg.indexOf(key);
                if (start != -1) {
                    int i = start += key.length();
                    while (i < m.log_msg.length() && -1 == " ,".indexOf(m.log_msg.charAt(i))) {
                        ++i;
                    }
                    if (i > start) {
                        m.conn.fromServer = m.conn.findUser(Util.AsciiToByteArray(m.log_msg.substring(start, i)));
                        m.conn.Log("OnServerName", m.conn.fromServer.getEscapedName());
                    }
                }
            }
        });
        IRCMessageReader.add("464", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                m.log_msg = m.getTrail(1);
                if (m.conn.myself == null) {
                    m.conn.fAutoReconnect = false;
                    m.params_str = m.params_str + "(\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u305f\u3088\u3046\u3067\u3059\u3002\u81ea\u52d5\u518d\u63a5\u7d9a\u3092\u7121\u52b9\u306b\u3057\u307e\u3059\u3002)";
                }
            }
        });
        IRCMessageReader.add("3,4", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
            }
        });
        IRCMessageReader.add("376,422", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                IRCConnection cfr_ignored_0 = m.conn;
                m.conn.SendToServer(IRCConnection.encodeString("WHO " + m.conn.myself.getName()));
                m.conn.getListener().OnConnectMOTDEnd(m);
            }
        });
        IRCMessageReader.add("433", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                if (m.conn.myself == null) {
                    m.conn.SetNick(m.conn.getListener().getNickName(m.conn, false));
                }
            }
        });
        IRCMessageReader.add("352", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                IRCUser user;
                String RealName;
                m.checkSize(6);
                byte[] sender = m.getParam(0);
                byte[] channel = m.getParam(1);
                byte[] loginname = m.getParam(2);
                byte[] host = m.getParam(3);
                byte[] server = m.getParam(4);
                byte[] nick = m.getParam(5);
                byte[] homegone = m.getParam(6);
                if (homegone[0] >= 65 && homegone[0] <= 90) {
                    RealName = m.getTrail(7);
                } else {
                    homegone = new byte[]{63};
                    RealName = m.getTrail(6);
                }
                int hopcount = -1;
                int pos = RealName.indexOf(32);
                if (pos != -1 && pos > 0) {
                    int i = 0;
                    while (i < pos) {
                        char c = RealName.charAt(i);
                        if (c < '0' || c > '9') {
                            hopcount = -2;
                            break;
                        }
                        ++i;
                    }
                    if (hopcount == -1) {
                        hopcount = Integer.parseInt(RealName.substring(0, pos));
                        RealName = RealName.substring(pos + 1);
                    }
                }
                try {
                    ByteArrayOutputStream ba = new ByteArrayOutputStream();
                    ba.write(nick);
                    ba.write(33);
                    ba.write(loginname);
                    ba.write(64);
                    ba.write(host);
                    user = m.conn.findUser(ba.toByteArray());
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "paese who reply", e);
                    user = m.conn.findUser(nick);
                }
                user.setWhoReply(server, hopcount, RealName, homegone);
                m.log_msg = "server=" + Util.fromJIS(server) + " hop=" + hopcount + " realname=" + RealName;
                m.log_to = user;
                boolean found = false;
                IRCChannel chan = m.conn.FindChannel(channel, false);
                if (chan != null && chan.OnWhoReply(m, user)) {
                    m.log_context = chan;
                    m.conn.getListener().OnWhoReply(m, chan, user);
                } else {
                    m.conn.getListener().OnWhoReply(m, null, user);
                }
            }
        });
        IRCMessageReader.add("353", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                if (m.size() < 2) {
                    return;
                }
                byte[] channel_type = m.getParam(1);
                IRCChannel chan = m.setChannelContext(m.getParam(2));
                m.log_msg = m.getTrail(0);
                int i = 3;
                while (i < m.size()) {
                    byte[] left = m.getParam(i);
                    int start = 0;
                    int p = 0;
                    while (true) {
                        if (p < left.length && 32 == left[p]) {
                            ++p;
                            continue;
                        }
                        if (p >= left.length) break;
                        String mode = "";
                        while (-1 != "@+".indexOf(left[p])) {
                            mode = mode + (char)left[p];
                            ++p;
                        }
                        start = p;
                        while (p < left.length && left[p] != 32) {
                            ++p;
                        }
                        if (start == p) break;
                        IRCUser user = m.conn.findUser(Util.ByteSubString(left, start, p));
                        if (m.conn.myself.equals(user)) {
                            if (chan.OnJoinMyself()) {
                                m.conn.getListener().ChangeChannelJoin(m.conn, chan, true);
                            }
                            chan.AddUser(m, m.conn.myself, mode);
                            continue;
                        }
                        chan.AddUser(m, user, mode);
                    }
                    ++i;
                }
            }
        });
        IRCMessageReader.add("331,332", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                m.checkSize(2);
                IRCChannel chan = m.setChannelContext(m.getParam(1));
                m.log_msg = m.getTrail(2);
                chan.setTopic(m.log_msg);
                m.conn.getListener().ChangeTopic(m, chan);
            }
        });
        IRCMessageReader.add("TOPIC", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                m.checkSize(2);
                IRCChannel chan = m.setChannelContext(m.getParam(0));
                m.log_msg = m.getTrail(1);
                chan.setTopic(m.log_msg);
                m.conn.getListener().ChangeTopic(m, chan);
            }
        });
        IRCMessageReader.add("PING", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                IRCConnection cfr_ignored_0 = m.conn;
                m.conn.SendToServer(IRCConnection.encodeString("PONG " + m.params_str), true, true);
                m.log_msg = m.getTrail(0);
                m.addContext(m.conn);
            }
        });
        IRCMessageReader.add("QUIT", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                m.log_msg = m.getTrail(0);
                List channels = m.conn.getChannels();
                if (m.from.equals(m.conn.myself)) {
                    Iterator it = channels.iterator();
                    while (it.hasNext()) {
                        IRCChannel chan = (IRCChannel)it.next();
                        if (chan.OnPartMyself()) {
                            m.addContext(chan);
                            m.conn.getListener().ChangeChannelJoin(m.conn, chan, false);
                        }
                        chan.RemoveUserAll(m.conn);
                    }
                    m.conn.removeUserAll();
                } else {
                    Iterator it = channels.iterator();
                    while (it.hasNext()) {
                        IRCChannel chan = (IRCChannel)it.next();
                        if (!chan.RemoveUser(m, m.from)) continue;
                        m.addContext(chan);
                    }
                    m.conn.removeUser(m.from);
                }
            }
        });
        IRCMessageReader.add("PRIVMSG,NOTICE", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                m.checkSize(2);
                byte[] msg_target = m.getParam(0);
                m.log_msg = m.getTrail(1);
                if (m.from.equals(m.conn.myself) && m.log_msg.length() == 0) {
                    m.hideMessage = true;
                    return;
                }
                if (m.ctcp != null && m.ctcp.size() != 0 && m.log_msg.length() == 0) {
                    m.hideMessage = true;
                    m.log_to = new IRCChannelName(msg_target);
                    return;
                }
                if (IRCChannelName.isChannelName(msg_target)) {
                    m.setChannelContext(msg_target);
                    return;
                }
                IRCUser to = m.conn.findUser(msg_target);
                m.log_to = to;
                if (-1 != Util.ByteIndexOf(msg_target, '.')) {
                    m.addContext(m.conn);
                    return;
                }
                m.cmd = m.cmd + "_u";
                IRCChannel chan = to == m.conn.myself ? m.conn.FindChannel(m.from, true) : m.conn.FindChannel(to, true);
                m.log_context = chan;
                m.addContext(chan);
            }
        });
        IRCMessageReader.add("JOIN", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                m.checkSize(1);
                Vector<byte[]> channels = new Vector<byte[]>();
                byte[] ba = m.getParam(0);
                int i = 0;
                while (i < ba.length) {
                    int start = i;
                    i = ba.length;
                    byte[] b = Util.ByteSubString(ba, start, i);
                    channels.add(b);
                    ++i;
                }
                int c = 0;
                while (c < channels.size()) {
                    byte[] cname = (byte[])channels.get(c);
                    int div = Util.ByteIndexOf(cname, 7);
                    IRCChannel chan = m.conn.FindChannel(cname, true);
                    m.addContext(chan);
                    m.log_dupForAllLog = true;
                    if (m.from.equals(m.conn.myself) && chan.OnJoinMyself()) {
                        m.conn.getListener().ChangeChannelJoin(m.conn, chan, true);
                    }
                    chan.AddUser(m, m.from, "");
                    if (div != -1) {
                        char toggle = '+';
                        int i2 = div + 1;
                        while (i2 < cname.length) {
                            char moji = (char)cname[i2];
                            switch (moji) {
                                case 'I': 
                                case 'O': 
                                case 'b': 
                                case 'e': 
                                case 'k': 
                                case 'l': 
                                case 'o': 
                                case 'v': {
                                    chan.SetChannelMode(m, toggle, moji, m.from);
                                }
                            }
                            ++i2;
                        }
                    }
                    ++c;
                }
            }
        });
        IRCMessageReader.add("PART", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                m.checkSize(1);
                Vector<IRCChannelName> channels = new Vector<IRCChannelName>();
                byte[] ba = m.getParam(0);
                int i = 0;
                while (i < ba.length) {
                    int start = i;
                    i = ba.length;
                    channels.add(new IRCChannelName(Util.ByteSubString(ba, start, i)));
                    ++i;
                }
                m.log_msg = m.getTrail(1);
                m.log_dupForAllLog = true;
                int i2 = 0;
                while (i2 < channels.size()) {
                    IRCChannel chan = m.conn.FindChannel((IRCChannelName)channels.get(i2), true);
                    m.addContext(chan);
                    if (m.from == m.conn.myself) {
                        if (chan.OnPartMyself()) {
                            m.conn.getListener().ChangeChannelJoin(m.conn, chan, false);
                        }
                        chan.RemoveUserAll(m.conn);
                    } else {
                        chan.RemoveUser(m, m.from);
                    }
                    ++i2;
                }
            }
        });
        IRCMessageReader.add("NICK", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                m.checkSize(1);
                byte[] from_nick = m.from.getNickBytes();
                m.log_to = new IRCChannelName(from_nick);
                m.from = m.conn.changeUserNick(m.from, m.getParam(0));
                m.log_msg = m.getTrail(2);
                boolean isMyself = false;
                if (m.from == m.conn.myself) {
                    isMyself = true;
                    m.addContext(m.conn);
                    m.conn.getListener().ChangeNickMyself(m);
                }
                List channels = m.conn.getChannels();
                int i = 0;
                while (i < channels.size()) {
                    ((IRCChannel)channels.get(i)).OnChangeNick(m, from_nick, m.from, isMyself);
                    ++i;
                }
            }
        });
        IRCMessageReader.add("KICK", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                m.checkSize(2);
                IRCChannel chan = m.setChannelContext(m.getParam(0));
                IRCUser user = m.conn.findUser(m.getParam(1));
                m.log_to = user;
                m.log_msg = m.getTrail(2);
                if (user.equals(m.conn.myself)) {
                    if (chan.OnPartMyself()) {
                        m.conn.getListener().ChangeChannelJoin(m.conn, chan, false);
                    }
                    chan.RemoveUserAll(m.conn);
                    m.conn.getListener().onChannelKicked(m);
                } else {
                    chan.RemoveUser(m, user);
                }
            }
        });
        IRCMessageReader.add("324", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                m.checkSize(3);
                IRCChannel chan = m.setChannelContext(m.getParam(1));
                m.log_msg = m.getTrail(2);
                chan.FixChannelMode(m, m.getParam(2));
            }
        });
        IRCMessageReader.add("MODE", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                m.checkSize(2);
                byte[] c_or_u = m.getParam(0);
                byte[] modebytes = m.getParam(1);
                if (IRCChannelName.isChannelName(c_or_u)) {
                    IRCChannel chan = m.setChannelContext(c_or_u);
                    m.log_msg = m.getTrail(0);
                    char toggle = '/';
                    int p_index = 2;
                    int i = 0;
                    while (i < modebytes.length) {
                        char c = (char)modebytes[i];
                        switch (c) {
                            case '+': 
                            case '-': 
                            case '/': {
                                toggle = c;
                                break;
                            }
                            case 'a': 
                            case 'i': 
                            case 'm': 
                            case 'n': 
                            case 'p': 
                            case 'q': 
                            case 'r': 
                            case 's': 
                            case 't': {
                                chan.SetChannelMode(m, toggle, c);
                                break;
                            }
                            case 'I': 
                            case 'O': 
                            case 'b': 
                            case 'e': 
                            case 'k': 
                            case 'l': 
                            case 'o': 
                            case 'v': {
                                chan.SetChannelMode(m, toggle, c, m.conn.findUser(m.getParam(p_index++)));
                            }
                        }
                        ++i;
                    }
                }
            }
        });
        IRCMessageReader.add("CTCP_ACTION", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                if (IRCChannelName.isChannelName(m.log_to.getRawBytes())) {
                    m.setChannelContext(m.log_to.getRawBytes());
                    return;
                }
                if (-1 != Util.ByteIndexOf(m.log_to.getRawBytes(), '.')) {
                    m.addContext(m.conn);
                    return;
                }
                IRCUser to = m.conn.findUser(m.log_to.getRawBytes());
                m.cmd = m.cmd + "_u";
                IRCChannel chan = to.equals(m.conn.myself) ? m.conn.FindChannel(m.from, true) : m.conn.FindChannel(to, true);
                m.log_context = chan;
                m.addContext(chan);
            }
        });
        IRCMessageReader.add("CTCP_FINGER", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                if (m.ctcp_index < m.conn.getListener().getCTCPSendCueMaxInLine(m.conn) && m.ctcp_is_request) {
                    Vector<String> v = new Vector<String>();
                    v.add("FINGER");
                    v.add(":" + m.conn.getListener().getCTCPReplyFinger(m));
                    m.conn.SendCTCPReplyIfAvail(m.time, m.from, v);
                }
            }
        });
        IRCMessageReader.add("CTCP_VERSION", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                if (m.ctcp_index < m.conn.getListener().getCTCPSendCueMaxInLine(m.conn) && m.ctcp_is_request) {
                    Vector<String> v = new Vector<String>();
                    v.add("VERSION");
                    v.add(m.conn.getListener().getCTCPReplyVersion(m));
                    m.conn.SendCTCPReplyIfAvail(m.time, m.from, v);
                }
            }
        });
        IRCMessageReader.add("CTCP_SOURCE", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                if (m.ctcp_index < m.conn.getListener().getCTCPSendCueMaxInLine(m.conn) && m.ctcp_is_request) {
                    Vector<String> v = new Vector<String>();
                    v.add("SOURCE");
                    v.add("http://tate.undef.jp/pub/BluntIRC/BluntIRC.html");
                    m.conn.SendCTCPReplyIfAvail(m.time, m.from, v);
                }
            }
        });
        IRCMessageReader.add("CTCP_USERINFO", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                if (m.ctcp_index < m.conn.getListener().getCTCPSendCueMaxInLine(m.conn) && m.ctcp_is_request) {
                    Vector<String> v = new Vector<String>();
                    v.add("USERINFO");
                    v.add(":" + m.conn.getListener().getCTCPReplyUserInfo(m));
                    m.conn.SendCTCPReplyIfAvail(m.time, m.from, v);
                }
            }
        });
        IRCMessageReader.add("CTCP_CLIENTINFO", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                if (m.ctcp_index < m.conn.getListener().getCTCPSendCueMaxInLine(m.conn) && m.ctcp_is_request) {
                    String s = ":ACTION USERINFO SOURCE VERSION FINGER CLIENTINFO DCC PING TIME";
                    Vector<String> v = new Vector<String>();
                    v.add("CLIENTINFO");
                    v.add(s);
                    m.conn.SendCTCPReplyIfAvail(m.time, m.from, v);
                }
            }
        });
        IRCMessageReader.add("CTCP_PING", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                if (m.ctcp_index < m.conn.getListener().getCTCPSendCueMaxInLine(m.conn) && m.ctcp_is_request) {
                    Vector<Object> v = new Vector<Object>();
                    v.add("PING");
                    v.add(m.getParam(0));
                    m.conn.SendCTCPReplyIfAvail(m.time, m.from, v);
                    return;
                }
                if (!m.ctcp_is_request) {
                    m.conn.getListener().checkCTCPPingReply(m);
                }
            }
        });
        IRCMessageReader.add("CTCP_TIME", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                if (m.ctcp_index < m.conn.getListener().getCTCPSendCueMaxInLine(m.conn) && m.ctcp_is_request) {
                    Vector<String> v = new Vector<String>();
                    v.add("TIME");
                    v.add(":" + m.getDateStr() + " " + m.getTimeStr() + " " + m.time.getTimeZone().getDisplayName(Locale.US));
                    m.conn.SendCTCPReplyIfAvail(m.time, m.from, v);
                    return;
                }
            }
        });
        IRCMessageReader.add("CTCP_DCC", new IRCMessageReader(){

            public void dispach(IRCMessage m) throws IndexOutOfBoundsException {
                if (m.ctcp_index < m.conn.getListener().getCTCPSendCueMaxInLine(m.conn) && m.ctcp_is_request) {
                    m.conn.getListener().checkDCC(m);
                }
            }
        });
        logger.info(log_sb.toString());
        log_sb = null;
    }

    static {
        logger.setLevel(null);
        map = new HashMap();
        log_sb = new StringBuffer();
    }
}

