/*
 * Decompiled with CFR 0.152.
 */
package irc;

import base.Util;
import irc.CTCPQuote;
import irc.IRCChannel;
import irc.IRCChannelNameOrPrefix;
import irc.IRCConnection;
import irc.IRCLogContext;
import irc.IRCUser;
import java.io.ByteArrayOutputStream;
import java.util.GregorianCalendar;
import java.util.Vector;

public class IRCMessage {
    public GregorianCalendar time;
    public IRCConnection conn;
    public byte[] line;
    public IRCUser from;
    public String cmd;
    public Vector ctcp;
    public String params_str;
    protected Vector params;
    boolean ctcp_is_request;
    boolean config_checkParamsCount = true;
    int ctcp_index;
    public Object log_context = null;
    public IRCChannelNameOrPrefix log_from;
    public IRCChannelNameOrPrefix log_to;
    public String log_msg;
    public boolean hideMessage = false;
    public Vector target = new Vector();
    public boolean log_dupForAllLog = false;

    public String getTimeStr() {
        return Util.GetTimeStr(this.time);
    }

    public String getDateStr() {
        return Util.getDateStr(this.time);
    }

    public byte[] getParam(int index) {
        return (byte[])this.params.get(index);
    }

    public int size() {
        return this.params.size();
    }

    public void checkSize(int need) throws IndexOutOfBoundsException {
        if (this.size() < need) {
            throw new IndexOutOfBoundsException("server returns command with too few args : cmd=" + this.cmd + " need=" + need + " now=" + this.size() + " plain_line=" + Util.fromJIS(this.line));
        }
    }

    public IRCMessage(IRCConnection conn, String cmd, String log_msg) {
        this.conn = conn;
        this.from = conn.findUser(Util.AsciiToByteArray("*local*"));
        this.time = new GregorianCalendar(conn.getListener().getTimeZone(conn));
        this.cmd = cmd;
        this.params_str = this.log_msg = log_msg;
    }

    public IRCMessage(IRCConnection conn, byte[] ba) {
        this.conn = conn;
        this.time = new GregorianCalendar(conn.getListener().getTimeZone(conn));
        this.readFromBytes(ba);
    }

    protected IRCMessage(IRCMessage src, byte[] ba, int index) {
        int end;
        this.conn = src.conn;
        this.time = src.time;
        this.line = ba;
        this.from = src.from;
        this.ctcp_index = index;
        this.log_from = src.log_from;
        this.log_to = src.log_to;
        this.log_context = src.log_context;
        this.target = new Vector(0);
        this.ctcp_is_request = 0 == src.cmd.indexOf("PRIVMSG");
        int start = end = 0;
        while (end < ba.length && ba[end] != 32) {
            ++end;
        }
        this.cmd = "CTCP_" + Util.fromJIS(ba, start, end);
        while (end < ba.length && ba[end] == 32) {
            ++end;
        }
        this.params = new Vector();
        this.params.add(Util.ByteSubString(ba, end, ba.length));
        this.log_msg = this.params_str = Util.fromJIS(this.getParam(0));
    }

    public String toString() {
        StringBuffer pb = new StringBuffer();
        pb.append(Util.GetTimeStr(this.time));
        pb.append(' ');
        if (!(this.from == null || this.conn.fromServer != null && this.conn.fromServer.equals(this.from))) {
            pb.append(this.from.getNick());
        }
        pb.append(">");
        pb.append(this.cmd);
        if (this.params != null) {
            int start = 0;
            if (this.conn.myself != null && this.size() > 0 && this.conn.myself.equals(this.getParam(start))) {
                ++start;
                pb.append("*");
            } else {
                pb.append(" ");
            }
            int i = start;
            while (i < this.size()) {
                if (this.config_checkParamsCount) {
                    pb.append("(" + i + ")");
                } else if (i != start) {
                    pb.append(' ');
                }
                pb.append(Util.fromJIS(this.getParam(i)));
                ++i;
            }
        }
        return new String(pb);
    }

    /*
     * Unable to fully structure code
     */
    public void readFromBytes(byte[] ba) {
        block26: {
            this.line = ba;
            total = ba.length;
            p = 0;
            if (ba[p] == 58) {
                start = ++p;
                while (p < total && ba[p] != 32) {
                    ++p;
                }
                prefix_bytes = Util.ByteSubString(ba, start, p);
                while (p < total && ba[p] == 32) {
                    ++p;
                }
                if (this.conn.FirstPrefix == null) {
                    this.conn.FirstPrefix = prefix_bytes;
                }
                this.from = this.conn.findUser(prefix_bytes);
            } else {
                this.from = this.conn.findUser(this.conn.FirstPrefix != null ? this.conn.FirstPrefix : Util.AsciiToByteArray("*server*"));
            }
            start = p;
            while (p < total && ba[p] != 32) {
                ++p;
            }
            this.cmd = Util.fromJIS(ba, start, p);
            while (p < total && ba[p] == 32) {
                ++p;
            }
            isNumeric = true;
            i = 0;
            while (i < this.cmd.length()) {
                if (!Character.isDigit(this.cmd.charAt(i))) {
                    isNumeric = false;
                    break;
                }
                ++i;
            }
            if (isNumeric) {
                this.cmd = Integer.toString(Integer.parseInt(this.cmd));
            }
            params_start = p;
            this.params_str = Util.fromJIS(ba, params_start, total);
            this.params = new Vector<E>();
            if (!this.cmd.equals("PRIVMSG") && !this.cmd.equals("NOTICE")) ** GOTO lbl81
            start = p;
            while (p < total && ba[p] != 32) {
                ++p;
            }
            if (this.conn.getListener().isQuoteAllParam(this.conn)) {
                bao = new ByteArrayOutputStream();
                CTCPQuote.decodeParam(bao, ba, start, p);
                b = bao.toByteArray();
            } else {
                this.params.add(Util.ByteSubString(ba, start, p));
            }
            while (p < total && ba[p] == 32) {
                ++p;
            }
            if (p < total && ba[p] == 58) {
                ++p;
            }
            bao = new ByteArrayOutputStream();
            i = p;
            while (i < total) {
                start = i;
                while (i < ba.length && ba[i] != 1) {
                    ++i;
                }
                if (i > start) {
                    CTCPQuote.decodeParam(bao, ba, start, i);
                }
                if (++i < total) {
                    start = i;
                    while (i < ba.length && ba[i] != 1) {
                        ++i;
                    }
                    if (i > start) {
                        if (this.ctcp == null) {
                            this.ctcp = new Vector<E>();
                        }
                        this.ctcp.add(Util.ByteSubString(ba, start, i));
                    }
                }
                ++i;
            }
            this.params.add(bao.toByteArray());
            break block26;
            {
                ++p;
lbl81:
                // 2 sources

                while (true) {
                    block27: {
                        if (p < total && ba[p] == 32) continue block10;
                        if (p >= total) break block10;
                        start = p;
                        if (ba[p] != 58) ** GOTO lbl90
                        ++start;
                        p = total;
                        break block27;
lbl-1000:
                        // 1 sources

                        {
                            ++p;
lbl90:
                            // 2 sources

                            ** while (p < total && ba[p] != 32)
                        }
                    }
                    if (this.conn.getListener().isQuoteAllParam(this.conn)) {
                        bao = new ByteArrayOutputStream();
                        CTCPQuote.decodeParam(bao, ba, start, p);
                        b = bao.toByteArray();
                        continue;
                    }
                    this.params.add(Util.ByteSubString(ba, start, p));
                }
            }
        }
    }

    public IRCMessage[] getCTCP() {
        if (this.ctcp == null) {
            return null;
        }
        IRCMessage[] result = new IRCMessage[this.ctcp.size()];
        int i = 0;
        while (i < this.ctcp.size()) {
            byte[] ba = (byte[])this.ctcp.get(i);
            result[i] = new IRCMessage(this, ba, i);
            ++i;
        }
        return result;
    }

    public String getTrail(int index) {
        StringBuffer sb = new StringBuffer();
        while (index < this.size()) {
            sb.append(Util.fromJIS(this.getParam(index)));
            if (index != this.size() - 1) {
                sb.append(' ');
            }
            ++index;
        }
        return new String(sb);
    }

    public IRCMessage addContext(Object t) {
        if (t != null) {
            this.target.add(t);
        }
        return this;
    }

    public IRCChannel setChannelContext(byte[] name) {
        IRCChannel chan = this.conn.FindChannel(name, true);
        this.log_context = chan;
        this.log_to = chan.getCName();
        this.addContext(chan);
        return chan;
    }

    public void sendLogToListener() {
        if (this.hideMessage) {
            return;
        }
        int t = this.target.size();
        if (t == 0) {
            this.conn.getListener().OnLogEvent(this, this.conn, IRCLogContext.LB_All);
            this.conn.getListener().OnLogEvent(this, this.conn, IRCLogContext.LB_Conn);
            this.conn.getListener().OnLogEvent(this, this.conn, IRCLogContext.LF_Conn);
            this.conn.getListener().OnLogEvent(this, this.conn, IRCLogContext.LB_Dump);
            this.conn.getListener().OnLogEvent(this, this.conn, IRCLogContext.LF_Dump);
            return;
        }
        Object to = this.target.get(0);
        if (this.log_context != null) {
            this.log_dupForAllLog = false;
            to = this.log_context;
        }
        if (!this.log_dupForAllLog) {
            this.conn.getListener().OnLogEvent(this, to, IRCLogContext.LB_Dump);
            this.conn.getListener().OnLogEvent(this, to, IRCLogContext.LF_Dump);
            this.conn.getListener().OnLogEvent(this, to, IRCLogContext.LB_All);
        }
        int i = 0;
        while (i < t) {
            to = this.target.get(i);
            if (this.log_dupForAllLog) {
                this.conn.getListener().OnLogEvent(this, to, IRCLogContext.LB_Dump);
                this.conn.getListener().OnLogEvent(this, to, IRCLogContext.LF_Dump);
                this.conn.getListener().OnLogEvent(this, to, IRCLogContext.LB_All);
            }
            if (to instanceof IRCConnection) {
                this.conn.getListener().OnLogEvent(this, to, IRCLogContext.LB_Conn);
                this.conn.getListener().OnLogEvent(this, to, IRCLogContext.LF_Conn);
            } else if (to instanceof IRCChannel) {
                IRCChannel chan = (IRCChannel)to;
                if (chan.isChannel()) {
                    this.conn.getListener().OnLogEvent(this, to, IRCLogContext.LB_Chan);
                    this.conn.getListener().OnLogEvent(this, to, IRCLogContext.LF_Chan);
                } else {
                    this.conn.getListener().OnLogEvent(this, to, IRCLogContext.LB_Priv);
                    this.conn.getListener().OnLogEvent(this, to, IRCLogContext.LF_Priv);
                }
            }
            ++i;
        }
    }
}

