/*
 * Decompiled with CFR 0.152.
 */
package buffer;

import buffer.LogSelPos;

class LogSelectionRange {
    public LogSelPos start;
    public LogSelPos end;

    public final boolean isIn(LogSelPos pos) {
        return this.start.compareTo(pos) <= 0 && pos.compareTo(this.end) < 0;
    }

    public LogSelectionRange(LogSelPos _s, LogSelPos _e) {
        if (_s.compareTo(_e) < 0) {
            this.start = _s;
            this.end = _e;
        } else {
            this.start = _e;
            this.end = _s;
        }
    }

    public LogSelectionRange(LogSelectionRange src, int lineno, int endspan, int endoffset) {
        this.start = lineno == src.start.lineno ? src.start : new LogSelPos(0, 0);
        this.end = lineno == src.end.lineno ? src.end : new LogSelPos(endspan, endoffset);
    }

    public LogSelectionRange(LogSelectionRange src, int lineno, LogSelPos srcend) {
        this.start = lineno == src.start.lineno ? src.start : new LogSelPos(0, 0);
        this.end = lineno == src.end.lineno ? src.end : new LogSelPos(srcend.span, srcend.offset);
    }

    public boolean empty() {
        return this.start.lineno == this.end.lineno && this.start.span == this.end.span && this.start.offset == this.end.offset;
    }

    public void clear(int lineno) {
        this.start = new LogSelPos(lineno);
        this.end = new LogSelPos(lineno);
    }
}

