/*
 * Decompiled with CFR 0.152.
 */
package bluntirc;

import base.MyURL;
import base.Util;
import bluntirc.DecorationStack;
import bluntirc.DecorationStack2;
import bluntirc.KeywordMatching;
import bluntirc.PrintFormat;
import bluntirc.PrintFormatMacro;
import buffer.PackedLineWriter;
import buffer.StyleID;
import irc.IRCMessage;
import java.util.Iterator;
import java.util.List;

public class PrintFormatToTextSpan {
    public static String[] controlToText = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "\t", "%0a", "%0b", "%0c", "%0d", "%0e", "%0f", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1a", "%1b", "%1c", "%1d", "%1e", "%1f"};

    public static String getText(IRCMessage m, Object to, PrintFormat pf, boolean unshiftTime) {
        if (pf.NoDisp) {
            return null;
        }
        DecorationStack2 ary = new DecorationStack2();
        PrintFormatToTextSpan.read(ary, m, to, pf, unshiftTime, true);
        return ary.getText();
    }

    public static PackedLineWriter getTextLine(IRCMessage m, Object to, PrintFormat pf, boolean unshiftTime, StyleID sid) {
        if (pf.NoDisp) {
            return null;
        }
        DecorationStack ary = new DecorationStack(sid);
        PrintFormatToTextSpan.read(ary, m, to, pf, unshiftTime, false);
        return ary.getTextLine();
    }

    public static void read(DecorationStack ary, IRCMessage m, Object to, PrintFormat pf, boolean unshiftTime, boolean toFile) {
        if (unshiftTime) {
            if (!toFile) {
                ary.addPFStyle("time");
            }
            ary.add(m.getTimeStr());
            if (!toFile) {
                ary.addPFStyle(null);
            }
            ary.add(" ");
        }
        int i = 0;
        while (i < pf.macro.size()) {
            Object o = pf.macro.get(i);
            if (o instanceof String) {
                ary.add((String)o);
            } else {
                PrintFormatMacro pfm = (PrintFormatMacro)o;
                int s = pfm.getStyle();
                if (s != 0) {
                    if (!toFile) {
                        ary.addPFExtra(s, pfm.extra());
                    }
                } else {
                    String text = pfm.getText(m, to);
                    if (text != null) {
                        if (toFile) {
                            ary.add(text);
                        } else {
                            ary.addPFStyle(pfm.name());
                            if (pfm.allowCTCP()) {
                                PrintFormatToTextSpan.solveCTCP(m, to, ary, text);
                            } else {
                                PrintFormatToTextSpan.solveKeyword(m, to, ary, text);
                            }
                            ary.addPFStyle(null);
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected static void solveCTCP(IRCMessage m, Object to, DecorationStack ary, String text) {
        int lastColor = -1;
        boolean in_b = false;
        boolean in_r = false;
        boolean in_u = false;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c >= ' ') {
                int start = i++;
                while (i < text.length() && text.charAt(i) >= ' ') {
                    ++i;
                }
                PrintFormatToTextSpan.solveURL(m, to, ary, text.substring(start, i));
                --i;
            } else if (c == '\u0002') {
                in_b = !in_b;
                ary.addCTCPBold(in_b);
            } else if (c == '\u0016') {
                in_r = !in_r;
                ary.addCTCPReverse(in_r);
            } else if (c == '\u001f') {
                in_u = !in_u;
                ary.addCTCPUnder(in_u);
            } else if (c == '\u000f') {
                if (lastColor != -1) {
                    lastColor = -1;
                    ary.addCTCPColor(-1, -1);
                }
                if (in_b) {
                    in_b = !in_b;
                    ary.addCTCPBold(in_b);
                }
                if (in_r) {
                    in_r = !in_r;
                    ary.addCTCPReverse(in_r);
                }
                if (in_u) {
                    in_u = !in_u;
                    ary.addCTCPUnder(in_u);
                }
            } else if (c == '\u0003') {
                int fc;
                if (text.length() - i >= 3 && Util.isURIDigit(text.charAt(i + 1)) && Util.isURIDigit(text.charAt(i + 2)) && 0 <= (fc = Integer.parseInt(text.substring(i + 1, i + 3))) && fc < 16) {
                    int bc;
                    if (text.length() - i >= 6 && ',' == text.charAt(i + 3) && Util.isURIDigit(text.charAt(i + 4)) && Util.isURIDigit(text.charAt(i + 5)) && 0 <= (bc = Integer.parseInt(text.substring(i + 4, i + 6))) && bc < 16) {
                        lastColor = fc;
                        ary.addCTCPColor(lastColor, bc);
                        i += 5;
                    } else {
                        lastColor = fc;
                        ary.addCTCPColor(lastColor, -1);
                        i += 2;
                    }
                } else {
                    lastColor = -1;
                    ary.addCTCPColor(-1, -1);
                }
            } else {
                ary.add(controlToText[c]);
            }
            ++i;
        }
        if (lastColor != -1) {
            ary.addCTCPColor(-1, -1);
        }
        if (in_b) {
            ary.addCTCPBold(false);
        }
        if (in_r) {
            ary.addCTCPReverse(false);
        }
        if (in_u) {
            ary.addCTCPUnder(false);
        }
    }

    protected static void solveURL(IRCMessage m, Object to, DecorationStack ary, String text) {
        Iterator it = Util.URISplitter(text).iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof MyURL) {
                ary.addURLStyle("url");
                ary.add(((MyURL)o).toString());
                ary.addURLStyle(null);
                continue;
            }
            PrintFormatToTextSpan.solveKeyword(m, to, ary, (String)o);
        }
    }

    protected static void solveKeyword(IRCMessage m, Object to, DecorationStack ary, String text) {
        Iterator it = KeywordMatching.getExcludeList().iterator();
        while (it.hasNext()) {
            if (!((KeywordMatching)it.next()).check(text, 0)) continue;
            ary.add(text);
            return;
        }
        List key_list = KeywordMatching.getList();
        int i = 0;
        block1: while (i < text.length()) {
            int checkstart = i;
            Iterator it2 = key_list.iterator();
            while (it2.hasNext()) {
                KeywordMatching km = (KeywordMatching)it2.next();
                if (!km.check(text, checkstart)) continue;
                int matchstart = km.getLastMatchStart();
                i = matchstart + km.getLastMatchLength();
                if (matchstart > checkstart) {
                    ary.add(text.substring(checkstart, matchstart));
                }
                ary.addKWStyle(km.getStyleName());
                ary.add(text.substring(matchstart, i));
                ary.addKWStyle(null);
                continue block1;
            }
            ary.add(text.substring(checkstart));
            break;
        }
    }
}

