/*
 * Decompiled with CFR 0.152.
 */
package bluntirc;

import bluntirc.App;
import bluntirc.ChannelMemberView;
import bluntirc.InputAreaWrap;
import buffer.LogDocument;
import buffer.LogView;
import gui.ImagePanel;
import gui.MyScrollPane;
import gui.MySplitPaneUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class MainWindow
extends JFrame {
    public JSplitPane ChannelAndUserSplitter = new JSplitPane();
    public JSplitPane LRSplitter = new JSplitPane();
    public JSplitPane AllLogSplitter = new JSplitPane();
    public JPanel RightPanel = new JPanel();
    public ImagePanel image_panel;
    public ChannelMemberView user_view;
    public JScrollPane buflist_scroll;
    public InputAreaWrap input_area;
    public LogView log_view;
    public JTextField labelBufferInfo = new JTextField("");
    public JButton btnTalk;
    public JButton btnTopic2;
    public JButton btnNotice;
    public JButton btnAction;
    public JButton btnSendAll;
    public JButton btnURL;

    public MainWindow() {
        App.main_window = this;
        this.setTitle(App.config_AppName);
        this.setIconImage(App.icon_app.getImage());
        this.enableEvents(64L);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                App.getApp().AppExit("windowClosed");
            }
        });
        this.btnTalk = new JButton(App.action_manager.find("inputarea-send-privmsg"));
        JButton[] jb = new JButton[]{this.btnTalk, this.btnTopic2 = new JButton(App.action_manager.find("inputarea-send-topic")), this.btnNotice = new JButton(App.action_manager.find("inputarea-send-notice")), this.btnAction = new JButton(App.action_manager.find("inputarea-send-action")), this.btnSendAll = new JButton(App.action_manager.find("inputarea-send-all-channnel")), this.btnURL = new JButton(App.action_manager.find("buffer-url-list"))};
        int i = 0;
        while (i < jb.length) {
            jb[i].setRequestFocusEnabled(false);
            jb[i].setVerifyInputWhenFocusTarget(false);
            jb[i].setMargin(new Insets(0, 0, 0, 0));
            jb[i].setOpaque(false);
            ++i;
        }
        App.menu_conf.setJMenuBar(this);
        this.initGUI();
        this.updateOpaque();
        this.log_view.setDocument(App.console_doc);
        this.setSize(600, 200);
    }

    public void updateOpaque() {
        JRootPane root = this.getRootPane();
        JLayeredPane layer = root.getLayeredPane();
        JPanel glass = (JPanel)root.getGlassPane();
        JPanel content = (JPanel)root.getContentPane();
        JMenuBar menu = root.getJMenuBar();
        root.setBorder(null);
        root.setOpaque(false);
        layer.setBorder(null);
        layer.setOpaque(false);
        menu.setBorder(null);
        glass.setBorder(null);
        glass.setOpaque(false);
        content.setBorder(null);
        content.setOpaque(false);
        this.ChannelAndUserSplitter.setOpaque(false);
        this.AllLogSplitter.setOpaque(false);
        this.LRSplitter.setOpaque(false);
        this.RightPanel.setOpaque(false);
        this.LRSplitter.setBorder(null);
        this.LRSplitter.setContinuousLayout(false);
        this.ChannelAndUserSplitter.setContinuousLayout(false);
        this.log_view.setOpaque(false);
        this.labelBufferInfo.setEditable(false);
        this.labelBufferInfo.setOpaque(false);
        this.log_view.setPreferredSize(new Dimension(300, 200));
        this.btnTalk.setMargin(new Insets(0, 0, 0, 0));
        this.btnTopic2.setMargin(new Insets(0, 0, 0, 0));
        this.btnNotice.setMargin(new Insets(0, 0, 0, 0));
        this.btnAction.setMargin(new Insets(0, 0, 0, 0));
        this.btnSendAll.setMargin(new Insets(0, 0, 0, 0));
        this.btnURL.setMargin(new Insets(0, 0, 0, 0));
        this.btnTalk.setOpaque(false);
        this.btnTopic2.setOpaque(false);
        this.btnNotice.setOpaque(false);
        this.btnAction.setOpaque(false);
        this.btnSendAll.setOpaque(false);
        this.btnURL.setOpaque(false);
        App.buf_list.setOpaque(false);
        this.buflist_scroll.setBorder(null);
        this.buflist_scroll.setOpaque(false);
        this.buflist_scroll.getViewport().setOpaque(false);
        if (App.root_property.getBoolean("TransparentSplitPaneUI", false)) {
            this.ChannelAndUserSplitter.setUI(new MySplitPaneUI());
            this.LRSplitter.setUI(new MySplitPaneUI());
            this.AllLogSplitter.setUI(new MySplitPaneUI());
        }
        this.input_area.repair();
    }

    private void initGUI() {
        JComponent logarea_top;
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        AffineTransform at = gc.getDefaultTransform();
        App.logger.info("getGraphicsConfiguration.getDefaultTransform=" + at.toString());
        JLayeredPane layer = this.getRootPane().getLayeredPane();
        this.image_panel = new ImagePanel(layer);
        this.getContentPane().add(this.image_panel);
        boolean scrollbar_trans = App.root_property.setDefaultBoolean("TransparentScrollBarUI", false);
        this.buflist_scroll = new MyScrollPane(App.buf_list, scrollbar_trans);
        this.buflist_scroll.setPreferredSize(new Dimension(128, 120));
        App.buf_list.addItem(App.getApp());
        this.input_area = new InputAreaWrap();
        this.log_view = new LogView(scrollbar_trans);
        this.log_view.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.checkPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.checkPopup(e);
            }

            void checkPopup(MouseEvent e) {
                if (e.isPopupTrigger() && e.getComponent() instanceof LogView) {
                    LogView lv = (LogView)e.getComponent();
                    LogDocument doc = lv.getDocument();
                    if (doc == null) {
                        return;
                    }
                    lv.requestFocus();
                    App.menu_conf.showPopupMenu(e, doc.getMenuListener(), doc);
                }
            }
        });
        this.user_view = new ChannelMemberView(App.root_property.setDefaultBoolean("TransparentScrollBarUI", false));
        this.RightPanel.setLayout(new BorderLayout());
        if (App.log_all.isWindow()) {
            this.RightPanel.add((Component)this.log_view, "Center");
            this.RightPanel.add((Component)this.input_area.getComponent(), "South");
            logarea_top = this.RightPanel;
        } else {
            this.AllLogSplitter.setOrientation(0);
            this.AllLogSplitter.setResizeWeight(0.5);
            if (App.root_property.getBoolean("alllog_top", false)) {
                this.AllLogSplitter.add((Component)this.log_view, "right");
                this.AllLogSplitter.add((Component)App.log_all.getComponent(), "left");
                this.RightPanel.add((Component)this.AllLogSplitter, "Center");
                this.RightPanel.add((Component)this.input_area.getComponent(), "South");
                logarea_top = this.RightPanel;
            } else {
                this.RightPanel.add((Component)this.input_area.getComponent(), "South");
                this.RightPanel.add((Component)this.log_view, "Center");
                this.AllLogSplitter.add((Component)this.RightPanel, "left");
                this.AllLogSplitter.add((Component)App.log_all.getComponent(), "right");
                logarea_top = this.AllLogSplitter;
            }
        }
        this.ChannelAndUserSplitter.setOrientation(App.root_property.getBoolean("HorizontalLayout", false) ? 1 : 0);
        if (App.root_property.getBoolean("TopTree", false)) {
            this.ChannelAndUserSplitter.add((Component)this.user_view.getComponent(), "right");
            this.ChannelAndUserSplitter.add((Component)this.buflist_scroll, "left");
            this.ChannelAndUserSplitter.setResizeWeight(0.0);
            this.ChannelAndUserSplitter.setDividerLocation(-1);
        } else {
            this.ChannelAndUserSplitter.add((Component)this.user_view.getComponent(), "left");
            this.ChannelAndUserSplitter.add((Component)this.buflist_scroll, "right");
            this.ChannelAndUserSplitter.setResizeWeight(1.0);
            this.ChannelAndUserSplitter.setDividerLocation(-1);
        }
        if (App.root_property.getBoolean("RightTree", false)) {
            this.LRSplitter.add((Component)this.ChannelAndUserSplitter, "right");
            this.LRSplitter.add((Component)logarea_top, "left");
            this.LRSplitter.setResizeWeight(0.0);
        } else {
            this.LRSplitter.add((Component)this.ChannelAndUserSplitter, "left");
            this.LRSplitter.add((Component)logarea_top, "right");
            this.LRSplitter.setResizeWeight(1.0);
        }
        this.image_panel.setLayout(new BorderLayout());
        this.image_panel.add((Component)this.LRSplitter, "Center");
    }

    public void reloadBGInfoAll() {
        App.log_all.image_panel.reloadBGInfo(App.style_manager.findBGInfo(App.log_all.isWindow() ? "AllLog" : "MainWindow"));
        this.image_panel.reloadBGInfo(App.style_manager.findBGInfo("MainWindow"));
        this.user_view.reloadFontInfo();
        this.input_area.reloadFontInfo();
        App.buf_list.setFontInfo(App.style_manager.findFontInfo("ConnListCaption"), App.style_manager.findFontInfo("ConnListLabel2"), App.style_manager.findFontInfo("ConnListNumber"));
        App.menu_conf.load();
        App.menu_conf.setJMenuBar(this);
    }

    public void neatSplitter() {
        if (App.root_property.getBoolean("TopTree", false)) {
            this.ChannelAndUserSplitter.setDividerLocation((int)this.buflist_scroll.getPreferredSize().getWidth());
        } else {
            this.ChannelAndUserSplitter.setDividerLocation((double)this.ChannelAndUserSplitter.getWidth() - this.buflist_scroll.getPreferredSize().getWidth());
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            App.getApp().AppExit("WindowEvent.WINDOW_CLOSING");
        }
    }
}

