/*
 * Decompiled with CFR 0.152.
 */
package bluntirc;

import base.Util;
import bluntirc.ChannelMemberView;
import irc.IRCChannelMember;
import irc.IRCUser;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.swing.event.TableModelEvent;

class ChannelMemberList {
    private static Logger logger = Logger.getLogger("bluntirc.channelmemberlist");
    ChannelMemberView view;
    public static Comparator nickname_comparator;
    LinkedList members_ary = new LinkedList();
    Comparator comparator = nickname_comparator;

    ChannelMemberList() {
    }

    public void removeView(ChannelMemberView v) {
        this.view = null;
    }

    public void addView(ChannelMemberView v) {
        this.view = v;
    }

    public int getRowCount() {
        return this.members_ary.size();
    }

    public IRCChannelMember getByRow(int row) {
        return (IRCChannelMember)this.members_ary.get(row);
    }

    public int findNick(byte[] key) {
        int i = 0;
        Iterator it = this.members_ary.iterator();
        while (it.hasNext()) {
            IRCChannelMember m = (IRCChannelMember)it.next();
            if (nickname_comparator.compare(m, key) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int findInsertPoint(IRCChannelMember key) {
        int i = 0;
        Iterator it = this.members_ary.iterator();
        while (it.hasNext()) {
            IRCChannelMember m = (IRCChannelMember)it.next();
            if (this.comparator.compare(m, key) >= 0) {
                return i;
            }
            ++i;
        }
        return i;
    }

    public void sort(Comparator new_comparator) {
        if (new_comparator != null) {
            this.comparator = new_comparator;
        }
        Collections.sort(this.members_ary, this.comparator);
        if (this.view != null) {
            this.view.fireTableModelListener(new TableModelEvent(this.view));
        }
    }

    public void setWhoReply(IRCUser who) {
        int i = this.findNick(who.getNickBytes());
        if (i != -1 && this.view != null) {
            this.view.fireTableModelListener(new TableModelEvent(this.view, i, i, -1, 0));
        }
    }

    public void RemoveUserList(IRCChannelMember who) {
        int i = this.findNick(who.getUser().getNickBytes());
        if (i == -1) {
            return;
        }
        this.members_ary.remove(i);
        if (this.view != null) {
            this.view.fireTableModelListener(new TableModelEvent(this.view, i, i, -1, -1));
        }
    }

    public void AddUserList(IRCChannelMember who) {
        this.ChangeUserInfo(null, who);
    }

    public void ChangeUserInfo(byte[] from_nick, IRCChannelMember to) {
        int i = this.findNick(to.getUser().getNickBytes());
        if (i == -1 && from_nick != null) {
            logger.warning("ChangeUserInfo " + (from_nick == null ? "(null)" : Util.fromJIS(from_nick)) + "=>" + to.getUser().getName());
            i = this.findNick(from_nick);
        }
        if (i != -1) {
            this.members_ary.remove(i);
            if (this.view != null) {
                this.view.fireTableModelListener(new TableModelEvent(this.view, i, i, -1, -1));
            }
        }
        i = this.findInsertPoint(to);
        this.members_ary.add(i, to);
        if (this.view != null) {
            this.view.fireTableModelListener(new TableModelEvent(this.view, i, i, -1, 1));
        }
    }

    static {
        logger.setLevel(null);
        nickname_comparator = IRCUser.createComparator();
    }
}

