/*
 * Decompiled with CFR 0.152.
 */
package bluntirc;

import bluntirc.App;
import buffer.LogDocument;
import buffer.LogView;
import gui.ImagePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

public class AllLogWindow
extends JFrame {
    Container RootPane;
    public LogView log_view;
    public LogDocument doc;
    public ImagePanel image_panel;
    boolean is_window;

    boolean isWindow() {
        return this.is_window;
    }

    public AllLogWindow(boolean is_window) {
        super("\u5168\u3066\u306e\u30e1\u30c3\u30bb\u30fc\u30b8 - " + App.config_AppName);
        this.is_window = is_window;
        if (is_window) {
            this.RootPane = this.getContentPane();
            this.setIconImage(App.icon_app.getImage());
        }
        this.log_view = new LogView(App.root_property.setDefaultBoolean("TransparentScrollBarUI", false));
        this.log_view.addLogSweepListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                App.getApp().updateTopic();
            }
        });
        this.log_view.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.checkPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.checkPopup(e);
            }

            void checkPopup(MouseEvent e) {
                if (e.isPopupTrigger() && e.getComponent() instanceof LogView) {
                    LogView lv = (LogView)e.getComponent();
                    LogDocument doc = lv.getDocument();
                    if (doc == null) {
                        return;
                    }
                    lv.requestFocus();
                    App.menu_conf.showPopupMenu(e, doc.getMenuListener(), doc);
                }
            }
        });
        this.doc = new LogDocument(App.style_manager);
        this.log_view.setDocument(this.doc);
        LogView fore = this.log_view;
        fore.setOpaque(false);
        this.image_panel = new ImagePanel(this.RootPane);
        this.image_panel.mode = 1;
        if (is_window) {
            BorderLayout bl = new BorderLayout();
            bl.setVgap(0);
            bl.setHgap(0);
            this.image_panel.setLayout(bl);
            this.image_panel.add((Component)fore, "Center");
            this.RootPane.add(this.image_panel);
        }
    }

    public void show() {
        if (this.is_window) {
            super.show();
            super.setState(0);
            ActionMap actionmap = this.log_view.getActionMap();
            InputMap inputmap = this.log_view.getInputMap();
            String[] keyaction = new String[]{"edit-selectall", "edit-cut", "edit-copy", "edit-paste", "buffer-find-dialog", "buffer-find-next", "buffer-find-prev"};
            int i = 0;
            while (i < keyaction.length) {
                String name = keyaction[i];
                Action a = App.action_manager.find(name);
                KeyStroke k = App.menu_conf.findAccelerator(name);
                if (a != null && k != null) {
                    actionmap.put(name, a);
                    inputmap.put(k, name);
                }
                ++i;
            }
            this.log_view.setActionMap(actionmap);
            this.log_view.setInputMap(0, inputmap);
        }
    }

    public void hide() {
        if (this.is_window) {
            super.hide();
        }
    }

    public Rectangle getBounds() {
        if (this.is_window) {
            return super.getBounds();
        }
        return new Rectangle(0, 0, this.log_view.getWidth(), this.log_view.getHeight());
    }

    public boolean isShowing() {
        if (this.is_window) {
            return super.isShowing();
        }
        return true;
    }

    public void setBounds(Rectangle r) {
        if (this.is_window) {
            super.setBounds(r);
        }
    }

    public JComponent getComponent() {
        return this.log_view;
    }

    public void setSize(int x, int y) {
        if (this.is_window) {
            super.setSize(x, y);
        }
    }
}

