/*
 * Decompiled with CFR 0.152.
 */
package bluntirc;

import bluntirc.App;
import bluntirc.CTN_Chan;
import bluntirc.CTN_Conn;
import bluntirc.StyleManager;
import buffer.LogDocument;
import buffer.LogView;
import buffer.PackedLineReader;
import buffer.TextSpanInfo;
import gui.FontInfo2;
import irc.IRCChannelMember;
import irc.IRCConnection;
import irc.IRCUser;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JMenuItem;

public class ActionUtility {
    public static String getStringParamater() {
        Object o = App.action_manager.getStackParameter();
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public static String StringToArg(String src, int index) {
        if (src != null) {
            int i = 0;
            while (true) {
                if (i < src.length() && " \t\n".indexOf(src.charAt(i)) != -1) {
                    ++i;
                    continue;
                }
                int start = i;
                while (i < src.length() && " \t\n".indexOf(src.charAt(i)) == -1) {
                    ++i;
                }
                if (i > start && index == 0) {
                    return src.substring(start, i);
                }
                --index;
            }
        }
        return null;
    }

    public static CTN_Conn createConn(String name) {
        CTN_Conn r = new CTN_Conn(App.getApp(), name);
        return r;
    }

    public static void setUsersMode(String modeStr) {
        LinkedList users = App.main_window.user_view.getSelectedMulti();
        if (users != null) {
            CTN_Chan ctn = App.main_window.user_view.getChannelNode();
            IRCConnection conn = ctn.getConnNode().conn;
            while (0 != users.size()) {
                LinkedList<Object> v = new LinkedList<Object>();
                while (0 != users.size() && v.size() < 3) {
                    IRCChannelMember member = (IRCChannelMember)users.removeFirst();
                    IRCUser user = member.getUser();
                    if (user == conn.myself) continue;
                    v.add(user.getNickBytes());
                }
                if (v.size() == 0) continue;
                v.addFirst(modeStr.substring(0, v.size() + 1));
                v.addFirst(ctn.chan.getRawBytes());
                v.addFirst("MODE");
                conn.SendToServer(v);
            }
        }
    }

    public static String readHoverOrSelected(ActionEvent e) {
        TextSpanInfo info = ActionUtility.getLastHover(e);
        Object o = e.getSource();
        if (!(o instanceof JMenuItem)) {
            return null;
        }
        o = App.getFocusComponent();
        if (!(o instanceof LogView)) {
            return null;
        }
        LogView view = (LogView)o;
        LogDocument doc = view.getDocument();
        if (doc == null) {
            return null;
        }
        doc.getLastHover();
        if (info == null) {
            App.Log("readHoverOrSelected: getLastHover is null");
            return null;
        }
        return info.text;
    }

    public static TextSpanInfo getLastHover(ActionEvent e) {
        Object o = e.getSource();
        if (!(o instanceof JMenuItem)) {
            App.Log("getLastHover: \u30e1\u30cb\u30e5\u30fc\u304b\u3089\u547c\u3070\u308c\u305f\u306e\u3067\u306f\u306a\u3044\uff1f");
            return null;
        }
        o = App.getFocusComponent();
        if (!(o instanceof LogView)) {
            App.Log("getLastHover: FocusComponent is not LogView");
            return null;
        }
        LogView view = (LogView)o;
        LogDocument doc = view.getDocument();
        if (doc == null) {
            App.Log("getLastHover: getDocument is null");
            return null;
        }
        TextSpanInfo info = doc.getLastHover();
        if (info == null) {
            App.Log("getLastHover: doc.getLastHover is null");
            return null;
        }
        return info;
    }

    public static CTN_Conn getConnectionNode(TextSpanInfo info) {
        StyleManager sid = App.style_manager;
        PackedLineReader tsi = new PackedLineReader(info.block, info.line, sid, "base");
        Object o = App.getFocusComponent();
        if (!(o instanceof LogView)) {
            App.Log("getLastHover: FocusComponent is not LogView");
            return null;
        }
        LogView view = (LogView)o;
        LogDocument doc = view.getDocument();
        String name = null;
        while (tsi.hasNextSpan()) {
            FontInfo2 base_style;
            if (tsi.readSpan() == 0 || !(base_style = sid.getBaseStyle(tsi.baseid)).get(7).equals("%s")) continue;
            name = tsi.getSpanText();
            break;
        }
        if (name != null) {
            Iterator it = App.getApp().getChilds();
            while (it.hasNext()) {
                o = it.next();
                if (!(o instanceof CTN_Conn) || !((CTN_Conn)o).getName().equals(name)) continue;
                return (CTN_Conn)o;
            }
        }
        if (view == App.log_all.log_view) {
            if (name == null) {
                App.Log(info.text + "\u306ewhois\u3092\u3069\u306e\u63a5\u7d9a\u5148\u306b\u5bfe\u3057\u3066\u767a\u884c\u3059\u308c\u3070\u3044\u3044\u304b\u30ed\u30b0\u304b\u3089\u306f\u8aad\u3081\u306a\u304b\u3063\u305f\u3002(%s\u304c\u306a\u3044)");
            } else {
                App.Log(info.text + "\u306ewhois\u3092" + name + "\u306b\u305f\u305a\u306d\u3088\u3046\u3068\u3057\u305f\u304c\u3001\u63a5\u7d9a\u5148\u306e\u4e00\u89a7\u306b\u305d\u306e\u540d\u524d\u304c\u306a\u3044(\u524a\u9664\u307e\u305f\u306f\u30ea\u30cd\u30fc\u30e0\u3057\u307e\u3057\u305f\u306d?)");
            }
            return null;
        }
        return App.getSelectedConn();
    }
}

