/*
 * Decompiled with CFR 0.152.
 */
package action;

import action.Action_;
import action.ConnectionAndTarget;
import bdate.BuildDate;
import bluntirc.ActionUtility;
import bluntirc.App;
import bluntirc.CTN_Chan;
import bluntirc.CTN_Conn;
import bluntirc.CTN_Priv;
import bluntirc.ChannelMemberView;
import bluntirc.ConnTreeNode;
import bluntirc.PropertyInspector;
import bluntirc.PropertyManager;
import buffer.LogDocument;
import buffer.LogView;
import buffer.TextSpanInfo;
import dialog.AppConfDialog;
import dialog.ChannelDialog;
import dialog.ConnDialog;
import gui.OneLineDialog;
import gui.OneLineDialogListener;
import irc.IRCChannel;
import irc.IRCChannelMember;
import irc.IRCChannelName;
import irc.IRCChannelNameOrPrefix;
import irc.IRCConnection;
import irc.IRCUser;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.nio.charset.Charset;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public class BaseActions {
    public static Logger logger = Logger.getLogger("action.baseactions");

    public static void entry() {
        App owner = App.getApp();
        App.action_manager.add(owner, "app-dialog", new Action_(){

            public String GetName() {
                return "\u74b0\u5883\u8a2d\u5b9a";
            }

            public String GetDesc() {
                return App.config_AppName + "\u306e\u74b0\u5883\u8a2d\u5b9a\u3092\u884c\u3044\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                new AppConfDialog(App.getApp());
            }
        });
        App.action_manager.add(owner, "conn-dialog", new Action_(){
            int callcount = 0;

            public String GetName() {
                return "\u63a5\u7d9a\u5148\u306e\u8a2d\u5b9a";
            }

            public String GetDesc() {
                return "\u9078\u629e\u3057\u305f\u63a5\u7d9a\u5148\u306e\u8a2d\u5b9a\u3092\u7de8\u96c6\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return null != App.getSelectedConn();
            }

            public void actionPerformed(ActionEvent e) {
                CTN_Conn node = App.getSelectedConn();
                if (node != null) {
                    new ConnDialog(node);
                }
            }
        });
        App.action_manager.add(owner, "channel-dialog", new Action_(){

            public String GetName() {
                return "\u8a2d\u5b9a";
            }

            public String GetDesc() {
                return "\u9078\u629e\u3057\u305f\u30c1\u30e3\u30f3\u30cd\u30eb\u306e\u8a2d\u5b9a\u3092\u898b\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return App.getSelectedChannel() != null;
            }

            public void actionPerformed(ActionEvent e) {
                CTN_Chan node = App.getSelectedChannel();
                if (node != null) {
                    new ChannelDialog(node);
                }
            }
        });
        App.action_manager.add(owner, "connection-new", new Action_(){

            public String GetName() {
                return "\u63a5\u7d9a\u5148\u306e\u8ffd\u52a0";
            }

            public String GetDesc() {
                return "\u63a5\u7d9a\u5148\u306e\u8a2d\u5b9a\u3092\u30c4\u30ea\u30fc\u306b\u8ffd\u52a0\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                new ConnDialog(null);
            }
        });
        App.action_manager.add(owner, "app-save", new Action_(){

            public String GetName() {
                return "\u63a5\u7d9a\u8a2d\u5b9a\u4fdd\u5b58";
            }

            public String GetDesc() {
                return "\u63a5\u7d9a\u8a2d\u5b9a\u3092" + App.config_AppName + ".ini\u306b\u4fdd\u5b58\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                PropertyManager.resetSaveFlag();
                PropertyManager.save(App.getApp(), App.IniFileName);
            }
        });
        App.action_manager.add(owner, "allmessage-show", new Action_(){

            public String GetName() {
                return "\u300c\u5168\u3066\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u300d\u3092\u8868\u793a";
            }

            public String GetDesc() {
                return "\u300c\u5168\u3066\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u300d\u3092\u8868\u793a\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                App.getApp();
                App.log_all.show();
            }
        });
        App.action_manager.add(owner, "allmessage-clear", new Action_(){

            public String GetName() {
                return "\u300c\u5168\u3066\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u300d\u3092\u30af\u30ea\u30a2";
            }

            public String GetDesc() {
                return "\u300c\u5168\u3066\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u300d\u306e\u8868\u793a\u5185\u5bb9\u3092\u6d88\u53bb\u3057\u307e\u3059";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                App.getApp();
                App.log_all.doc.clear(App.main_window);
            }
        });
        App.action_manager.add(owner, "scriptslist-show", new Action_(){

            public String GetName() {
                return "\u30b9\u30af\u30ea\u30d7\u30c8\u4e00\u89a7";
            }

            public String GetDesc() {
                return "\u30b9\u30af\u30ea\u30d7\u30c8\u4e00\u89a7\u3092\u8868\u793a\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                App.script_manager.show();
            }
        });
        App.action_manager.add(owner, "app-exit", new Action_(){

            public String GetName() {
                return "<HTML><font color=\"red\">" + App.config_AppName + "\u306e\u7d42\u4e86</font>";
            }

            public String GetDesc() {
                return App.config_AppName + "\u3092\u7d42\u4e86\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                App.getApp().AppExit("menu action");
            }
        });
        App.action_manager.add(owner, "conn-start", new Action_(){

            public String GetName() {
                return "\u63a5\u7d9a\u958b\u59cb";
            }

            public String GetDesc() {
                return "\u63a5\u7d9a\u3092\u958b\u59cb\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return null != App.getSelectedConn() && !App.getSelectedConn().conn.isConnected();
            }

            public void actionPerformed(ActionEvent e) {
                CTN_Conn c = App.getSelectedConn();
                if (c != null && !c.conn.isConnected()) {
                    c.conn.Connect();
                }
            }
        });
        App.action_manager.add(owner, "conn-stop", new Action_(){

            public String GetName() {
                return "\u63a5\u7d9a\u7d42\u4e86";
            }

            public String GetDesc() {
                return "\u63a5\u7d9a\u3092\u7d42\u4e86\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return null != App.getSelectedConn() && App.getSelectedConn().conn.isConnected();
            }

            public void actionPerformed(ActionEvent e) {
                CTN_Conn c = App.getSelectedConn();
                if (c == null || !c.conn.isConnected()) {
                    return;
                }
                String message = (String)c.property.get("QuitMessage");
                if (message == null) {
                    message = "";
                }
                new OneLineDialog(App.main_window, App.config_AppName, "\u7d42\u4e86\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u6307\u5b9a\u3059\u308c", message, new OneLineDialogListener(this, new Object[]{c.conn}){
                    private final /* synthetic */ 11 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void apply(String value) {
                        IRCConnection conn = (IRCConnection)this.args[0];
                        conn.Disconnect(value);
                    }
                });
            }
        });
        App.action_manager.add(owner, "conn-nick-dialog", new Action_(){

            public String GetName() {
                return "\u30cb\u30c3\u30af\u30cd\u30fc\u30e0\u5909\u66f4";
            }

            public String GetDesc() {
                return "\u81ea\u5206\u306e\u30cb\u30c3\u30af\u30cd\u30fc\u30e0\u3092\u5909\u66f4\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return null != App.getSelectedConn() && App.getSelectedConn().conn.isConnected();
            }

            public void actionPerformed(ActionEvent e) {
                CTN_Conn c = App.getSelectedConn();
                if (c != null && c.conn.isConnected()) {
                    new OneLineDialog(App.main_window, App.config_AppName, c.getName() + "\u3067\u306e\u65b0\u3057\u3044\u30cb\u30c3\u30af\u30cd\u30fc\u30e0\u3092\u6307\u5b9a\u3059\u308c", c.conn.myself.getShortName(), new OneLineDialogListener(this, new Object[]{c.conn}){
                        private final /* synthetic */ 13 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void apply(String value) {
                            IRCConnection conn = (IRCConnection)this.args[0];
                            if (conn.isConnected()) {
                                Vector<String> v = new Vector<String>();
                                v.add("NICK");
                                v.add(value);
                                conn.SendToServer(v);
                            }
                        }
                    });
                }
            }
        });
        App.action_manager.add(owner, "channel-new", new Action_(){

            public String GetName() {
                return "\u30c1\u30e3\u30f3\u30cd\u30eb\u8ffd\u52a0";
            }

            public String GetDesc() {
                return "\u30c1\u30e3\u30f3\u30cd\u30eb\u307e\u305f\u306f\u3077\u308a\u3076\u7528\u306e\u30d0\u30c3\u30d5\u30a1\u3092\u30c4\u30ea\u30fc\u306b\u8ffd\u52a0\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return null != App.getSelectedConn() && App.getSelectedConn().conn.isConnected();
            }

            public void actionPerformed(ActionEvent e) {
                CTN_Conn c = App.getSelectedConn();
                if (c != null && c.conn.isConnected()) {
                    new OneLineDialog(App.main_window, App.config_AppName, c.getName() + "\u306b\u8ffd\u52a0\u3059\u308b\u30c1\u30e3\u30f3\u30cd\u30eb\u540d\u304b\u30d7\u30ea\u30d6\u5148\u306e\u30cb\u30c3\u30af\u3092\u6307\u5b9a\u3059\u308c", "", new OneLineDialogListener(this, new Object[]{c.conn}){
                        private final /* synthetic */ 15 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void apply(String value) {
                            IRCConnection conn = (IRCConnection)this.args[0];
                            if (value.length() == 0) {
                                return;
                            }
                            if (IRCChannelName.isChannelName(value.charAt(0))) {
                                Vector<Object> v = new Vector<Object>();
                                v.add("JOIN");
                                v.add(IRCChannelName.unescape(value));
                                conn.SendToServer(v);
                            } else {
                                IRCChannel chan = conn.FindChannel(value, true);
                                App.buf_list.select((ConnTreeNode)chan.Extra);
                            }
                        }
                    });
                }
            }
        });
        App.action_manager.add(owner, "conn-list-channel", new Action_(){

            public String GetName() {
                return "\u30c1\u30e3\u30f3\u30cd\u30eb\u4e00\u89a7";
            }

            public String GetDesc() {
                return "\u30b5\u30fc\u30d0\u304b\u3089\u30c1\u30e3\u30f3\u30cd\u30eb\u306e\u4e00\u89a7\u3092\u53d6\u5f97\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return App.getSelectedConn() != null && App.getSelectedConn().conn.isConnected();
            }

            public void actionPerformed(ActionEvent e) {
                CTN_Conn c = App.getSelectedConn();
                if (c != null && c.conn.isConnected()) {
                    App.Log(this.GetName() + ":\u672a\u5bfe\u5fdc");
                }
            }
        });
        App.action_manager.add(owner, "conn-ignore-edit", new Action_(){

            public String GetName() {
                return "\u7121\u8996\u30ea\u30b9\u30c8\u7de8\u96c6";
            }

            public String GetDesc() {
                return "\u7121\u8996\u30ea\u30b9\u30c8\u3092\u7de8\u96c6\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return App.getSelectedConn() != null;
            }

            public void actionPerformed(ActionEvent e) {
                CTN_Conn c = App.getSelectedConn();
                if (c != null) {
                    App.Log(this.GetName() + ":\u672a\u5bfe\u5fdc");
                }
            }
        });
        App.action_manager.add(owner, "conn-remove", new Action_(){

            public String GetName() {
                return "\u524a\u9664";
            }

            public String GetDesc() {
                return "\u9078\u629e\u3057\u305f\u63a5\u7d9a\u5148\u306e\u8a2d\u5b9a\u3092\u30c4\u30ea\u30fc\u304b\u3089\u524a\u9664\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return App.getSelectedConn() != null && !App.getSelectedConn().conn.isConnected();
            }

            public void actionPerformed(ActionEvent e) {
                CTN_Conn c = App.getSelectedConn();
                if (c != null && !c.conn.isConnected()) {
                    c.getParent().removeNode(c);
                }
            }
        });
        App.action_manager.add(owner, "channel-join", new Action_(){

            public String GetName() {
                return "\u53c2\u52a0";
            }

            public String GetDesc() {
                return "\u30c1\u30e3\u30f3\u30cd\u30eb\u306bjoin\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                CTN_Chan node = App.getSelectedChannel();
                return node != null && !node.chan.isInMyself();
            }

            public void actionPerformed(ActionEvent e) {
                CTN_Chan node = App.buf_list.getChannel();
                if (node != null && !node.chan.isInMyself()) {
                    node.OnMenuJoin();
                }
            }
        });
        App.action_manager.add(owner, "channel-name-copy", new Action_(){

            public String GetName() {
                return "\u30c1\u30e3\u30f3\u30cd\u30eb\u540d\u3092\u30b3\u30d4\u30fc";
            }

            public String GetDesc() {
                return "\u30c1\u30e3\u30f3\u30cd\u30eb\u540d\u3092\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                CTN_Chan node = App.getSelectedChannel();
                return node != null;
            }

            public void actionPerformed(ActionEvent e) {
                CTN_Chan node = App.buf_list.getChannel();
                if (node == null) {
                    return;
                }
                IRCChannel channel = node.getChannel();
                String s = e.getActionCommand();
                if (s == null) {
                    s = "";
                }
                String name = null;
                name = s.equals("ShortName") ? channel.getShortName() : (s.equals("PrintableName") ? channel.getPrintableName() : (s.equals("EscapedName") ? channel.getEscapedName() : channel.getName()));
                App.os_dependence.Copy(name);
            }
        });
        App.action_manager.add(owner, "channel-part", new Action_(){

            public String GetName() {
                return "\u9000\u5ba4";
            }

            public String GetDesc() {
                return "\u30c1\u30e3\u30f3\u30cd\u30eb\u304b\u3089\u9000\u5ba4\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                CTN_Chan node = App.getSelectedChannel();
                return node != null && node.chan.isInMyself();
            }

            public void actionPerformed(ActionEvent e) {
                CTN_Chan node = App.getSelectedChannel();
                if (node == null) {
                    return;
                }
                String PartMessage = (String)node.property.get("PartMessage");
                if (PartMessage == null || PartMessage.length() == 0) {
                    PartMessage = (String)node.getParent().property.get("PartMessage");
                }
                if (PartMessage == null) {
                    PartMessage = "";
                }
                new OneLineDialog(App.main_window, App.config_AppName, "\u9000\u51fa\u30e1\u30c3\u30bb\u30fc\u30b8", PartMessage, new OneLineDialogListener(this, new Object[]{node}){
                    private final /* synthetic */ 22 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void apply(String value) {
                        CTN_Chan node = (CTN_Chan)this.args[0];
                        if (node != null && node.chan.isInMyself()) {
                            node.OnMenuPart(value);
                        }
                    }
                });
            }
        });
        App.action_manager.add(owner, "channel-topic-dialog", new Action_(){

            public String GetName() {
                return "\u30c8\u30d4\u30c3\u30af\u8a2d\u5b9a";
            }

            public String GetDesc() {
                return "\u30c1\u30e3\u30f3\u30cd\u30eb\u306e\u30c8\u30d4\u30c3\u30af\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                CTN_Chan node = App.getSelectedChannel();
                return node != null && node.chan.isInMyself();
            }

            public void actionPerformed(ActionEvent e) {
                CTN_Chan node = App.getSelectedChannel();
                new OneLineDialog(App.main_window, App.config_AppName, "\u65b0\u3057\u3044\u30c8\u30d4\u30c3\u30af\u3092\u6307\u5b9a\u3059\u308c", node.chan.getTopic(), new OneLineDialogListener(this, new Object[]{node}){
                    private final /* synthetic */ 24 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void apply(String value) {
                        CTN_Chan node = (CTN_Chan)this.args[0];
                        if (node != null && node.chan.isInMyself()) {
                            node.OnMenuTopic(value);
                        }
                    }
                });
            }
        });
        App.action_manager.add(owner, "channel-ban-dialog", new Action_(){

            public String GetName() {
                return "ban\u30ea\u30b9\u30c8\u7de8\u96c6";
            }

            public String GetDesc() {
                return "\u30c1\u30e3\u30f3\u30cd\u30eb\u306eban\u30ea\u30b9\u30c8\u3092\u7de8\u96c6\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                App.Log(this.GetName() + ":\u672a\u5bfe\u5fdc");
            }
        });
        App.action_manager.add(owner, "channel-remove", new Action_(){

            public String GetName() {
                return "\u524a\u9664";
            }

            public String GetDesc() {
                return "\u9078\u629e\u3057\u305f\u30c1\u30e3\u30f3\u30cd\u30eb\u3092\u30c4\u30ea\u30fc\u304b\u3089\u524a\u9664\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                CTN_Chan node = App.getSelectedChannel();
                return node != null && !node.chan.isInMyself();
            }

            public void actionPerformed(ActionEvent e) {
                CTN_Chan node = App.getSelectedChannel();
                if (node != null && !node.chan.isInMyself()) {
                    node.getParent().removeNode(node);
                }
            }
        });
        App.action_manager.add(owner, "irc-call1", new Action_(){

            public String GetName() {
                return "irc-call1";
            }

            public String GetDesc() {
                return "IRC\u30b3\u30de\u30f3\u30c9\u3092\u5b9f\u884c\u3057\u307e\u3059\u3002\u5f15\u6570\u306f\u30c1\u30e3\u30f3\u30cd\u30eb\u540d\u304b\u30cb\u30c3\u30af\u30cd\u30fc\u30e0";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand().toUpperCase();
                if (command == null || command.length() == 0) {
                    App.Log("irc-call1 \u306b\u30a2\u30af\u30b7\u30e7\u30f3\u30b3\u30de\u30f3\u30c9\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044");
                }
                ConnectionAndTarget ct = new ConnectionAndTarget(e);
                if (ct.node != null && ct.target != null) {
                    int i = 0;
                    while (i < ct.target.length) {
                        Object o = ct.target[i];
                        if (o instanceof IRCChannelMember) {
                            o = ((IRCChannelMember)o).getUser();
                        }
                        if (o instanceof CTN_Chan) {
                            o = ((CTN_Chan)o).GetChannel();
                        }
                        if (o instanceof CTN_Priv) {
                            o = ((CTN_Priv)o).GetChannel();
                        }
                        if (o instanceof IRCChannelNameOrPrefix) {
                            LinkedList<Object> v = new LinkedList<Object>();
                            v.add(command);
                            v.add(((IRCChannelNameOrPrefix)o).getRawBytes());
                            ct.node.conn.SendToServer(v);
                        } else {
                            App.Log("irc-call1:unknown target type:" + o.getClass().getName());
                        }
                        ++i;
                    }
                }
            }
        });
        App.action_manager.add(owner, "priv-open", new Action_(){

            public String GetName() {
                return "\u3077\u308a\u3076\u7a93\u4f5c\u6210";
            }

            public String GetDesc() {
                return "\u500b\u5225\u306b\u8a71\u3059\u305f\u3081\u306e\u30d0\u30c3\u30d5\u30a1\u3092\u4f5c\u6210\u3057\u307e\u3059";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                ConnectionAndTarget ct = new ConnectionAndTarget(e);
                if (ct.node != null && ct.target != null) {
                    int i = 0;
                    while (i < ct.target.length) {
                        Object o = ct.target[i];
                        if (o instanceof IRCChannelMember) {
                            o = ((IRCChannelMember)o).getUser();
                        }
                        if (o instanceof CTN_Chan) {
                            o = ((CTN_Chan)o).GetChannel();
                        }
                        if (o instanceof CTN_Priv) {
                            o = ((CTN_Priv)o).GetChannel();
                        }
                        if (o instanceof IRCChannelNameOrPrefix) {
                            IRCUser user = ct.node.conn.findUser(((IRCChannelNameOrPrefix)o).getRawBytes());
                            if (user != null) {
                                IRCChannel chan = ct.node.conn.FindChannel(user, true);
                                App.buf_list.select((ConnTreeNode)chan.Extra);
                            }
                        } else {
                            App.Log("irc-call1:unknown target type:" + o.getClass().getName());
                        }
                        ++i;
                    }
                }
            }
        });
        App.action_manager.add(owner, "priv-ignore-add", new Action_(){

            public String GetName() {
                return "\u7121\u8996\u30ea\u30b9\u30c8\u8ffd\u52a0";
            }

            public String GetDesc() {
                return "\u3077\u308a\u3076\u30d0\u30c3\u30d5\u30a1\u306e\u76f8\u624b\u3092\u7121\u8996\u30ea\u30b9\u30c8\u306b\u8ffd\u52a0\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return false;
            }

            public void actionPerformed(ActionEvent e) {
                App.Log(this.GetName() + ":\u672a\u5bfe\u5fdc");
            }
        });
        App.action_manager.add(owner, "priv-remove", new Action_(){

            public String GetName() {
                return "\u524a\u9664";
            }

            public String GetDesc() {
                return "\u9078\u629e\u3057\u305f\u3077\u308a\u3076\u30d0\u30c3\u30d5\u30a1\u3092\u30c4\u30ea\u30fc\u304b\u3089\u524a\u9664\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                CTN_Priv node = App.getSelectedPriv();
                return node != null;
            }

            public void actionPerformed(ActionEvent e) {
                CTN_Priv node = App.getSelectedPriv();
                if (node != null) {
                    node.getParent().removeNode(node);
                }
            }
        });
        App.action_manager.add(owner, "cuser-op-add", new Action_(){

            public String GetName() {
                return "+o op\u6a29\u9650\u3092\u6e21\u3059";
            }

            public String GetDesc() {
                return "\u9078\u629e\u3057\u305f\u53c2\u52a0\u8005\u306b\u306a\u308b\u3068\u3092\u914d\u308a\u307e\u3059";
            }

            public boolean isEnabled() {
                return App.main_window != null && App.main_window.user_view != null && App.main_window.user_view.isSelectedMulti();
            }

            public void actionPerformed(ActionEvent e) {
                ActionUtility.setUsersMode("+ooo");
            }
        });
        App.action_manager.add(owner, "cuser-copy-nickname", new Action_(){

            public String GetName() {
                return "copy nickname";
            }

            public String GetDesc() {
                return "\u9078\u629e\u3057\u305f\u30e6\u30fc\u30b6\u306e\u30cb\u30c3\u30af\u30cd\u30fc\u30e0\u3092\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return App.main_window != null && App.main_window.user_view != null && App.main_window.user_view.isSelectedMulti();
            }

            public void actionPerformed(ActionEvent e) {
                LinkedList users = App.main_window.user_view.getSelectedMulti();
                if (users != null && users.size() != 0) {
                    StringBuffer sb = new StringBuffer();
                    while (0 != users.size()) {
                        IRCChannelMember user = (IRCChannelMember)users.removeFirst();
                        sb.append(user.getUser().getShortName());
                        sb.append('\n');
                    }
                    App.os_dependence.Copy(new String(sb));
                }
            }
        });
        App.action_manager.add(owner, "cuser-copy-prefix", new Action_(){

            public String GetName() {
                return "copy prefix";
            }

            public String GetDesc() {
                return "\u9078\u629e\u3057\u305f\u30e6\u30fc\u30b6\u306eprefix\u3092\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return App.main_window != null && App.main_window.user_view != null && App.main_window.user_view.isSelectedMulti();
            }

            public void actionPerformed(ActionEvent e) {
                LinkedList users = App.main_window.user_view.getSelectedMulti();
                if (users != null && users.size() != 0) {
                    StringBuffer sb = new StringBuffer();
                    boolean flag = false;
                    while (0 != users.size()) {
                        IRCChannelMember user = (IRCChannelMember)users.removeFirst();
                        sb.append(user.getUser().getEscapedName());
                        if (!flag) {
                            flag = true;
                            continue;
                        }
                        sb.append('\n');
                    }
                    App.os_dependence.Copy(new String(sb));
                }
            }
        });
        App.action_manager.add(owner, "cuser-ignore-add", new Action_(){

            public String GetName() {
                return "\u7121\u8996";
            }

            public String GetDesc() {
                return "\u9078\u629e\u3057\u305f\u53c2\u52a0\u8005\u3092\u7121\u8996\u3057\u307e\u3059\u3002\u6c38\u7d9a\u7684\u306a\u8a2d\u5b9a\u306f\u4ed6\u306e\u30e1\u30cb\u30e5\u30fc\u3067\u3002";
            }

            public boolean isEnabled() {
                return App.main_window != null && App.main_window.user_view != null && App.main_window.user_view.isSelectedMulti();
            }

            public void actionPerformed(ActionEvent e) {
                App.Log(this.GetName() + ":\u672a\u5bfe\u5fdc");
            }
        });
        App.action_manager.add(owner, "cuser-kick", new Action_(){

            public String GetName() {
                return "kick \u8ffd\u3044\u51fa\u3059";
            }

            public String GetDesc() {
                return "\u9078\u629e\u3057\u305f\u53c2\u52a0\u8005\u3092\u30c1\u30e3\u30f3\u30cd\u30eb\u304b\u3089\u8ffd\u3044\u51fa\u3057\u307e\u3059";
            }

            public boolean isEnabled() {
                return App.main_window != null && App.main_window.user_view != null && App.main_window.user_view.isSelectedMulti();
            }

            public void actionPerformed(ActionEvent e) {
                App.Log(this.GetName() + ":\u672a\u5bfe\u5fdc");
            }
        });
        App.action_manager.add(owner, "cuser-ban", new Action_(){

            public String GetName() {
                return "ban\u30ea\u30b9\u30c8\u8ffd\u52a0";
            }

            public String GetDesc() {
                return "\u9078\u629e\u3057\u305f\u53c2\u52a0\u8005\u3092ban\u3057\u307e\u3059";
            }

            public boolean isEnabled() {
                return App.main_window != null && App.main_window.user_view != null && App.main_window.user_view.isSelectedMulti();
            }

            public void actionPerformed(ActionEvent e) {
                App.Log(this.GetName() + ":\u672a\u5bfe\u5fdc");
            }
        });
        App.action_manager.add(owner, "cuser-op-remove", new Action_(){

            public String GetName() {
                return "-o";
            }

            public String GetDesc() {
                return "\u9078\u629e\u3057\u305f\u53c2\u52a0\u8005\u3092 -o \u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return App.main_window != null && App.main_window.user_view != null && App.main_window.user_view.isSelectedMulti();
            }

            public void actionPerformed(ActionEvent e) {
                ActionUtility.setUsersMode("-ooo");
            }
        });
        App.action_manager.add(owner, "cuser-voice-add", new Action_(){

            public String GetName() {
                return "+v \u767a\u8a00\u8005\u306b\u3059\u308b";
            }

            public String GetDesc() {
                return "\u9078\u629e\u3057\u305f\u53c2\u52a0\u8005\u3092\u767a\u8a00\u8005\u306b\u3057\u307e\u3059\u3002(+v)";
            }

            public boolean isEnabled() {
                return App.main_window != null && App.main_window.user_view != null && App.main_window.user_view.isSelectedMulti();
            }

            public void actionPerformed(ActionEvent e) {
                ActionUtility.setUsersMode("+vvv");
            }
        });
        App.action_manager.add(owner, "cuser-voice-remove", new Action_(){

            public String GetName() {
                return "-v";
            }

            public String GetDesc() {
                return "\u9078\u629e\u3057\u305f\u53c2\u52a0\u8005\u3092 -v \u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return App.main_window != null && App.main_window.user_view != null && App.main_window.user_view.isSelectedMulti();
            }

            public void actionPerformed(ActionEvent e) {
                ActionUtility.setUsersMode("-vvv");
            }
        });
        App.action_manager.add(owner, "ctcp-request", new Action_(){

            public String GetName() {
                return "CTCP request";
            }

            public String GetDesc() {
                return "CTCP\u30ea\u30af\u30a8\u30b9\u30c8\u3092\u767a\u884c\u3057\u307e\u3059";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand().toUpperCase();
                if (command == null || command.length() == 0) {
                    App.Log("ctcp-request \u306b\u30a2\u30af\u30b7\u30e7\u30f3\u30b3\u30de\u30f3\u30c9\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044");
                }
                ConnectionAndTarget ct = new ConnectionAndTarget(e);
                if (ct.node != null && ct.target != null) {
                    int i = 0;
                    while (i < ct.target.length) {
                        Object o = ct.target[i];
                        if (o instanceof IRCChannelMember) {
                            o = ((IRCChannelMember)o).getUser();
                        }
                        if (o instanceof CTN_Chan) {
                            o = ((CTN_Chan)o).GetChannel();
                        }
                        if (o instanceof CTN_Priv) {
                            o = ((CTN_Priv)o).GetChannel();
                        }
                        if (o instanceof IRCChannelNameOrPrefix) {
                            long now = new GregorianCalendar().getTime().getTime();
                            LinkedList<String> v = new LinkedList<String>();
                            v.add(command);
                            if (command.equals("PING")) {
                                v.add(Long.toString(new GregorianCalendar().getTime().getTime()));
                            }
                            ct.node.conn.SendToServer(ct.node.conn.encodeCTCP(((IRCChannelNameOrPrefix)o).getRawBytes(), v, "PRIVMSG"));
                        } else {
                            App.Log("unknown target type:" + o.getClass().getName());
                        }
                        ++i;
                    }
                }
            }
        });
        App.action_manager.add(owner, "buffer-select-all", new Action_(){

            public String GetName() {
                return "\u5168\u3066\u9078\u629e";
            }

            public String GetDesc() {
                return "\u8868\u793a\u3055\u308c\u3066\u3044\u308b\u30d0\u30c3\u30d5\u30a1\u306e\u30c6\u30ad\u30b9\u30c8\u3092\u5168\u3066\u9078\u629e\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                LogDocument d;
                ConnTreeNode ctn;
                return App.buf_list != null && null != (ctn = App.buf_list.getSelected()) && null != (d = ctn.getLogDocument());
            }

            public void actionPerformed(ActionEvent e) {
                LogDocument d;
                ConnTreeNode ctn;
                if (App.buf_list != null && null != (ctn = App.buf_list.getSelected()) && null != (d = ctn.getLogDocument())) {
                    d.selectAll();
                }
            }
        });
        App.action_manager.add(owner, "buffer-paste-to-input", new Action_(){

            public String GetName() {
                return "\u9078\u629e\u7bc4\u56f2\u3092\u5165\u529b\u7a93\u306b\u8cbc\u308b";
            }

            public String GetDesc() {
                return "\u30d0\u30c3\u30d5\u30a1\u306e\u9078\u629e\u7bc4\u56f2\u3092\u5165\u529b\u7a93\u306b\u8cbc\u308a\u4ed8\u3051\u307e\u3059\u3002\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u306f\u30a2\u30af\u30bb\u30b9\u3057\u307e\u305b\u3093\u3002";
            }

            public boolean isEnabled() {
                LogDocument d;
                ConnTreeNode ctn;
                return App.buf_list != null && null != (ctn = App.buf_list.getSelected()) && null != (d = ctn.getLogDocument()) && 0 != d.getSelectedText().length();
            }

            public void actionPerformed(ActionEvent e) {
                String s;
                LogDocument d;
                ConnTreeNode ctn;
                if (App.buf_list != null && null != (ctn = App.buf_list.getSelected()) && null != (d = ctn.getLogDocument()) && (s = d.getSelectedText()).length() != 0) {
                    App.main_window.input_area.pasteText(s);
                }
            }
        });
        App.action_manager.add(owner, "buffer-clear", new Action_(){

            public String GetName() {
                return "\u30af\u30ea\u30a2";
            }

            public String GetDesc() {
                return "\u4eca\u898b\u3066\u3044\u308b\u30d0\u30c3\u30d5\u30a1\u306e\u5185\u5bb9\u3092\u30af\u30ea\u30a2\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                LogDocument d;
                ConnTreeNode ctn;
                return App.buf_list != null && null != (ctn = App.buf_list.getSelected()) && null != (d = ctn.getLogDocument());
            }

            public void actionPerformed(ActionEvent e) {
                LogDocument d;
                ConnTreeNode ctn;
                if (App.buf_list != null && null != (ctn = App.buf_list.getSelected()) && null != (d = ctn.getLogDocument())) {
                    d.clear(App.main_window);
                }
            }
        });
        App.action_manager.add(owner, "buffer-url-list", new Action_(){

            public String GetName() {
                return "URL\u5c65\u6b74";
            }

            public String GetDesc() {
                return "\u30ed\u30b0\u306b\u51fa\u73fe\u3057\u305fURL\u306e\u5c65\u6b74\u3092\u8868\u793a\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return false;
            }

            public void actionPerformed(ActionEvent e) {
                App.Log(this.GetName() + ":\u672a\u5bfe\u5fdc");
            }
        });
        App.action_manager.add(owner, "inputarea-send-privmsg", new Action_(){

            public String GetName() {
                return "\u767a\u8a00";
            }

            public String GetDesc() {
                return "\u5165\u529b\u30a8\u30ea\u30a2\u306b\u66f8\u304b\u308c\u305f\u5185\u5bb9\u3092\u767a\u8a00\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                App.main_window.input_area.OnMenuTalk();
            }
        });
        App.action_manager.add(owner, "inputarea-send-topic", new Action_(){

            public String GetName() {
                return "\u30c8\u30d4\u30c3\u30af";
            }

            public String GetDesc() {
                return "\u5165\u529b\u30a8\u30ea\u30a2\u306b\u66f8\u304b\u308c\u305f\u5185\u5bb9\u3092\u30c8\u30d4\u30c3\u30af\u306b\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                App.main_window.input_area.OnMenuTopic();
            }
        });
        App.action_manager.add(owner, "inputarea-send-notice", new Action_(){

            public String GetName() {
                return "NOTICE";
            }

            public String GetDesc() {
                return "\u5165\u529b\u30a8\u30ea\u30a2\u306b\u66f8\u304b\u308c\u305f\u5185\u5bb9\u3092NOTICE\u3067\u9001\u4fe1\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                App.main_window.input_area.OnMenuNotice();
            }
        });
        App.action_manager.add(owner, "inputarea-send-action", new Action_(){

            public String GetName() {
                return "ACTION";
            }

            public String GetDesc() {
                return "\u5165\u529b\u30a8\u30ea\u30a2\u306b\u66f8\u304b\u308c\u305f\u5185\u5bb9\u3092CTCP ACTION\u3067\u9001\u4fe1\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                App.main_window.input_area.OnMenuAction();
            }
        });
        App.action_manager.add(owner, "inputarea-send-all-channnel", new Action_(){

            public String GetName() {
                return "\u5168CH";
            }

            public String GetDesc() {
                return "\u5165\u529b\u30a8\u30ea\u30a2\u306b\u66f8\u304b\u308c\u305f\u5185\u5bb9\u3092\u5168\u30c1\u30e3\u30f3\u30cd\u30eb\u3067\u767a\u8a00\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                App.main_window.input_area.OnMenuSendAll();
            }
        });
        App.action_manager.add(owner, "inputarea-cut", new Action_(){

            public String GetName() {
                return "\u30ab\u30c3\u30c8";
            }

            public String GetDesc() {
                return "\u9078\u629e\u7bc4\u56f2\u3092\u30ab\u30c3\u30c8\u3057\u3066\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u8a18\u9332\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return App.main_window.input_area != null && App.main_window.input_area.InputArea.hasFocus() && App.main_window.input_area.hasSelectedText();
            }

            public void actionPerformed(ActionEvent e) {
                if (App.main_window.input_area != null) {
                    App.main_window.input_area.cutText();
                }
            }
        });
        App.action_manager.add(owner, "inputarea-paste", new Action_(){

            public String GetName() {
                return "\u8cbc\u308a\u4ed8\u3051";
            }

            public String GetDesc() {
                return "\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306e\u5185\u5bb9\u3092\u73fe\u5728\u30ad\u30e3\u30ec\u30c3\u30c8\u304c\u3042\u308b\u4f4d\u7f6e\u306b\u8cbc\u308a\u4ed8\u3051\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return App.main_window.input_area != null && App.os_dependence.canGetClipboardText();
            }

            public void actionPerformed(ActionEvent e) {
                String s = App.os_dependence.getClipboardText();
                if (s != null) {
                    App.main_window.input_area.pasteText(s);
                }
            }
        });
        App.action_manager.add(owner, "reload-conf", new Action_(){

            public String GetName() {
                return "reload *.conf";
            }

            public String GetDesc() {
                return "\u8868\u793a\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u76f4\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                App.style_manager.load("Style.conf");
                App.pfm_manager.load("PrintFormat.conf");
                App.main_window.reloadBGInfoAll();
            }
        });
        App.action_manager.add(owner, "font-list", new Action_(){

            public String GetName() {
                return "\u30d5\u30a9\u30f3\u30c8\u4e00\u89a7\u3092\u30c0\u30f3\u30d7";
            }

            public String GetDesc() {
                return "\u30d5\u30a9\u30f3\u30c8\u4e00\u89a7\u3092\u30c0\u30f3\u30d7\u30d0\u30c3\u30d5\u30a1\u306b\u51fa\u529b\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
                String[] fl = genv.getAvailableFontFamilyNames();
                int i = 0;
                while (i < fl.length) {
                    App.Log(fl[i]);
                    ++i;
                }
            }
        });
        App.action_manager.add(owner, "lookandfeel-list", new Action_(){

            public String GetName() {
                return "Look&Feel\u306e\u4e00\u89a7";
            }

            public String GetDesc() {
                return "Look&Feel\u306e\u4e00\u89a7\u3092\u30c0\u30f3\u30d7\u30d0\u30c3\u30d5\u30a1\u306b\u51fa\u529b\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                UIManager.LookAndFeelInfo[] list = UIManager.getInstalledLookAndFeels();
                int i = 0;
                while (i < list.length) {
                    App.Log(list[i].getClassName());
                    ++i;
                }
            }
        });
        App.action_manager.add(owner, "system-property", new Action_(){

            public String GetName() {
                return "Java\u306e\u30b7\u30b9\u30c6\u30e0\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u30c0\u30f3\u30d7";
            }

            public String GetDesc() {
                return "Java\u306e\u30b7\u30b9\u30c6\u30e0\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u30c0\u30f3\u30d7\u30d0\u30c3\u30d5\u30a1\u306b\u51fa\u529b\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                TreeMap<Object, Object> tm = new TreeMap<Object, Object>();
                Iterator<Map.Entry<Object, Object>> it = System.getProperties().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Object, Object> m = it.next();
                    tm.put(m.getKey(), m.getValue());
                }
                Iterator it2 = tm.entrySet().iterator();
                while (it2.hasNext()) {
                    Map.Entry m = it2.next();
                    App.Log(m.getKey().toString() + "=" + m.getValue());
                }
            }
        });
        App.action_manager.add(owner, "garbage-collection", new Action_(){

            public String GetName() {
                return "garbage collection";
            }

            public String GetDesc() {
                return "\u53c2\u7167\u3055\u308c\u3066\u3044\u306a\u3044\u30e1\u30e2\u30ea\u3092\u89e3\u653e\u3057\u307e\u3059";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                System.gc();
            }
        });
        App.action_manager.add(owner, "repair-inputarea", new Action_(){

            public String GetName() {
                return "\u5165\u529b\u30a8\u30ea\u30a2\u306e\u4fee\u5fa9";
            }

            public String GetDesc() {
                return "\u5165\u529b\u30a8\u30ea\u30a2\u3092\u4ea4\u63db\u3057\u307e\u3059";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                App.main_window.input_area.repair();
            }
        });
        App.action_manager.add(owner, "property-inspector", new Action_(){

            public String GetName() {
                return "property-inspector";
            }

            public String GetDesc() {
                return "\u30d0\u30c3\u30d5\u30a1\u9805\u76ee\u306e\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u8868\u793a/\u7de8\u96c6\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return App.getSelected() != null;
            }

            public void actionPerformed(ActionEvent e) {
                ConnTreeNode node = App.getSelected();
                if (node != null) {
                    new PropertyInspector(node.property, node.GetCaption() + " property");
                }
            }
        });
        App.action_manager.add(owner, "bufferlist-num", new Action_(){

            public String GetName() {
                return "\u30d0\u30c3\u30d5\u30a1\u4e00\u89a7\u304b\u3089\u6307\u5b9a\u3057\u305f\u9805\u76ee\u3092\u9078\u629e";
            }

            public String GetDesc() {
                return "\u30d0\u30c3\u30d5\u30a1\u4e00\u89a7\u304b\u3089\u6307\u5b9a\u3057\u305f\u9805\u76ee\u3092\u9078\u629e";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                Object o = App.action_manager.getStackParameter();
                if (o == null) {
                    o = e.getActionCommand();
                }
                try {
                    int i = Integer.parseInt((String)o);
                    App.buf_list.select(i);
                }
                catch (Throwable ee) {
                    if (o == null) {
                        o = "(null)";
                    }
                    if (!(o instanceof String)) {
                        o = o.getClass().getName();
                    }
                    App.Log("bufferlist-num " + (String)o + " failed:" + ee.getClass().getName() + " " + ee.getMessage());
                }
            }
        });
        App.action_manager.add(owner, "bufferlist-prevnext", new Action_(){

            public String GetName() {
                return "\u30d0\u30c3\u30d5\u30a1\u4e00\u89a7\u3092\u79fb\u52d5";
            }

            public String GetDesc() {
                return "\u6307\u5b9a\u3057\u305f\u5024\u3060\u3051\u4e0a\u4e0b\u306b\u79fb\u52d5";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                Object o = App.action_manager.getStackParameter();
                if (o == null) {
                    o = e.getActionCommand();
                }
                try {
                    int i = Integer.parseInt((String)o);
                    App.buf_list.StepScroll(i, true);
                }
                catch (Throwable ee) {
                    if (o == null) {
                        o = "(null)";
                    }
                    if (!(o instanceof String)) {
                        o = o.getClass().getName();
                    }
                    App.Log("bufferlist-prevnext " + (String)o + " failed:" + ee.getClass().getName() + " " + ee.getMessage());
                }
            }
        });
        App.action_manager.add(owner, "inputhistory-prev", new Action_(){

            public String GetName() {
                return "\u524d\u306e\u5165\u529b\u5c65\u6b74";
            }

            public String GetDesc() {
                return "\u524d\u306e\u5165\u529b\u5c65\u6b74";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    App.main_window.input_area.history_prev();
                }
                catch (Throwable ee) {
                    App.Log("inputhistory-prev " + ee.getClass().getName() + " " + ee.getMessage());
                }
            }
        });
        App.action_manager.add(owner, "inputhistory-next", new Action_(){

            public String GetName() {
                return "\u6b21\u306e\u5165\u529b\u5c65\u6b74";
            }

            public String GetDesc() {
                return "\u6b21\u306e\u5165\u529b\u5c65\u6b74";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    App.main_window.input_area.history_next();
                }
                catch (Throwable ee) {
                    App.Log("inputhistory-next " + ee.getClass().getName() + " " + ee.getMessage());
                }
            }
        });
        App.action_manager.add(owner, "edit-cut", new Action_(){

            public String GetName() {
                return "\u30ab\u30c3\u30c8";
            }

            public String GetDesc() {
                return "\u9078\u629e\u7bc4\u56f2\u3092\u30ab\u30c3\u30c8\u3057\u3066\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u683c\u7d0d\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                Object o = App.getFocusComponent();
                if (o == null) {
                    return;
                }
                if (o instanceof LogView) {
                    String s = ((LogView)o).getSelectedText();
                    if (s.length() > 0) {
                        App.os_dependence.Copy(s);
                    }
                    return;
                }
                if (o instanceof JTextComponent) {
                    Action_.logger.finer("edit-cut for JTextComponent");
                    ((JTextComponent)o).cut();
                    return;
                }
                if (o instanceof JTable && (o = ((JTable)o).getModel()) instanceof ChannelMemberView) {
                    Action a = App.action_manager.find("cuser-copy-prefix");
                    if (a != null) {
                        App.action_manager.call(a, null);
                    }
                    return;
                }
                App.Log("edit-cut " + o.getClass().getName());
            }
        });
        App.action_manager.add(owner, "edit-copy", new Action_(){

            public String GetName() {
                return "\u30b3\u30d4\u30fc";
            }

            public String GetDesc() {
                return "\u9078\u629e\u7bc4\u56f2\u3092\u30b3\u30d4\u30fc\u3057\u3066\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u683c\u7d0d\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                Object o = App.getFocusComponent();
                if (o == null) {
                    return;
                }
                if (o instanceof LogView) {
                    String s = ((LogView)o).getSelectedText();
                    if (s.length() > 0) {
                        App.os_dependence.Copy(s);
                    }
                    return;
                }
                if (o instanceof JTextComponent) {
                    Action_.logger.finer("edit-copy for JTextComponent");
                    ((JTextComponent)o).copy();
                    return;
                }
                if (o instanceof JTable && (o = ((JTable)o).getModel()) instanceof ChannelMemberView) {
                    Action a = App.action_manager.find("cuser-copy-prefix");
                    if (a != null) {
                        App.action_manager.call(a, null);
                    }
                    return;
                }
                App.Log("edit-copy " + o.getClass().getName());
            }
        });
        App.action_manager.add(owner, "edit-paste", new Action_(){

            public String GetName() {
                return "\u8cbc\u308a\u4ed8\u3051";
            }

            public String GetDesc() {
                return "\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306e\u5185\u5bb9\u3092\u9078\u629e\u4f4d\u7f6e\u306b\u8cbc\u308a\u4ed8\u3051\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                String s = App.os_dependence.getClipboardText();
                if (s != null && s.length() > 0) {
                    App.main_window.input_area.pasteText(s);
                }
            }
        });
        App.action_manager.add(owner, "edit-selectall", new Action_(){

            public String GetName() {
                return "\u5168\u3066\u9078\u629e";
            }

            public String GetDesc() {
                return "\u30d5\u30a9\u30fc\u30ab\u30b9\u306e\u3042\u308b\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8\u306e\u5185\u5bb9\u3092\u5168\u3066\u9078\u629e\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                Object o = App.getFocusComponent();
                if (o == null) {
                    return;
                }
                if (o instanceof JTextComponent) {
                    ((JTextComponent)o).selectAll();
                    return;
                }
                if (o instanceof LogView) {
                    ((LogView)o).selectAll();
                    return;
                }
                if (o instanceof JTable) {
                    ((JTable)o).selectAll();
                    return;
                }
                App.Log("edit-selectall " + o.getClass().getName());
            }
        });
        App.action_manager.add(owner, "popupurl-browse", new Action_(){

            public String GetName() {
                return "browse";
            }

            public String GetDesc() {
                return "\u30d0\u30c3\u30d5\u30a1\u3067\u9078\u629e\u4e2d\u306eURL\u3092\u30d6\u30e9\u30a6\u30b6\u3067\u958b\u304d\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                String url = ActionUtility.readHoverOrSelected(e);
                if (url == null || url.length() == 0) {
                    return;
                }
                String keyname = e.getActionCommand();
                if (keyname == null || keyname.length() == 0) {
                    App.Log("menu.conf \u306e popupurl-browse \u306b\u30a2\u30af\u30b7\u30e7\u30f3\u30b3\u30de\u30f3\u30c9\u3067\u30d6\u30e9\u30a6\u30b6\u30d1\u30b9\u8a2d\u5b9a\u306e\u30d7\u30ed\u30d1\u30c6\u30a3\u540d\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
                    return;
                }
                String cmd = App.root_property.getString(keyname);
                App.os_dependence.openURL("\u30d7\u30ed\u30d1\u30c6\u30a3" + keyname, cmd, url);
            }
        });
        App.action_manager.add(owner, "popupurl-other", new Action_(){

            public String GetName() {
                return "popupurl-other";
            }

            public String GetDesc() {
                return "\u30d0\u30c3\u30d5\u30a1\u3067\u9078\u629e\u4e2d\u306eURL\u3092menu.conf\u306b\u6307\u5b9a\u3057\u305f\u30b3\u30de\u30f3\u30c9\u3067\u958b\u304d\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                String url = ActionUtility.readHoverOrSelected(e);
                if (url == null || url.length() == 0) {
                    return;
                }
                App.os_dependence.openURL("popupurl-other\u306ecommand\u6307\u5b9a", e.getActionCommand(), url);
            }
        });
        App.action_manager.add(owner, "popupurl-click", new Action_(){

            public String GetName() {
                return "popupurl-click";
            }

            public String GetDesc() {
                return "\u30d0\u30c3\u30d5\u30a1\u3067\u9078\u629e\u4e2d\u306eURL\u3092\u30d6\u30e9\u30a6\u30b6\u3067\u958b\u304d\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                String cmd = App.root_property.getString("BrowserName");
                if (cmd == null || cmd.length() == 0) {
                    App.Log("\u74b0\u5883\u8a2d\u5b9a\u306e\u30d6\u30e9\u30a6\u30b6\u306e\u30d1\u30b9\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044");
                    return;
                }
                Object o = App.action_manager.getStackParameter();
                boolean result = false;
                if (o instanceof Object[]) {
                    Object[] arg = (Object[])o;
                    MouseEvent ee = (MouseEvent)arg[0];
                    LogDocument document = (LogDocument)arg[1];
                    TextSpanInfo pos = (TextSpanInfo)arg[2];
                    if (ee.getClickCount() != 2) {
                        return;
                    }
                    result = App.os_dependence.openURL("\u30d7\u30ed\u30d1\u30c6\u30a3BrowserName", cmd, pos.text);
                } else {
                    result = o instanceof String ? App.os_dependence.openURL("\u30d7\u30ed\u30d1\u30c6\u30a3BrowserName", cmd, (String)o) : App.os_dependence.openURL("\u30d7\u30ed\u30d1\u30c6\u30a3BrowserName", cmd, e.getActionCommand());
                }
                App.action_manager.setStackParameter(result ? this : null);
            }
        });
        App.action_manager.add(owner, "texteditor-open", new Action_(){

            public String GetName() {
                return "texteditor-open";
            }

            public String GetDesc() {
                return "\u6307\u5b9a\u3057\u305f\u30d5\u30a1\u30a4\u30eb\u3092\u30c6\u30ad\u30b9\u30c8\u30a8\u30c7\u30a3\u30bf\u3067\u958b\u304d\u307e\u3059";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                String s = ActionUtility.getStringParamater();
                if (s == null || s.length() == 0) {
                    s = e.getActionCommand();
                }
                if (s == null || s.length() == 0) {
                    App.Log("texteditor-open: \u5f15\u6570\u304c\u4e0d\u660e");
                    return;
                }
                App.os_dependence.editTextFile(new File(s));
            }
        });
        App.action_manager.add(owner, "buffer-list-sort", new Action_(){

            public String GetName() {
                return "\u30d0\u30c3\u30d5\u30a1\u4e00\u89a7\u306e\u30bd\u30fc\u30c8";
            }

            public String GetDesc() {
                return "\u30d0\u30c3\u30d5\u30a1\u4e00\u89a7\u3092\u6574\u5217\u3057\u307e\u3059\u3002";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                App.buf_list.sortItem();
            }
        });
        App.action_manager.add(owner, "bluntirc-version", new Action_(){

            public String GetName() {
                return "\u30d3\u30eb\u30c9\u8868\u8a18";
            }

            public String GetDesc() {
                return "\u30d3\u30eb\u30c9\u8868\u8a18\u3092\u5168\u3066\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u306b\u66f8\u304d\u307e\u3059";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                App.Log(App.config_AppName + " build " + BuildDate.getVersion());
            }
        });
        App.action_manager.add(owner, "java-charset-list", new Action_(){

            public String GetName() {
                return "Charset\u4e00\u89a7";
            }

            public String GetDesc() {
                return "Charset\u4e00\u89a7\u3092\u5168\u3066\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u306b\u66f8\u304d\u307e\u3059";
            }

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                Iterator<Charset> it = Charset.availableCharsets().values().iterator();
                while (it.hasNext()) {
                    Charset cs = it.next();
                    StringBuffer sb = new StringBuffer();
                    sb.append(cs.displayName());
                    Iterator<String> it2 = cs.aliases().iterator();
                    while (it2.hasNext()) {
                        sb.append(" " + it2.next());
                    }
                    App.Log(sb.toString());
                }
            }
        });
    }

    static {
        logger.setLevel(null);
    }
}

