/*
 * Decompiled with CFR 0.152.
 */
package org.intabulas.sandler;

import java.util.Date;
import org.intabulas.sandler.Sandler;
import org.intabulas.sandler.builders.SyndicationBuilder;
import org.intabulas.sandler.elements.AtomElement;
import org.intabulas.sandler.elements.Content;
import org.intabulas.sandler.elements.Entry;
import org.intabulas.sandler.elements.Feed;
import org.intabulas.sandler.elements.Generator;
import org.intabulas.sandler.elements.Link;
import org.intabulas.sandler.elements.Person;
import org.intabulas.sandler.elements.impl.ContentImpl;
import org.intabulas.sandler.elements.impl.EntryImpl;
import org.intabulas.sandler.elements.impl.FeedImpl;
import org.intabulas.sandler.elements.impl.GeneratorImpl;
import org.intabulas.sandler.elements.impl.LinkImpl;
import org.intabulas.sandler.elements.impl.PersonImpl;
import org.intabulas.sandler.exceptions.MarshallException;

public class SyndicationFactory
implements AtomElement {
    public static Feed newSyndicationFeed() {
        FeedImpl result = new FeedImpl();
        return result;
    }

    public static Feed newSyndicationFeed(String feed) throws MarshallException {
        Feed result = Sandler.unmarshallFeed(feed);
        return result;
    }

    public static Feed newSyndicationFeed(String feed, SyndicationBuilder builder) throws MarshallException {
        Feed result = Sandler.unmarshallFeed(feed, builder);
        return result;
    }

    public static Entry newSyndicationEntry() {
        EntryImpl result = new EntryImpl();
        result.setCreated(new Date());
        return result;
    }

    public static Entry newSyndicationEntry(String entry) throws MarshallException {
        Entry result = Sandler.unmarshallEntry(entry);
        result.setCreated(new Date());
        return result;
    }

    public static Entry newSyndicationEntry(String entry, SyndicationBuilder builder) throws MarshallException {
        Entry result = Sandler.unmarshallEntry(entry, builder);
        result.setCreated(new Date());
        return result;
    }

    public static Person createPerson(String name, String email, String url) {
        PersonImpl person = new PersonImpl();
        person.setEmail(email);
        person.setName(name);
        person.setUrl(url);
        return person;
    }

    public static Content createEscapedContent(String body) {
        ContentImpl content = new ContentImpl();
        content.setMimeType("text/html");
        content.setBody(body);
        content.setMode("escaped");
        return content;
    }

    public static Content createTextXmlContent(String body) {
        ContentImpl content = new ContentImpl();
        content.setMimeType("text/xml");
        content.setBody(body);
        content.setMode("xml");
        return content;
    }

    public static Content createContent(String textcontent) {
        ContentImpl content = new ContentImpl();
        content.setBody(textcontent);
        content.setMimeType("text/plain");
        return content;
    }

    public static Link createAlternateLink(String href, String title) {
        LinkImpl link = new LinkImpl();
        link.setHref(href);
        link.setRelationship("alternate");
        link.setType("text/html");
        if (title != null) {
            link.setTitle(title);
        }
        return link;
    }

    public static Link createAlternateLink(String href) {
        return SyndicationFactory.createAlternateLink(href, null);
    }

    public static Generator createGenerator(String name) {
        GeneratorImpl generator = new GeneratorImpl();
        generator.setName(name);
        return generator;
    }

    public static Generator createGenerator(String name, String uri, String version) {
        GeneratorImpl generator = new GeneratorImpl();
        generator.setName(name);
        generator.setUri(uri);
        generator.setVersion(version);
        return generator;
    }

    public static Feed createFeed(Person author, String title, Link alternate, Date modified) {
        FeedImpl feed = new FeedImpl();
        feed.setAuthor(author);
        feed.setVersion("0.3");
        feed.setLanguage("en_US");
        feed.setTitle(title);
        feed.addLink(alternate);
        feed.setModified(modified);
        return feed;
    }

    public static Entry createEntry(String title, String id, Link alternate, Date issued, Date modified) {
        return SyndicationFactory.createEntry(null, title, id, alternate, issued, modified);
    }

    public static Entry createEntry(Content content, String title, String id, Link alternate, Date issued, Date modified) {
        EntryImpl entry = new EntryImpl();
        entry.setTitle(title);
        entry.addLink(alternate);
        entry.setModified(modified);
        entry.setIssued(issued);
        if (content != null) {
            entry.addContent(content);
        }
        entry.setId(id);
        return entry;
    }
}

