/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.util.resources;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomUtils;
import org.blojsom.util.resources.ResourceManager;

public class ResourceBundleResourceManager
implements BlojsomConstants,
ResourceManager {
    private transient Log _logger = LogFactory.getLog((Class)ResourceBundleResourceManager.class);

    public void init(BlojsomConfiguration blojsomConfiguration) throws BlojsomException {
        String[] resourceBundles;
        String resourceBundlesToLoad = blojsomConfiguration.getBlojsomPropertyAsString("blojsom-resource-manager-bundles");
        if (!BlojsomUtils.checkNullOrBlank(resourceBundlesToLoad) && (resourceBundles = BlojsomUtils.parseCommaList(resourceBundlesToLoad)) != null && resourceBundles.length > 0) {
            for (int i = 0; i < resourceBundles.length; ++i) {
                String resourceBundle = resourceBundles[i];
                try {
                    ResourceBundle.getBundle(resourceBundle);
                    this._logger.debug((Object)("Loaded resource bundle: " + resourceBundle));
                    continue;
                }
                catch (Exception e) {
                    this._logger.error((Object)e);
                }
            }
        }
        this._logger.debug((Object)"Initialized resource bundle resource manager");
    }

    public String getString(String resourceID, String resource, String fallback) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(resource);
            return resourceBundle.getString(resourceID);
        }
        catch (MissingResourceException e) {
            this._logger.error((Object)e);
            return fallback;
        }
    }

    public String getString(String resourceID, String resource, String fallback, String language) {
        return this.getString(resourceID, resource, fallback, new Locale(language));
    }

    public String getString(String resourceID, String resource, String fallback, String language, String country) {
        return this.getString(resourceID, resource, fallback, new Locale(language, country));
    }

    public String getString(String resourceID, String resource, String fallback, Locale locale) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(resource, locale);
            return resourceBundle.getString(resourceID);
        }
        catch (MissingResourceException e) {
            this._logger.error((Object)e);
            return fallback;
        }
    }

    public String format(String pattern, Object[] arguments) {
        String value = null;
        try {
            value = MessageFormat.format(pattern, arguments);
        }
        catch (Exception e) {
            this._logger.error((Object)e);
        }
        return value;
    }
}

