/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.util.password;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomUtils;

public class EncryptedPasswordConversion {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: EncryptedPasswordConversion <Full path to blojsom authorization.properties file> <Digest Algorithm - Defaults to MD5>");
        } else {
            File authorizationFile = new File(args[0]);
            if (!authorizationFile.exists()) {
                System.out.println(authorizationFile.toString() + " does not exist.");
            } else {
                try {
                    String digestAlgorithm = "MD5";
                    if (args.length == 2) {
                        digestAlgorithm = args[1];
                        System.out.println("Requested digest algorithm: " + digestAlgorithm);
                        try {
                            MessageDigest messageDigest = MessageDigest.getInstance(digestAlgorithm);
                        }
                        catch (NoSuchAlgorithmException e) {
                            digestAlgorithm = "MD5";
                        }
                    }
                    System.out.println("Using digest algorithm: " + digestAlgorithm);
                    System.out.println("Encrypting authorization file: " + authorizationFile.toString());
                    BlojsomProperties authorization = new BlojsomProperties();
                    BlojsomProperties encryptedAuthorization = new BlojsomProperties();
                    FileInputStream fis = new FileInputStream(authorizationFile);
                    authorization.load(fis);
                    fis.close();
                    Iterator<Object> userIterator = authorization.keySet().iterator();
                    while (userIterator.hasNext()) {
                        String user = (String)userIterator.next();
                        String passwordAndEmailProperty = authorization.getProperty(user);
                        String[] passwordAndEmail = BlojsomUtils.parseLastComma(passwordAndEmailProperty);
                        if (passwordAndEmail.length == 1) {
                            encryptedAuthorization.setProperty(user, BlojsomUtils.digestString(passwordAndEmail[0], digestAlgorithm));
                            continue;
                        }
                        if (passwordAndEmail.length != 2) continue;
                        encryptedAuthorization.setProperty(user, BlojsomUtils.digestString(passwordAndEmail[0], digestAlgorithm) + "," + passwordAndEmail[1]);
                    }
                    FileOutputStream fos = new FileOutputStream(authorizationFile);
                    encryptedAuthorization.store(fos, null);
                    fos.close();
                    System.out.println("Converted authorization file to use encrypted passwords.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

