/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomUtils;

public class BlojsomProperties
extends Properties
implements BlojsomConstants {
    private String encoding = "UTF-8";
    private static final String strictKeyValueSeparators = "=:";
    private static final String whiteSpaceChars = " \t\r\n\f";
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private boolean allowMultipleValues = false;

    public BlojsomProperties() {
    }

    public BlojsomProperties(boolean allowMultipleValues) {
        this.allowMultipleValues = allowMultipleValues;
    }

    public BlojsomProperties(Properties defaults) {
        super(defaults);
    }

    public BlojsomProperties(String encoding) {
        this.encoding = encoding;
    }

    public void setAllowMultipleValues(boolean allowMultipleValues) {
        this.allowMultipleValues = allowMultipleValues;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void store(OutputStream out, String header) throws IOException {
        BufferedWriter writer = this.encoding == null ? new BufferedWriter(new OutputStreamWriter(out)) : new BufferedWriter(new OutputStreamWriter(out, this.encoding));
        if (header != null) {
            writer.write("#" + header);
            writer.newLine();
        }
        writer.write("#" + new Date().toString());
        writer.newLine();
        Enumeration<Object> e = this.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            Object value = this.get(key);
            key = BlojsomUtils.replace(key, " ", "\\ ");
            if (value != null && value instanceof List && this.allowMultipleValues) {
                List values = (List)value;
                for (int i = 0; i < values.size(); ++i) {
                    value = values.get(i);
                    writer.write(key + "=" + value);
                    writer.newLine();
                }
                continue;
            }
            value = value != null ? value.toString() : "";
            writer.write(key + "=" + value);
            writer.newLine();
        }
        writer.flush();
    }

    public void load(InputStream in) throws IOException {
        if (in == null) {
            return;
        }
        BufferedReader reader = this.encoding == null ? new BufferedReader(new InputStreamReader(in)) : new BufferedReader(new InputStreamReader(in, this.encoding));
        String line;
        while ((line = reader.readLine()) != null) {
            String value;
            int valueIndex;
            int separatorIndex;
            int keyIndex;
            if (line.length() <= 0 || line.charAt(0) == '#') continue;
            int len = line.length();
            for (keyIndex = 0; keyIndex < len; ++keyIndex) {
                if (line.charAt(keyIndex) == '\\') {
                    keyIndex += 2;
                    continue;
                }
                if (whiteSpaceChars.indexOf(line.charAt(keyIndex)) == -1) break;
            }
            for (separatorIndex = keyIndex; separatorIndex < len; ++separatorIndex) {
                char currentChar = line.charAt(separatorIndex);
                if (currentChar == '\\') {
                    ++separatorIndex;
                    continue;
                }
                if (keyValueSeparators.indexOf(currentChar) != -1) break;
            }
            for (valueIndex = separatorIndex; valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1; ++valueIndex) {
            }
            if (valueIndex < len && strictKeyValueSeparators.indexOf(line.charAt(valueIndex)) != -1) {
                ++valueIndex;
            }
            while (valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1) {
                ++valueIndex;
            }
            String key = line.substring(keyIndex, separatorIndex);
            key = BlojsomUtils.replace(key, "\\", "");
            String string = value = separatorIndex < len ? line.substring(valueIndex, len) : "";
            if (this.containsKey(key) && this.allowMultipleValues) {
                ArrayList<String> values;
                Object previousValue = this.get(key);
                if (previousValue instanceof List) {
                    values = (ArrayList<String>)previousValue;
                    values.add(value);
                } else {
                    values = new ArrayList<String>(1);
                    values.add((String)previousValue);
                    values.add(value);
                }
                this.put(key, values);
                continue;
            }
            this.put(key, value);
        }
        return;
    }

    public String getProperty(String key) {
        if (this.allowMultipleValues && this.containsKey(key)) {
            Object value = this.get(key);
            if (value == null) {
                return null;
            }
            if (value instanceof List) {
                return BlojsomUtils.listToCSV((List)value);
            }
            return value.toString();
        }
        return super.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        if (this.allowMultipleValues && this.containsKey(key)) {
            Object value = this.get(key);
            if (value == null) {
                return null;
            }
            if (value instanceof List) {
                return BlojsomUtils.listToCSV((List)value);
            }
            return value.toString();
        }
        return super.getProperty(key, defaultValue);
    }
}

