/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.servlet;

import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.blog.BlojsomConfigurationException;
import org.blojsom.fetcher.BlojsomFetcher;
import org.blojsom.fetcher.BlojsomFetcherException;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomUtils;

public class BlojsomBaseServlet
extends HttpServlet
implements BlojsomConstants {
    private Log _logger = LogFactory.getLog((Class)BlojsomBaseServlet.class);
    protected String _baseConfigurationDirectory;
    protected BlojsomFetcher _fetcher;
    protected BlojsomConfiguration _blojsomConfiguration;
    protected ServletConfig _servletConfig;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this._servletConfig = servletConfig;
    }

    protected void configureFetcher(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws ServletException {
        String fetcherClassName = blojsomConfiguration.getFetcherClass();
        try {
            Class<?> fetcherClass = Class.forName(fetcherClassName);
            this._fetcher = (BlojsomFetcher)fetcherClass.newInstance();
            this._fetcher.init(servletConfig, blojsomConfiguration);
            this._logger.info((Object)("Added blojsom fetcher: " + fetcherClassName));
        }
        catch (ClassNotFoundException e) {
            this._logger.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (InstantiationException e) {
            this._logger.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            this._logger.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (BlojsomFetcherException e) {
            this._logger.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected void configureBlojsom(ServletConfig servletConfig) throws ServletException {
        try {
            Properties configurationProperties = BlojsomUtils.loadProperties(servletConfig, "blojsom-configuration", true, true);
            this._blojsomConfiguration = new BlojsomConfiguration(servletConfig, BlojsomUtils.propertiesToMap(configurationProperties));
            this._baseConfigurationDirectory = this._blojsomConfiguration.getBaseConfigurationDirectory();
            this.configureFetcher(servletConfig, this._blojsomConfiguration);
        }
        catch (BlojsomConfigurationException e) {
            this._logger.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (BlojsomException e) {
            this._logger.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }
}

