/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.filter;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.util.BlojsomUtils;

public class PermalinkFilter
implements Filter {
    private static final Log _logger = LogFactory.getLog((Class)PermalinkFilter.class);
    private static final String YMD_PERMALINK_REGEX = "/(\\d\\d\\d\\d)/(\\d{1,2}+)/(\\d{1,2}+)/(.+)";
    private static final Pattern YMD_PERMALINK_PATTERN = Pattern.compile("/(\\d\\d\\d\\d)/(\\d{1,2}+)/(\\d{1,2}+)/(.+)", 64);
    private static final String YMD_REGEX = "/(\\d\\d\\d\\d)/(\\d{1,2}+)/(\\d{1,2}+)/";
    private static final Pattern YMD_PATTERN = Pattern.compile("/(\\d\\d\\d\\d)/(\\d{1,2}+)/(\\d{1,2}+)/", 64);
    private static final String YM_REGEX = "/(\\d\\d\\d\\d)/(\\d{1,2}+)/";
    private static final Pattern YM_PATTERN = Pattern.compile("/(\\d\\d\\d\\d)/(\\d{1,2}+)/", 64);
    private static final String Y_REGEX = "/(\\d\\d\\d\\d)/";
    private static final Pattern Y_PATTERN = Pattern.compile("/(\\d\\d\\d\\d)/", 64);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        request.setCharacterEncoding("UTF-8");
        Object hreq = (HttpServletRequest)request;
        String uri = hreq.getRequestURI();
        StringBuffer url = hreq.getRequestURL();
        String pathInfo = hreq.getPathInfo();
        if (BlojsomUtils.checkNullOrBlank(pathInfo)) {
            pathInfo = "/";
        }
        Matcher ymdpMatcher = YMD_PERMALINK_PATTERN.matcher(pathInfo);
        Matcher ymdMatcher = YMD_PATTERN.matcher(pathInfo);
        Matcher ymMatcher = YM_PATTERN.matcher(pathInfo);
        Matcher yMatcher = Y_PATTERN.matcher(pathInfo);
        if (ymdpMatcher.find()) {
            String year = ymdpMatcher.group(1);
            String month = ymdpMatcher.group(2);
            String day = ymdpMatcher.group(3);
            String permalink = ymdpMatcher.group(4);
            HashMap<String, String[]> extraParameters = new HashMap<String, String[]>();
            extraParameters.put("year", new String[]{year});
            extraParameters.put("month", new String[]{month});
            extraParameters.put("day", new String[]{day});
            extraParameters.put("permalink", new String[]{permalink});
            String yearSubstring = year + "/";
            int yearIndex = pathInfo.lastIndexOf(yearSubstring);
            String pathinfo = pathInfo.substring(0, yearIndex);
            yearIndex = uri.lastIndexOf(yearSubstring);
            String URI2 = uri.substring(0, yearIndex);
            yearIndex = url.lastIndexOf(yearSubstring);
            String URL2 = url.substring(0, yearIndex);
            _logger.debug((Object)("Handling YYYY/MM/DD/permalink request: " + pathinfo));
            hreq = new PermalinkRequest((HttpServletRequest)hreq, extraParameters, URI2, URL2, pathinfo);
        } else if (ymdMatcher.find()) {
            String year = ymdMatcher.group(1);
            String month = ymdMatcher.group(2);
            String day = ymdMatcher.group(3);
            HashMap<String, String[]> extraParameters = new HashMap<String, String[]>();
            extraParameters.put("year", new String[]{year});
            extraParameters.put("month", new String[]{month});
            extraParameters.put("day", new String[]{day});
            String yearSubstring = year + "/";
            int yearIndex = pathInfo.lastIndexOf(yearSubstring);
            String pathinfo = pathInfo.substring(0, yearIndex);
            yearIndex = uri.lastIndexOf(yearSubstring);
            String URI3 = uri.substring(0, yearIndex);
            yearIndex = url.lastIndexOf(yearSubstring);
            String URL3 = url.substring(0, yearIndex);
            hreq = new PermalinkRequest((HttpServletRequest)hreq, extraParameters, URI3, URL3, pathinfo);
            _logger.debug((Object)("Handling YYYY/MM/DD/ request: " + pathinfo));
        } else if (ymMatcher.find()) {
            String year = ymMatcher.group(1);
            String month = ymMatcher.group(2);
            HashMap<String, String[]> extraParameters = new HashMap<String, String[]>();
            extraParameters.put("year", new String[]{year});
            extraParameters.put("month", new String[]{month});
            String yearSubstring = year + "/";
            int yearIndex = pathInfo.lastIndexOf(yearSubstring);
            String pathinfo = pathInfo.substring(0, yearIndex);
            yearIndex = uri.lastIndexOf(yearSubstring);
            String URI4 = uri.substring(0, yearIndex);
            yearIndex = url.lastIndexOf(yearSubstring);
            String URL4 = url.substring(0, yearIndex);
            hreq = new PermalinkRequest((HttpServletRequest)hreq, extraParameters, URI4, URL4, pathinfo);
            _logger.debug((Object)("Handling YYYY/MM request: " + pathinfo));
        } else if (yMatcher.find()) {
            String year = yMatcher.group(1);
            HashMap<String, String[]> extraParameters = new HashMap<String, String[]>();
            extraParameters.put("year", new String[]{year});
            String yearSubstring = year + "/";
            int yearIndex = pathInfo.lastIndexOf(yearSubstring);
            String pathinfo = pathInfo.substring(0, yearIndex);
            yearIndex = uri.lastIndexOf(yearSubstring);
            String URI5 = uri.substring(0, yearIndex);
            yearIndex = url.lastIndexOf(yearSubstring);
            String URL5 = url.substring(0, yearIndex);
            hreq = new PermalinkRequest((HttpServletRequest)hreq, extraParameters, URI5, URL5, pathinfo);
            _logger.debug((Object)("Handling YYYY request: " + pathinfo));
        } else {
            String permalinkSubstring = "/";
            int permalinkIndex = pathInfo.substring(1).lastIndexOf(permalinkSubstring);
            if (permalinkIndex != -1 && permalinkIndex < pathInfo.length() - 1) {
                HashMap<String, String[]> extraParameters = new HashMap<String, String[]>();
                if (request.getParameter("permalink") == null && !"/".equals(pathInfo.substring(permalinkIndex + 1))) {
                    extraParameters.put("permalink", new String[]{pathInfo.substring(permalinkIndex + 1)});
                }
                String pathinfo = pathInfo.substring(0, permalinkIndex + 1);
                permalinkIndex = uri.lastIndexOf(permalinkSubstring);
                String URI6 = uri.substring(0, permalinkIndex + 1);
                permalinkIndex = url.lastIndexOf(permalinkSubstring);
                String URL6 = url.substring(0, permalinkIndex + 1);
                _logger.debug((Object)("Handling permalink request: " + pathinfo));
                hreq = new PermalinkRequest((HttpServletRequest)hreq, extraParameters, URI6, URL6, pathinfo);
            }
        }
        chain.doFilter((ServletRequest)hreq, response);
    }

    public class PermalinkRequest
    extends HttpServletRequestWrapper {
        private Map params;
        private String uri;
        private String url;
        private String pathInfo;

        public PermalinkRequest(HttpServletRequest httpServletRequest, Map params, String uri, String url, String pathInfo) {
            super(httpServletRequest);
            HashMap updatedParams = new HashMap(httpServletRequest.getParameterMap());
            Iterator keys = params.keySet().iterator();
            while (keys.hasNext()) {
                Object o = keys.next();
                updatedParams.put(o, params.get(o));
            }
            this.params = Collections.unmodifiableMap(updatedParams);
            this.uri = uri;
            this.url = url;
            this.pathInfo = pathInfo;
        }

        public String getRequestURI() {
            return this.uri;
        }

        public StringBuffer getRequestURL() {
            return new StringBuffer(this.url);
        }

        public String getPathInfo() {
            return this.pathInfo;
        }

        public String getParameter(String name) {
            String[] values = this.getParameterValues(name);
            return values != null ? values[0] : null;
        }

        public Map getParameterMap() {
            return this.params;
        }

        public Enumeration getParameterNames() {
            return Collections.enumeration(this.params.keySet());
        }

        public String[] getParameterValues(String name) {
            return (String[])this.params.get(name);
        }

        public void setPathInfo(String pathInfo) {
            this.pathInfo = pathInfo;
        }
    }
}

