/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.fetcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogCategory;
import org.blojsom.blog.BlogComment;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.blog.FileBackedBlogCategory;
import org.blojsom.blog.FileBackedBlogComment;
import org.blojsom.blog.FileBackedBlogEntry;
import org.blojsom.blog.FileBackedPingback;
import org.blojsom.blog.FileBackedTrackback;
import org.blojsom.blog.Pingback;
import org.blojsom.blog.Trackback;
import org.blojsom.fetcher.BlojsomFetcher;
import org.blojsom.fetcher.BlojsomFetcherException;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomUtils;

public class StandardFetcher
implements BlojsomFetcher,
BlojsomConstants {
    protected Log _logger = LogFactory.getLog((Class)StandardFetcher.class);
    protected static final String DEPTH_PARAM = "depth";
    protected static final String IGNORE_FLAVORS_PARAM = "ignore-flavors";
    protected static final String DEFAULT_IGNORE_FLAVORS = "admin";
    protected static final String STANDARD_FETCHER_CATEGORY = "STANDARD_FETCHER_CATEGORY";
    protected static final String STANDARD_FETCHER_DEPTH = "STANDARD_FETCHER_DEPTH";
    protected String _ignoreFlavors = "admin";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomFetcherException {
        String ignoreFlavors = blojsomConfiguration.getBlojsomPropertyAsString(IGNORE_FLAVORS_PARAM);
        if (!BlojsomUtils.checkNullOrBlank(ignoreFlavors)) {
            this._ignoreFlavors = ignoreFlavors;
        }
        this._logger.debug((Object)("Ignoring flavors: " + this._ignoreFlavors));
        this._logger.debug((Object)"Initialized standard fetcher");
    }

    public BlogEntry newBlogEntry() {
        return new FileBackedBlogEntry();
    }

    public BlogCategory newBlogCategory() {
        return new FileBackedBlogCategory();
    }

    public BlogComment newBlogComment() {
        return new FileBackedBlogComment();
    }

    public Trackback newTrackback() {
        return new FileBackedTrackback();
    }

    public Pingback newPingback() {
        return new FileBackedPingback();
    }

    protected BlogEntry[] getPermalinkEntry(BlogUser blogUser, BlogCategory requestedCategory, String permalink) {
        String permalinkEntry;
        File blogFile;
        Blog blog = blogUser.getBlog();
        String category = BlojsomUtils.removeInitialSlash(requestedCategory.getCategory());
        permalink = BlojsomUtils.urlDecode(permalink);
        if (!category.endsWith("/")) {
            category = category + "/";
        }
        if (!(blogFile = new File(permalinkEntry = blog.getBlogHome() + category + permalink)).exists()) {
            return new BlogEntry[0];
        }
        BlogEntry[] entryArray = new BlogEntry[1];
        BlogEntry blogEntry = this.newBlogEntry();
        if (blogEntry instanceof FileBackedBlogEntry) {
            ((FileBackedBlogEntry)blogEntry).setSource(blogFile);
        }
        blogEntry.setCategory(category);
        try {
            blogEntry.load(blogUser);
        }
        catch (BlojsomException e) {
            return new BlogEntry[0];
        }
        entryArray[0] = blogEntry;
        return entryArray;
    }

    protected BlogEntry[] getEntriesForCategory(BlogUser user, BlogCategory requestedCategory, int maxBlogEntries) {
        File blogCategory;
        File[] entries;
        Blog blog = user.getBlog();
        String category = BlojsomUtils.removeInitialSlash(requestedCategory.getCategory());
        if (!category.endsWith("/")) {
            category = category + "/";
        }
        if ((entries = (blogCategory = new File(blog.getBlogHome() + category)).listFiles(BlojsomUtils.getRegularExpressionFilter(blog.getBlogFileExtensions()))) == null) {
            this._logger.debug((Object)("No blog entries in blog directory: " + blogCategory));
            return new BlogEntry[0];
        }
        Arrays.sort(entries, BlojsomUtils.FILE_TIME_COMPARATOR);
        int entryCounter = maxBlogEntries == -1 ? entries.length : (maxBlogEntries > entries.length ? entries.length : maxBlogEntries);
        BlogEntry[] entryArray = new BlogEntry[entryCounter];
        for (int i = 0; i < entryCounter; ++i) {
            File entry = entries[i];
            BlogEntry blogEntry = this.newBlogEntry();
            if (blogEntry instanceof FileBackedBlogEntry) {
                ((FileBackedBlogEntry)blogEntry).setSource(entry);
            }
            blogEntry.setCategory(category);
            try {
                blogEntry.load(user);
            }
            catch (BlojsomException e) {
                this._logger.error((Object)e);
            }
            entryArray[i] = blogEntry;
        }
        return entryArray;
    }

    protected BlogEntry[] getEntriesAllCategories(BlogUser user, String flavor, int maxBlogEntries, int blogDirectoryDepth) {
        Blog blog = user.getBlog();
        String flavorMappingKey = flavor + '.' + "blog-default-category-mapping";
        String categoryMappingForFlavor = blog.getBlogProperty(flavorMappingKey);
        String[] categoryMappingsForFlavor = null;
        if (!BlojsomUtils.checkNullOrBlank(categoryMappingForFlavor)) {
            this._logger.debug((Object)("Using category mappings for flavor: " + flavor));
            categoryMappingsForFlavor = BlojsomUtils.parseCommaList(categoryMappingForFlavor);
        } else if (blog.getBlogDefaultCategoryMappings() != null && blog.getBlogDefaultCategoryMappings().length > 0) {
            this._logger.debug((Object)"Using default category mapping");
            categoryMappingsForFlavor = blog.getBlogDefaultCategoryMappings();
        } else {
            categoryMappingsForFlavor = null;
        }
        return this.getEntriesAllCategories(user, categoryMappingsForFlavor, maxBlogEntries, blogDirectoryDepth);
    }

    protected BlogEntry[] getEntriesAllCategories(BlogUser user, String[] categoryFilter, int maxBlogEntries, int blogDirectoryDepth) {
        BlogCategory blogCategory;
        BlogCategory[] blogCategories = null;
        Blog blog = user.getBlog();
        if (categoryFilter == null) {
            blogCategories = this.getBlogCategories(user, blogDirectoryDepth);
        } else {
            blogCategories = new BlogCategory[categoryFilter.length];
            for (int i = 0; i < categoryFilter.length; ++i) {
                String category = BlojsomUtils.removeInitialSlash(categoryFilter[i]);
                blogCategory = this.newBlogCategory();
                blogCategory.setCategoryURL(blog.getBlogURL() + category);
                if ("".equals(category)) {
                    blogCategory.setCategory("/");
                } else {
                    blogCategory.setCategory(category);
                }
                blogCategories[i] = blogCategory;
            }
        }
        if (blogCategories == null) {
            return new BlogEntry[0];
        }
        ArrayList<BlogEntry> blogEntries = new ArrayList<BlogEntry>();
        for (int i = 0; i < blogCategories.length; ++i) {
            blogCategory = blogCategories[i];
            BlogEntry[] entriesForCategory = this.getEntriesForCategory(user, blogCategory, -1);
            if (entriesForCategory == null) continue;
            Arrays.sort(entriesForCategory, BlojsomUtils.FILE_TIME_COMPARATOR);
            if (maxBlogEntries != -1) {
                int entryCounter = maxBlogEntries >= entriesForCategory.length ? entriesForCategory.length : maxBlogEntries;
                for (int j = 0; j < entryCounter; ++j) {
                    BlogEntry blogEntry = entriesForCategory[j];
                    blogEntries.add(blogEntry);
                }
                continue;
            }
            for (int j = 0; j < entriesForCategory.length; ++j) {
                BlogEntry blogEntry = entriesForCategory[j];
                blogEntries.add(blogEntry);
            }
        }
        BlogEntry[] entries = blogEntries.toArray(new BlogEntry[blogEntries.size()]);
        Arrays.sort(entries, BlojsomUtils.FILE_TIME_COMPARATOR);
        return entries;
    }

    protected BlogCategory getBlogCategory(BlogUser user, HttpServletRequest httpServletRequest) {
        Blog blog = user.getBlog();
        String requestedCategory = httpServletRequest.getPathInfo();
        String userFromPath = BlojsomUtils.getUserFromPath(httpServletRequest.getPathInfo());
        requestedCategory = userFromPath == null ? httpServletRequest.getPathInfo() : (userFromPath.equals(user.getId()) ? BlojsomUtils.getCategoryFromPath(httpServletRequest.getPathInfo()) : httpServletRequest.getPathInfo());
        requestedCategory = BlojsomUtils.normalize(requestedCategory);
        this._logger.debug((Object)("blojsom path info: " + requestedCategory));
        String categoryParameter = httpServletRequest.getParameter("category");
        if (categoryParameter != null && !"".equals(categoryParameter)) {
            categoryParameter = BlojsomUtils.normalize(categoryParameter);
            this._logger.debug((Object)("category parameter override: " + categoryParameter));
            requestedCategory = categoryParameter;
        }
        if (requestedCategory == null) {
            requestedCategory = "/";
        } else if (!requestedCategory.endsWith("/")) {
            requestedCategory = requestedCategory + "/";
        }
        requestedCategory = BlojsomUtils.urlDecode(requestedCategory);
        this._logger.debug((Object)("User requested category: " + requestedCategory));
        BlogCategory category = this.newBlogCategory();
        category.setCategory(requestedCategory);
        category.setCategoryURL(blog.getBlogURL() + BlojsomUtils.removeInitialSlash(requestedCategory));
        try {
            category.load(user);
        }
        catch (BlojsomException e) {
            this._logger.error((Object)e);
        }
        return category;
    }

    public BlogEntry[] fetchEntries(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, String flavor, Map context) throws BlojsomFetcherException {
        BlogCategory category = (BlogCategory)context.get(STANDARD_FETCHER_CATEGORY);
        context.remove(STANDARD_FETCHER_CATEGORY);
        int blogDirectoryDepth = (Integer)context.get(STANDARD_FETCHER_DEPTH);
        context.remove(STANDARD_FETCHER_DEPTH);
        Blog blog = user.getBlog();
        if (this._ignoreFlavors.indexOf(flavor) != -1) {
            return new BlogEntry[0];
        }
        String permalink = httpServletRequest.getParameter("permalink");
        if (permalink != null) {
            permalink = BlojsomUtils.getFilenameForPermalink(permalink, blog.getBlogFileExtensions());
            if ((permalink = BlojsomUtils.urlDecode(permalink)) == null) {
                this._logger.error((Object)("Permalink request for invalid permalink: " + httpServletRequest.getParameter("permalink")));
            } else {
                this._logger.debug((Object)("Permalink request for: " + permalink));
            }
        }
        if (permalink != null) {
            context.put("BLOJSOM_PERMALINK", permalink);
            BlogEntry[] permalinkEntry = this.getPermalinkEntry(user, category, permalink);
            if (blog.getLinearNavigationEnabled().booleanValue()) {
                BlogEntry[] allEntries = this.getEntriesAllCategories(user, flavor, -1, blogDirectoryDepth);
                if (permalinkEntry.length > 0 && allEntries.length > 0) {
                    String permalinkId = permalinkEntry[0].getId();
                    for (int i = allEntries.length - 1; i >= 0; --i) {
                        BlogEntry blogEntry = allEntries[i];
                        String blogEntryId = blogEntry.getId();
                        if (blogEntryId == null || !blogEntryId.equals(permalinkId)) continue;
                        if (i - 1 >= 0) {
                            context.put("BLOJSOM_PERMALINK_NEXT_ENTRY", allEntries[i - 1]);
                        } else {
                            context.put("BLOJSOM_PERMALINK_NEXT_ENTRY", null);
                        }
                        if (i + 1 < allEntries.length) {
                            context.put("BLOJSOM_PERMALINK_PREVIOUS_ENTRY", allEntries[i + 1]);
                            break;
                        }
                        context.put("BLOJSOM_PERMALINK_PREVIOUS_ENTRY", null);
                        break;
                    }
                }
            }
            return permalinkEntry;
        }
        if ("/".equals(category.getCategory())) {
            return this.getEntriesAllCategories(user, flavor, -1, blogDirectoryDepth);
        }
        if ("true".equalsIgnoreCase(blog.getBlogProperty("recursive-categories"))) {
            List subcategories = category.getSubcategories();
            if (subcategories != null && subcategories.size() > 0) {
                String[] subcategoriesForEntries = new String[subcategories.size() + 1];
                subcategoriesForEntries[0] = category.getCategory();
                for (int i = 0; i < subcategories.size(); ++i) {
                    subcategoriesForEntries[i + 1] = ((BlogCategory)subcategories.get(i)).getCategory();
                }
                return this.getEntriesAllCategories(user, subcategoriesForEntries, -1, -1);
            }
            return this.getEntriesForCategory(user, category, -1);
        }
        return this.getEntriesForCategory(user, category, -1);
    }

    public BlogEntry[] fetchEntries(Map fetchParameters, BlogUser user) throws BlojsomFetcherException {
        Blog blog = user.getBlog();
        if (fetchParameters.containsKey("FETCHER_CATEGORY") && fetchParameters.containsKey("FETCHER_PERMALINK")) {
            return this.getPermalinkEntry(user, (BlogCategory)fetchParameters.get("FETCHER_CATEGORY"), (String)fetchParameters.get("FETCHER_PERMALINK"));
        }
        if (fetchParameters.containsKey("FETCHER_FLAVOR") && fetchParameters.containsKey("FETCHER_NUM_POSTS_INTEGER")) {
            return this.getEntriesAllCategories(user, (String)fetchParameters.get("FETCHER_FLAVOR"), (int)((Integer)fetchParameters.get("FETCHER_NUM_POSTS_INTEGER")), blog.getBlogDepth());
        }
        if (fetchParameters.containsKey("FETCHER_CATEGORY") && fetchParameters.containsKey("FETCHER_NUM_POSTS_INTEGER")) {
            return this.getEntriesForCategory(user, (BlogCategory)fetchParameters.get("FETCHER_CATEGORY"), (Integer)fetchParameters.get("FETCHER_NUM_POSTS_INTEGER"));
        }
        return new BlogEntry[0];
    }

    protected void recursiveCategoryBuilder(BlogUser blogUser, int blogDepth, int blogDirectoryDepth, String blogDirectory, ArrayList categoryList) {
        Blog blog = blogUser.getBlog();
        if (blogDirectoryDepth != -1 && ++blogDepth == blogDirectoryDepth) {
            return;
        }
        File blogDir = new File(blogDirectory);
        File[] directories = blog.getBlogDirectoryFilter() == null ? blogDir.listFiles(BlojsomUtils.getDirectoryFilter()) : blogDir.listFiles(BlojsomUtils.getDirectoryFilter(blog.getBlogDirectoryFilter()));
        String categoryKey = BlojsomUtils.getBlogCategory(blog.getBlogHome(), blogDirectory);
        if (!categoryKey.endsWith("/")) {
            categoryKey = categoryKey + "/";
        }
        BlogCategory blogCategory = this.newBlogCategory();
        blogCategory.setCategory(categoryKey);
        blogCategory.setCategoryURL(blog.getBlogURL() + BlojsomUtils.removeInitialSlash(categoryKey));
        try {
            blogCategory.load(blogUser);
        }
        catch (BlojsomException e) {
            this._logger.error((Object)e);
        }
        categoryList.add(blogCategory);
        if (directories == null) {
            return;
        }
        for (int i = 0; i < directories.length; ++i) {
            File directory = directories[i];
            this.recursiveCategoryBuilder(blogUser, blogDepth, blogDirectoryDepth, directory.toString(), categoryList);
        }
    }

    protected BlogCategory[] getBlogCategories(BlogUser blogUser, int blogDirectoryDepth) {
        ArrayList categoryList = new ArrayList();
        this.recursiveCategoryBuilder(blogUser, -1, blogDirectoryDepth, blogUser.getBlog().getBlogHome(), categoryList);
        return categoryList.toArray(new BlogCategory[categoryList.size()]);
    }

    protected BlogCategory[] getBlogCategoryHierarchy(BlogUser blogUser, BlogCategory currentCategory, int blogDirectoryDepth) {
        if ("/".equals(currentCategory.getCategory())) {
            return null;
        }
        Blog blog = blogUser.getBlog();
        StringTokenizer slashTokenizer = new StringTokenizer(currentCategory.getCategory(), "/");
        String previousCategoryName = "/";
        ArrayList<BlogCategory> categoryList = new ArrayList<BlogCategory>();
        ArrayList<BlogCategory> sanitizedCategoryList = new ArrayList<BlogCategory>();
        while (slashTokenizer.hasMoreTokens()) {
            if ((previousCategoryName = previousCategoryName + slashTokenizer.nextToken() + '/').equals(currentCategory.getCategory())) continue;
            BlogCategory updatedBackedCategory = this.newBlogCategory();
            updatedBackedCategory.setCategory(previousCategoryName);
            updatedBackedCategory.setCategoryURL(blog.getBlogURL() + BlojsomUtils.removeInitialSlash(previousCategoryName));
            try {
                updatedBackedCategory.load(blogUser);
            }
            catch (BlojsomException e) {
                this._logger.error((Object)e);
            }
            categoryList.add(updatedBackedCategory);
        }
        this.recursiveCategoryBuilder(blogUser, -1, blogDirectoryDepth, blog.getBlogHome() + BlojsomUtils.removeInitialSlash(currentCategory.getCategory()), categoryList);
        for (int i = 0; i < categoryList.size(); ++i) {
            BlogCategory category = (BlogCategory)categoryList.get(i);
            if (category.getCategory().equals(currentCategory.getCategory())) continue;
            this._logger.debug((Object)category.getCategory());
            sanitizedCategoryList.add(category);
        }
        BlogCategory rootCategory = this.newBlogCategory();
        rootCategory.setCategory("/");
        rootCategory.setCategoryURL(blog.getBlogURL());
        try {
            rootCategory.load(blogUser);
        }
        catch (BlojsomException e) {
            this._logger.error((Object)e);
        }
        sanitizedCategoryList.add(0, rootCategory);
        if (sanitizedCategoryList.size() > 0) {
            return sanitizedCategoryList.toArray(new BlogCategory[sanitizedCategoryList.size()]);
        }
        return null;
    }

    public BlogCategory[] fetchCategories(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, String flavor, Map context) throws BlojsomFetcherException {
        Blog blog = user.getBlog();
        BlogCategory category = this.getBlogCategory(user, httpServletRequest);
        context.put(STANDARD_FETCHER_CATEGORY, category);
        context.put("BLOJSOM_REQUESTED_CATEGORY", category);
        int blogDirectoryDepth = blog.getBlogDepth();
        String depthParam = httpServletRequest.getParameter(DEPTH_PARAM);
        if (depthParam != null || !"".equals(depthParam)) {
            try {
                blogDirectoryDepth = Integer.parseInt(depthParam);
            }
            catch (NumberFormatException e) {
                blogDirectoryDepth = blog.getBlogDepth();
            }
        }
        context.put(STANDARD_FETCHER_DEPTH, new Integer(blogDirectoryDepth));
        BlogCategory[] allCategories = this.getBlogCategories(user, -1);
        context.put("BLOJSOM_ALL_CATEGORIES", allCategories);
        BlogCategory[] categories = "/".equals(category.getCategory()) ? allCategories : this.getBlogCategoryHierarchy(user, category, blogDirectoryDepth);
        return categories;
    }

    public BlogCategory[] fetchCategories(Map fetchParameters, BlogUser user) throws BlojsomFetcherException {
        Blog blog = user.getBlog();
        if (fetchParameters == null) {
            return this.getBlogCategories(user, -1);
        }
        if (fetchParameters.containsKey("FETCHER_CATEGORY")) {
            BlogCategory category = (BlogCategory)fetchParameters.get("FETCHER_CATEGORY");
            if ("/".equals(category.getCategory())) {
                return this.getBlogCategories(user, blog.getBlogDepth());
            }
            return this.getBlogCategoryHierarchy(user, category, blog.getBlogDepth());
        }
        return new BlogCategory[0];
    }

    public void destroy() throws BlojsomFetcherException {
    }
}

