/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.event;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.event.BlojsomEventBroadcaster;
import org.blojsom.event.BlojsomFilter;
import org.blojsom.event.BlojsomListener;

public class SimpleBlojsomEventBroadcaster
implements BlojsomEventBroadcaster {
    private static final Log _logger = LogFactory.getLog((Class)SimpleBlojsomEventBroadcaster.class);
    private Set _listeners = new HashSet();
    private Map _listenerToHandler = new HashMap();

    public void addListener(BlojsomListener listener) {
        EventHandler handler = new EventHandler(listener, new BlojsomFilter(){

            public boolean processEvent(BlojsomEvent event) {
                return true;
            }
        });
        if (!this._listenerToHandler.containsKey(listener.getClass().getName())) {
            this._listeners.add(handler);
            this._listenerToHandler.put(listener.getClass().getName(), handler);
            _logger.debug((Object)("Added event: " + listener.getClass().getName() + " with process all events filter"));
        }
    }

    public void addListener(BlojsomListener listener, BlojsomFilter filter) {
        EventHandler handler = new EventHandler(listener, filter);
        if (!this._listenerToHandler.containsKey(listener.getClass().getName())) {
            this._listeners.add(handler);
            this._listenerToHandler.put(listener.getClass().getName(), handler);
            _logger.debug((Object)("Added event: " + listener.getClass().getName() + " with filter: " + filter.getClass().getName()));
        }
    }

    public void removeListener(BlojsomListener listener) {
        if (this._listenerToHandler.containsKey(listener.getClass().getName())) {
            EventHandler handler = (EventHandler)this._listenerToHandler.get(listener.getClass().getName());
            this._listeners.remove(handler);
            this._listenerToHandler.remove(listener.getClass().getName());
        }
        _logger.debug((Object)("Removed event: " + listener.getClass().getName()));
    }

    public void broadcastEvent(BlojsomEvent event) {
        Thread eventBroadcaster = new Thread(new AsynchronousEventBroadcaster(event));
        eventBroadcaster.setDaemon(true);
        eventBroadcaster.start();
    }

    public void processEvent(BlojsomEvent event) {
        Iterator handlerIterator = this._listeners.iterator();
        while (handlerIterator.hasNext()) {
            EventHandler eventHandler = (EventHandler)handlerIterator.next();
            if (!eventHandler._filter.processEvent(event)) continue;
            eventHandler._listener.processEvent(event);
        }
    }

    private class AsynchronousEventBroadcaster
    implements Runnable {
        private BlojsomEvent _event;

        public AsynchronousEventBroadcaster(BlojsomEvent event) {
            this._event = event;
        }

        public void run() {
            Iterator handlerIterator = SimpleBlojsomEventBroadcaster.this._listeners.iterator();
            while (handlerIterator.hasNext()) {
                EventHandler eventHandler = (EventHandler)handlerIterator.next();
                if (!eventHandler._filter.processEvent(this._event)) continue;
                eventHandler._listener.handleEvent(this._event);
            }
        }
    }

    protected class EventHandler {
        protected BlojsomListener _listener;
        protected BlojsomFilter _filter;

        protected EventHandler(BlojsomListener listener, BlojsomFilter filter) {
            this._listener = listener;
            this._filter = filter;
        }
    }
}

