/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.dispatcher;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.dispatcher.BlojsomDispatcher;
import org.blojsom.filter.PermalinkFilter;
import org.blojsom.util.BlojsomUtils;

public class JSPDispatcher
implements BlojsomDispatcher {
    private Log _logger = LogFactory.getLog((Class)JSPDispatcher.class);
    private ServletContext _context;
    private String _templatesDirectory;
    private String _baseConfigurationDirectory;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomException {
        this._context = servletConfig.getServletContext();
        this._baseConfigurationDirectory = blojsomConfiguration.getBaseConfigurationDirectory();
        this._templatesDirectory = blojsomConfiguration.getTemplatesDirectory();
        this._logger.debug((Object)("Using templates directory: " + this._templatesDirectory));
        this._logger.debug((Object)"Initialized JSP dispatcher");
    }

    public void dispatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, String flavorTemplate, String flavorContentType) throws IOException, ServletException {
        String templateToLoad;
        httpServletResponse.setContentType(flavorContentType);
        if (!flavorTemplate.startsWith("/")) {
            flavorTemplate = '/' + flavorTemplate;
        }
        String flavorTemplateForPage = null;
        if (BlojsomUtils.getRequestValue("page", httpServletRequest) != null) {
            flavorTemplateForPage = BlojsomUtils.getTemplateForPage(flavorTemplate, BlojsomUtils.getRequestValue("page", httpServletRequest));
            this._logger.debug((Object)("Retrieved template for page: " + flavorTemplateForPage));
        }
        Iterator contextIterator = context.keySet().iterator();
        while (contextIterator.hasNext()) {
            String contextKey = (String)contextIterator.next();
            httpServletRequest.setAttribute(contextKey, context.get(contextKey));
        }
        if (httpServletRequest instanceof PermalinkFilter.PermalinkRequest) {
            PermalinkFilter.PermalinkRequest permalinkRequest = (PermalinkFilter.PermalinkRequest)httpServletRequest;
            permalinkRequest.setPathInfo(null);
        }
        if (flavorTemplateForPage != null) {
            templateToLoad = this._baseConfigurationDirectory + user.getId() + this._templatesDirectory + BlojsomUtils.removeInitialSlash(flavorTemplateForPage);
            if (this._context.getResource(templateToLoad) != null) {
                httpServletRequest.getRequestDispatcher(templateToLoad).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                httpServletResponse.getWriter().flush();
                this._logger.debug((Object)("Dispatched to flavor page template for user: " + templateToLoad));
                return;
            }
            templateToLoad = this._baseConfigurationDirectory + BlojsomUtils.removeInitialSlash(this._templatesDirectory) + BlojsomUtils.removeInitialSlash(flavorTemplateForPage);
            if (this._context.getResource(templateToLoad) != null) {
                httpServletRequest.getRequestDispatcher(templateToLoad).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                httpServletResponse.getWriter().flush();
                this._logger.debug((Object)("Dispatched to flavor page template: " + templateToLoad));
                return;
            }
            this._logger.error((Object)("Unable to dispatch to flavor page template: " + templateToLoad));
        } else {
            templateToLoad = this._baseConfigurationDirectory + user.getId() + this._templatesDirectory + BlojsomUtils.removeInitialSlash(flavorTemplate);
            if (this._context.getResource(templateToLoad) != null) {
                httpServletRequest.getRequestDispatcher(templateToLoad).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                httpServletResponse.getWriter().flush();
                this._logger.debug((Object)("Dispatched to flavor template for user: " + templateToLoad));
                return;
            }
            templateToLoad = this._baseConfigurationDirectory + BlojsomUtils.removeInitialSlash(this._templatesDirectory) + BlojsomUtils.removeInitialSlash(flavorTemplate);
            if (this._context.getResource(templateToLoad) != null) {
                httpServletRequest.getRequestDispatcher(templateToLoad).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                httpServletResponse.getWriter().flush();
                this._logger.debug((Object)("Dispatched to flavor template: " + templateToLoad));
                return;
            }
            this._logger.error((Object)("Unable to dispatch to flavor template: " + templateToLoad));
        }
    }
}

