/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.blog;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.blojsom.BlojsomException;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;

public abstract class Trackback
implements Serializable {
    protected String _title;
    protected String _excerpt;
    protected String _url;
    protected String _blogName;
    protected long _trackbackDateLong;
    protected String _id;
    protected Map _metaData;
    protected BlogEntry _blogEntry;

    public Trackback() {
        this._trackbackDateLong = -1L;
    }

    public Trackback(String title, String excerpt, String url, String blogName) {
        this._title = title;
        this._excerpt = excerpt;
        this._url = url;
        this._blogName = blogName;
        this._trackbackDateLong = -1L;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getExcerpt() {
        return this._excerpt;
    }

    public void setExcerpt(String excerpt) {
        this._excerpt = excerpt;
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public String getBlogName() {
        return this._blogName;
    }

    public Map getMetaData() {
        if (this._metaData == null) {
            return new HashMap();
        }
        return this._metaData;
    }

    public void setBlogName(String blogName) {
        this._blogName = blogName;
    }

    public void setTrackbackDateLong(long trackbackDateLong) {
        this._trackbackDateLong = trackbackDateLong;
    }

    public long getTrackbackDateLong() {
        return this._trackbackDateLong;
    }

    public Date getTrackbackDate() {
        return new Date(this._trackbackDateLong);
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        if (this._id == null) {
            this._id = id;
        }
    }

    public void setMetaData(Map metaData) {
        this._metaData = metaData;
    }

    public String getDateAsFormat(String format) {
        if (format == null) {
            return null;
        }
        SimpleDateFormat sdf = null;
        Date trackbackDate = new Date(this._trackbackDateLong);
        try {
            sdf = new SimpleDateFormat(format);
            return sdf.format(trackbackDate);
        }
        catch (IllegalArgumentException e) {
            return trackbackDate.toString();
        }
    }

    public BlogEntry getBlogEntry() {
        return this._blogEntry;
    }

    public void setBlogEntry(BlogEntry blogEntry) {
        this._blogEntry = blogEntry;
    }

    public abstract void load(BlogUser var1) throws BlojsomException;

    public abstract void save(BlogUser var1) throws BlojsomException;

    public abstract void delete(BlogUser var1) throws BlojsomException;
}

